// CatchRtdxEvents.h : Declaration of the CCatchRtdxEvents

#ifndef __CATCHRTDXEVENTS_H_
#define __CATCHRTDXEVENTS_H_

#include "resource.h"       // main symbols
#include <atlhost.h>
#include "RtdxEventsSink.h"

/////////////////////////////////////////////////////////////////////////////
// CCatchRtdxEvents
class CCatchRtdxEvents : 
	public CAxDialogImpl<CCatchRtdxEvents>
{
public:
	CCatchRtdxEvents()
	{
		m_pRtdx.p = NULL;
		m_dwRtdxEventsCookie = NULL;
	}

	~CCatchRtdxEvents()
	{
	}

	enum { IDD = IDD_CATCHRTDXEVENTS };

BEGIN_MSG_MAP(CCatchRtdxEvents)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	COMMAND_ID_HANDLER(IDOK, OnOK)
	COMMAND_HANDLER(IDC_CHECK_CAPTURE_RTDX_EVENTS, BN_CLICKED, OnCaptureRtdxEvents)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);
	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnCaptureRtdxEvents(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);

	HRESULT GetPointers2RTDXInterfaces();
	HRESULT ReleasePointers2RTDXInterfaces();
	HRESULT ConnectRtdxEvents();
	HRESULT DisConnectRtdxEvents();

private:
	CComPtr<IRtdx>        m_pRtdx;
	DWORD                 m_dwRtdxEventsCookie;
};

#endif //__CATCHRTDXEVENTS_H_
