// CatchRtdxEvents.cpp : Implementation of CCatchRtdxEvents
#include "stdafx.h"
#include "CatchRtdxEvents.h"

/////////////////////////////////////////////////////////////////////////////
// CCatchRtdxEvents

LRESULT CCatchRtdxEvents::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	return 1;  // Let the system set the focus
}

LRESULT CCatchRtdxEvents::OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	EndDialog(wID);
	return 0;
}

LRESULT CCatchRtdxEvents::OnCaptureRtdxEvents(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	TCHAR strCapturingRtdxEvents[] = _T("Capturing RTDX Events");
	TCHAR strNotCapturingRtdxEvents[] = _T("Not Capturing RTDX Events");

	if (this->IsDlgButtonChecked(IDC_CHECK_CAPTURE_RTDX_EVENTS)) {
		if (SUCCEEDED(GetPointers2RTDXInterfaces()))
			::SetWindowText(this->GetDlgItem(IDC_CHECK_CAPTURE_RTDX_EVENTS),strCapturingRtdxEvents);
	} else {
		if (SUCCEEDED(ReleasePointers2RTDXInterfaces()))
			::SetWindowText(this->GetDlgItem(IDC_CHECK_CAPTURE_RTDX_EVENTS),strNotCapturingRtdxEvents);
	}
		
	return 0;
}

HRESULT CCatchRtdxEvents::GetPointers2RTDXInterfaces()
{
	CComPtr<IApplication>   cc_app;
	VARIANT                 index;
	HRESULT                 hr      = S_OK;
	VariantInit(&index);
	index.vt                        = VT_I2;
	index.iVal                      = 0;
	
	// Initialize COM
	::CoInitialize(NULL);

	// Create an instance of the CodeComposer::Application coclase and
	// obtain a pointer to the IApplication interface
	hr = cc_app.CoCreateInstance(__uuidof(CodeComposer::Application),
									NULL,
									CLSCTX_LOCAL_SERVER);
	if (FAILED(hr))
		return hr;

	// Make sure Code Composer is visible
	cc_app->PutVisible(VARIANT_TRUE);


	// Get pointer to CodeComposer::IRtdx interface
	m_pRtdx = cc_app->GetDspBoards()->Item(index)->GetDspTasks()->Item(index)->Getrtdx();

	// Release pointer to CodeComposer::IApplication interface
	cc_app.Release();		

	// Setup to receive event notification from CodeComposer::IRtdxEvents
	hr = ConnectRtdxEvents();
	if (FAILED(hr))
		return hr;
	return hr;
}

HRESULT CCatchRtdxEvents::ReleasePointers2RTDXInterfaces()
{
	HRESULT hr=S_OK;

	// Disconnect link from receiving event notification from
	// CodeComposer::IRtdxEvents
	hr = DisConnectRtdxEvents();
	if (FAILED(hr))
		return hr;

	// release reference to CodeComposer::IRtdx interface
	if (m_pRtdx) {
		m_pRtdx.Release();
		m_pRtdx.p = NULL;
	}
	return hr;
}

HRESULT CCatchRtdxEvents::ConnectRtdxEvents()
{
	CComObject<CRtdxEventsSink> *pRtdxEventsSink = NULL;
	LPUNKNOWN                   pUnk             = NULL;
	HRESULT                     hr               = S_OK;

	// Create instance of RtdxEventsSink object
	hr = CComObject<CRtdxEventsSink>::CreateInstance(&pRtdxEventsSink);
	if (FAILED(hr))
		return hr;

	// Query for CodeComposer::IUnknown interface
	hr = m_pRtdx->QueryInterface(IID_IUnknown,(LPVOID*)&pUnk);
	if (FAILED(hr))
		return hr;

	// Setup to receive event notifications from CodeComposer::IRtdxEvents
	hr = AtlAdvise(pUnk,
					pRtdxEventsSink->GetUnknown(),
					__uuidof(CodeComposer::IRtdxEvents),
					&m_dwRtdxEventsCookie);

	// release reference to IUnknown interface
	if (pUnk) pUnk->Release();

	return hr;

}

HRESULT CCatchRtdxEvents::DisConnectRtdxEvents()
{
	CComObject<CRtdxEventsSink> *pRtdxEventsSink = NULL;
	LPUNKNOWN                   pUnk             = NULL;
	HRESULT                     hr               = S_OK;

	if (m_dwRtdxEventsCookie) {
		if (m_pRtdx) {
			// Query for CodeComposer::IUnknown interface
			hr = m_pRtdx->QueryInterface(IID_IUnknown,(LPVOID*)&pUnk);
			if (SUCCEEDED(hr))
				// release connection to CodeComposer::IRtdxEvents
				hr = AtlUnadvise(pUnk,
									__uuidof(CodeComposer::IRtdxEvents),
									m_dwRtdxEventsCookie);
			// release IUknown interface
			if (pUnk) pUnk->Release();
		}
	}
	m_dwRtdxEventsCookie = NULL;
	return hr;

}