/************************************************************************/
/*  ctype.h C16 2.04                                                    */
/*  Copyright (c) 1992,1997 Texas Instruments Incorporated              */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*  CHARACTER TYPING FUNCTIONS AND MACROS                               */
/*                                                                      */
/*  Note that in this implementation, either macros or functions may    */
/*  be used.  Macros are prefixed with an underscore.                   */
/*                                                                      */
/************************************************************************/
#ifndef _CTYPE
#define _CTYPE

extern char _ctypes_[];

#if _INLINE
#define __INLINE static inline
#else
#define __INLINE
#endif

/************************************************************************/
/*   FUNCTION DEFINITIONS                                               */
/************************************************************************/
__INLINE  int isalnum(int _c);
__INLINE  int isalpha(int _c);
__INLINE  int iscntrl(int _c);
__INLINE  int isdigit(int _c);
__INLINE  int isgraph(int _c);
__INLINE  int islower(int _c);
__INLINE  int isprint(int _c);
__INLINE  int ispunct(int _c);
__INLINE  int isspace(int _c);
__INLINE  int isupper(int _c);
__INLINE  int isxdigit(int _c);
__INLINE  int isascii(int _c);

__INLINE  int toupper(int _c);
__INLINE  int tolower(int _c);
__INLINE  int toascii(int _c);

/************************************************************************/
/*  MACRO DEFINITIONS                                                   */
/************************************************************************/
#define _U_   0x01
#define _L_   0x02
#define _N_   0x04
#define _S_   0x08
#define _P_   0x10
#define _C_   0x20
#define _H_   0x40
#define _B_   0x80

#define _isalnum(a)  (_ctypes_[(a)+1] & (_U_ | _L_ | _N_))
#define _isalpha(a)  (_ctypes_[(a)+1] & (_U_ | _L_))
#define _iscntrl(a)  (_ctypes_[(a)+1] & _C_)
#define _isdigit(a)  (_ctypes_[(a)+1] & _N_)
#define _isgraph(a)  (_ctypes_[(a)+1] & (_U_ | _L_ | _N_ | _P_))
#define _islower(a)  (_ctypes_[(a)+1] & _L_)
#define _isprint(a)  (_ctypes_[(a)+1] & (_B_ | _U_ | _L_ | _N_ | _P_))
#define _ispunct(a)  (_ctypes_[(a)+1] & _P_)
#define _isspace(a)  (_ctypes_[(a)+1] & _S_)
#define _isupper(a)  (_ctypes_[(a)+1] & _U_)
#define _isxdigit(a) (_ctypes_[(a)+1] & _H_)
#define _isascii(a)  (((a) & ~0x7F) == 0)

#define _toupper(b)  ((_islower(b)) ? (b) - ('a' - 'A') : (b))
#define _tolower(b)  ((_isupper(b)) ? (b) + ('a' - 'A') : (b))
#define _toascii(a)  ((a) & 0x7F)

#if _INLINE
__INLINE  int isalnum(int _c)  {return(_isalnum(_c));  }
__INLINE  int isalpha(int _c)  {return(_isalpha(_c));  }
__INLINE  int iscntrl(int _c)  {return(_iscntrl(_c));  }
__INLINE  int isdigit(int _c)  {return(_isdigit(_c));  }
__INLINE  int isgraph(int _c)  {return(_isgraph(_c));  }
__INLINE  int islower(int _c)  {return(_islower(_c));  }
__INLINE  int isprint(int _c)  {return(_isprint(_c));  }
__INLINE  int ispunct(int _c)  {return(_ispunct(_c));  }
__INLINE  int isspace(int _c)  {return(_isspace(_c));  }
__INLINE  int isupper(int _c)  {return(_isupper(_c));  }
__INLINE  int isxdigit(int _c) {return(_isxdigit(_c)); }
__INLINE  int isascii(int _c)  {return(_isascii(_c));  }

__INLINE  int toupper(int _c)  {return(_toupper(_c));  }
__INLINE  int tolower(int _c)  {return(_tolower(_c));  }
__INLINE  int toascii(int _c)  {return(_toascii(_c));  }
#endif

#undef __INLINE

#endif
