module writeeqn[public];
(* $INCLUDE:'TYPE.IBM' *)

{GLOBAL} procedure write_eqn (eqnptr:tree_ptr);

var  temptr,temptr1,temptr2: tree_ptr;
     templst,orlst:op_node;
     colcnt,colcnt1,i:integer;

(********************************************************************)
(* This procedure creates the orlst, which is a list pointing to all*)
(* the OR nodes of the tree. The last node of the tree will be at   *)
(* the top of the list.                                             *)
(********************************************************************)
procedure create_orlst (eqnptr:tree_ptr;
                        var orlst:op_node);
var tempnode : op_node;

  begin
   if eqnptr<>nil then
    begin
     if eqnptr^.kind =137  then
      begin
       new(tempnode);
       tempnode^.next:=orlst;
       tempnode^.ptr:=eqnptr;
       orlst:=tempnode;
      end;
     create_orlst (eqnptr^.child,orlst);
     create_orlst (eqnptr^.rsibling,orlst);
   end;
 end;

(******************************************************************)
(* procedure create_andlst creates the and_lst. It is a list which*)
(* points to all the AND nodes in the tree. The last AND node is  *)
(* at the top of the list.                                        *)
(******************************************************************)

procedure create_andlst (eqnptr:tree_ptr;
                         var andlst: op_node);

var tempnode: op_node;

 begin
  if (eqnptr<>nil) then
   begin
    if eqnptr^.kind = 136 then
     begin
      new(tempnode);
      tempnode^.next:=andlst;
      tempnode^.ptr:=eqnptr;
      andlst:=tempnode;
     end;
   create_andlst (eqnptr^.child,andlst);
   create_andlst (eqnptr^.rsibling,andlst);
 end;
end;

procedure write_id_name (temptr:tree_ptr;
                         var colcnt:integer);

var i:integer;
begin
 if (not temptr^.polarity) then
  begin
   write('/');
   colcnt:=colcnt+1;
  end;
 for i:=1 to index do
   if temptr^.chiptr^.id_name[i]<> chr(0) then
    begin
     write(temptr^.chiptr^.id_name[i]);
     colcnt:=colcnt+1;
    end;
end;

procedure write_and (andptr:tree_ptr);

var andlst,templst:op_node;
    temptr:tree_ptr;
    i:integer;

begin
 andptr^.rsibling:=nil;
 andlst:=nil;
 create_andlst(andptr,andlst);
 if andlst<>nil then
  begin
   templst:=andlst;
   temptr:=andlst^.ptr^.child;
   write_id_name(temptr,colcnt);
   write(' * ');
   colcnt:=colcnt+3;
   temptr:=templst^.ptr^.child^.rsibling;
   write_id_name(temptr,colcnt);
   while templst<>nil do
    begin
     if templst^.ptr^.rsibling<>nil then
      begin
       write( ' * ');
       colcnt:=colcnt+3;
       temptr:=templst^.ptr^.rsibling;
       write_id_name(temptr,colcnt);
      end;
    templst:=templst^.next;
   end;
 end;
if andlst=nil then
 begin
  temptr:=andptr;
  write_id_name (temptr,colcnt);
 end;
end;


begin
 while eqnptr<>nil do
  begin
   temptr1:=eqnptr^.rsibling;
   eqnptr^.rsibling:=nil;
   colcnt:=1;
   temptr:=eqnptr^.child;
   if temptr^.kind = 56 then
    begin
     write_id_name (temptr^.child,colcnt);
     write('.clk');
     colcnt:=colcnt+4;
    end;
   if temptr^.kind = 57 then
    begin
     write_id_name (temptr^.child,colcnt);
     write('.trst');
     colcnt:=colcnt+5;
    end;
   if temptr^.kind = 58 then
    begin
     write_id_name(temptr^.child,colcnt);
     write('.reset');
     colcnt:=colcnt+6;
    end;
   if temptr^.kind = 33 then
    begin
     write_id_name (temptr^.child,colcnt);
     write('.set');
     colcnt:=colcnt+1;
   end;
    if (temptr^.kind<>33) and (temptr^.kind<>56) and (temptr^.kind<>57)
     and (temptr^.kind<>58) then write_id_name(temptr,colcnt);
    if eqnptr^.kind=122 then write(' :=');
    if eqnptr^.kind=121 then write('  =');
    colcnt:=colcnt+3;
    colcnt1:=colcnt;
    orlst:=nil;
    create_orlst(eqnptr^.child^.rsibling,orlst);
    if orlst<>nil then
     begin
      templst:=orlst;
      temptr2:=templst^.ptr^.child^.rsibling;
      templst^.ptr^.child^.rsibling:=nil;
      write_and(templst^.ptr^.child);
      templst^.ptr^.child^.rsibling:=temptr2;
      writeln;
      for i:=1 to colcnt1 do write(' ');
      write('+ ');
      colcnt:=colcnt+2;
      write_and(templst^.ptr^.child^.rsibling);
      writeln;
      while templst^.next<>nil do
       begin
        if templst^.ptr^.rsibling<>nil then
         begin
          for i:=1 to colcnt1 do write(' ');
          write('+');
          write_and(templst^.ptr^.rsibling);
          writeln;
         end;
       templst:=templst^.next;
      end;
    end;
   if orlst=nil then write_and(eqnptr^.child^.rsibling);
  eqnptr^.rsibling:=temptr1;
  writeln;
  writeln;
  eqnptr:=eqnptr^.rsibling;
 end;
end;
end.
