module xplot[public];
(* $INCLUDE:'TYPE.IBM' *)
(***********************************************************)
(* This procedure generates the fuseplot for 20RP10 PAL.   *)
(* It outputs the data in the default file XPLOT.DAT.      *)
(* The basic steps in this procedure are as follows:       *)
(* For every equation do the following:                    *)
(*                                                         *)
(*      1) Determine the output id_name ,pin_num, polarity *)
(*         and whether registered or not.                  *)
(*                                                         *)
(*      2) If the particular equation is for special       *)
(*         product functions like SET,RESET,CLK and TRST   *)
(*         then set the corresponding flags in the LOGARR  *)
(*                                                         *)
(*      3) Knowing the pin_num, and the type of product    *)
(*         function, generate the start of the product     *)
(*         terms and the corresponding offset. For e.g.    *)
(*         pin_num 14 has product term starting from 73    *)
(*         and the offsets for TRST is 0, CLK is 1,        *)
(*         RESET is 2 ,SET 3 and DATA is 4                 *)
(*                                                         *)
(*      4) Once all the data in terms of output pin,       *)
(*         start of prodterm and the offsets, the program  *)
(*         scans the right side of equation and            *)
(*         creates a list of all OR gates. There can be 0  *)
(*         to 4 orgates.                                   *)
(*                                                         *)
(*      5) For each orgate, a list of and gate is created  *)
(*                                                         *)
(*      6) For each AND gate, a vert position is evaluated *)
(*         for all the signals attached to the andgate and *)
(*         a 'x' is placed in that particular prodterm/vert*)
(*         location. If this is the first time the prodterm*)
(*         is used than all the remaining locations along  *)
(*         that prodterm are filled with '-'               *)
(*                                                         *)
(*      7) repeat steps 5 and 6 till all the orgates are   *)
(*         finished. Repeat steps 1 to 6 for all the       *)
(*         equations.                                      *)
(*                                                         *)
(*   Fuse intact : 'x'  Fuse blown : '-'                   *)
(*   Default state : TRST line to be high                  *)
(*                   SET and RESET low, for REGISTERED out *)
(*                   SET and RESET high for COMB out       *)
(***********************************************************)
procedure error (eqnptr : tree_ptr;
                 errsym1,errsym2 : chstring;
                 errnum : integer;
                var errflag : boolean); external;
                        
{GLOBAL} procedure fuseplot (var pinlist : chip_ptr;
                     eqnptr : tree_ptr;
                    var fusemap : fusearray;
                    var pol_map : polarray;
                    var errflag : boolean;
                    var f : text);

label 102;


var  pin_num, vert, errnum,i : integer;
     prodterm,fuses,prodterm1,j:integer;
     orlst,templst:op_node;
     temptr:chip_ptr;
     temptr1,temptr2:tree_ptr;
     prodtot : array [1..10] of integer;

procedure  check (var pinlist : chip_ptr;
                  pin_num : integer;
                  var errflag : boolean);

var templst : chip_ptr;
    errsym1,errsym2 : chstring;

begin

  case pin_num of

        14,23 : if prodtot[pin_num-13]>= 8 then
                 begin
                  templst := pinlist;
                  while templst<> nil do
                   begin
                    if templst^.level= pin_num then
                     begin
                      errsym1:=templst^.id_name;
                      templst:=nil;
                     end
                   else templst:=templst^.rsibling;
                  end;
                  error(nil,errsym1,errsym2,2,errflag);
                  if errflag then goto 102;
                end;
 15,17,19,21 : if prodtot[pin_num - 13]
                 + prodtot[pin_num -12] >= 16 then
                begin
                  templst:=pinlist;
                  while templst<>nil do
                   begin
                    if templst^.level = pin_num then
                     errsym1:= templst^.id_name;
                    if templst^.level = pin_num + 1 then
                     errsym2:=templst^.id_name;
                    templst:=templst^.rsibling;
                  end;
                 error(nil,errsym1,errsym2,3,errflag);
                 if errflag then goto 102;
                end;
 16,18,20,22 : if prodtot[pin_num -13]
                + prodtot[pin_num -14] >= 16 then
                begin
                 templst:=pinlist;
                 while templst<>nil do
                  begin
                   if (templst^.level=pin_num)
                    then errsym2:= templst^.id_name;
                   if (templst^.level=pin_num -1 )
                    then errsym1:= templst^.id_name;
                   templst:=templst^.rsibling;
                  end;
                 error(nil,errsym1,errsym2,3,errflag);
                 if errflag then goto 102;
               end;
    end;
end;

(*******************************************************)
(* This procedure creates the list of all the and gates*)
(* attached to an or node. The top of the list points  *)
(* to the last AND gate.                               *)
(*******************************************************)
procedure create_andlst ( eqnptr : tree_ptr;
                          var andlst:op_node);
                

var tempnode: op_node;

begin
 if eqnptr<>nil then
  begin
   if  (eqnptr^.kind=136) then
    begin
     new (tempnode);
     tempnode^.next:=andlst;
     tempnode^.ptr:=eqnptr;
     andlst:=tempnode;
    end;
  create_andlst(eqnptr^.child,andlst);
  create_andlst(eqnptr^.rsibling,andlst);
 end;
end;

(***********************************************************)
(* This proceudre creates the list of all the OR gates  in *)
(* an equation. The top of the list points to the last OR  *)
(* gate.                                                   *)
(***********************************************************)

procedure create_orlst(eqnptr:tree_ptr;
                       var orlst:op_node);
                

var tempnode:op_node;

begin
 if eqnptr<>nil then
  begin
   if (eqnptr^.kind=137) then
    begin
     new(tempnode);
     tempnode^.next:=orlst;
     tempnode^.ptr:=eqnptr;
     orlst:=tempnode;
    end;
  create_orlst(eqnptr^.child,orlst);
  create_orlst(eqnptr^.rsibling,orlst);
 end;
end;

(**********************************************************)
(* This procedure evaluates the vertical location of the  *)
(* fuse for the particular signal. Once the vert and      *)
(* the prodterm is known, a 'x' is put in that position.  *)
(* If this was the first time this product term was used  *)
(* than all the fuses (40) in that prodterm are blown (-) *)
(* and then'x' is put. If the first two locations on the  *)
(* prodterm are 'x' then the prodterm was used for the    *)
(* first time. Since putting an 'x' is like keeping the   *)
(* fuse intact, a one is subtracted from FUSES for every  *)
(* 'x' added.                                             *)
(**********************************************************)

procedure blow_fuse (eqnptr:tree_ptr);

var vert,i:integer;

begin
 if (eqnptr^.chiptr^.level >= 2)
 and(eqnptr^.chiptr^.level <=11)
  then                                      (* vert evaluation for *)
   begin                                    (* pins 2 to 11        *)
    vert:= 4 * eqnptr^.chiptr^.level - 7;
    if ((eqnptr^.polarity)and(not(eqnptr^.chiptr^.polarity)))
       or ((not (eqnptr^.polarity))and(eqnptr^.chiptr^.polarity)) then
     vert:=vert+1;                          (* a 1 is added for -ve signal*)
     if (fusemap[prodterm,1]='x') and (fusemap[prodterm,2]='x')
     then                              (* if prodterm is visited for the *)
      begin                            (* first time than blow all the   *)
       for i:=1 to 40 do               (* fuses and then add a 'x' in    *)
        fusemap[prodterm,i]:='-';      (* the desired location.          *)
        fuses:=fuses+40;
        case pin_num of
          15,17,19,21 : fusemap [prodterm,41]:='-';
          16,18,20,22 : fusemap [prodterm,42]:='-';
          otherwise  begin
                      fuses:=fuses-1;
                    end;
       end;
      fuses:=fuses+1;
     end;
     fusemap[prodterm,vert]:='x';      (* whenever 'x' is added FUSES is *)
     fuses:=fuses-1;                   (* decremented.                   *)
   end;
 if (eqnptr^.chiptr^.level >= 14)      (* same things for pins 14 to 23 *)
 and(eqnptr^.chiptr^.level <= 23)
  then
   begin
    vert:=95 - 4*eqnptr^.chiptr^.level;
    if ((eqnptr^.polarity)and(not (eqnptr^.chiptr^.polarity)))
       or((not(eqnptr^.polarity)) and (eqnptr^.chiptr^.polarity)) then
     vert:=vert+1;
    if (fusemap[prodterm,1]='x') and (fusemap[prodterm,2]='x')
    then
     begin
      for i:= 1 to 40 do fusemap[prodterm,i]:='-';
      fuses:=fuses+40;
      case pin_num of
        15,17,19,21 : fusemap[prodterm,41]:='-';
        16,18,20,22 : fusemap[prodterm,42]:='-';
        otherwise
          begin
           fuses:=fuses-1;
          end;
      end;
      fuses:=fuses+1;
     end;
    fusemap[prodterm,vert]:='x';
    fuses:=fuses-1;
   end;
  if (eqnptr^.chiptr^.level=24)   (* if the signal is VCC then blow *)
   then                           (* all the fuses.                 *)
    begin
     for i:=1 to 40 do fusemap[prodterm,i]:='-';
     fuses:=fuses+40;
     case pin_num of
       15,17,19,21 : fusemap[prodterm,41]:='-';
       16,18,20,22 : fusemap[prodterm,42]:='-';
       otherwise
         begin
          fuses:=fuses-1;
         end;
      end;
     fuses:=fuses+1;
    end;
  if (eqnptr^.chiptr^.level = 12) then
   begin
    case pin_num of
     15,17,19,21 : fusemap[prodterm,41]:='-';
     16,18,20,22 : fusemap[prodterm,42]:='-';
     otherwise
      begin
       fuses:=fuses-1;
      end;
     end;
    fuses:=fuses+1;
  end;
end;

(************************************************************)
(* This procedure  creates the andlst for each sibling of   *)
(* the orgate. And for each signal attached to the AND gate *)
(* bloww the fuse.                                          *)
(************************************************************)

procedure product (andptr:tree_ptr);

var andlst,templst:op_node;
    temptr:tree_ptr;
    i:integer;

begin
 andptr^.rsibling:=nil;
 andlst:=nil;
 create_andlst(andptr,andlst);
 if andlst<>nil then
  begin
   templst:=andlst;
   temptr:=templst^.ptr^.child;
   blow_fuse(temptr);
   temptr:=templst^.ptr^.child^.rsibling;
   blow_fuse(temptr);
   while templst<>nil do
    begin
     if templst^.ptr^.rsibling<>nil then
      blow_fuse(templst^.ptr^.rsibling);
     templst:=templst^.next;
    end;
  end;
 if andlst=nil then
  blow_fuse(andptr);
end;

begin  (* start of the procedure xplot *)
fuses:=0;
pin_num:=0;
vert:=0;
prodterm:=0;
for i:=1 to 80 do      (* Initialise the fuse map and polar map to 'x' *)
for j:=1 to 42 do
 fusemap[i,j]:='x';
for i:=1 to 10 do pol_map[i]:='x';
for i:=1 to 10 do prodtot[i]:=0;
while eqnptr<>nil do
 begin
  temptr1:=eqnptr^.rsibling;
  eqnptr^.rsibling:=nil;
  pin_num:= eqnptr^.child^.chiptr^.level;
  if ((eqnptr^.child^.chiptr^.polarity)
     and (eqnptr^.child^.polarity))
    or ((not(eqnptr^.child^.chiptr^.polarity)) and
        (not(eqnptr^.child^.polarity))) then
    pol_map[pin_num-13]:='-';
  case pin_num of
        14 : prodterm:=73;
        15 : prodterm:=72;
        16 : prodterm:=57;
        17 : prodterm:=56;
        18 : prodterm:=41;
        19 : prodterm:=40;
        20 : prodterm:=25;
        21 : prodterm:=24;
        22 : prodterm:=9;
        23 : prodterm:=1;
    end;
  orlst:=nil;
  create_orlst(eqnptr^.child^.rsibling,orlst);
  if orlst<>nil then
   begin
    templst:=orlst;
    temptr2:=templst^.ptr^.child^.rsibling;
    templst^.ptr^.child^.rsibling:=nil;
    check ( pinlist,pin_num,errflag);
    product(templst^.ptr^.child);
    case pin_num of
      14,16,18,20,22,23 : prodterm:=prodterm+1;
      15,17,19,21       : prodterm:=prodterm-1;
    end;
    prodtot[pin_num-13]:=prodtot[pin_num-13]+1;
    templst^.ptr^.child^.rsibling:=temptr2;
    check(pinlist,pin_num,errflag);       (* prodterms can be caught *)
    product(templst^.ptr^.child^.rsibling);
    case pin_num of
     14,16,18,20,22,23 : prodterm:=prodterm+1;
     15,17,19,21 : prodterm:=prodterm-1;
    end;
    prodtot[pin_num - 13]:=prodtot[pin_num-13]+1;
    while templst^.next<>nil do
     begin
      if templst^.ptr^.rsibling<>nil then
      begin
       check(pinlist,pin_num,errflag);
       product (templst^.ptr^.rsibling);
       case pin_num of
        14,16,18,20,22,23 : prodterm:=prodterm+1;
        15,17,19,21 : prodterm:=prodterm-1;
       end;
      prodtot[pin_num-13]:=prodtot[pin_num-13]+1;
      end;
       templst:=templst^.next;
     end;
   end;
 if orlst=nil then
   begin
    check (pinlist,pin_num,errflag);
    product(eqnptr^.child^.rsibling);
   end;
 eqnptr^.rsibling:=temptr1;     (* repeate for all equations *)
 eqnptr:=eqnptr^.rsibling;
end;
writeln(f,'PALASM V1.9A - 20RP10');
writeln(f);
if (pinlist^.rsibling^.level<>1)
  then write(f,pinlist^.rsibling^.id_name,'        ');
if (pinlist^.rsibling^.rsibling^.level<>1) then
       write(f,pinlist^.rsibling^.rsibling^.id_name);
writeln(f);
writeln(f,'   ','            11 1111 1111 2222 2222 2233 3333 3333    ');
writeln(f,'   ','0123 4567 8901 2345 6789 0123 4567 8901 2345 6789  01');
writeln(f);
for i:=1 to 80 do
 begin
  if(i=9)  or (i=25)  or (i=41)
    or (i=57) or  (i=73) then writeln(f);
  write(f,(i-1):2,' ');
 for vert := 1 to 40 do
  begin
   if (vert=5) or (vert=9) or (vert=13) or (vert=17) or (vert=21)
    or(vert=25) or (vert=29) or (vert=33) or (vert=37) then write(f,' ');
   write(f,fusemap[i,vert]);
  end;
if((i>=1)and(i<=8)) or ((i>=73) and (i<=80)) then
    write(f,'  ',fusemap[i,41])
else
    write(f,'  ',fusemap[i,41],fusemap[i,42]);
writeln(f);
end;
writeln(f);
writeln(f,'Polarity Fuses ');
writeln(f);
writeln(f,'Output pin: ','1111112222');
writeln(f,'            ','4567890123');
writeln(f);
write(f,'            ');
for i:=1 to 10 do write(f,pol_map[i]);
writeln(f);
writeln(f);
writeln(f, 'Legend:  fuse blown: -   fuse intact: x');
writeln(f);
writeln(f, 'Fuses Blown :', fuses:5);
102: end;
end.

writeln(f, 'Legend:  fuse blown: -   fuse intact: x');
writeln(f);
writeln(f, 'Fuses Blown :', fuses:5);
102: end;
en