TITLE 'APEEL FILE: PEEL18CV8 Synchronization Circuits
DESIGNER: Robin Jigour and James Khong
DATE: 9/13/88'

PEEL18CV8

"DESCRIPTION
"                      PEEL18CV8
"                     _____  _____
"                    |     \/     |
"               CLK  { 1       20 }  Vcc
"                I1  { 2       19 }- SYNC1
"                I2  { 3       18 }- SYNC2
"                I3  { 4       17 }- SYNC3
"                I4  { 5       16 }- SYNC4
"                I5  { 6       15 }- SYNC5      { - = output}
"                I6  { 7       14 }- SYNC6
"                I7  { 8       13 }- SYNC7
"                I8  { 9       12 }- SYNC8
"               Gnd  {10       11 }  RESET
"                    |____________|
"
"Quite often in synchronous systems, there is a need to synchronize an
"asynchronous input in order to avoid potential metastability conditions
"due to set-up time violations. A common method is to use two rippled D-type
"flip-flops (i.e. 74LS74).
"                                 Ŀ       Ŀ
"   Asynchronous Input  ĴD  QĴD  Qį  Synchronized
"         System Clock  o>      Ĵ>           Input
"                                      
"                         
"
"This APEEL application example uses the internal feedback capability
"(configuration# 6) of the PEEL18CV8 macro cell to emulate the above
"synchronization circuit.  The internal feedback is used to create an
"asynchronous latch before the register. The asynchronous latch is clocked on
"the falling edge of CLK, the register is clocked on the rising edge of CLK.
"
"PIN ASSIGNMENTS
"---------------
" CLK     - System Clock
" I(n)    - Asynchronous Input data signals
" SYNC(n) - Synchronized Output data signals
" RESET   - Synchronous Reset

"Inputs
  CLK         pin 1
  I1          pin 2
  I2          pin 3
  I3          pin 4
  I4          pin 5
  I5          pin 6
  I6          pin 7
  I7          pin 8
  I8          pin 9
  RESET       pin 11

"Outputs and Macro cell configurations
  SYNC1       pin 19 = pos reg feed_or
  SYNC2       pin 18 = pos reg feed_or
  SYNC3       pin 17 = pos reg feed_or
  SYNC4       pin 16 = pos reg feed_or
  SYNC5       pin 15 = pos reg feed_or
  SYNC6       pin 14 = pos reg feed_or
  SYNC7       pin 13 = pos reg feed_or
  SYNC8       pin 12 = pos reg feed_or

"Internal Nodes
 AC     node 21              "Asynchronous Clear - not used
 SP     node 22              "Synchronous Preset - not used


EQUATIONS

SYNC1 := !RESET &  CLK &    I1 #  "When CLK=1, latches SYNC1 at register.
         !RESET & !CLK & SYNC1 #  "When CLK=0, latches SYNC1 internally.
         !RESET &   I1 & SYNC1    "Prevents hazard condition.

SYNC2 := !RESET &  CLK &    I2 #
         !RESET & !CLK & SYNC2 #
         !RESET &   I2 & SYNC2

SYNC3 := !RESET &  CLK &    I3 #
         !RESET & !CLK & SYNC3 #
         !RESET &   I3 & SYNC3

SYNC4 := !RESET &  CLK &    I4 #
         !RESET & !CLK & SYNC4 #
         !RESET &   I4 & SYNC4

SYNC5 := !RESET &  CLK &    I5 #
         !RESET & !CLK & SYNC5 #
         !RESET &   I5 & SYNC5

SYNC6 := !RESET &  CLK &    I6 #
         !RESET & !CLK & SYNC6 #
         !RESET &   I6 & SYNC6

SYNC7 := !RESET &  CLK &    I7 #
         !RESET & !CLK & SYNC7 #
         !RESET &   I7 & SYNC7

SYNC8 := !RESET &  CLK &    I8 #
         !RESET & !CLK & SYNC8 #
         !RESET &   I8 & SYNC8


TEST_VECTORS

(CLK RESET I1 I2 I3 I4 I5 I6 I7 I8 -> SYNC1 SYNC2 SYNC3 SYNC4 SYNC5 SYNC6 SYNC7 SYNC8)
  C    1    0  0  0  0  0  0  0  0 ->   L      L     L     L     L     L     L     L
  0    0    0  0  0  0  0  0  0  0 ->   L      L     L     L     L     L     L     L
  1    0    0  0  0  0  0  0  0  0 ->   L      L     L     L     L     L     L     L
  1    0    1  1  1  1  1  1  1  1 ->   L      L     L     L     L     L     L     L
  0    0    1  1  1  1  1  1  1  1 ->   L      L     L     L     L     L     L     L
  1    0    1  1  1  1  1  1  1  1 ->   H      H     H     H     H     H     H     H
  1    0    0  0  0  0  0  0  0  0 ->   H      H     H     H     H     H     H     H
  0    0    0  0  0  0  0  0  0  0 ->   H      H     H     H     H     H     H     H
  0    0    0  0  0  0  0  0  0  0 ->   H      H     H     H     H     H     H     H
  1    0    0  0  0  0  0  0  0  0 ->   L      L     L     L     L     L     L     L