TITLE 'APEEL FILE: PEEL18CV8 8-Bit Counter with Function Controls
DESIGNER:   Robin Jigour and John Birkner
DATE:       9/14/87'

P18CV8

"DESCRIPTION

"                      PEEL18CV8

" 8-bit Binary Counter with Hold, Reset, Repeat and Output Enable
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     20 }  Vcc
"             (TEST) { 2     19 }- Q0     ( - = output )
"                    { 3     18 }- Q1
"                    { 4     17 }- Q2
"                    { 5     16 }- Q3
"                    { 6     15 }- Q4
"              HOLD  { 7     14 }- Q5
"              SRES  { 8     13 }- Q6
"              REP   { 9     12 }- Q7
"               Gnd  {10     11 }  /OE
"                    |__________|

"
" This application uses the PEEL18CV8 as an 8 bit counter with four
" control functions: hold, reset, repeat and output enable. The
" operation of each control listed below.  The Synchronous Preset
" term was utilized to free-up a product term from the eighth bit of
" the counter.  This allowed the hold function to be implemented.

" SRES  (Synchronous Reset) - When SRES is set high the outputs
" (Q0-7) will go low after the next clock.  When SRES is set high
" the counter will start counting up with each clock.

" HOLD  (Hold Count) - When HOLD is set high the count will hold the
" present state. When HOLD is low the counter will resume.

" REP (Repeat Count) - When REP is set high, the counter repeat the
" count after reaching FF hex.  When REP is set low, the counter will
" stop after one complete count.

" OE  (Output Enable) - When OE is high the outputs will disable to
" high impedance.  When low the outpus are enabled.

" (TEST) - This input is used to preload the registers to simplify
" test vector operation.


"PIN ASSIGNMENTS

 CLK      pin 1
 TEST     pin 2                     "For test only, set Q0-Q5 to 1's.
 HOLD     pin 7
 SRES     pin 8
 REP      pin 9
 !OE      pin 11


"Outputs"

 Q7       pin 12 = pos reg feed_reg  "All positive registered outputs.
 Q6       pin 13 = pos reg feed_reg
 Q5       pin 14 = pos reg feed_reg
 Q4       pin 15 = pos reg feed_reg
 Q3       pin 16 = pos reg feed_reg
 Q2       pin 17 = pos reg feed_reg
 Q1       pin 18 = pos reg feed_reg
 Q0       pin 19 = pos reg feed_reg


"Internal Nodes"

 AC        node 21                   "Asynchronous Clear node.
 SP        node 22                   "Synchronous Preset node.


EQUATIONS

AC  = !SRES & !REP & !Q7 & !Q6 & !Q5 & !Q4 & !Q3 & !Q2 & !Q1 & !Q0
         "If REP=1 repeat count else stop at count 00 hex.

SP  = !SRES & Q7 & Q6 & Q5 & Q4 & Q3 & Q2 & Q1 & !Q0
         "Free up product term on Q7.

Q0  =  !SRES & !HOLD & !Q0 #           "Count.
       !SRES &  HOLD &  Q0 #           "Hold state.
       !SRES &  TEST
Enable Q0 = OE                         "Enable output.

Q1  =  !SRES & !HOLD  & !Q1 &  Q0 #
       !SRES & !HOLD  &  Q1 & !Q0 #
       !SRES &  HOLD  &  Q1       #
       !SRES &  TEST
Enable Q1 = OE

Q2  =  !SRES & !HOLD  & !Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q2 & !Q1       #
       !SRES & !HOLD  &  Q2 &       !Q0 #
       !SRES &  HOLD  &  Q2             #
       !SRES &  TEST
Enable Q2 = OE

Q3  =  !SRES & !HOLD  & !Q3 &  Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q3 & !Q2             #
       !SRES & !HOLD  &  Q3 &       !Q1       #
       !SRES & !HOLD  &  Q3 &             !Q0 #
       !SRES &  HOLD  &  Q3                   #
       !SRES &  TEST
Enable Q3 = OE

Q4  =  !SRES & !HOLD  & !Q4 &  Q3 &  Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q4 & !Q3                   #
       !SRES & !HOLD  &  Q4 &       !Q2             #
       !SRES & !HOLD  &  Q4 &             !Q1       #
       !SRES & !HOLD  &  Q4 &                   !Q0 #
       !SRES &  HOLD  &  Q4                         #
       !SRES &  TEST
Enable Q4 = OE

Q5  =  !SRES & !HOLD  & !Q5 &  Q4 &  Q3 &  Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q5 & !Q4                         #
       !SRES & !HOLD  &  Q5 &       !Q3                   #
       !SRES & !HOLD  &  Q5 &             !Q2             #
       !SRES & !HOLD  &  Q5 &                   !Q1       #
       !SRES & !HOLD  &  Q5 &                         !Q0 #
       !SRES &  HOLD  &  Q5                               #
       !SRES &  TEST
Enable Q5 = OE

Q6  =  !SRES & !HOLD  & !Q6 &  Q5 &  Q4 &  Q3 &  Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q6 & !Q5                               #
       !SRES & !HOLD  &  Q6 &       !Q4                         #
       !SRES & !HOLD  &  Q6 &             !Q3                   #
       !SRES & !HOLD  &  Q6 &                   !Q2             #
       !SRES & !HOLD  &  Q6 &                         !Q1       #
       !SRES & !HOLD  &  Q6 &                               !Q0 #
       !SRES &  HOLD  &  Q6
Enable Q6 = OE

Q7  =  !SRES & !HOLD  & !Q7 &  Q6 &  Q5 &  Q4 &  Q3 &  Q2 &  Q1 &  Q0 #
       !SRES & !HOLD  &  Q7 & !Q6                                     #
       !SRES & !HOLD  &  Q7 &       !Q5                               #
       !SRES & !HOLD  &  Q7 &             !Q4                         #
       !SRES & !HOLD  &  Q7 &                   !Q3                   #
       !SRES & !HOLD  &  Q7 &                         !Q2             #
       !SRES & !HOLD  &  Q7 &                               !Q1       #
       !SRES &  HOLD  &  Q7
Enable Q7 = OE


TEST_VECTORS

( CLK  TEST  HOLD  SRES  REP  OE -> Q7  Q6  Q5  Q4  Q3  Q2  Q1  Q0 )
   C    0     0     1     0    1 ->  X   X   X   X   X   X   X   X
   C    0     0     1     0    1 ->  L   L   L   L   L   L   L   L
   C    0     0     0     1    1 ->  L   L   L   L   L   L   L   H
   C    0     0     0     0    0 ->  Z   Z   Z   Z   Z   Z   Z   Z
   C    0     0     0     0    1 ->  L   L   L   L   L   L   H   H
   C    0     0     1     0    1 ->  L   L   L   L   L   L   L   L
   C    0     0     0     0    1 ->  L   L   L   L   L   L   L   L
   C    0     0     0     1    1 ->  L   L   L   L   L   L   L   H
   C    0     0     0     0    1 ->  L   L   L   L   L   L   H   L
   C    1     0     0     0    1 ->  L   L   H   H   H   H   H   H
   C    0     0     0     0    1 ->  L   H   L   L   L   L   L   L
   C    1     0     0     0    1 ->  L   H   H   H   H   H   H   H
   C    0     0     0     0    1 ->  H   L   L   L   L   L   L   L
   C    1     0     0     0    1 ->  H   L   H   H   H   H   H   H
   C    0     0     0     0    1 ->  H   H   L   L   L   L   L   L
   C    0     0     0     0    1 ->  H   H   L   L   L   L   L   H
   C    0     0     0     0    1 ->  H   H   L   L   L   L   H   L
   C    0     1     0     0    1 ->  H   H   L   L   L   L   H   L
   C    0     1     0     0    1 ->  H   H   L   L   L   L   H   L
   C    1     0     0     0    1 ->  H   H   H   H   H   H   H   H
   C    0     1     0     0    1 ->  H   H   H   H   H   H   H   H
   C    0     1     0     0    1 ->  H   H   H   H   H   H   H   H
   C    0     0     0     0    1 ->  L   L   L   L   L   L   L   L
   C    0     0     0     0    1 ->  L   L   L   L   L   L   L   L
   C    0     0     0     1    1 ->  L   L   L   L   L   L   L   H
