TITLE 'APEEL FILE: PEEL18CV8 CLOCK DIVIDER AND ADDRESS DECODER
DESIGNER: Robin Jigour, ICT
DATE: 9/20/87'

PEEL18CV8

"DESCRIPTION

"                      PEEL18CV8

"            Clock Divider and Address Decoder
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     20 }   Vcc
"               SET  { 2     19 }-  CLK2    ( - = output )
"               A08  { 3     18 }-  CLK4
"               A09  { 4     17 }-  CLK8
"               A10  { 5     16 }-  /EPROM
"               A11  { 6     15 }-  /EEPROM
"               A12  { 7     14 }-  /UART
"               A13  { 8     13 }-  /PORT
"               A14  { 9     12 }-  /SRAM
"               Gnd  {10     11 }   A15
"                    |__________|

" This application uses the PEEL18CV8 for two common microprocessor
" system functions:a clock divider and a memory mapped address decoder
" The clock divider provides divide 2, 4 and 8 clock outputs. The SET
" input sets all clock outputs high.  The address decoder decodes the
" processor address lines to select one of five memory or I/O devices.
" The chip select for these devices are active low.  The memory map
" over a 64K boundry is shown below.

"  Memory Map for Address Decoder
"
"  EPROM  (32K X 8)     8000-FFFF hex
"  EEPROM ( 2K X 8)     5000-5FFF hex
"  UART                 4100-41FF hex
"  PORT                 4000-40FF hex
"  SRAM   ( 8K X 8)     0000-1FFF hex


"PIN ASSIGNMENTS

"Inputs

 CLK      pin 1
 SET      pin 2
 A08      pin 3
 A09      pin 4
 A10      pin 5
 A11      pin 6
 A12      pin 7
 A13      pin 8
 A14      pin 9
 A15      pin 11


"Outputs and Macro Cell definitions

SRAM    pin 12 = neg com feed_pin  "5 Combinatorial outputs.
PORT    pin 13 = neg com feed_pin
UART    pin 14 = neg com feed_pin  "Pins 12-16 have active low outputs.
EEPROM  pin 15 = neg com feed_pin
EPROM   pin 16 = neg com feed_pin
CLK8    pin 17 = pos reg feed_reg  "3 Registered outputs.
CLK4    pin 18 = pos reg feed_reg
CLK2    pin 19 = pos reg feed_reg


"Internal Nodes

 AC      node 21                      "Asynchronous Clear - not used.
 SP      node 22                      "Synchronous Preset.


EQUATIONS

"Clock Divider

SP = SET                           "If SET=1 set all CLK outputs high.

CLK2 := !CLK2                      "CLK divided by 2.

CLK4 := !CLK4 &  CLK2 #            "CLK divided by 4.
         CLK4 & !CLK2

CLK8 := !CLK8 &  CLK4 &  CLK2 #    "CLK divided by 8.
         CLK8 & !CLK4 #
         CLK8 & !CLK2


"Address Decoder (active low outputs)

/SRAM   =  !A15 & !A14 & !A13      "The '/' is actually ignored by APEEL.
                                   "Here, the '/' is inserted to:
                                   "  (1) indicate that the output is active
                                   "      LOW, and
                                   "  (2) allow the user to match the output
                                   "      signal name with what's on his/her
                                   "      design.
                                   "Note: '/' can be used instead of '!'.

/PORT   =  !A15 &  A14 & !A13 & !A12 & !A11 & !A10 & !A09 & !A08

/UART   =  !A15 &  A14 & !A13 & !A12 & !A11 & !A10 & !A09 &  A08

/EEPROM =  !A15 &  A14 & !A13 &  A12 & !A11

/EPROM  =  A15


TEST_VECTORS "for Clock Divider"

(  CLK  SET   ->   CLK8  CLK4  CLK2  )
    C    1    ->     H     H     H
    C    0    ->     L     L     L
    C    0    ->     L     L     H
    C    0    ->     L     H     L
    C    0    ->     L     H     H
    C    0    ->     H     L     L
    C    0    ->     H     L     H
    C    0    ->     H     H     L
    C    0    ->     H     H     H
    C    0    ->     L     L     L


TEST_VECTORS "for Address Decoder"

( A15 A14 A13 A12 A11 A10 A09 A08  ->   EPROM EEPROM UART PORT SRAM  )
   0   0   0   X   X   X   X   X   ->     H      H     H    H    L
   0   0   1   X   X   X   X   X   ->     H      H     H    H    H
   0   1   0   0   0   0   0   0   ->     H      H     H    L    H
   0   1   0   0   0   0   0   1   ->     H      H     L    H    H
   0   1   0   1   0   X   X   X   ->     H      L     H    H    H
   0   1   1   0   X   X   X   X   ->     H      H     H    H    H
   1   X   X   X   X   X   X   X   ->     L      H     H    H    H