TITLE 'APEEL FILE: PEEL22CV10 8-Bit Up/Down Loadable Counter with
       Carry-Out or Borrow-In.
DESIGNER: James Khong              DATE: 6/9/88'

Peel22CV10

"DESCRIPTION"

"                     PEEL22CV10
"                     ____  ____
"                    |    \/    |
"               CLK  { 1     24 }  Vcc
" (synchronous) CLR  { 2     23 }  LOAD  (This I/O is used as an input)
"                UP  { 3     22 }  CO_BI (Carry-Out/Borrow-In)
"                D4  { 4     21 }  Q4
"                D5  { 5     20 }  Q5
"                D6  { 6     19 }  Q6
"                D7  { 7     18 }  Q7
"                D3  { 8     17 }  Q3
"                D2  { 9     16 }  Q2
"                D1  {10     15 }  Q1
"                D0  {11     14 }  Q0
"               Gnd  {12     13 }  !OE
"                    |__________|


" This application uses the PEEL22CV10 as an 8-bit Up/Down Loadable counter.
" The four controls are:
"     CLR (Synchronous Clear) - When CLR is set to High, all outputs (Q7-Q0
"                               and CO_BI) will be set to Low on next clock.
"     UP (Up/Down control)    - When UP is set to High, outputs Q7-Q0 will
"                               count up on each clock. When UP is set
"                               to Low, outputs Q7-Q0 will count down.
"     LOAD (Load data)        - When LOAD is set High, outputs Q7-Q0 will
"                               follow the data of D7-D0 on next clock and
"                               the output CO_BI will be set to Low.
"     !OE (Output Enable)     - When OE is set to High, all outputs (Q7-Q0
"                               and CO_BI) will be High Impedance. When OE
"                               is set Low, all outputs will be enabled.
"
" Note: After counting up 255, the count will go to 0 and the CO_BI will be
"       set High on next clock. The High will remain on the CO_BI pin until
"       LOAD or CLR goes High.
"
" The table below describes the operation:
"
" OPERATION TABLE
"  -----------------------------------------------------------------
" | CLK | CLR | UP | LOAD | !OE |  D7 - D0  |   Q7 - Q0   |  CO_BI  |
"  -----------------------------------------------------------------
" |  C  |  1  |  X |   X  |  0  |     X     |     LOW     |    0    |
" |  C  |  0  |  1 |   0  |  0  |     X     |   COUNT UP  |    0    |
" |  C  |  0  |  1 |   0  |  0  |     X     |   255 -> 0  |    1    | Carry-Out
" |  C  |  0  |  0 |   0  |  0  |     X     |  COUNT DOWN |    0    |
" |  C  |  0  |  0 |   0  |  0  |     X     |   0 -> 255  |    1    | Borrow-In
" |  C  |  0  |  X |   1  |  0  |  DATA IN  |   DATA IN   |    0    |
" |  X  |  X  |  X |   X  |  1  |     X     |   3-STATE   |    0    |
"  -----------------------------------------------------------------
"  C = CLOCK PULSE (0 -> 1)
"  X = DON'T CARE


"PIN ASSIGNMENTS

CLK      pin 1
CLR      pin 2
D0       pin 3
D1       pin 4
D2       pin 5
D3       pin 6
D4       pin 7
D5       pin 8
D6       pin 9
D7       pin 10
UP       pin 11
OE       pin 13
LOAD     pin 23             "Used as input only. Default macro configuration
                            "is defaulted to 'pos com feed_pin'.

Q0       pin 14 = pos reg   "All positive registered outputs.
Q1       pin 15 = pos reg
Q2       pin 16 = pos reg
Q3       pin 17 = pos reg
Q7       pin 18 = pos reg
Q6       pin 19 = pos reg
Q5       pin 20 = pos reg
Q4       pin 21 = pos reg
CO_BI    pin 22 = pos reg   "Carry-Out / Borrow-In.

AC        node 25           "Asynchronous Clear node - not used.
SP        node 26           "Synchronous Preset node.


Equations

Enable Q7    = !OE
Enable Q6    = !OE
Enable Q5    = !OE
Enable Q4    = !OE
Enable Q3    = !OE
Enable Q2    = !OE
Enable Q1    = !OE
Enable Q0    = !OE
Enable CO_BI = !OE
Enable LOAD  = 0          "Disables output (unconditionally).

SP = !CLR & !Q0 & !Q1 & !Q2 & !Q3 & !Q4 & !Q5 & !Q6 & !Q7 & !UP & !LOAD;

Q7 = !CLR &  Q0 & Q7 & !UP & !LOAD #  "Count Down.
     !CLR &  Q1 & Q7 & !UP & !LOAD #
     !CLR &  Q2 & Q7 & !UP & !LOAD #
     !CLR &  Q3 & Q7 & !UP & !LOAD #
     !CLR &  Q4 & Q7 & !UP & !LOAD #
     !CLR &  Q5 & Q7 & !UP & !LOAD #
     !CLR &  Q6 & Q7 & !UP & !LOAD #
     !CLR & !Q0 & Q7 &  UP & !LOAD #  "Count Up.
     !CLR & !Q1 & Q7 &  UP & !LOAD #
     !CLR & !Q2 & Q7 &  UP & !LOAD #
     !CLR & !Q3 & Q7 &  UP & !LOAD #
     !CLR & !Q4 & Q7 &  UP & !LOAD #
     !CLR & !Q5 & Q7 &  UP & !LOAD #
     !CLR & !Q6 & Q7 &  UP & !LOAD #
     !CLR &  Q0 & Q1 &  Q2 & Q3 & Q4 & Q5 & Q6 & !Q7 & UP & !LOAD #
     !CLR &  D7 & LOAD                "Load Data.

Q6 = !CLR & !Q0 & !Q1 & !Q2 & !Q3 & !Q4 & !Q5 & !Q6 & !UP & !LOAD #
     !CLR &  Q0 & Q6 & !UP & !LOAD #
     !CLR &  Q1 & Q6 & !UP & !LOAD #
     !CLR &  Q2 & Q6 & !UP & !LOAD #
     !CLR &  Q3 & Q6 & !UP & !LOAD #
     !CLR &  Q4 & Q6 & !UP & !LOAD #
     !CLR &  Q5 & Q6 & !UP & !LOAD #
     !CLR & !Q0 & Q6 &  UP & !LOAD #
     !CLR & !Q1 & Q6 &  UP & !LOAD #
     !CLR & !Q2 & Q6 &  UP & !LOAD #
     !CLR & !Q3 & Q6 &  UP & !LOAD #
     !CLR & !Q4 & Q6 &  UP & !LOAD #
     !CLR & !Q5 & Q6 &  UP & !LOAD #
     !CLR &  Q0 & Q1 & Q2 & Q3 & Q4 & Q5 & !Q6 & UP & !LOAD #
     !CLR &  D6 & LOAD

Q5 = !CLR & !Q0 & !Q1 & !Q2 & !Q3 & !Q4 & !Q5 & !UP & !LOAD #
     !CLR &  Q0 & Q5 & !UP & !LOAD #
     !CLR &  Q1 & Q5 & !UP & !LOAD #
     !CLR &  Q2 & Q5 & !UP & !LOAD #
     !CLR &  Q3 & Q5 & !UP & !LOAD #
     !CLR &  Q4 & Q5 & !UP & !LOAD #
     !CLR & !Q0 & Q5 &  UP & !LOAD #
     !CLR & !Q1 & Q5 &  UP & !LOAD #
     !CLR & !Q2 & Q5 &  UP & !LOAD #
     !CLR & !Q3 & Q5 &  UP & !LOAD #
     !CLR & !Q4 & Q5 &  UP & !LOAD #
     !CLR &  Q0 & Q1 &  Q2 & Q3 & Q4 & !Q5 & UP & !LOAD #
     !CLR & D5 & LOAD

Q4 = !CLR & !Q0 & !Q1 & !Q2 & !Q3 & !Q4 & !UP & !LOAD #
     !CLR &  Q0 & Q4 & !UP & !LOAD #
     !CLR &  Q1 & Q4 & !UP & !LOAD #
     !CLR &  Q2 & Q4 & !UP & !LOAD #
     !CLR &  Q3 & Q4 & !UP & !LOAD #
     !CLR & !Q0 & Q4 &  UP & !LOAD #
     !CLR & !Q1 & Q4 &  UP & !LOAD #
     !CLR & !Q2 & Q4 &  UP & !LOAD #
     !CLR & !Q3 & Q4 &  UP & !LOAD #
     !CLR &  Q0 & Q1 & Q2 & Q3 & !Q4 & UP & !LOAD #
     !CLR & D4 & LOAD

Q3 = !CLR & !Q0 & !Q1 & !Q2 & !Q3 & !UP & !LOAD #
     !CLR &  Q0 & Q3 & !UP & !LOAD #
     !CLR &  Q1 & Q3 & !UP & !LOAD #
     !CLR &  Q2 & Q3 & !UP & !LOAD #
     !CLR & !Q0 & Q3 &  UP & !LOAD #
     !CLR & !Q1 & Q3 &  UP & !LOAD #
     !CLR & !Q2 & Q3 &  UP & !LOAD #
     !CLR &  Q0 & Q1 &  Q2 & !Q3 & UP & !LOAD #
     !CLR &  D3 & LOAD

Q2 = !CLR & !Q0 & !Q1 & !Q2 & !UP & !LOAD #
     !CLR &  Q0 & Q2 & !UP & !LOAD #
     !CLR &  Q1 & Q2 & !UP & !LOAD #
     !CLR & !Q0 & Q2 &  UP & !LOAD #
     !CLR & !Q1 & Q2 &  UP & !LOAD #
     !CLR &  Q0 & Q1 & !Q2 & UP & !LOAD #
     !CLR &  D2 & LOAD

Q1 = !CLR & !Q0 & !Q1 & !UP & !LOAD #
     !CLR &  Q0 &  Q1 & !UP & !LOAD #
     !CLR & !Q0 &  Q1 &  UP & !LOAD #
     !CLR &  Q0 & !Q1 &  UP & !LOAD #
     !CLR &  D1 & LOAD

Q0 = !CLR & !Q0 & !LOAD #
     !CLR &  D0 &  LOAD

CO_BI = !CLR & !Q0   & !Q1 & !Q2 & !Q3 & !Q4 & !Q5 & !Q6 & !Q7 & !UP & !LOAD #
        !CLR &  Q0   &  Q1 &  Q2 &  Q3 &  Q4 &  Q5 &  Q6 &  Q7 &  UP & !LOAD #
        !CLR & CO_BI & !LOAD  "Latch in the previous CO_BI.


Test_vectors

(CLK CLR UP LOAD D7 D6 D5 D4 D3 D2 D1 D0 OE -> Q7 Q6 Q5 Q4 Q3 Q2 Q1 Q0 CO_BI)
  C   1   X   X   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  L   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  H   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  H  L   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  H  H   L
  C   0   1   1   1  1  1  1  1  1  0  1  0 ->  H  H  H  H  H  H  L  H   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  H  H  H  H  H  H  H  L   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  H  H  H  H  H  H  H  H   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  L   H
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  H   H
  C   0   0   1   0  1  0  1  0  1  0  1  0 ->  L  H  L  H  L  H  L  H   L
  C   0   1   0   X  X  X  X  X  X  X  X  0 ->  L  H  L  H  L  H  H  L   L
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  L  H  L  H  L  H  L  H   L
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  L  H  L  H  L  H  L  L   L
  C   0   0   1   0  0  0  0  0  0  1  0  0 ->  L  L  L  L  L  L  H  L   L
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  H   L
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  L   L
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  H  H  H  H  H  H  H  H   H
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  H  H  H  H  H  H  H  L   H
  C   0   0   0   X  X  X  X  X  X  X  X  0 ->  H  H  H  H  H  H  L  H   H
  C   1   1   1   X  X  X  X  X  X  X  X  0 ->  L  L  L  L  L  L  L  L   L
