;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Filename	: NPNP_18.ASM
; Description	: Sample Non-PnP Resource data file for NM95MS18
; Date		: Jun 1, 1997
; Revision date : 
; Device	: NM95MS18
; Author	: Fairchild Semiconductor Corporation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;-------------------------------------------------------------------------------------
;--------------------------- NM95MS18 NON_PNP PORTION FORMAT  ------------------------
;-------------------------------------------------------------------------------------
; NM95MS18 can handle upto 31 NON-PNP configurations occupying a total of 248 bytes.
; Each NON-PNP configuration information occupies 8 bytes (Byte#0 through Byte#7 )
; and has the following format.
; ------------------------------------------------------------------------------------
; BYTE#0 INFORMATION :
;
;	 Bit[7:6] - IRQIN1 TYPE
;		  - "00" <-- LOW_TRUE_EDGE_SENSITIVE
;		  - "01" <-- LOW_TRUE_LEVEL_SENSITIVE
;		  - "10" <-- HIGH_TRUE_EDGE_SENSITIVE (ISA BUS COMPATIBLE)
;		  - "11" <-- HIGH_TRUE_LEVEL_SENSITIVE
;	 Bit[5:4] - IRQIN0 TYPE
;		  - "00" <-- LOW_TRUE_EDGE_SENSITIVE
;		  - "01" <-- LOW_TRUE_LEVEL_SENSITIVE
;		  - "10" <-- HIGH_TRUE_EDGE_SENSITIVE (ISA BUS COMPATIBLE)
;		  - "11" <-- HIGH_TRUE_LEVEL_SENSITIVE
;        Bit[3]   - UNDEFINED ( DON'T CARE )
;	 Bit[2:0] - DRQ LEVEL SELECTED FOR 'DRQIN' SIGNAL
;		    "000" --> ISA DRQ0
;		    "001" --> ISA DRQ1
;		    "010" --> ISA DRQ2
;		    "011" --> ISA DRQ3
;		    "100" --> DRQIN is not used
;		    "101" --> ISA DRQ5
;		    "110" --> ISA DRQ6
;		    "111" --> ISA DRQ7
;-------------------------------------------------------------------------------------
; BYTE#1 INFORMATION :
;	
;        Bit[7:4] - IRQIN1 LEVEL
;		  - "0000" -->  IRQIN1 is not used
;		  - "0001" -->  ISA IRQ1
;		  - "0010" -->  ISA IRQ2 
;		  - "0011" -->  ISA IRQ3
;		  - "0100" -->  ISA IRQ4
;		  - "0101" -->  ISA IRQ5
;		  - "0110" -->  ISA IRQ6
;		  - "0111" -->  ISA IRQ7
;		  - "1000" -->  ISA IRQ8
;		  - "1001" -->  ISA IRQ9
;		  - "1010" -->  ISA IRQ10
;		  - "1011" -->  ISA IRQ11
;		  - "1100" -->  ISA IRQ12
;		  - "1101" -->  ISA IRQ13
;		  - "1110" -->  ISA IRQ14
;		  - "1111" -->  ISA IRQ15
;	 Bit[3:0] - IRQIN0 LEVEL
;		    Bit definitions are similar to Bit[7:4]
;
;-------------------------------------------------------------------------------------
; BYTE#2 This byte stores the LSB of the base address (SA7 through SA0)for IOCS2
;        signal. If IOCS2 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[7:0]   ( for IOCS2 signal )
;-------------------------------------------------------------------------------------
; BYTE#3 This byte stores the MSB of the base address (SA15 through SA8)for IOCS2 
;        signal. If IOCS2 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[15:8]   ( for IOCS2 signal )
;-------------------------------------------------------------------------------------
; BYTE#4 This byte stores the LSB of the base address (SA7 through SA0)for IOCS1
;        signal. If IOCS1 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[7:0]   ( for IOCS1 signal )
;-------------------------------------------------------------------------------------
; BYTE#5 This byte stores the MSB of the base address (SA15 through SA8)for IOCS1
;        signal. If IOCS1 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[15:8]   ( for IOCS1 signal )
;-------------------------------------------------------------------------------------
; BYTE#6 This byte stores the LSB of the base address (SA7 through SA0)for IOCS0
;        signal. If IOCS0 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[7:0]   ( for IOCS0 signal )
;-------------------------------------------------------------------------------------
; BYTE#7 This byte stores the MSB of the base address (SA15 through SA8)for IOCS0
;        signal. If IOCS0 signal is not used initialize this byte to 0x00 value.
;	 Bit[7:0] - SA[15:8]   ( for IOCS0 signal )
;-------------------------------------------------------------------------------------

; Repeat the above structure (Byte#0 through Byte#7) for every additional non-PnP
; configuration information. 


data segment
; Fill in the Non-PnP configuration information here 
;
;
;
;
;
;
data ends
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Note: 
;	This file is constructed in x86 Assembly language format. Common assembly
;	language compiler like MASM as well as any other C language compiler can 
;	compile this file. When using MASM, typical sequence would be to
; 	1) Compile this file using MASM.EXE
; 	2) Link the Object file using LINK.EXE. This will produce "EXE" version.
; 	3) Convert the "EXE" version to "BIN" version using DOS utility called 
;	   EXE2BIN.EXE.
; 	4) Program the "BIN" version of the file on to NM95MS18 using Fairchild 
;	   supplied programming utility "MS18V1.EXE". Also read MS18V1.TXT for 
;	   proper syntax.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
