	LIST ON                          ; 8/4/89
;
	INCLUDE	CONFIG.ASM
;
	IFTRUE FAX
	EXTERNAL	CHK_MDA0,R_PDATA
	EXTERNAL	CHK_MDAB,W_PDATA
	EXTERNAL	WAIT_3MS,PUT_CHAR,LATCH
	EXTERNAL	MSG_OK,MSG_ERR,SND_RESULT
;	EXTERNAL 	TIM_4,TIM_4F
;
	GLOBAL		SPDT,INI_SPDFT, LOST_DTR
;
S3	EQU	16H
OPT_1	EQU	9D0AH
;BIT
LOST_DTR	REG	20H.1	;DTR LOSS STATUS ( RDEFINE.ASM )
;BYTE1
BYTE1	EQU	22H
;	REG     22H.0		;BYTE AVA.
DELAC	REG     22H.0		;
;	REG	22H.1		;SEND BREAK
DCE_S	REG	22H.2		;DCE-SENDING
FLOW	REG	22H.3		;FLOW CONTROL NOW
SND_S	REG	22H.4		;SEND CONTROL S
SND_Q	REG	22H.5		;SEND CONTROL Q
;	REG	22H.6		;SEND DATA
FIN_F	REG	22H.7		;FAX DATA FINISHED
PAR_1		REG	26H.4	;PARITY OPTIONS
PAR_2		REG	26H.5	;
DTR_L	REG	P1.4		;DATA TERMINAL READY ( RDEFINE.ASM )
;


EIA	EQU	2FH
EIACTS	EQU	78H
;
TIM_4	EQU	0EH		; ( FROM RDEFINE.ASM )
TIM_4F	REG	2AH.3		;TIMER 4 FLAG
TIM_7	EQU	35H		; ( FROM RDEFINE.ASM )
TIM_7F	REG	2AH.6	;TIMER 7 FLAG
;
S_FLOW	EQU	0F1H
;
	RSECT
;BYTE
	ORG	3EH
O_PTRL	DS	1		;POINTER FOR OUTPUT
O_PTRH	DS	1
CNT_L	DS 	1		;COUNTER FOR DATA BYTE
CNT_H	DS	1
IN_L	DS	1		;POINTER FOR INPUT
IN_H	DS	1
DCE_TX	DS	1		;DCE TRANSMIT BUFFER
;
;CONSTANT
CTL_S	EQU	13H   		;CONTROL S
CTL_Q	EQU	11H		;CONTROL Q
FULL	EQU	0FFH
	EJECT
;	
	CODE
;
SPDT:
	LCALL	SPDH_TX		;TRANSMITTER FOR HALF DUPLEX MODE
	LCALL	DCE1_TX		;DCE TRANSMITTER ROUTINE
	LCALL	DTE_RX		;DTE TRANSMIT TO DCE ROUTINE
	LCALL	DTE_TX		;DCE TRANSMIT TO DTE ROUTINE
	JNB	FIN_F,SPDT
	RET
;
;=================================================
;9-14-90
;	DTE TRANSMITTER ROUTINE
;=================================================
;
DTE_TX:
	JBC	SND_S,G_SNDS	;SEND CTL_S ?
	JBC	SND_Q,G_SNDQ	;SEND CTL_Q ?
	RET
G_SNDS:
	MOV	A,#CTL_S
	LCALL	ADDPAR
	LCALL	PUT_CHAR	;
	SETB	S_FLOW		;FLOW CONTROL IS ON
	RET
G_SNDQ:
	MOV	A,#CTL_Q
	LCALL	ADDPAR
	LCALL	PUT_CHAR	;
	CLR	S_FLOW		;FLOW CONTROL IS OFF
	RET
;
ADDPAR:	ANL	A,#7FH
	JB	PAR_1,PUT001
	MOV	C,P
	JNB	PAR_2,PUT002
	CPL	C
PUT002:	MOV	ACC.7,C
	SJMP	PUT003
PUT001:	JNB	PAR_2,PUT003
 	SETB	ACC.7
PUT003:	RET
;	
;============================================
;	DTE RECEIVE ROUTINE
; TAKE DATA FROM SERIAL PORT, THEN SAVE IN BUFFER
;============================================
;
DTE_RX:
	JBC	RI,CON_RX		;ANY DATA FROM SERIAL PORT
	JB	TIM_4F,RX_RET
	MOV	A,CNT_L			;CHECK DATA BUFFER EMPTY
	JNZ	RX_RET			;AND NO MORE DATA COME IN
	MOV	A,CNT_H			;THEN STOP TRANSMIT DATA.
	JNZ	RX_RET
	SETB	FIN_F
RX_RET:	RET
;
CON_RX:
;2-1-91	MOV	TIM_4,#10		;SETUP TIME OUT TIMER-33ms
	MOV	TIM_4,#20		;SETUP TIME OUT TIMER-33ms
	SETB	TIM_4F
;	
	MOV	DPL,CNT_L		 ;JUST NORMAL DATA IN
	MOV	DPH,CNT_H
	INC	DPTR
	MOV	A,DPH
	ANL	A,#0F8H			 ;GETTING FULL
	JNZ	NEED_FL	
	MOV	A,SBUF			 ;NOT YET
; -- CHECK <DLE><ETX>
	JBC	DELAC,CON_RX1		;JUMP IF ALREADY GET 1ST <DLE> LAST TIME
	CLR	DELAC			; SETUP FLAG
	CJNE	A,#10H,CON_RX0		;
	SETB	DELAC			; SETUP FLAG
	SJMP	CON_RXA			;
CON_RX0:				;
	MOV	CNT_L,DPL		
	MOV	CNT_H,DPH
	MOV	DPL,IN_L     		 ;STORE INTO BUFFER
	MOV	DPH,IN_H
	INC	DPTR
	MOVX	@DPTR,A	
	ANL	DPH,#8FH		 ;WRAP AROUND
	MOV	IN_L,DPL
	MOV	IN_H,DPH
CON_RXA:					;
	MOV	A,CNT_H
	XRL	A,#07H			 ;CLOSE FLOW CONTROL ?
	JZ	NEED_FL			 ;JUMP IF DATA BUFFER USED >= (2K-256)
	RET

NEED_FL:
	MOV	DPTR,#OPT_1		 ;WHAT OPTION FOR FLOW CONTROL
	MOVX	A,@DPTR
	JZ	N_FL0			 ;9-14 JUMP IF AT\Q1
	SETB	FLOW			 ;HARDWARE FLOW CONTROL
	RET
N_FL0:
	JB	S_FLOW,N_FL1
	SETB	SND_S			 ;9-14-90SOFTWARE FLOW CONTROL
N_FL1:
	RET			
CON_RX3:			
;	CJNE	A,#0AH,CON_RX4	;JUMP IF NOT <DLE><LF>
	SJMP	CON_RXA
;
CON_RX4:			
	CJNE	A,S3,CON_RX4A		;NOT A <CR> FETCH ANOTHER CHAR
	MOV	DPTR,#MSG_ERR		;SEND OUT ERROR MESSAGE
	CJNE	R7,#16H,CON_RX4B	;JUMP IF RESULTANT CMD CHKCMD NOT EQ. 16H
	MOV	DPTR,#MSG_OK		;SEND OUT OK MESSAGE
CON_RX4B:
	LCALL	SND_RESULT		;SEND RESULT
	MOV	R7,#00H			;RESET CMD CHKSUM
	SJMP	CON_RXA
CON_RX4A:
	XRL	A,R7			;CHKSUM OF "AT+FBUF?"
	MOV	R7,A			;CHKSUM OF "AT+FBUF?"
	SJMP	CON_RXA
;
CON_RX2:			
	CJNE	A,#10H,CON_RX3	;IF NOT 2ND <DLE>, SOULD DELETE 1ST <DLE> AND FOLLOWING BYTE
	LJMP	CON_RX0		;WOULD GET THE SECOND ONE DLE ONLY
CON_RX1:			; AFTER 1ST <DLE>
	CJNE	A,#03H,CON_RX2	; IS END OF TEXT ?
;10-11-90 -- TRANSMIT RTC
	LCALL	CON_RX0AA		;
	LCALL	CON_RX0AA		;
	LCALL	CON_RX0AA		;
	LCALL	CON_RX0AA		;
	RET			;
CON_RX0AA:
	MOV	A,#00H		;
	LCALL	CON_RX0A	;
	MOV	A,#08H		;
	LCALL	CON_RX0A	;
	MOV	A,#80H		;
	LCALL	CON_RX0A	;
	RET
CON_RX0A:    			;
	MOV	DPL,CNT_L	;INCREMENT COUNTER 0F (O_PTR - IN_PTR )
	MOV	DPH,CNT_H
	INC	DPTR
	MOV	CNT_L,DPL		
	MOV	CNT_H,DPH
;
	MOV	DPL,IN_L     	;	 ;STORE INTO BUFFER
	MOV	DPH,IN_H	;
	INC	DPTR		;
	MOVX	@DPTR,A		;
	ANL	DPH,#8FH		 ;WRAP AROUND
	MOV	IN_L,DPL	;
	MOV	IN_H,DPH	;
	RET			;
;
;===========================================
;	DCE TRANSMITTER ROUTINE
;   TAKE DATA FROM BUFFER, PUT IN -DCE_TX, AND
;   SET   "DCE_S FLAG =1".
;===========================================
;
DCE1_TX:
	JB	DCE_S,NO_TX
CHK_D:	MOV	A,CNT_L			 ;ANY DATA WAITING ?
	JNZ	DATA_H
	MOV	A,CNT_H
	JNZ	DATA_H
	SJMP	NO_TX			 ;NO DATA!
DATA_H:
	MOV	DPL,O_PTRL 		 ;GET DATA FOR SENDING
	MOV	DPH,O_PTRH
	INC	DPTR			 ;MOVE POINTER
	MOVX	A,@DPTR
	MOV	DCE_TX,A		 ;DATA IN ALREADY
	ANL	DPH,#8FH		 ;WRAP AROUND
	MOV	O_PTRL,DPL
	MOV	O_PTRH,DPH
	MOV	A,CNT_L			 ;DECREMENT ONE COUNT
	CLR	C
	SUBB	A,#1
	MOV	CNT_L,A
	MOV	A,CNT_H
	SUBB	A,#0H
	MOV	CNT_H,A
	SETB	DCE_S			 ;INFORM DCE TO SEND
;
NO_TX:	JB	FLOW,CHCTS    		 ;NEED CHECK FLOW CONTROL ?
	JB	S_FLOW,CHCTS
	SJMP	BK_RET
CHCTS:
	MOV	A,CNT_H
	CLR	C
	SUBB	A,#06H			 ;CAN WE RELEASE ?
	JNC	BK_RET			; RELEASE IF DATA BUFFER USED < (2K-512)
	MOV	DPTR,#OPT_1		 ;WHAT OPTION FOR FLOW CONTROL
	MOVX	A,@DPTR
	JNZ	CTSC			;9-14 JUMP IF NOT AT\Q1
	SETB	SND_Q
	RET	
CTSC:	CLR	FLOW
BK_RET:
	JB	FLOW,CTSOFF		 ;HARDWARE FLOW CONTROL IS HERE
CTSON:
	CLR	EIACTS
EIAOUT:	MOV	A,EIA
	MOV	DPTR,#LATCH
	MOVX	@DPTR,A
 	RET
CTSOFF:
	SETB	EIACTS
	SJMP	EIAOUT
;
;===============================================================
;  SPEED CONVERSION FOR HALF DUPLEX TRANSMITTER ROUTINE
;  CHECK DCE_S = 1 AND MDA0 = 1 TO SEND DCE_S TO MODEM
;
;=============================================================
SPDH_TX:
	JNB	DCE_S,SPT_BK
	LCALL	CHK_MDAB
	JNC	SPT_BK			;IF MODEM NOT READY,RETURN
	MOV	A,DCE_TX
	LCALL	W_PDATA
	CLR	DCE_S
SPT_BK:	RET
;
;==================================================
;	SPEED CONVERSION INITIALIZE
;===================================================
;
INI_SPDFT:
	LCALL	RST_PTR
	MOV	DPTR,#8000H
AGAIN:	CLR	A
	MOVX	@DPTR,A
	INC	DPTR
	MOV	A,DPH
	XRL	A,#90H
	JNZ	AGAIN
	MOV	BYTE1,A
	CLR	FIN_F
	CLR	DCE_S
	CLR	DELAC			;
	RET
;****************
RST_PTR:
	CLR	A
	MOV	O_PTRL,A
	MOV	IN_L,A
	MOV	CNT_L,A
	MOV	CNT_H,A
	MOV	O_PTRH,#80H
	MOV	IN_H,#80H
	RET
;============================================================
;8-22-90
;LOSS_DTR - LOSS OF DTR DETECTED - VALIDATE
;       - DTR LOSS TIMER IS 50 MS
;============================================================
IF_DTROFF:
	JB	DTR_L,IF_D0		;BRANCH IF DTR OFF
	RET
IF_D0:	JB	LOST_DTR,L_DTR10	;BRANCH IF DTR LOST PREVIOUSLY
	MOV	TIM_7,#5		; 50 MS DTR OFF TIME
	SETB	TIM_7F			;START DTR LOSS TIMER
	SETB	LOST_DTR		;SET LOST FLAG
L_DTR10:
	JB	TIM_7F,L_DTR15		;EXIT IF DTR LOSS NOT CONFIRMED
	SETB	FIN_F			; ACT AS NO MORE DATA 
L_DTR15:
	RET
	ENDIF

	END
