 	list	on
	pl	104
	pw	128
;************************************************************************
;* FILE		: MOD5.ASM UNIVERSAL					*
;* SUBJECT	: COMMAMDS						*
;************************************************************************

; 3/1/91	RELEASE 1.0
	
	LIST	OFF
	INCLUDE CONFIG.ASM
	INCLUDE RDEFINE.ASM
	LIST	ON
;
;========================================
;GLOBAL DEFINITIONS
;========================================
;
	GLOBAL		H_40,H_46,H_47				;134
	GLOBAL		AT_MAIN,SND_RESULT,SND_MSG
	GLOBAL		ON_HOOK,OFF_HOOK,INIT_AT
	GLOBAL		SND_DIGITS,S_CRLF,WAIT_3MS,CON_MSG
	GLOBAL		WAIT_SEC,AT_POINT,PP_D45
	GLOBAL		IS_VALID,V1_CRLF,AT_O,FETCH,AT_000,GET_PARAM
	GLOBAL		V_CRLF,SYNC_DIAL,UPDATE_IO,INITA0
	GLOBAL		WAIT_3RD,SND_OK
	GLOBAL		WAIT_E3MS,SET_AA_BIT
	GLOBAL		GO_ONLINE,LATCH
	GLOBAL		SND_HEX,SND_MSG
	GLOBAL		VALID_1D,VALID_D,AT_ERR,PASS,BUF_CHARS
	GLOBAL		POINTER,AT_OK,IS_VA
	GLOBAL		INI_CTS			;121

	IFTRUE	FAX
	GLOBAL		RESET_ID,SET_ID,VALID_ID		4-26-90
	ENDIF

;========================================
;EXTERNAL REFERENCES
;========================================
;
;FROM MODULE1.ASM
;
	EXTERNAL	SET_UR
	EXTERNAL	SET_SPEED,WARM0,WARM1,WARM_ST
	EXTERNAL	IDLE,PUT_CHAR
	EXTERNAL	INIT_IO,INIT_MOD
	EXTERNAL	WAIT200,INIT_TIM,SET_OUT			;109
	EXTERNAL	CXR_OFF,CXR_ON
	EXTERNAL	CTS_OFF,CTS_ON
	EXTERNAL	DSR_ON,DSR_OFF
	EXTERNAL	SET_T1,CTS_N1
;
;FROM MODULE2.ASM
;
	EXTERNAL	LEE_COM,AT.V0
;
;FROM MODULE3.ASM
;
	EXTERNAL	ORIGINATE,ANSWER,DATA_MOD
	EXTERNAL	INIT_FLAGS,MAN_ORG
	EXTERNAL	TX_ON,TX_OFF,SET_IDL
	EXTERNAL	CLR_ON_FLGS
	EXTERNAL	DISCONNECT
	EXTERNAL	ALB_MOD
;
;FROM MODULE4.ASM
;
	EXTERNAL	CPM_MOD,QUIET_A,CHK_DT,CHK_DTW
	EXTERNAL	C_ENERGY
;
;FROM MODULE6.ASM
;
	EXTERNAL	ATX_C,ATX_D,ATX_F,ATX_G,ATX_J,ATX_J,ATX_L,ATX_M
	EXTERNAL	ATX_P,ATX_R,ATX_S,ATX_T,ATX_W,ATX_X,ATX_Y,ATX_Z
	EXTERNAL	ATX_Q,ATX_K				;110;111
	EXTERNAL	CHK_NV,SD_CRLF,WRT_NV0,TEL_ADD_S
	EXTERNAL	ATX_U,ATX_E,ATX_V,ATX_TY
	EXTERNAL	GET_S,PUT_S,MSG_VER,MSG_VER1,GET_DIAL
	EXTERNAL	READ_NV,WRT_NV,LOADNV,SAVENV,NV_R
;
; FROM WMOD.ASM
;
	EXTERNAL	WR0_CNTL,RD0_CNTL,WR1_CNTL,RD1_CNTL,RD_STAT
	EXTERNAL	SET_DMF,SET_RTS,CLR_RTS,TT_D10,SPEAK3
	EXTERNAL	W_MEMORY,RX_MK,UPDAT_SPK,DTMF_OFF,SET_DTMF
	EXTERNAL	SET_PDM,CHK_MDA0,SPEAK_ON,SPEAK_OFF
	EXTERNAL	RX_MKD						;164

	IFTRUE	FAX
;
; FROM FAXP.ASM
;
	EXTERNAL	ATF_A
	EXTERNAL	ATF_T,ATF_F,ATF_R
	EXTERNAL	ATF_P,ATF_E
	EXTERNAL	ATF_B,ATF_J,ATF_I
	EXTERNAL	FAX_ANS,FAX_CALL
	EXTERNAL	ATF_LID0,ATF_AA,ATF_CLASS0,ATF_CLASS1,FD_CSIS,FD_CSIA
	EXTERNAL	ATF_CR,ATF_SESS,ATF_BOR,ATF_MINSP0,ATF_MINSP1
	EXTERNAL	ATF_BUG0,ATF_BUG1,ATF_HPS0
	EXTERNAL	ATF_SESS1,MSG_MFR,MSG_MDL
	ENDIF
;
;FROM MODULE8.ASM
;
	EXTERNAL	ATN_A,ATN_B,ATN_C,ATN_F,ATN_G,ATN_I,ATN_J  ;148
	EXTERNAL	ATN_K,ATN_L,ATN_N,ATN_O,ATN_M
	EXTERNAL	ATN_Q,ATN_U,ATN_V,ATN_X,ATN_S,ATN_T
	EXTERNAL	ATN_Y,ATN_Z
	EXTERNAL	ATP_A,ATP_C,ATP_U
	EXTERNAL	ATM_P
	EXTERNAL	ATP_D,ATP_V
	EXTERNAL	ATM_C,ATM_D
	IFTRUE MICROCOM
	EXTERNAL	ADDS_REG,EX_SREG
	ENDIF

	IFTRUE	V.23
;FROM MOD10.ASM
	EXTERNAL	INIT_23,ORGV21,V_ORG
	ENDIF
;
; FROM MNP5.ASM
;
;
	GLOBAL		MSG_12CON,MSG_CON,MSG_RING,MSG_24CON
	GLOBAL		MSG_NCAR,MSG_OK,TONE_TAB,MSG_NANS,MSG_ID0
	GLOBAL		MSG_ERR,MSG_NODT,MSG_BUSY,MSG_ID1
	GLOBAL		VALID_1D,VALID_D,PARSE
	GLOBAL		AT_EQ3
	IFTRUE	MICROCOM
	EXTERNAL	MSG_CP
	EXTERNAL	MSG_CPY
	ENDIF

	EJECT
	TITLE THE "AT" DIALER MODULE
;
;############################################################
;#                                                          #
;#             THE "AT" DIALER MODULE                       #
;#                                                          #
;############################################################
	CODE
;============================================================
;ENTRY POINT FOR "AT" COMMAND MODE
;============================================================
;
AT_MAIN:	
	SETB	PASS
	CLR	SYNC_D			;SET ASYNC DIAL
	JB	AT_SLASH,AT_005		;BRANCH IF RECIEVED A/
	LCALL	BUF_CHARS		;BUFFER CHARACHTERS
AT_005:	
	MOV	A,#76			;250MS CONSTANT
	LCALL	WAIT_3MS
	JB	PASS,AT_010		;BRANCH IF NOT OVERFLOW
AT_001:	LJMP	AT_ERR			;SEND OUT ERROR MESSAGE
AT_010:	MOV	POINTER,#00H		;POINT TO BEGIN OF BUFFER
;
AT_000:
	LCALL	UPDATE_IO		;UPDATE I/O AFTER EVERY COMMAND
	LCALL	FETCH			;FETCH CHARACHTER
	CJNE	A,#';',AT_00A		;4-26BRANCH IF NOT ";" 
	LCALL	FETCH			;4-26FETCH CHARACHTER
AT_00A:					;4-26-90
	CJNE	A,S3,AT_006		;BRANCH IF NOT <CR>
	LJMP	AT_OK
AT_006:	CJNE	A,#'&',AT_002		;BRANCH IF NOT EXTENDED "AT"
	LCALL	FETCH
	CJNE	A,S3,AT_004		;BRANCH IF NOT <CR>
	LJMP	AT_OK
AT_004:	MOV	DPTR,#COM1_TABLE	;EXTENDED "AT" COMMAND JUMP TABLE
	LJMP	PARSE
AT_002:
	IFTRUE	JCM
	CJNE	A,#'.',AT_003
	LJMP	LEE_COM
	ENDIF
AT_003:
; -------------------------------------- FAX
	IFTRUE	FAX
	CJNE	A,#'+',AT_FT		;JUMP IF NOT FAX "+" COMMAND
	LCALL	FETCH
	CJNE	A,S3,AT_004F		;BRANCH IF NOT <CR>
	SJMP	AT_OK
AT_004F:
	CJNE	A,#'F',AT_ERR1		;4-26-90JUMP IF NOT FAX "+F" COMMAND
	LCALL	FETCH			;4-26
	MOV	B,#0			;4-26
	CJNE	A,S3,AT_004F0		;4-26BRANCH IF NOT <CR>
	SJMP	AT_OK			;4-26
AT_004F0:				;4-26
	CJNE	A,#';',AT_004F1		;4-26BRANCH IF NOT ";"
	SJMP	AT_000			;4-26
;XOR FAX COMMAND CHARS
AT_004F1:				;4-26
	XRL	B,A			;4-26 TEMP STORE CMD CHKSUM IN B REG
	LCALL	FETCH			;4-26
	CJNE	A,#'=',AT_004F3		;4-26BRANCH IF NOT "=" GO ON EX-OR CMD CHARS
	XRL	B,A			;4-26 XOR INCLUDE "="
AT_004F2:				;4-26
	MOV	A,B			;4-26 STORE CMD CHKSUM IN ACC
	MOV	DPTR,#COMP_TABLE	;FAX "+F" COMMAND JUMP TABLE
	LJMP	PARSE
AT_004F3:				;4-26
	CJNE	A,S3,AT_004F4		;4-26BRANCH IF NOT <CR> GO ON EX-OR CMD CHARS
	DEC	POINTER			;4-26FOR NEXT FETCH IN AT_000
	SJMP	AT_004F2		;4-26
AT_004F4:				;4-26
	CJNE	A,#';',AT_004F1		;4-26BRANCH IF NOT ";" GO ON EX-OR CMD CHARS
	SJMP	AT_004F2		;4-26
AT_ERR1:
	LJMP	AT_ERR
AT_FT:	
	ENDIF
; -------------------------------------- MICROCOM
	IFTRUE	MICROCOM
	CJNE	A,#'\',AT_MC1
	LCALL	FETCH
	CJNE	A,S3,AT_N02
	SJMP	AT_OK
AT_MC1:	CJNE	A,#'%',AT_N15
	LCALL	FETCH
	CJNE	A,S3,AT_N11
	SJMP	AT_OK
AT_N15:	CJNE	A,#'-',AT_U
	LCALL	FETCH
	CJNE	A,S3,AT_N12
	SJMP	AT_OK	
AT_U:	CJNE	A,#'_',AT_MT
	LCALL	FETCH
	CJNE	A,S3,AT_N13
	SJMP	AT_OK
AT_N02:	MOV	DPTR,#COM2_TABLE	;"\" MICROCOM COMMAND SET JUMP TABLE
	SJMP	PARSE
AT_N11:	MOV	DPTR,#COM3_TABLE	;"%" COMMAND SET JUMP TABLE
	SJMP	PARSE
AT_N12:	MOV	DPTR,#COM4_TABLE	;"-" COMMAND SET JUMP TABLE
	SJMP	PARSE	
AT_N13:	MOV	DPTR,#COM5_TABLE	;"_" COMMAND SET JUMP TABLE
	SJMP	PARSE	
AT_MT:
	ENDIF
; -------------------------------------- NO MICROCOM
	IFFALSE	MICROCOM
	CJNE	A,#'\',AT_NMT
	LCALL	FETCH
	CJNE	A,S3,AT_N02A
	SJMP	AT_OK
AT_N02A:
	CJNE	A,#'Q',NM_C1		;116S
	SJMP	NM_TB
NM_C1:	CJNE	A,#'N',NM_C2
	SJMP	NM_TB
NM_C2:	CJNE	A,#'J',AT_ERR
NM_TB:	MOV	DPTR,#COM2_TABLE	;"\" MICROCOM COMMAND SET JUMP TABLE
	SJMP	PARSE			;116T
AT_NMT:
	ENDIF

; -------------------------------------- STANDARD AT 
AT_N01:	MOV	DPTR,#COM_TABLE		;STANDARD "AT" COMMAND JUMP TABLE
	SJMP	PARSE			
AT_OK:
	MOV	A,#10H			;162S
	CJNE	A,U_ST,NC_S3
	MOV	DPTR,#JS9
	MOVX	A,@DPTR
	MOV	S3,A
NC_S3:	MOV	DPTR,#MSG_OK		;162T
	SJMP	AT_030
AT_ERR:	MOV	DPTR,#MSG_ERR		
AT_030:	LCALL	SND_RESULT		;SEND RESULT
	CLR	HS_H			;2400 LED ON
	JB	BIT_24,AT_031
	SETB	HS_H			;2400 LED OFF
AT_031:	LCALL	UPDATE_IO
	LJMP 	WARM0
;
;============================================================
;GO_ONLINE - EXIT TO ONLINE LOOP
;  COMES HERE TO GO BACK TO THE DATA MODE FROM THE ONLINE INTERACTIVE
;  MODE.  RESETS ALL ONLINE FLAGS AND RE-ENABLES SCT + SCR AND ASYNC
;  INTERRUPTS.
;============================================================
;
GO_ONLINE:
	JB	RDLB_REQ,GO_ON1		;DONT SEND CONNECT MESSAGE YET IF
					;RDLB REQUESTED
	JB	RETRAIN,GO_ON2
	MOV	DPTR,#MNP_S		;CHECK IN MNP MODE
	MOVX	A,@DPTR
	JB	ACC.5,GO_ON1		;IF MNP MODE, SKIP CONNECT MESSAGE
	LCALL	CON_MSG			;OUTPUT CONNECT MESSAGE
GO_ON1:	LCALL	INIT_FLAGS		;INIT ONLINE FLAGS AND COUNTER
GO_ON2:	LJMP	DATA_MOD	
;
;==================================================
;PARSE - PARSE COMMAND
;  THIS ROUTINE WILL SEARCH THROUGH THE VALID TABLE
;  OF COMMANDS AND JUMP THE ROUTINE IF FOUND.  IF NOT
;  FOUND THE ROUTINE WILL RETURN TO THE CALLER.
;
; DESTROYS - ACC,R1,DPTR
; CALLS -  NOTHING
; EXPECTS - ACC CONTAINS THE COMMAND CHARACHTER
; RETURNS - NOTHING
; STACK - 2
;==================================================
;
PARSE:	MOV	R1,A		;SAVE CHAR
PARS_1:	CLR	A
	MOVC	A,@A+DPTR
	CJNE	A,#0FFH,PARS_4
	SJMP	AT_ERR		;EXIT IF NOT IN TABLE
PARS_4:	INC	DPTR		;POINT TO ADDRESS
	CJNE	A,REG_1,PARS_2	;BRANCH IF NOT IN TABLE
PARS_5:	CLR	A
	MOVC	A,@A+DPTR
	MOV	R1,A
	CLR	A
	INC	DPTR
	MOVC	A,@A+DPTR	;GET ADDRESS
	PUSH	ACC		;PUT LSB ON STACK
	MOV	A,R1
	PUSH	ACC		;NOW MSB ON STACK
	RET			;GO TO ROUTINE		
PARS_2:	INC	DPTR
	INC	DPTR
	SJMP	PARS_1
;
;==================================================
;JUMP TABLE FOR "AT" COMMANDS
;==================================================
COM_TABLE:
	DB	'A'		;ANSWER COMMAND
	DW	AT_A
	DB	'B'		;BELL/CCITT MODE
	DW	AT_B
	DB	'D'		;DIAL COMMAND
	DW	AT_D
;901S
	DB	'F'		;
	DW	AT_F
	DB	'E'		;ECHO COMMAND
	DW	AT_E
	DB	'H'		;HOOK  COMMAND
	DW	AT_H
	DB	'I'		;IDENTIFICATION COMMAND
	DW	AT_I

	IFTRUE	DEBUG
	DB	'K'		;SPECIAL TEST COMMAND
	DW	AT_K
	ENDIF

	DB	'L'		;SPEAKER VOLUME COMMAND
	DW	AT_L
	DB	'M'		;SPEAKER CONTROL COMMAND
	DW	AT_M

	IFTRUE	DEBUG
	DB	'N'		;READ AND WRITE TO NV RAM
	DW	AT_N
	ENDIF

	DB	'O'		;ONLINE/ORIGINATE COMMAND
	DW	AT_O
	DB	'P'		;PULSE DIAL COMMAND
	DW	AT_P
	DB	'Q'		;QUIET COMMAND
	DW	AT_Q

	IFTRUE	DEBUG
	DB	'R'		;XR2400 REGISTERS
	DW	AT_R
	ENDIF

	DB	'S'		;S REGISTER COMMAND
	DW	AT_S
	DB	'T'		;TONE DIAL COMMAND
	DW	AT_T
	DB	'V'		;VERBOSE COMMAND
	DW	AT_V
	DB	'W'		;
	DW	AT_W
	DB	'X'		;RESULT CODE CONTROL
	DW	AT_X
	DB	'Y'		;LONG SPACE DISCONNECT CONTROL
	DW	AT_Y
	DB	'Z'		;RESET MODEM
	DW	AT_Z
	DB	'='		;S REGISTER SET COMMAND
	DW	AT_EQ
	DB	'?'		;S REGISTER INQUIRE COMMAND
	DW	AT_QUES
	DB	CR		;CARRIAGE RETURN
	DW	AT_000
	DB	0FFH		;TERMINATOR
;
;^^^^
	IFTRUE	MICROCOM
;================================================================
;JUMP TABLE FOR EXTENDED "AT" COMMANDS WITH MICROCOM COMMAND SET
; "\" COMMAND SET
;================================================================
COM2_TABLE:
	DB	'A'		;BLOCK SIZE TRANSMIT
	DW	ATN_A
	DB	'B'		;BREAK OPTION
	DW	ATN_B
	DB	'C'		;SET AUTO-RELIABLE BUFFER
	DW	ATN_C
	DB	'F'		;148 DISPLAY PHONE NUMBER
	DW	ATN_F		;148
	DB	'G'		;SET MODEM SERIAL PORT FLOW CONTROL
	DW	ATN_G
	DB	'I'		;INTERFACE PROTOCOL
	DW	ATN_I
	DB	'J'		;BAUD RATE ADJUST
	DW	ATN_J
	DB	'K'		;BREAK CONTROL
	DW	ATN_K
	DB	'L'		;
	DW	ATN_L
	DB	'M'		;MICROCOM SLOW DOWN OPTION
	DW	ATN_M
	DB	'N'		;MNP LINK OPTION
	DW	ATN_N
	DB	'O'		;ORIG RELIABLE LINK
	DW	ATN_O
	DB	'Q'		;FLOW CONTROL OPTION
	DW	ATN_Q
	DB	'S'		;ON LINE STATUS
	DW	ATN_S
	DB	'T'		;SET INACTIVITY TIMER
	DW	ATN_T
	DB	'U'		;ACCEPT RELIABLE LINK AFTER '+++'
	DW	ATN_U
	DB	'V'		;MODIFIED RESULT CODE
	DW	ATN_V
	DB	'X'		;XON/XOFF OPTION(PASS THROUGH)
	DW	ATN_X
	DB	'Y'		;SWITCH TO RELIABLE MODE
	DW	ATN_Y
	DB	'Z'		;SWITCH TO NORMAL MODE
	DW	ATN_Z
	DB	0FFH		;TERMINATOR
;
;================================================================
; "%" COMMAND SET
;================================================================
COM3_TABLE:
	DB	'A'		;SET AUTO-RELIABLE FALLBACK CHAR.
	DW	ATP_A
	DB	'C'		;DATA COMPRESSION
	DW	ATP_C
	DB	'D'
	DW	ATP_D
	DB	'U'		;CLEAR SERIAL PORT SPEED
	DW	ATP_U
	DB	'V'		;ELIMINATE ODP
	DW	ATP_V
	DB	0FFH
;
;================================================================
; "-" COMMAND SET
;================================================================
COM4_TABLE:
	DB	'C'		;SET BTLZ MAXIMUM STING CHAR.
	DW	ATM_C
	DB	'D'		;SET BTLZ DICTIONARY SIZE.
	DW	ATM_D
	DB	'P'		;PARITY BIT CHECK FOR FLOW CONTROL.
	DW	ATM_P
	DB	0FFH	
;
;================================================================
; "_" COMMAND SET
;================================================================
COM5_TABLE:
	DB	'I'
	DW	ATU_I		;CONUTRY CODE
	DB	0FFH	
	ENDIF

	IFFALSE	MICROCOM
COM2_TABLE:
	IFFALSE	NSP	;118S
	DB	'G'		;116S
	DW	ATN_G
	DB	'J'		;116S
	DW	ATN_J
	DB	'N'	
	DW	ATN_N	;116T
	ENDIF		;118T
	DB	'Q'		;FLOW CONTROL OPTION
	DW	ATN_Q
	DB	0FFH
	ENDIF
;==================================================
;JUMP TABLE FOR EXTENDED "AT" COMMANDS
;==================================================
COM1_TABLE:
	DB	'C'		;CXR CONTROL
	DW	ATX_C
	DB	'D'		;DTR CONTROL
	DW	ATX_D
	DB	'E'		;ERROR CONTROL
	DW	ATX_E
	DB	'F'		;FETCH FACTORY CONFIGURATION
	DW	ATX_F
	DB	'G'		;GAURD TONE SELECT
	DW	ATX_G
	DB	'J'		;TELCO JACK SELECT (NOT IMPLEMENTED)
	DW	ATX_J
	DB	'K'		;110
	DW	ATX_K	;110
	DB	'L'		;LEASED LINE/SWITCHED LINE SELECT
	DW	ATX_L

	IFFALSE	INTERNAL
	DB	'M'		;ASYNC/SYNC SELECT
	DW	ATX_M
	ENDIF

;	DB	'O'		;FLOW CONTROL
;	DW	ATX_O
	DB	'P'		;PULSE DIAL MAKE/BREAK RATIO
	DW	ATX_P
	DB	'Q'		;111
	DW	ATX_Q	;111

	IFFALSE	INTERNAL
	DB	'R'		;CTS CONTROL
	DW	ATX_R
	ENDIF

	DB	'S'		;DSR CONTROL
	DW	ATX_S
	DB	'T'		;TEST CONTROL
	DW	ATX_T
	DB	'U'		;SPEED CONVERSION
	DW	ATX_U
	DB	'V'
	DW	ATX_V		;DISPLAY MODEM SETTING
	DB	'W'		;NV RAM STORAGE
	DW	ATX_W

	IFFALSE	INTERNAL
	DB	'X'		;TRANSMIT CLOCK SOURCE
	DW	ATX_X
	ENDIF

	DB	'Y'		;STORE TELCO NUMBER
	DW	ATX_Y
	DB	'Z'		;STORE TELCO NUMBER
	DW	ATX_Z
	DB	0FFH		;TERMINATOR

	IFTRUE	FAX
;==================================================
;JUMP TABLE FOR EXTENDED FAX "+F" "AT" COMMANDS
;==================================================
COMP_TABLE:
;4-26-90 -- AT+Fxxxy<CR\;>  : x.XOR.x.XOR.x.XOR.x.XOR.y, y MAYBE "=" OR ";"
	DB	07CH		;+FLID=	LOCAL FAX ID, TSI\CSI
	DW	ATF_LID0
	DB	3DH		;+FAA=	AUTO ANSWER
	DW	ATF_AA
	DB	073H		;+FCLASS= SET SERVICE CLASS ID
	DW	ATF_CLASS0
	DB	071H		;+FCLASS? INQUIRE SERVICE CLASS ID
	DW	ATF_CLASS1
	DB	02CH		;+FCR=	CAPABILITY TO RECEIVE
	DW	ATF_CR
	DB	079H		;+FDCC=	DCE CAPABILITY PARAMETER
	DW	ATF_SESS
	DB	063H		;+FDIS=	CURRENT SESSION NEGOIATION PARAMETER
	DW	ATF_SESS
	DB	059H		;+FDCS=	CURRENT SESSION PARAMETER
	DW	ATF_SESS
	DB	07BH		;+FDCC?	INQUIRE CURRENT DCE CAPABILITY PARAMETER
	DW	ATF_SESS1
	DB	062H		;+FBOR=	PHASE C DATA BIT ORDER PARAMETER
	DW	ATF_BOR
	DB	074H		;+FMINSP= MINIMUN PHASE C SPEED PARAMETER
	DW	ATF_MINSP0
	DB	076H		;+FMINSP? INQUIRE MINIMUN PHASE C SPEED PARAMETER
	DW	ATF_HPS0	;+FHPS=  HANDSHAKING PROCOTOL SELECT
;	DW	ATF_MINSP1
	DB	06DH		;+FBUG= SESSION MSG REPORTING PARAMETER
	DW	ATF_BUG0
	DB	06FH		;+FBUG? INQUIRE SESSION MSG REPORTING PARAMETER
	DW	ATF_BUG1
	DB	07EH		;+FREV? EQUIVALENT TO ATI1
	DW	ATI5
	DB	066H		;+FMFR? 
	DW	ATF_I6		;11-9-90
	DB	07AH		;+FMDL? 
	DW	ATF_I7		;11-9-90
	DB	0FFH		
	ENDIF
;
;==================================================
;AT_A - ANSWER COMMAND
;  THIS COMMAND WILL PUT THE MODEM INTO ANSWER MODE
;  AFTER GOING OFFHOOK THE MODEM WILL WAIT A 2 SECOND
;  BILLING DELAY AND THEN OUTPUT CARRIER
;  THIS COMMAND REQUIRES DTR TO FUNCTION
;
;  THIS COMMAND HAS NO PARAMTERS
; DESTROYS - ACC
; CALLS -  NOTHING
; EXPECTS - NOTHING
; EXITS - TO ANSWER MODE IF NOT ONLINE
;         TO GO_ONLINE IF ALREADY ONLINE
; STACK - 0
;==================================================
;
AT_A:	JB	DATA_BIT,AT_A1	;BRANCH IF ALREADY ONLINE
	CLR	ORG_BIT		;SET ANSWER FLAG
	CLR	RING_IP	
	CLR	RI_IN
	SETB	RI_OUT
	SETB	AA_BIT
	LCALL	UPDATE_IO

	IFTRUE FAX
AT_A2:	MOV	DPTR,#OPT_FAX
	MOVX	A,@DPTR
	JZ	AT_AD		;4-26-90
	JB	ACC.1,AT_AD	;4-26-90 JUMP IF +FAA
	JNB	ACC.0,AT_AD	;4-26-90 JUMP IF +FCLASS NOT 2
	LJMP	FAX_ANS
AT_AD:	
	ENDIF

	LJMP	ANSWER
AT_A1:	LJMP	AT_ERR		;ONLY ATO WILL GET BACK TO ONLINE

;==================================================
;AT_B - BELL/CCITT SELECT
;  THIS COMMAND WILL SELECT BELL 212A OR CCITT V.22
;  STANDARD FOR THE HIGH SPEED CONNECT SEQUENCE
;
;   B0 = SELECT CCITT V.22
;   B1 = SELECT BELL 212A
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH BELL212 BIT SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_B:	CLR	BELL212
	MOV	DPTR,#JS5	;125S
	MOVX	A,@DPTR
	CLR	A
	MOVX	@DPTR,A
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_B1	;BRANCH IF NONE
	CJNE	A,#01,AT_B2
	SETB	BELL212
AT_B1:	LJMP	AT_000		
AT_B2:	MOV	DPTR,#JS5
	MOVX	A,@DPTR
	SETB	ACC.0
	MOVX	@DPTR,A
	LJMP	AT_000
;
;==================================================
;AT_D - DIAL COMMAND
;  THE DIAL COMMAND WILL DIAL A PHONE NUMBER AND PROCEED TO
;  THE ORIGINATE MODE IF ANSWER TONE IS DETECTED.  IF AN
;  ILLEGAL CHARACHTER IS DETECTED IT WILL BE IGNORED.
;   PARAMETERS - DIGITS 0-9 # AND *
;                T,P,R,/,!,@
; DESTROYS - ACC,B
; CALLS - FETCH,CHK_DIGIT,DIGIT_D,ON_HOOK,OFF_HOOK,CPM_MOD
;         WAIT_3MS,QUIET_A,DT_WAIT,SPEAK_ON,SPEAK_OFF  
; EXPECTS - NOTHING
; EXITS - GO_ONLINE - IF ALREADY ONLINE
;         ORIGINATE - IN SUCCESSFUL DIAL
;         ANSWER - IF REVERSE ANSWER MODE
;         WARM0 - IF ABORT
; STACK - 14
;==================================================
;
AT_D:	
	SETB	RI_OUT		;147
	MOV	U_ST,#'3' 	;PUT ID
	CLR	JP_004
	JNB	DATA_BIT,AT_D00
	LJMP	AT_ERR		;ONLY ATO WILL GET BACK TO ONLINE MODE
AT_D00:	MOV	A,#30
	LCALL	WAIT_3MS	;WAIT 100MS TO MAKE SURE NO <LF> AFTER <CR>	
	CLR	RI	

SYNC_DIAL:			;103
AT_D0Z:	LCALL	OFF_HOOK	;GO OFF HOOK TO DIAL
	SETB	ORG_BIT
	LCALL	UPDAT_SPK	;102
	JNB	SPEAK_1,AT_D0X
	JNB	SPEAK_2,AT_D0X
	SJMP	AT_D0Y

AT_D0X:	LCALL	SPEAK_ON
AT_D0Y:	JB	LEASED_L,AT_D09	;DONT CHECK FOR DIALTONE  IF LEASED LINE
	JB	PSW.5,AT_D09
	LCALL	DIAL_WAIT	;WAIT OR CHECK FOR DIALTONE
	JNB	ABORT1,AT_D09	;
	CALL	ON_HOOK
	CALL	INIT_MOD
	MOV	DPTR,#MSG_OK	;SEND "OK" MESSAGE
	SJMP	AT_D08

AT_D09:	JB	PASS,AT_D03
AT_D01:	LCALL	ON_HOOK
	MOV	DPTR,#MSG_NODT	;SEND "NO DIALTONE" MESSAGE
AT_D08:	LJMP	AT_D98
AT_D03:	JB	SYNC_D,AT_D06D	;103 SYNC_D DIALING
TRY:	LCALL	FETCH		;FETCH DIAL PARAMETER
	CJNE	A,#'S',AT_D06
	MOV	U_ST,#'2'
	LCALL	FETCH
	CJNE	A,#'=',AT_D06A
NXTDG:	LCALL	FETCH
AT_D06B:
	LCALL	TEL_ADD_S	;R0 <- NV RAM ADDRESS
	SJMP	AT_D05
AT_D06D:
	MOV	A,#'0'		;ILLIEGO PARAMETER
	MOV	U_ST,#'2'	;PUT ID
	SJMP	AT_D06B

AT_D06A:		
	CJNE	A,S3,AT_D06D	;CR check
	SJMP	AT_D06D		;GO DIRECTLY TO MANUAL ORIGINATE

AT_D06:
	CJNE	A,S3,AT_D10
	LJMP	AT_O		;GO DIRECTLY TO MANUAL ORIGINATE
AT_D05:
	LCALL	SD_CRLF
	CLR	JP_004		;BUFFER FLAG
	MOV	B,#TEL_TAB	;100
;	LCALL	GET_DIAL	;GET STORED NUMBER DIALING
	LCALL	NV_R		
	SJMP	AT_D02
AT_D10A:
	LCALL	SD_CRLF
	SJMP	AT_D04

AT_D02:	LCALL	FETCH		;FETCH DIAL PARAMETER
AT_D04:
	CJNE	A,S3,AT_D10
	LJMP	AT_D50		;GO TO TONES DETECT SECTION IF <CR> DETECTED
AT_D10:	LCALL	IS_VALID	
	JNB	PASS,AT_D02	;GO GET ANOTHER CHAR IF NOT VALID
	LCALL	CHK_DIGIT	;IS IT A DIGIT
	JNB	PASS,AT_D12
	LCALL	DIGIT_D		;GO DIAL DIGIT
	JB	ABORT,AT_D11
	SJMP	AT_D02		;GO FETCH ANOTHER DIGIT
AT_D11:	LJMP	AT_D99
AT_D12:	CJNE	A,#';',AT_D14	;RETURN TO COMMAND MODE?
	SETB	PSW.5
	LJMP	AT_000		;RETURN TO COMMAND MODE
AT_D14:	CJNE	A,#'!',AT_D16	;HOOK FLASH
	LCALL	ON_HOOK
	MOV	A,#76		;250MS CONSTANT
	LCALL	WAIT_3MS
	LCALL	OFF_HOOK
	SJMP	AT_D02		;GO GET ANOTHER DIGIT
AT_D16:	CJNE	A,#',',AT_D18
	MOV	ACC,S8
	LCALL	WAIT_SEC
	JB	ABORT,AT_D99	;ABORTED
	SJMP	AT_D02
AT_D18:	CJNE	A,#'/',AT_D20	;1/8 SECOND WAIT
	MOV	A,#37		
	LCALL	WAIT_3MS
	JB	ABORT,AT_D99	
AT_D20:	CJNE	A,#'T',AT_D22	;TONE DIAL
	CLR	PUL_DIAL
	SJMP	AT_D02	
AT_D22:	CJNE	A,#'P',AT_D24	;PULSE DIAL
	SETB	PUL_DIAL
	SJMP	AT_D02	
AT_D24:	CJNE	A,#'W',AT_D26
	LCALL	CHK_DTW
	JB	ABORT,AT_D99
	JB	PASS,AT_D30
	LJMP	AT_D01		;SEND NO DIALTONE MESSAGE
AT_D26:	CJNE	A,#'@',AT_D28
	LCALL	QUIET_A
	JBC     BUSYB,B_ATD60	;BUSY MSG
	JB	ABORT,AT_D99	;147 EXIT IF USER ABORT NO CARRY
	JB	PASS,AT_D30	;BRANCH IF QUIET ANSWER DETECTED
	LCALL	ON_HOOK		;NO ANS
	MOV	DPTR,#MSG_NANS	
	SJMP	AT_D98
AT_D28:	CJNE	A,#'R',AT_D30
	LJMP	ANSWER		;GO TO ANSWER MODE
AT_D30:	LJMP	AT_D02		;GO FETCH ANOTHER CHAR
B_ATD60:
	LJMP	AT_D60
;
;====================
;COMES HERE ON ABORT
;====================
;
AT_D99:	LCALL	ON_HOOK
	LCALL	INIT_MOD	;INITIALIZE MODEM
	MOV	DPTR,#MSG_NCAR	;NO CARRIER MESSAGE
AT_D98:	MOV	A,#250
	LCALL	WAIT_3MS	;WAIT FOR RELAY TO DEBOUNCE
	LCALL	SND_RESULT		
	LCALL	SPEAK_OFF
	LJMP	WARM1		;RETURN TO COMMAND MODE ;JP-
;
;====================
;TONES DETECT SECTION
;====================
;
AT_ALB:	LJMP	AT_O4		;ALB
AT_D50:	
	JB	ALB_REQ,AT_ALB
	JB	ALB1_REQ,AT_ALB
	JB	LEASED_L,AT_D70	;NO TONES DETECT IF LEASED LINE
	MOV	A,S7
	LCALL	SET_T1		;SETUP ABORT TIMER
	LCALL	SPEAK_ON
	LCALL	CPM_MOD		;LOOK FOR ANSWER TONE
	JB	BUSYB,AT_D60	;branch if busy detected
	JB	ANSWER_T,AT_D70	;branch if answer tone detected
	JB	ABORT,AT_D99	;branch if S7 timeout or user abort

	IFTRUE	V.23		;017S
	MOV	DPTR,#JS5
	MOVX	A,@DPTR
	JB	ACC.0,V23T
	LJMP	ORGV21
V23T:	LJMP	V_ORG		;016
	ENDIF			;017T

;XXX	SJMP	AT_D99
AT_D60:
	LCALL	ON_HOOK
	MOV	DPTR,#MSG_BUSY
	SJMP	AT_D98
AT_D70:	SETB	AUTODIAL
;	LCALL	SPEAK_OFF
AT_D71:
	IFTRUE FAX
	MOV	DPTR,#OPT_FAX
	MOVX	A,@DPTR
	JZ	AT_DE
	JNB	ACC.0,AT_DE	;4-26-90
	LJMP	FAX_CALL
	ENDIF 

AT_DE:	LJMP	ORIGINATE
;
;==================================================
;DIAL_WAIT - WAIT FOR DIALTONE OR S6 DELAY
;  DESTROYS: ACC
;  CALLS:  WAIT_SEC,CHK_DT
;  EXPECTS:  NOTHING
;  RETURNS:  ABORT = 1 IF USER ABORT OR S7 TIMEOUT
;            PASS = 1 IF DIAL TONE OR S6 WAIT
;            BUSY_CHK = 1 IF X3 OR X4 ENABLED
; STACK - 12
;==================================================
;
DIAL_WAIT:
	CLR	PASS
	CLR	ABORT
	CLR	ABORT1
	CLR	BUSY_CHK
	MOV	A,S22
	ANL	A,#70H
	CJNE	A,#70H,DL_W02	
	SJMP	DL_W20			;DIALTONE AND BUSY
DL_W02:	CJNE	A,#50H,DL_W04	
	SJMP	DL_W30			;DIALTONE CHECK ONLY
DL_W04:	CJNE	A,#60H,DL_W10			
DL_W09:	SETB	BUSY_CHK		;BUSY CHECK ONLY
DL_W10:	MOV	A,S6
	LCALL	WAIT_SEC		;WAIT S6 SECONDS
	SETB	PASS
	CLR	RI
	RET
;
DL_W20:	SETB	BUSY_CHK
DL_W30:	LJMP	CHK_DT			;WAIT FOR DIALTONE
;	RET				;AND RETURN
;
;==================================================
;AT_E - ECHO CONTROL
;  THIS COMMAND CONTROL THE ECHO DURING COMMAND MODE
;   E0 = DON'T ECHO DATA DURING IDLE/COMMAND MODE
;   E1 = ECHO DATA DURING IDLE/COMMAND MODE
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH COM_ECHO SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_E:	CLR	COM_ECHO
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_E1	;BRANCH IF NONE
	SETB	COM_ECHO
AT_E1:	SJMP	AT_F2
;
;==================================================
;AT_F - DUPLEX COMMAND
;  THIS COMMAND CONTROLS THE ECHOING OF DATA DURING
;  DATA MODE
;   F0 = ECHO DATA DURING DATA MODE (HALF DUPLEX)
;   F1 = DO NOT ECHO DATA DURING DATA MODE (FULL DUPLEX)
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - WITH FUL_DUP BIT SET ACCORDINGLY
; STACK - 4
;==================================================
;
AT_F:
;	CLR	FUL_DUP
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_F3	;BRANCH IF NONE OR 0
;	SETB	FUL_DUP
AT_F2:	LJMP	AT_000		
AT_F3:	LJMP	AT_ERR
;
;==================================================
;AT_H - RELAY CONTROL
;   H0 = ON HOOK
;   H1 = OFF HOOK
;   H2 = OFF HOOK (FOR COMPATABILITY)
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM,OFF_HOOK,ON_HOOK,SPEAK_OFF,SPEAK_ON
;          CLR_ON_FLGS
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 8
;==================================================
;
AT_H:	CLR	HOOK_BIT	;ON HOOK STATUS
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_H2	;BRANCH IF NONE OR 0

	SETB	HOOK_BIT	;OFFHOOK STATUS
	LCALL	OFF_HOOK
	LCALL	SPEAK_ON
AT_H1:	MOV	U_ST,#FFH
	SJMP	AT_F2		;AT_000	

AT_H2:	MOV	IE,#82H		;165
	LCALL	SPEAK_OFF
	JNB	DATA_BIT,AT_H3
	LCALL	CLR_ON_FLGS
	LCALL	INIT_TIM	;109
	LCALL	SET_OUT		;109
;	LCALL	INIT_MOD	;109D
AT_H3:	MOV	RAM2EH,#07H	;RESET ONLINE FLAGS
	MOV	RAM29H,#00	;RESET TEST FLAGS
	MOV	S16,#00		;RESET TEST FLAGS
	CLR	M_READY
;	LCALL	RX_MK		;109D
AT_H4:	LCALL	ON_HOOK
	LCALL	ATX_TY
	LCALL	INIT_MOD	;109
	SJMP	AT_H1
;
;==================================================
;AT_I - IDENTIFICATION COMMAND
; DESTROYS - ACC,DPTR,R0,R1,R2
; CALLS - GET_PARAM,SND_MSG
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 6
;==================================================
;
AT_I:	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JNB	PASS,AT_I1	;BRANCH IF NONE OR 0
	MOV	DPTR,#MSG_ID0	;I0 SEND MODEM TYPE IDENTIFICATION
AT_I3:	LCALL	V_CRLF
AT_I3B:	LCALL	SND_MSG
AT_I3A:	LCALL	V1_CRLF
AT_I4:	LJMP	AT_000		

AT_I1:	CJNE	A,#01,AT_I2
	MOV	DPTR,#MSG_ID1	;I1 SEND MODEM CHECKSUM
	SJMP	AT_I3

AT_I2:	CJNE	A,#02,AT_I8
	CALL	SND_OK		;I2
	SJMP	AT_I4		;DO NOTHING, COULD BE SELF TEST

AT_I8:	CJNE	A,#03,AT_I9	;I3 VERSION
ATI5A:	
	MOV	DPTR,#MSG_VER	;EXAR testing date code
;013	MOV	DPTR,#MSG_VER2	;RESERVED FOR CUSTOMERS
				;Create your own MSG_VER2 if necessary.
				; example:
				; MSG_VER2 : DB 0DH,0AH,'1/2/91',0FFH
	LCALL	SND_MSG
	MOV	DPTR,#MSG_VER1
	SJMP	AT_I3B

AT_I9:	CJNE	A,#06,AT_I5
	MOV	DPTR,#MSG_SYS	;I6 SHOW SYSTEM CONFIGURATION
	LCALL	SND_MSG
	IFTRUE	JCM
	LJMP	AT.V0		;SHOW EXAR VERSION ID
	ENDIF
	SJMP	AT_I3A		;SKIP LAST INSTRUCTION IF YOU DON'T WANT
				;TO SHOW ID

AT_I5:	CJNE	A,#09,ATI5A

	IFTRUE	MICROCOM
	MOV	DPTR,#MSG_CP	;I9 SEND OUT VERSION NUMBER
	LCALL	MSG_CPY
	ENDIF
	SJMP	AT_I3A

	IFTRUE	FAX
AT_I6:	DEC	POINTER		;11-9-90
	DEC	POINTER		;11-9-90
	LCALL	FETCH		;11-9-90 INC OPINTER
	ANL	A,#11011111B    ;11-9 MASK OUT LOWER CASE 
	CJNE	A,#'V',ATI_ERR	;11-9
	INC	POINTER		;11-9
ATI5:	MOV	DPTR,#MSG_VER
	LCALL	SND_MSG
	MOV	DPTR,#MSG_VER1
	SJMP	AT_I3B
ATF_I6:	MOV	DPTR,#MSG_MFR	;11-9-90
	SJMP	AT_I3
ATF_I7:	MOV	DPTR,#MSG_MDL	;11-9-90
	SJMP	AT_I3
ATI_ERR:LJMP	AT_ERR		;11-9-90
	ENDIF
;
;==================================================
;AT_K - SPECIAL TEST COMMAND
;  TEST 1 - R/W TEST OF SELECTED REGISTES
; DESTROYS - ACC,DPTR,R0,R1
; CALLS - SND_MSG,C_ENERGY
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 4
;==================================================
;
	IFTRUE	DEBUG
AT_K:	MOV	DPTR,#MSG_READ
	LCALL	SND_MSG
AT_K1:	LCALL	C_ENERGY
	JBC	RI,AT_K2
	SJMP	AT_K1
AT_K2:	LJMP	AT_000
	ENDIF
;
;==================================================
;AT_L - SPEAKER VOLUME COMMAND
;  THIS COMMAND WILL ONLY RETURN AN OK MESSAGE
; DESTROYS -  ACC,R0,R1,R2
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 4
;==================================================
;
AT_L:	
	PUSH	RAM22H
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	SETB	SPEAK_A
	CLR	SPEAK_B
	ORL	RAM22H,#00000011B
	JB	PASS,AT_L00	;BRANCH IF NONE
	CJNE	A,#01,AT_L1
AT_L00:	SJMP	AT_L3		;ATL1 OR ATL0 = LOW SPEAKER VOLUME
AT_L1:	CJNE	A,#02,AT_L2
	SETB	SPEAK_B		;MEDIUM SPEAKER VOLUME
	CLR	SPEAK_A		;MEDIUM SPEAKER VOLUME
	CLR	SPKR1A
	SJMP	AT_L3
AT_L2:	ORL	S22,#00000011B	
	ANL	RAM22H,#0H
				;CLR	SPEAK_A
				;CLR	SPEAK_B
;	SETB	SPEAK_B		;HI SPEAKER VOLUME
;	SETB	SPEAK_A
AT_L3:	LCALL	UPDAT_SPK
	POP	RAM22H
	SJMP	AT_M3		;AND EXIT
;
;==================================================
;AT_M - SPEAKER CONTROL
;  THIS COMMAND CONTROLS THE WAY THE SPEAKER IS USED
;  DURING THE DIALING SEQUENCE
;   M0 = SPEAKER ALWAYS OFF
;   M1 = SPEAKER ON UNTIL CARRIER
;   M2 = SPEAKER ALWAYS OFF
;   M3 = SPEAKER ALWAYS OFF
; DESTROYS - ACC,DPTR,R0,R1,R2
; CALLS -  GET_PARAM,SPEAK_ON,SPEAK_OFF
; EXPECTS - NOTHING
; RETURNS - SPEAK_1 AND SPEAK_2 BITS SET AS SPECIFIED
; STACK - 8
;==================================================
;
AT_M:	
	ANL	S22,#11110011B	
				;CLR	SPEAK_1
				;CLR	SPEAK_2
	LCALL	SPEAK_OFF	;GO TURN OFF SPEAKER 
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_M3	;BRANCH IF NONE
	CJNE	A,#01,AT_M1
	SETB	SPEAK_1
	SJMP	AT_M3
AT_M1:	CJNE	A,#02,AT_M2
	SETB	SPEAK_2
	LCALL	SPEAK_ON	;GO TURN ON SPEAKER 
	SJMP	AT_M3
AT_M2:	ORL	S22,#00001100B	
				;SETB	SPEAK_1	;SPEAKER ONLY ON AFTER DIALING
				;SETB	SPEAK_2
AT_M3:	SJMP	AT_P1		
;
;==================================================
;AT_N - NON VOLITLE RAM CHECK
; DESTROYS - ACC,R0,R1,R2,R3
; CALLS -  GET_PARAM,FETCH,SND_DIGITS,SND_BITS
;          READ_NV,WRT_NV,V_CRLF,V1_CRLF 
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 6
;==================================================
;
	IFTRUE	DEBUG
;MMM
;SPECIAL REQUEST
	IF WING
AT_N:
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_N3	;BRANCH IF NONE OR 0
AT_N2:	LJMP	AT_000		
AT_N3:	LJMP	AT_ERR
	ELSE
AT_N:	LCALL	GET_PARAM	;GET S REGISTER NUMBER
	MOV	R3,A
AT_N10:	LCALL	FETCH		;GET PARAMETER
	JNB	PASS,AT_N99	;BRANCH IF NONE
	CJNE	A,#'=',AT_N20
	SJMP	ATNEQ
AT_N20:	CJNE	A,#'?',AT_N30
	SJMP	ATNQUES
AT_N30:	DEC	POINTER		;POINT TO PREVIOUS CHAR
AT_N99:	LJMP	AT_000
;
;====================
;SET NV RAM REGISTER
;====================
;
ATNEQ:	LCALL	GET_PARAM	;GET VALUE
	MOV	REG_0,REG_3
	LCALL	WRT_NV		;WRITE TO RAM (R0=ADDR, ACC=DAT)
	ENDIF
	ENDIF
ATNEQ3:	LJMP	AT_000

	IFTRUE	DEBUG
;
;====================
;INQUIRE NV RAM REGISTER
;====================
;
ATNQUES:

	MOV	A,R3
	MOV	R0,A		;NV RAM ADDRESS
	LCALL	READ_NV

ATNQU3:	PUSH	ACC
	LCALL	V_CRLF
ATNQU4:	POP	ACC

	LCALL	SND_DIGITS	;OUTPUT DECIMAL VALUE
;	LCALL	SND_BITS	;OUTPUT BINARY VALUE

	LCALL	V1_CRLF
	SJMP	ATNEQ3		;RETURN

	ENDIF
;
;==================================================
;AT_O - ORIGINATE/ONLINE COMMAND
;  THIS COMMAND WILL PUT THE MODEM INTO ORIGINATE
;  OR BACK INTO THE DATA MODE IF ALREADY ONLINE.
;   O0 - ORIGINATE OR ONLINE
;   O1 - GO BACK ONLINE AND RETRAIN
;
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 4
;==================================================
;
AT_O:	LCALL	GET_PARAM
	JB	DATA_BIT,AT_O1
AT_O4:	SETB	ORG_BIT
	CLR	AUTODIAL
AT_O5:
	IFTRUE	FAX
	MOV	DPTR,#OPT_FAX
	MOVX	A,@DPTR
	JZ	AT_OF		;4-26-90
	JNB	ACC.0,AT_OF	;4-26-90
	LJMP	FAX_CALL
	ENDIF

AT_OF:	LJMP	MAN_ORG

AT_O1:	JB	RDLB_REQ,AT_O2	;11-2-89
	JB	PASS,AT_O2
	JB	ALB_REQ,AT_O2	;135
	CJNE	A,#01H,AT_O2	;
	JNB	HI_SPD2,AT_O2	;RETRAIN REQUEST ONLY IN 2400	
	SETB	RETRAIN		;REQUEST RETRAIN
AT_O2:
	CLR	A
	MOV	DPTR,#Z_BUF
	MOVX	@DPTR,A
	LJMP	GO_ONLINE	;GO BACK ONLINE

;==================================================
;AT_P - PULSE DIAL SELECT
;  NO PARAMETERS HERE
; DESTROYS - ACC
; CALLS -  NOTHING
; EXPECTS - NOTHING
; RETURNS - PUL_DIAL CLEARED
; STACK - 0
;==================================================
;
AT_P:	SETB	PUL_DIAL
AT_P1:	SJMP	AT_Q1		
;
;==================================================
;AT_Q - RESULT CODE  CONTROL
;  THIS COMMAND CONTROLS THE RESULT CODE
;   Q0 = ENABLE RESULT CODES
;   Q1 = DISABLE RESULT CODES
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - QUIET SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_Q:	CLR	QUIET
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_Q1	;BRANCH IF NONE
	SETB	QUIET
AT_Q1:	LJMP	AT_000		
;
	IFTRUE	DEBUG
;==================================================
;AT_R - MODEM REGISTER COMMAND
; DESTROYS - ACC,R0,R1,R2,R3
; CALLS -  GET_PARAM,FETCH,SND_BITS,SND_DIGITS,WR1_CNTL
;          V1_CRLF,V_CRLF 
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 8
;==================================================
;
	IFFALSE	X2400
AT_R:	LCALL	GET_PARAM	;GET S REGISTER NUMBER
	MOV	R3,A
AT_R10:	LCALL	FETCH		;GET PARAMETER
	JNB	PASS,AT_R99	;BRANCH IF NONE
	CJNE	A,#'=',AT_R20
	SJMP	ATREQ
AT_R20:	CJNE	A,#'?',AT_R30
	SJMP	ATRQUES
AT_R30:	DEC	POINTER		;POINT TO PREVIOUS CHAR
AT_R99:	LJMP	AT_000
;
;====================
;SET R REGISTER
;====================
;
ATREQ:	LCALL	GET_HEX		;GET VALUE
	JNB	PASS,AT_R99
	MOV	B,R3    	;BRING BACK ADDRS FROM R3
 	LCALL	WR0_CNTL		
ATREQ3:	LJMP	AT_000
;
;====================
;INQUIRE R REGISTER
;====================
;
ATRQUES:
	MOV	B,R3
	LCALL	RD0_CNTL
ATRQU3:	PUSH	ACC
	LCALL	V_CRLF
ATRQU4:	POP	ACC

;	LCALL	SND_DIGITS	;OUTPUT DECIMAL VALUE
	LCALL	SND_HEX		

	LCALL	V1_CRLF
	SJMP	ATREQ3		;RETURN
 	ENDIF
	
	IFTRUE	X2400
AT_R:	LCALL	GET_PARAM	;GET S REGISTER NUMBER
	MOV	R3,A
AT_R10:	LCALL	FETCH		;GET PARAMETER
	JNB	PASS,AT_R99	;BRANCH IF NONE
	CJNE	A,#'=',AT_R20
	SJMP	ATREQ
AT_R20:	CJNE	A,#'?',AT_R30
	SJMP	ATRQUES
AT_R30:	DEC	POINTER		;POINT TO PREVIOUS CHAR
AT_R99:	LJMP	AT_000
;
;====================
;SET R REGISTER
;====================
;
ATREQ:	LCALL	GET_PARAM	;GET VALUE
	MOV	B,R3
	LCALL	WR1_CNTL		;SET UP FOR FSK  MODE
ATREQ3:	LJMP	AT_000
;
;====================
;INQUIRE R REGISTER
;====================
;
ATRQUES:
	MOV	A,R3
	LCALL	RD_STAT
ATRQU3:	PUSH	ACC
	LCALL	V_CRLF
ATRQU4:	POP	ACC

;	LCALL	SND_DIGITS	;OUTPUT DECIMAL VALUE
	LCALL	SND_BITS	;OUTPUT DECIMAL VALUE

	LCALL	V1_CRLF
	SJMP	ATREQ3		;RETURN

	ENDIF
	
	ENDIF

;==================================================
;AT_S - S REGISTER CONTROL
;  SET OR INQUIRE S REGISTERS
;   SXX=XX   SET S REGISTERS
;   SXX?     INQUIRE S REGISTERS
; DESTROYS - ACC,DPTR,R0,R1,R2
; CALLS -  GET_PARAM,FETCH,SND_DIGITS,V_CRLF,V1_CRLF,GET_S,PUT_S 
; EXPECTS - NOTHING
; RETURNS - S REGISTERS SET AS SPECIFIED
; STACK - 8
;==================================================
;
AT_S:	LCALL	GET_PARAM	;GET S REGISTER NUMBER
	MOV	S_STORE,A	;SAVE FOR AT?
AT_S10:	LCALL	FETCH		;GET PARAMETER
	JNB	PASS,AT_S99	;BRANCH IF NONE
	CJNE	A,#'=',AT_S20
	SJMP	AT_EQ
AT_S20:	CJNE	A,#'?',AT_S30
	SJMP	AT_QUES
AT_S30:	DEC	POINTER		;POINT TO PREVIOUS CHAR
AT_S99:	LCALL	SET_AA_BIT	;SETUP AUTO ANSWER BIT AS NEEDED
	LJMP	AT_000
;
;====================
;SET S REGISTER
;====================
;
AT_EQ:	LCALL	GET_PARAM	;GET VALUE
	PUSH	ACC		;SAVE VALUE
	MOV	A,S_STORE
	CJNE	A,#MAX_S,AT_EQ1
AT_EQ1:	JNC	AT_EQ2		;S REGISTER > MAX_S
	CJNE	A,#03,AT_EQ4	
;	POP	ACC		;109S IT IS A <CR> CHARACHTER REPLACE <CR> IN
;	MOV	R0,END_OF_BUF	;BUFFER WITH NEW <CR> CHARACHTER
;	MOV	@R0,A
;	PUSH	ACC		
;	MOV	A,S_STORE	;162S
;	MOV	R0,A
	POP	ACC
	MOV	DPTR,#JS9
	MOVX	@DPTR,A
	MOV	U_ST,#10H
	LJMP	AT_000		;109T ;162T

AT_EQ4:	MOV	R0,A
	POP	ACC
	LCALL	PUT_S		;STORE S REGISTER

;	SETB	AA_BIT		;AUTO ANSWER LED OFF
;	CJNE	R0,#00,AT_EQ3	;IF S0 SET AA_BIT CORRECTLY
;	JZ	AT_EQ3		;BRANCH IF LIGHT OFF
;	CLR	AA_BIT	
	SJMP	AT_EQ3
AT_EQ2:	POP	ACC
	IFTRUE MICROCOM
	LJMP	ADDS_REG
	ENDIF
AT_EQ3:	SJMP	AT_S99
;
;====================
;INQUIRE S REGISTER
;====================
;
AT_QUES:
	MOV	A,S_STORE
	CJNE	A,#MAX_S,AT_QU1
AT_QU1:	JC	AT_QU2		;S REGISTER < 28

	IFTRUE	MICROCOM
	MOV	A,#00		;002S
	MOV	R1,#00
	MOV	DPTR,#EX_SREG
S_SREG:	MOVC	A,@A+DPTR
	CJNE	A,S_STORE,TL_S
	MOV	A,R1
	ADD	A,#MISC_RL		;143
	MOV	DPL,A
	MOV	DPH,#MISC_REG
	MOVX	A,@DPTR
	SJMP	AT_QU3

NEXTS:	INC	R1
	MOV	A,R1
	SJMP	S_SREG

TL_S:	CJNE	A,#0FFH,NEXTS
	ENDIF

	LJMP	AT_ERR		;002T

AT_QU2:	MOV	R0,A
	LCALL	GET_S		;GET REGISTER
AT_QU3:	PUSH	ACC
	LCALL	V_CRLF
AT_QU4:	POP	ACC
	LCALL	SND_DIGITS	;OUTPUT DECIMAL VALUE
	LCALL	V1_CRLF
	SJMP	AT_EQ3		;RETURN
;
;==================================================
;AT_T - TONE DIAL SELECT
;  NO PARAMETERS HERE
; DESTROYS - ACC
; CALLS -  NOTHING
; EXPECTS - NOTHING
; RETURNS - PUL_DIAL SET
; STACK - 0
;==================================================
;
AT_T:	CLR	PUL_DIAL
	SJMP	AT_V1
;
;==================================================
;AT_V - VERBOSE RESULT CODE  CONTROL
;  THIS COMMAND CONTROLS THE TYPE OF RESULT CODE
;   V0 = TERSE - NUMERIC RESULT CODES
;   V1 = VERBOSE - ENGLISH RESPONSE CODES
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - VERBOSE SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_V:	CLR	VERBOSE
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_V1	;BRANCH IF NONE
	SETB	VERBOSE
AT_V1:	LJMP	AT_000		
;
;==================================================
;AT_W - NEGOTIATION REPORT
;		W0 : disable
;		W1 : report carrier
;		W2 : report carrier & error control
; DESTROYS - 
; CALLS - GET_PARAM
; EXPECTS - NOTHING
; RETURNS - 
; STACK - 4
;==================================================
;
AT_W:
	MOV	DPTR,#JS6
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	CJNE	A,#3,CHK_BOND
CHK_BOND:
	JNC	AT_W1
	ANL	A,#00H		;FORCE ATW0 
;	ANL	A,#0FH
	MOV	B,A
	MOVX	A,@DPTR
	ANL	A,#F0H
	ORL	A,B
	MOVX	@DPTR,A
AT_W1:	LJMP	AT_000		

;==================================================
;AT_X - RESULT CODE ENABLE
;  THIS COMMAND CONTROLS WHICH RESULT CODES ARE 
;  ENABLED
;
; DESTROYS - ACC,R0,R1,R2
; CALLS - GET_PARAM
; EXPECTS - NOTHING
; RETURNS - XBIT_0 THROUGH XBIT_2 SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_X:	ANL	S22,#10001111B	
				;CLR	XBIT_0
				;CLR	XBIT_1
				;CLR	XBIT_2
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_X6	;BRANCH IF NONE OR 0
	CJNE	A,#01,AT_X1
	SETB	XBIT_2
	SJMP	AT_X6
AT_X1:	CJNE	A,#02,AT_X2
	ORL	S22,#01010000B	
				;SETB	XBIT_2
				;SETB	XBIT_0
	SJMP	AT_X6
AT_X2:	CJNE	A,#03,AT_X3
	ORL	S22,#01100000B	
				;SETB	XBIT_2
				;SETB	XBIT_1
	SJMP	AT_X6
AT_X3:	CJNE	A,#04,AT_X4
	ORL	S22,#01110000B	
				;SETB	XBIT_2
				;SETB	XBIT_1
				;SETB	XBIT_0
AT_X6:	SJMP	AT_V1
AT_X4:	LJMP	AT_ERR		;THE X COMMAND SENDS AN ERROR IF OVER 4

;
;==================================================
;AT_Y - LONG SPACE DISCONNECT CONTROL
;  THIS COMMAND CONTROLS THE ENABLING OF LONG SPACE DISCONNECT
;   Y0 = DISABLE LONG SPACE DISCONNECT
;   Y1 = ENABLE LONG SPACE DISCONNECT
; DESTROYS - ACC,R0,R1,R2
; CALLS -  GET_PARAM 
; EXPECTS - NOTHING
; RETURNS - LSD_ENB SET AS SPECIFIED
; STACK - 4
;==================================================
;
AT_Y:	
	IFFALSE	LIMITED
	CLR	LSD_ENB
	LCALL	GET_PARAM	;GET NEXT PARAMETER
	JB	PASS,AT_Y1	;BRANCH IF NONE
	SETB	LSD_ENB
AT_Y1:	LJMP	AT_000		
	ENDIF
;
;==================================================
;AT_Z - RESET MODEM
;  THIS COMMAND PUTS THE MODEM IN THE POWER UP STATE
;  NO PARAMETERS FOR THIS COMMAND
; DESTROYS - ACC,DPTR
; CALLS -  ON_HOOK,INIT_MOD,INIT_IO,INIT_AT,SND_RESULT
; EXPECTS - NOTHING
; RETURNS - XR2400 RESET
;           "AT" REGISTERS RESET TO POWER ON DEFAULTS
;           I/O SET TO POWER ON DEFAULTS
; STACK - 8
;==================================================
;
AT_Z:	LCALL	ON_HOOK
	LCALL	CHK_NV		;CHECK NV RAM
	JNB	PASS,AT_Z1
	LCALL	INIT_MOD	;INITIALIZE MODEM CHIP
	LCALL	INIT_IO		;INITIALIZE I/O
;12-17-89
	MOV	R2,S23
	ANL	REG_2,#3EH	;SAVE PARITY AND SPEED STATUS
	MOV	U_ST,#1		;ATZ CALLING ID
	LCALL	INIT_AT		;INITIALIZE ALL REGISTERS EXECPT BAUD RATE
				;AND PARITY
	LCALL	UPDAT_SPK
	LCALL	SND_OK
	LJMP	WARM_ST

AT_Z1:	PUSH	REG_0
	MOV	A,#BUFFER
	ADD	A,POINTER
	MOV	R0,A
	MOV	@R0,S3
	POP	REG_0
	LJMP	ATX_F
;
;############################################################
;#                                                          #
;#                    AT SUBROUTINES                        #
;#                                                          #
;############################################################
;
;==================================================
;GET_PARAM - GET DIGIT(S) PARAMETER FROM LINE BUFFER
;  THIS ROUTINE WILL GET THE NEXT COMPLETE DIGIT FROM
;  THE BUFFER.  THIS ROUTINE WILL CONTINUE TO FETCH
;  DIGITS UNTIL A NON DIGIT IS FOUND.
; DESTROYS - ACC,R0,R1,R2
; CALLS - IS_DIGIT
; EXPECTS - POINTER - POINTING TO NEXT CHAR
; RETURNS - PASS = 1  -  ZERO OR NO DIGIT FOUND
;           PASS = 0  -  DIGIT PARAMETER IN ACC
;
; STACK - 2
;==================================================
;
GET_PARAM:
	MOV	R1,#00H		;CLEAR RESULT
GET_P0:	MOV	A,#BUFFER
	ADD	A,POINTER
	MOV	R0,A		
GET_P1:	MOV	A,@R0		;GET PARAMETER
	INC	POINTER
	INC	R0
GET_P2:	LCALL	IS_DIGIT	;SEE IF IT'S A DIGIT AND MAKE BINARY
	JNB	PASS,GET_EX	;EXIT
	MOV	R2,A		;SAVE DIGIT
;
	MOV	A,R1		;TAKE LAST DIGIT AND MULTIPLY BY 10
	CLR	C	
	RLC	A		;X2
	CLR	C
	RLC	A		;X4
	CLR	C
	RLC	A		;X8
	CLR	C
	ADD	A,R1		;X9
	ADD	A,R1		;X10
;
	ADD	A,R2		;COMBINE WITH PRESENT DIGIT
	MOV	R1,A		;SAVE DIGIT
	SJMP	GET_P1
GET_EX:	MOV	A,R1		;PUT RESULT IN ACC
	DEC	POINTER
	CJNE	A,#00H,GET_EX2	;BRANCH IF NOT ZERO
GET_EX1:
	SETB	PASS
	RET
GET_EX2:
	CLR	PASS
	RET
;
;==================================================
;FETCH - GET NEXT CHAR IN BUFFER AND CONVERT TO UPPER
; CASE IF NECCESSARY
;
; DESTROYS -  ACC
; CALLS - NOTHING
; EXPECTS - POINTER - POINTING TO NEXT CHAR
; RETURNS - PASS = 1  -  ZERO OR NO DIGIT FOUND
;           PASS = 0  -  DIGIT PARAMETER IN ACC
;           ACC = CHARACHTER CONVERTED TO UPPER CASE IF NEEDED
; STACK - 1
;==================================================
;
FETCH:	PUSH	REG_0
	MOV	A,#BUFFER
	ADD	A,POINTER	;POINT TO NEXT CHAR
	MOV	R0,A		
	MOV	A,@R0		;GET CHAR
	CJNE	A,#'a',FET10
FET10:	JC	FET30		;CARRY = 1 IF CHAR LOWER THAN 'a'
	CJNE	A,#('z'+1),FET20
FET20:	JNC	FET30		;CARRY = 0 IF CHAR HIGHER THAN 'z'
	ANL	A,#0DFH		;CONVERT TO UPPER CASE IF LOWER CASE
FET30:	INC	POINTER
	POP	REG_0
	SETB	PASS
	RET
;
;==================================================
;IS_DIGIT - CHECKS TO SEE IF THE CHAR IN THE ACC IS
;  A DIGIT, IF IT IS A DIGIT CONVERT TO BINARY
; DESTROYS -  NOTHING
; CALLS - NOTHING
; EXPECTS - ACC = ASCII CHARACHTER FOR TEST
; RETURNS - PASS = 1  -  VALID ASCII DIGIT
;           PASS = 0  -  NOT A DIGIT
;
; STACK - 0
;==================================================
;
IS_DIGIT:
	CLR	PASS
	CJNE	A,#'0',IS_D10
IS_D10:	JC	IS_D_NOT		;BRANCH IF NOT DIGIT
	CJNE	A,#3AH,IS_D11
IS_D11:	JNC	IS_D_NOT
	ANL	A,#0FH	
	SETB	PASS
NOT_NULL:
	RET
IS_D_NOT:
	CJNE	A,#0,NOT_NULL
	INC	POINTER
	RET

	
	IFTRUE	FAX
SET_ID:
	MOV	A,#BUFFER
	ADD	A,POINTER
	MOV	R0,A		
;10-29-90	MOV	DPTR,#FD_CSIA+4
SET_ID1:
	MOV	A,@R0		;GET PARAMETER
	INC	POINTER		;FOR AT_000 ROUTINE TO FETCH <CR>/";"
	INC	R0
;10-29-90	PUSH	DPL
;10-29	PUSH	DPH
;10-29	MOV	DPTR,#VALID_ID	;POINT TO VALID DIGIT TABLE
;10-29	LCALL	IS_VA		;SEE IF ALL DIGITS IN FAX ID ARE VALID
;10-29	POP	DPH
;10-29	POP	DPL
;10-29	JNB	PASS,ID_EX	;EXIT
	CJNE	A,#'"',SET_ID2	;JUMP IF ID NOT TERMINATED YET
ID_EX:	
	RET
SET_ID2:
	MOVX	@DPTR,A
;10-29-90	INC	DPTR
	DEC	DPL		;10-29 WATCH OUT IN CASE DPL=00
	SJMP	SET_ID1
;
;10-29-90
RESET_ID:
	MOV	R3,#20D
;12-19-90	CLR	A
	MOV	A,#' '		;12-19-90
RESET_ID0:
	MOVX	@DPTR,A
	INC	DPTR
	DJNZ	R3,RESET_ID0
	RET
	ENDIF
;==================================================
;BUF_CHARS - BUFFER INCOMING CHARACHTERS
; THIS ROUTINE WILL BUFFER INCOMING CHARACHTERS FROM
; THE DTE UNTIL A VALID CARRIAGE RETURN IS DETECTED.
; IT WILL ALSO PROCESS A BACKSPACE BY ERASING THE
; PREVIOUS CHARACHTER
;  FOR THE 1200 PRODUCT CHARACHTERS RECEIVED AFTER THE
;  CARRIAGE RETURN CHARACHTER WILL NOT BE ECHOED
; DESTROYS -  ACC,R0,R1
; CALLS - GET_CHAR,PUT_CHAR
; EXPECTS - NOTHING
; RETURNS - PASS = 1  -  CHARACHTERS BUFFERED OK
;           PASS = 0  -  OVERFLOW DETECTED
;         - END_OF_BUF - LOCATION OF THE CARRIAGE RETURN
; STACK - 2
;==================================================
;
BUF_CHARS:
	SETB	PASS
	MOV	R1,#00H			;CLEAR BUFFER COUNT
	MOV	R0,#BUFFER		;POINT TO BEGIN OF BUFFER
BUF_C1:	LCALL	GET_CHAR		;GET CHAR FROM DTE AND ECHO
;
;====================
;CHECK FOR BACKSPACE
;====================
	CJNE	A,S5,BUF_C2		;IS IT A BACK SPACE
	CLR	A
	CJNE	A,REG_1,BUF_C3		;YES - BUT ARE WE AT BEGINNING OF LINE
	SJMP	BUF_C1			;CAN'T BACK UP ANY MORE - GO GET
					;FETCH ANOTHER CHAR
BUF_C3:	DEC	R1
	DEC	R0
	JNB	COM_ECHO,BUF_C1
	MOV	A,S5			;SEND BACKSPACE SINCE GET_CHAR WILL 
					;ECHO S5 CHARACHTER
	LCALL	PUT_CHAR
	MOV	A,#SPACE		;SEND A FORWARD SPACE
	LCALL	PUT_CHAR
	MOV	A,S5			;SEND ANOTHER BACKSPACE
	LCALL	PUT_CHAR
	SJMP	BUF_C1			;FETCH ANOTHER CHAR
;
;====================
;CHECK FOR TERMINATION
;====================
BUF_C2:
;10-29-90-- FOR AT+FLID=
;10-29	CJNE	A,#SPACE,BUF_C4		;DONT BUFFER SPACE CHAR
;10-29	SJMP	BUF_C1			;FETCH ANOTHER CHAR
	CJNE	A,#SPACE,BUF_C4		;12-19-90JUMP IF NOT SPACE
	MOV	DPTR,#OPT_FAX		;12-19-90
	MOVX	A,@DPTR			;12-19
	JB	ACC.0,BUF_C4		;12-19 JUMP IF CLASS IS NOT 0
	SJMP	BUF_C1			;12-19DONT BUFFER SPACE CHAR
					;FETCH ANOTHER CHAR
BUF_C4:	CJNE	R1,#(MAX_LINE+1),BUF_C5	;BRANCH IF NO OVERFLOW
	CLR	PASS			;SET OVERFLOW FLAG
	SJMP	BUF_C6
BUF_C5:	MOV	@R0,A			;SAVE CHARACHTER
	INC	R0			;POINT TO NEXT BUFFER LOCATION
	INC	R1			;INCREMENT BUFFER COUNT
BUF_C6:	CJNE	A,S3,BUF_C1		;NOT A <CR> FETCH ANOTHER CHAR
	DEC	R0
;	MOV	END_OF_BUF,R0		;109D SAVE LOCATION OF <CR> CHAR
	MOV	A,#4			;WAIT FOR <LF> CHAR
	LCALL	WAIT_3MS
	JNB	RI,BUF_CX
	LCALL	GET_C0	
BUF_CX:	RET		
;
;==================================================
;GET_CHAR - GET CHARACHTER FROM DTE
; THIS ROUTINE WILL WAIT FOR A CHARACHTER TO BE 
; RECEIVED FROM THE DTE AND ECHO IT IF NECCESSARY
; A BACKSPACE CHARACHTER (S5) WILL NOT BE ECHOED
;
; DESTROYS -  ACC,R0,R1
; CALLS - NOTHING
; EXPECTS - NOTHING
; RETURNS -  CHAR IN ACC
; I/O - GETS CHARACHTER FROM SBUF
;       OUTPUTS CHAR TO SBUF
; STACK - 1
;==================================================
;
GET_CHAR:
	
	IFTRUE	RING
	JB	RI_IN,GET_C3
	CLR	DATA_BIT
	LJMP	WARM_ST
GET_C3:
	ENDIF
	
	JNB	RI,GET_CHAR		;WAIT FOR CHARACHTER
GET_C0:	CLR	RI
	MOV	A,SBUF
	PUSH	ACC
	ANL	A,#7FH			;NO PARITY
	CJNE	A,S5,GET_C1		;
	POP	ACC
	SJMP	GET_C4			;DONT ECHO BACKSPACE
GET_C1:	POP	ACC
	JNB	COM_ECHO,GET_C4		;DON'T ECHO IF NOT OPTIONED
	MOV	SBUF,A			;SEND CHARACHTER BACK
GET_C2:	JNB	TI,GET_C2		;WAIT FOR CHAR TO ECHO
	CLR	TI
GET_C4:	ANL	A,#7FH			;MASK OFF PARITY
	RET
;
SND_OK:	MOV	DPTR,#MSG_OK
	SJMP	SND_RESULT
;
;==================================================
;SND_RESULT - SEND THE SELECTED RESULT CODE TO THE DTE
;  IF TERSE MODE IS ENABLED SEND ONLY THE DIGIT CODE
;
; DESTROYS -  ACC,R0,R1
; CALLS - S_CRLF,SND_MSG,PUT_CHAR
; EXPECTS - DPTR POINTING TO THE SELECTED RESULT CODE
; RETURNS -  NOTHING
; STACK - 4
;==================================================
;
SND_RESULT:
;	JB	SYNC_D,SND_R2		;103D DON'T SEND ANYTHING IF SYNC DIAL
	JB	QUIET,SND_R2		;DON'T SEND ANYTHING IF QUIET
	JNB	VERBOSE,SND_R1		;BRANCH IF TERSE (DIGITS ONLY)
	INC	DPTR
	INC	DPTR			;POINT TO ENGLISH RESPONSES
	CLR	A
	MOVC	A,@A+DPTR		;GET CHAR
	CJNE	A,#SPACE,SND_R4		;BRANCH IF NOT A SPACE
	INC	DPTR			;MUST BE "CONNECT 2400" MESSAGE
SND_R4:	LCALL	S_CRLF			;SEND VERBOSE PREFIX 
	LCALL	SND_MSG
	LJMP	S_CRLF			;TO RETUNR
;	RET

SND_R1:	CLR	A
	MOVC	A,@A+DPTR
	LCALL	PUT_CHAR
	INC	DPTR
	CLR	A
	MOVC	A,@A+DPTR
	CJNE	A,#SPACE,SND_R5		;BRANCH IF ANOTHER CHAR TO SEND
	SJMP	SND_R3
SND_R5:	LCALL	PUT_CHAR
SND_R3:	LCALL	S_CR
SND_R2:	RET
;
;==================================================
;SND_DIGITS - SEND THE ASCII DECIMAL REPRESENTATION
;  OF THE 8 BIT NUMBER CONTAINED IN THE ACC.
;
; DESTROYS -  ACC,B
; CALLS - PUT_CHAR
; EXPECTS - ACC = NUMBER TO PRINT
; RETURNS -  NOTHING
; STACK - 2
;==================================================
;
SND_DIGITS:
	MOV	B,#100
	DIV	AB
	ADD	A,#'0'
	LCALL	PUT_CHAR
	MOV	A,#10
	XCH	A,B
	DIV	AB
	ADD	A,#'0'
	LCALL	PUT_CHAR
	MOV	A,B
	ADD	A,#'0'
	LJMP	PUT_CHAR	;TO RETURN	

;==================================================
;SND_BITS - SEND THE BINARY REPRESENTATION
;  OF THE 8 BIT NUMBER CONTAINED IN THE ACC.
;
; DESTROYS -  ACC,B
; CALLS - PUT_CHAR
; EXPECTS - ACC = NUMBER TO PRINT
; RETURNS -  NOTHING
; STACK - 2
;==================================================
;

SND_BITS:
	IFTRUE	DEBUG

	MOV	R0,#8
SNDB1:	RLC	A
	JNC	SNDB2
	PUSH	ACC
	MOV	A,#'1'
SNDB3:	LCALL	PUT_CHAR
	MOV	A,#' '
	LCALL	PUT_CHAR
	POP	ACC
	DJNZ	R0,SNDB1
	RET
SNDB2:	PUSH	ACC
	MOV	A,#'0'
	SJMP	SNDB3

	ENDIF
;
;=========================================
; FETCH INPUT DATA AND CONVERT TO HEX
;=========================================
GET_HEX:
	LCALL	FETCH
	JNB	PASS,GET00
	LCALL	ASC_HEX
	JNB	PASS,GET00
	SWAP	A
	MOV 	R2,A		;MOVE TO R2 FOR TEMPERARY
	LCALL	FETCH
	JNB	PASS,GET00
	LCALL	ASC_HEX
	ORL	A,R2
GET00:	RET	
;
;=========================================
; ASCII TO HEX CODE CONVERTION
;=========================================
;
ASC_HEX:
	CJNE	A,#30H,NZ
	SJMP	NUMHEX
NZ	CJNE	A,#39H,N9
	SJMP	NUMHEX
N9	JC	NUMHEX
	CJNE	A,#41H,NA
	SJMP	LETHEX
NA	JC	ASCERR
	CJNE	A,#46H,NF
	SJMP	LETHEX
NF	JC	LETHEX
ASCERR	CLR	PASS
	RET
NUMHEX	SETB	PASS
  	ANL	A,#0FH
	RET
LETHEX	SETB	PASS
	ANL	A,#0FH
	ADD	A,#9
	RET
;
;======================================================
; CONVERRT BINARY TO HEX THEN SEND HEX CODE TO TERMINAL
;======================================================
;
SND_HEX:
	PUSH	A
	SWAP	A
	LCALL	HEXASC
	LCALL	PUT_CHAR
	POP	A
	LCALL	HEXASC
	LCALL	PUT_CHAR
	RET

HEXASC:	ANL	A,#0FH
	INC	A
	MOVC	A,@A+PC
	RET
ASCTBL:	DB	'0'
	DB	'1'
	DB	'2'
	DB	'3'
	DB	'4'
	DB	'5'
	DB	'6'
	DB	'7'
	DB	'8'
	DB	'9'
	DB	'A'
	DB	'B'
	DB	'C'
	DB	'D'
	DB	'E'
	DB	'F'
;
;==================================================
;SND_MSG - SEND CHARACHTERS POINTED TO BY DPTR UNTIL
; 0FFH CHARACTER RECEIVED
; DESTROYS -  ACC,DPTR
; CALLS - PUT_CHAR
; EXPECTS - DPTR POINTING TO STRING TERMINATED BY 0FFH
; RETURNS -  NOTHING
; STACK - 2
;==================================================
;
SND_MSG:
	CLR	A
	MOVC	A,@A+DPTR
	CJNE	A,#0FFH,SND_M1
	RET
SND_M1:	LCALL	PUT_CHAR
	INC	DPTR
	SJMP	SND_MSG
;
;==================================================
;S_CRLF - SEND CARRIAGE RETURN/LINEFEED
; DESTROYS -  NOTHING
; CALLS - PUT_CHAR
; EXPECTS - NOTHING
; RETURNS -  NOTHING
; STACK - 2
;==================================================
;
V1_CRLF:	
	JNB	VERBOSE,S_CR
V_CRLF:	JNB	VERBOSE,S_CR2
S_CRLF:	MOV	A,S3
	LCALL	PUT_CHAR
	MOV	A,S4
S_CR1:	LCALL	PUT_CHAR
S_CR2:	RET	
S_CR:	MOV	A,S3
	SJMP	S_CR1
;
;==================================================
;CHK_DIGIT - CHECK TO SEE IF DIGIT IN ACC IS A DIALABLE
;  DIGIT, IF IT IS CONVERT TO BINARY 
; DESTROYS -  ACC,DPTR,R0,B
; CALLS - NOTHING
; EXPECTS - ACC = DIGIT TO TEST
; RETURNS -  PASS = 1 IF DIALABLE DIGIT 
;            ACC = PULSE COUNT IF PULSE DIAL  (0) IF ILLEGAL PULSE DIGIT
;            ACC = TONE CONTROL WORD IF TONE DIAL
;            ACC = DIGIT TO TEST IF NOT A VALID DIAL DIGIT
; STACK - 0
;==================================================
;
CHK_DIGIT:
	CLR	PASS
	MOV	DPTR,#VALID_D
	JNB	PUL_DIAL,CHKD50	
	CJNE	A,#'0',CHKD20
	MOV	A,#10
CHKD20:	JC	CHKD99			;EXIT IF DIGIT < 0
	CJNE	A,#('9'+1),CHKD30
CHKD30:	JNC	CHKD99			;EXIT IF DIGIT > 9
	ANL	A,#0FH			;MAKE BINARY
CHKD98:	SETB	PASS
CHKD99:	RET
;
CHKD50:	MOV	DPTR,#VALID_D
	MOV	R0,#00
	MOV	B,A			;SAVE DIGIT
CHKD60:	CLR	A
	MOVC	A,@A+DPTR		;GET CHAR
	CJNE	A,B,CHKD70
	MOV	A,R0		
	MOV	DPTR,#TONE_TAB
	MOVC	A,@A+DPTR		;GET TONE CONTROL WORD
	SJMP	CHKD98			;VALID DIGIT
CHKD70:	INC	DPTR
	INC	R0
	CJNE	R0,#16,CHKD60		;END OF TABLE YET
	MOV	A,B			;RESTORE CHARACHTER
	RET				;RETURN WITH ERROR
;
;==================================================
;DIGIT_D - DIAL SELECTED DIGIT
;  TAKES THE DIGIT IN THE ACC AND TONE OR PULSE DIALS
;  IT DEPENDING ON THE STATUS OF THE PUL_DIAL BIT.
;
; DESTROYS -  ACC,B,R0,R1,R3
; CALLS - WAITMS,WAIT_3MS,WR1_CNTL,WAIT200,SET_DTMF,DTMF_OFF
; EXPECTS - ACC = DIGIT TO DIAL
;           PUL_DIAL TO SPECIFY DIAL TYPE
; RETURNS -  ABORT = 1  -  USER ABORT DURING DIALING
;            ABORT = 0  -  DIGIT DIALED
; STACK - 8
;==================================================
;
DIGIT_D:
	CLR	ABORT
	JNB	PUL_DIAL,TT_D1	;BRANCH IF TONE DIAL
;====================
;PULSE DIAL
;====================
PP_D20:	MOV	R1,A			;DIGIT COUNT
PP_D30:	LCALL	ON_HOOK	
	MOV	A,#18			;61MS MAKE TIME
	JNB	PUL_RATIO,PP_D32	;BRANCH IF UK PULSE RATIO
	ADD	A,#2			;61MS + 6MS = 67 MS MAKE TIME
PP_D32:	LCALL	WAIT_3MS		;
	JB	RI,PP_D45
	LCALL	OFF_HOOK
	MOV	A,#10			;33 MS
	JB	PUL_RATIO,PP_D36	;BRANCH IF UK PULSE RATIO
	ADD	A,#2			;33MS + 6MS = 39 MS MAKE TIME
PP_D36:	LCALL	WAIT_3MS		;39MS BREAK TIME
	JB	RI,PP_D45
	DJNZ	R1,PP_D30		;
PP_D40:	MOV	A,#240			;800MS INTERDIGIT TIME		
	LCALL	WAIT_3MS
	JB	RI,PP_D45
	RET
PP_D45:	SETB	ABORT
	CLR	RI
	RET
TT_D1:	LJMP	TT_D10

;==================================================
;WAIT_3MS - WAIT THE NUMBER OF MS IN THE ACC
;  THIS ROUTINE DOES NOT WAIT FOR A USER ABORT
; DESTROYS -  ACC
;             TIMER 4
; CALLS - NOTHING
; EXPECTS - ACC = NUMBER OF MS TO DELAY
; RETURNS -  ABORT = 1  -  USER ABORT DURING WAIT
;            ABORT = 0  -  DELAY OK
; STACK - 0
;==================================================
;
WAIT_3MS:	
	MOV	TIM_4,A		;LOAD TIMER
	SETB	TIM_4F
WAIT3:	JB	TIM_4F,WAIT3
	RET

WAIT_E3MS:	
	MOV	TIM_4,A			;LOAD TIMER
	SETB	TIM_4F
WAITB3:	JNB	COM_ECHO,WAITE3		;EXIT IF NO ECHO
	MOV	C,TXD_D
	MOV	RXD_D,C
WAITE3:	JB	TIM_4F,WAITB3
	RET

;
;==================================================
;WAIT_3RD - THIS ROUTINE WAITS 3.3MS AND ALSO READS THE
;  MODEM STATUS REGISTER CONTINUOUSLY.  THIS WILL BE ONLY
;  USED FOR TESTING PURPOSES AND ALL CALLS TO THIS ROUTINE
;  SHOULD BE CHANGED TO WAIT_3MS
; DESTROYS -  ACC
;             TIMER 4
; CALLS - NOTHING
; EXPECTS - ACC = NUMBER OF MS TO DELAY
; RETURNS -  ABORT = 1  -  USER ABORT DURING WAIT
;            ABORT = 0  -  DELAY OK
; STACK - 4
;==================================================
;
WAIT_3RD:	
	PUSH	ACC
	PUSH	DPL
	PUSH	DPH
;	PUSH	REG_0
	MOV	TIM_4,A		;LOAD TIMER
	SETB	TIM_4F
WAIT3R:	MOV	DPTR,#RX_P	;138
	MOVX	A,@DPTR		;GET MODEM STATUS
	JB	TIM_4F,WAIT3R
;	POP	REG_0
	POP	DPH
	POP	DPL
	POP	ACC
	RET
;
WAIT_SEC:	
	CLR	ABORT
	LCALL	SET_T1
WAITS:	JB	RI,WAITS1	;BRANCH IF ABORT
	JB	TIM_1F,WAITS	;WAIT FOR TIMER TO FINISH
	RET
WAITS1:	SETB	ABORT		;USER ABORT
	CLR	RI
	RET
;
;==================================================
;ON_HOOK AND OFF_HOOK ROUTINES - THESE ROUTINES CONTROL
; THE OFFHOOK RELAY AND UPDATE ANY STATUS THAT NEEDS
; UPDATING
; DESTROYS -  ACC
;             TIMER 3
; CALLS - CTS_ON,CTS_OFF,UPDATE_IO
; EXPECTS - 
; RETURNS -  
; STACK - 2
;==================================================
;
ON_HOOK:	

	IFTRUE	V.23
	LCALL	INIT_23
	ENDIF

	SETB	OH_L
	LCALL	CTS_ON
	LCALL	UPDATE_IO
	RET

OFF_HOOK:
	
	IFTRUE	V.23
	LCALL	INIT_23
	ENDIF
	
	JNB	SYNC,OFFH1	
	LCALL	CTS_OFF			;CTS OFF AFTER OFFHOOK
OFFH1:	CLR	OH_L
	LCALL	UPDATE_IO
	RET
;
;==================================================
;CON_MSG - SEND OUT CORRECT CONNECT MESSAGE
; DESTROYS -  ACC,DPTR
; CALLS - SND_RESULT,SET_SPEED
; EXPECTS - HI_SPD TO SHOW CONNECT STATUS
;           UART IN LAST "AT" SPEED 
; RETURNS - WITH UART SETUP AT CONNECT SPEED.
; STACK - 6
;==================================================
;
CON_MSG:	
	MOV	DPTR,#JS6	;NEW MESSAGE ?
	MOVX	A,@DPTR
	ANL	A,#0FH
	JZ	NO_NEW		;ATW0
	LCALL	SND_NEW		;ATW1,W2
NO_NEW:
	IFTRUE	V.23		;149S
	MOV	DPTR,#OPT_7
	MOVX	A,@DPTR
	CJNE	A,#1,T23
	MOV	DPTR,#MSG_21
	SJMP	T2321
T23:	CJNE	A,#2,OMSG
	MOV	DPTR,#MSG_23
T2321:	LCALL	SND_RESULT
	MOV	A,#10		;WAIT FOR CHAR TO FINISH
	LCALL	WAIT_3MS
	RET
OMSG:
	ENDIF			;149T

	JB	HI_SPD2,CONM40	;BRANCH IF CONNECT 2400
	JB	HI_SPD1,CONM10	;BRANCH IF CONNECT 1200
;
;CONNECTED AT 300
;
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JNB	ACC.0,NO_CON3	;CHECK NORMAL MODE
	LCALL	CON_NORM	;SET CONNECT MESSAGE ACCORING TO UART
NO_CON3:
	MOV	DPTR,#MSG_CON
	LCALL	SND_RESULT
	MOV	A,#10		;WAIT FOR CHAR TO FINISH
	LCALL	WAIT_3MS
	SETB	HS_H		;2400 LED OFF
	CLR	BIT_12
	CLR	BIT_24
	JB	BIT_1,SPEAK3A
;	SETB	BIT_3
;	SJMP	SET_U
CONM30:	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JB	ACC.1,SET_U	;"\J" OPTION
	RET
SPEAK3A:
	LJMP	SPEAK3
SET_U:	
	LJMP	SET_UR		;SET UART FOR CONNECT SPEED
;	RET
;
;CONNECTED AT 1200
;
CONM10:	JNB	XBIT_2,CONM15	;BRANCH IF X0
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JNB	ACC.0,NO_CON12	;CHECK NORMAL MODE
	LCALL	CON_NORM	;SET CONNECT MESSAGE ACCORDING TO UART
	SJMP	CONM20
NO_CON12:
	MOV	DPTR,#MSG_12CON
	SJMP	CONM20
CONM15:	MOV	DPTR,#MSG_CON
CONM20:	LCALL	SND_RESULT	;OUTPUT TO DTE
	CLR	BIT_24
	SETB	BIT_12		;CONNECT SPEED
	SETB	HS_H		;LOW SPEED STATUS TO EIA
CONM25:	CLR	BIT_1
CONM26:	CLR	BIT_3
	MOV	A,#10		;WAIT FOR CHAR TO FINISH
	LCALL	WAIT_3MS
	SJMP	CONM30		;GO SETUP UART FOR CONNECT SPEED
;
;CONNECTED AT 2400
;
CONM40:	JNB	XBIT_2,CONM45	;BRANCH IF X0
	MOV	DPTR,#OPT_2
	MOVX	A,@DPTR
	JNB	ACC.0,NO_CON24	;CHECK NORMAL MODE
	LCALL	CON_NORM	;SET CONNECT MESSAGE ACCORING TO UART
	SJMP	CONM46
NO_CON24:
	MOV	DPTR,#MSG_24CON
	SJMP	CONM46
CONM45:	MOV	DPTR,#MSG_CON
CONM46:	LCALL	SND_RESULT
	CLR	BIT_12
	SETB	BIT_24
	CLR	HS_H		;HIGH SPEED STATUS TO EIA
	SJMP	CONM25
;
CON_NORM:
	MOV	A,PCON
	JB	ACC.7,SND_CN192
	MOV	A,TH1
	CJNE	A,#0FDH,NO_M96
	MOV	DPTR,#CN96
	SJMP	SND_OUT
NO_M96:	CJNE	A,#0FAH,NO_M48
	MOV	DPTR,#CN48
	SJMP	SND_OUT
NO_M48:	CJNE	A,#0F4H,NO_M24	
	MOV	DPTR,#MSG_24CON
	SJMP	SND_OUT
NO_M24:	CJNE	A,#0E8H,NO_M12
	MOV	DPTR,#MSG_12CON
	SJMP	SND_OUT
NO_M12:	CJNE	A,#0A0H,NO_M3
NO_M3:	MOV	DPTR,#MSG_CON
	SJMP	SND_OUT
SND_CN192:
	MOV	DPTR,#CN192
SND_OUT:
	RET
SND_NEW:
W_CAR:	
	JB	HI_SPD2,H_24	;BRANCH IF CONNECT 2400
	JB	HI_SPD1,H_12	;BRANCH IF CONNECT 1200
	MOV	DPTR,#H_40	;CARRIER 300
BB_HAY:
	LCALL	SND_RESULT
	MOV	DPTR,#H_70	;NONE PROTOCOL
	LJMP	SND_RESULT
H_24:
	MOV	DPTR,#H_47	;CARRIER 2400
	SJMP	BB_HAY
H_12:
	MOV	DPTR,#H_46	;CARRIER 1200
	SJMP	BB_HAY
;
;==================================================
;INIT_AT - LOAD THE DEFAULT S REGISTERS INTO RAM
; DESTROYS -  ACC,B,DPTR,R0,R1,R2,R3
; CALLS - NOTHING
; EXPECTS - NOTHING
; RETURNS - NOTHING
; STACK - 8
;==================================================
;
INIT_AT:
	PUSH	REG_2
	LCALL	INITA0			;LOAD DEFAULT OPT_n FROM ROM
	CLR	A
	CJNE	A,U_ST,INTAT1A		;BRANCH IF WARM CALLING
	MOV	R0,#HRST_P		;POINT TO NV RAM
	CLR	JP_004			;READ LSB
	LCALL	READ_NV			;GET HARD RESET PROFILE PARAMETER
	MOV	B,A			;SAVE &Y PARAMETER
	CLR	ACC.0
	RR	A
	CJNE	A,#EP_ID,INTAT2
	MOV	A,B
	JB	ACC.0,INTAT2A
	CLR	JP_004
	SJMP	INTAT1B			;HARD RESET 0
	
INTAT2A:
	SETB	JP_004
	SJMP	INTAT1B			;HARD RESET 1

INTAT2:	MOV	U_ST,#5			;FIRST TIME BREAK IN
	MOV	A,#EP_ID		;DEFAULT PROFILE 0
	RL	A
	MOV	R0,#HRST_P		;POINT TO NV RAM
	SETB	JP_004			;WRITE LSB
	LCALL	WRT_NV			;WRITE INITIALIZED STATUS TO NV
	LCALL	SAVENV			;WRITE DEFAULT OPTIONS INTO NV
	LCALL	BK_IN			;CLEAR TEL #
	
	MOV	R0,#HRST_P		;CHECK IF NV RAM THERE
	CLR	JP_004
	LCALL	READ_NV
	RR	A
	CJNE	A,#EP_ID,INIAT4		
	SJMP	INTAT1B

INTAT1A:				;ATZ CALLING
	CLR	JP_004			;Z0
	LCALL	GET_PARAM			;GET PROFILE PARAMETER
	JB	PASS,INTAT1B
	SETB	JP_004			;Z1
INTAT1B:				;PF 
	LCALL	LOADNV			;LOAD NV RAM OPTIONS
;	SETB	EXT_LATCH
;	SJMP	INIAT3
INIAT4:					;no nv
;	CLR	EXT_LATCH
INIAT3:
	POP	REG_2
	MOV	A,R2
;12-17-89
	ANL	S23,#11000001B
;--------
	ORL	S23,A			;UPDATE WITH PREVIOUS PARITY
;====================
;INIT ALL FLAGS
;====================	
	CLR	A	
	MOV	DPTR,#OPT_6		;RESET OPT_6
	MOVX	@DPTR,A
	MOV	DPTR,#OPT_7		;RESET OPT_7
	MOVX	@DPTR,A	
	CLR	DATA_BIT
;	CLR	SPEAK_BIT	
	CLR	RET_BIT
;	CLR	LEASED_L		;140 DISABLE LEASED LINE

;--------------------------------------- INIT JCM REGISTERS
	IFTRUE JCM
	MOV	R0,#00H
	MOV	DPTR,#JS0
INI_JS:
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#JS_DEF
	MOV	A,R0
	MOVC	A,@A+DPTR
	POP	DPL
	POP	DPH
	MOVX	@DPTR,A
	INC	DPTR
	INC	R0
	CJNE	R0,#20H,INI_JS	
	ENDIF

;--------------------------------------- INIT EXTEND S REGISTERS
	IFTRUE	MICROCOM
	MOV	DPTR,#S36		;150S
	MOV	A,#5
	MOVX	@DPTR,A
	
	MOV	DPTR,#S46
	MOV	A,#2
	MOVX	@DPTR,A
	
	MOV	DPTR,#S48
	MOV	A,#7
	MOVX	@DPTR,A
	
	MOV	DPTR,#S82
	MOV	A,#128
	MOVX	@DPTR,A			;150T
	ENDIF
;
;INIT SPEAKER VOLUME OPTION
;
	PUSH	RAM22H
	MOV	A,S22
	ANL	A,#03
	CJNE	A,#02,SPKC00
	MOV	RAM22H,A
	SJMP	SPKCNT
SPKC00:	JC	SPKC01
	MOV	RAM22H,#03
	SJMP	SPKCNT
SPKC01:	MOV	RAM22H,#0
SPKCNT:
;AAA	LCALL	UPDAT_SPK		
	POP	RAM22H
	
;
;INIT DTR OPTION
;
	CLR	IGNORE_DTR
	JB	DTR_OP1,INITAA
	JB	DTR_OP2,INITAA
	SETB	IGNORE_DTR
INITAA:	
;====================
; LED & LATCH CONTROL
;====================	
	MOV	RAM2FH,#FFH
	CLR	M_READY			;MODEM READY LED ON
	CLR	HS_H			;HI SPEED ON
	LCALL	SET_AA_BIT		;INIT AUTO ANSWER LED STATUS
;
;INIT CXR SIGNAL PER OPTION
;
INTCX0:	JNB	CXR_NORM,INTCX1
	LCALL	CXR_OFF			;&C1
	SJMP	INTDS0
INTCX1:	CLR	CXR_L			;&C0 FORCE CXR ON TO EIA ONLY
	LCALL	UPDATE_IO
;
;INIT DSR SIGNAL PER OPTION
;
INTDS0:	JNB	DSR_NORM,INTDS1
	LCALL	DSR_OFF			
	SJMP	INTCT0
INTDS1:	LCALL	DSR_ON			;DSR FORCED ON
;
;INIT SYNC FLAGS
;
INTSY0:	
	CLR	SYNC

	IFFALSE	INTERNAL

	JB	ASYN_1,INTSY1
	JB	ASYN_2,INTSY1
	SJMP	INTCT0
INTSY1:	SETB	SYNC

	ENDIF
;
;INIT CTS SIGNAL PER OPTION
;
INTCT0:	CALL	INI_CTS			;121

	IFTRUE	FAX
;==================================================
; INIT_FAX
;==================================================
;
INIT_FAX:
	MOV	DPTR,#FAX_SPD	;SET FAX SPEED 
	MOV	A,#7		;SET 9600BPS
	MOVX	@DPTR,A

	MOV	DPTR,#OPT_FAX
	MOV	A,#0
	MOVX	@DPTR,A

	MOV	DPTR,#DEBUG_F
;	MOV	A,#0
	MOVX	@DPTR,A

	MOV	DPTR,#DEBUG_S
;	MOV	A,#0
	MOVX	@DPTR,A

	MOV	DPTR,#SET_MPS
	MOV	A,#1
	MOVX	@DPTR,A
	ENDIF

	IFTRUE	V.23
	CLR	V21_SPD
	CLR	V23_SPD
	ENDIF

	RET				;300 READY TO GO

	
INI_CTS:				;121S
	LCALL	CTS_OFF
	JNB	SYNC,INTCT3		;150S
	JB	CTS_OPT,INTCT2
INTCT3:	MOV	DPTR,#OPT_8
	MOVX	A,@DPTR
	JB	ACC.5,INTCT2		;150T
INTCT1:	LCALL	CTS_N1			;CXR FORCED ON FOR ASYNC OR COMMAND
INTCT2:	RET				;121T

;==================================================
;BK_IN - CLEAR TEL MEMORY
;	INITIAL = TADD0 
; DESTROYS -  ACC,R0
; CALLS - WRT_NV0
; EXPECTS - NOTHING
; RETURNS - 
; STACK - 1
;==================================================
;
BK_IN:
	MOV	R0,#TADD0
BK1:	MOV	A,#FEH
	MOV	B,#FFH
	LCALL	WRT_NV0			;WRITE INITIALIZED STATUS TO NV
	INC	R0
	CJNE	R0,#(MAX_NV_ADD+1),BK1
	RET
;
;==================================================
;INIT_A0 - LOAD THE DEFAULT S REGISTERS INTO RAM
; DESTROYS -  ACC,DPTR,R0,R1,R2,R3
; CALLS - NOTHING
; EXPECTS - NOTHING
; RETURNS - ALL S REGISTERS LOADED WITH FACTORY DEFAULT
; STACK - 1
;==================================================
;
INITA0:	MOV	R0,#00H			;INIT ROM OPTION POINTER
	MOV	R2,S23
	ANL	REG_2,#3EH		;SAVE PARITY AND SPEED STATUS
INITA1:	MOV	DPTR,#AT_DEF
	MOV	A,R0
	MOVC	A,@A+DPTR		;GET OPTION FROM ROM
	PUSH	ACC
	MOV	DPTR,#AT_POINT
	MOV	A,R0
	MOVC	A,@A+DPTR		;GET POINTER TO CORRECT REGSITER
	JNZ	INITA2			;BRANCH IF REGISTER NOT USED
	POP	ACC
	SJMP	INITA3
INITA2:	MOV	R1,A			
	POP	ACC			;RETRIEVE VALUE
	MOV	@R1,A			;STORE TO REGISTER
INITA3:	INC	R0
	CJNE	R0,#28,INITA1		;FINISH RESET OF REGISTERS
;
	MOV	DPTR,#OPT_0
	MOV	R0,#00H
INI_OPT:
	PUSH	DPH
	PUSH	DPL
	MOV	DPTR,#OPT_DEF
	MOV	A,R0
	MOVC	A,@A+DPTR
	POP	DPL
	POP	DPH
	MOVX	@DPTR,A
	INC	DPTR
	INC	R0
	CJNE	R0,#9,INI_OPT	
	MOV	DPTR,#CB_BUFF	;RESET \C1,\C2 COUNTER
	CLR	A
	MOVX	@DPTR,A
SET_OPT:
	MOV	A,#8H
	MOV	DPTR,#OPT_C
	MOVX	@DPTR,A
	MOV	A,#23H
	MOV	DPTR,#OPT_D
	MOVX	@DPTR,A
	RET
;
;==================================================
;IS_VALID - IS THE CHARACTER IN THE ACC A VALID DIAL CHAR OR MODIFIER
; DESTROYS -  ACC,DPTR
; CALLS - NOTHING
; EXPECTS - ACC = DIGIT TO DIAL
; RETURNS - ACC = DIGIT TO DIAL
;           PASS = 1 IF VALID DIAL DIGIT
; STACK - 1
;==================================================
;
IS_VALID:
	MOV	DPTR,#VALID_D	;POINT TO VALID DIGIT TABLE
IS_VA:	CLR	PASS
	PUSH	REG_0
IS_V4:	MOV	R0,A		;SAVE DIGIT TO COMPARE
IS_V1:	CLR	A
	MOVC	A,@A+DPTR	;GET CHAR
	CJNE	A,#0FFH,IS_V2
	SJMP	IS_V5		;CHAR NOT FOUND IN TABLE
IS_V2:	CJNE	A,REG_0,IS_V3
	SETB	PASS
IS_V5:	MOV	A,REG_0		;RESTORE ACCUMULATOR
	POP	REG_0
	RET
IS_V3:	INC	DPTR
	SJMP	IS_V1
;
;==================================================	;103DS
;SYNC_DIAL - DIAL STORED NUMBER IN SYNC MODE
;==================================================
;
;SYNC_DIAL:
;	LCALL	OFF_HOOK	;GO OFF HOOK TO DIAL
;	SETB	ORG_BIT
;	LCALL	SPEAK_ON
;	MOV	A,S6
;	LCALL	WAIT_SEC	;WAIT S6 SECONDS		
;	LJMP	AT_D05		;FETCH STORED NUMBER AND DIAL	
;	LJMP	AT_D0Z		;CHECK DIALTONE, FETCH NUMBER AND DIAL
;				;103DT
;==================================================
;UPDATE I/O - OUTPUT EIA STATUS BITS TO EXTERNAL 8 BIT PARALLEL
;  PORT OR INTERNAL PORT 2 IF OPTIONED
;==================================================
;
UPDATE_IO:
	PUSH	DPL
	PUSH	DPH
	PUSH	ACC
	MOV	DPTR,#LATCH
UPIO3:	MOV	A,RAM2FH
	MOVX	@DPTR,A		;OUTPUT
	POP	ACC
	POP	DPH
	POP	DPL
	RET

SET_AA_BIT:
	SETB	AA_BIT			;AA LED OFF
	MOV	A,S0
	JZ	SSAABB
	CLR	AA_BIT			;AUTO ANSWER LED ON
SSAABB:	RET

;==================================================
;S REGISTER DEFAULT TABLE
;==================================================
;
AT_DEF:	DB	0		;S0 - RINGS TO ANSWER
	DB	0		;S1 - RING IN COUNTER
	DB	43		;S2 - ESCAPE CHAR
	DB	13		;S3 - CARRIAGE RETURN CHAR
	DB	10		;S4 - LINE FEED CHAR
	DB	8		;S5 - BACKSPACE CHAR
	DB	2		;S6 - DIAL TONE WAIT CHAR
	DB	30		;S7 - WAIT FOR CARRIER
	DB	2		;S8 - COMMA PAUSE TIME
	DB	6		;S9 - CARRIER DETECT RESPONSE
	DB	14		;S10 - CARRIER LOSS RESPONSE
	DB	95		;S11 - TOUCH TONE TIMING
	DB	50		;S12 - ESCAPE CODE GAURD TIME
	DB	0		;S13 - BIT MAPPED REGISTER
	DB	0AAH		;S14 - BIT MAPPED REGISTER
	DB	59		;S15 - BIT MAPPED REGISTER
	DB	0		;S16 - TEST REGISTER
	DB	0		;S17 - RESERVED
	DB	0		;S18 - TEST TIMER
	DB	0		;S19 - RESERVED
	DB	0		;S20 - RESERVED
	DB	00H		;S21 - BIT MAPPED
	DB	76H		;S22 - BIT MAPPED
	DB	07H		;S23 - BIT MAPPED
	DB	0		;S24 - RESERVED
	DB	5		;S25 - DTR DELAY
	DB	1		;S26 - RTS/CTS DELAY
	DB	40H		;S27 - BIT MAPPED REGISTER
;
;==================================================
;S REGISTER POINTER TABLE
;==================================================
;
AT_POINT:
	DB	S0		;* S0 - RINGS TO ANSWER
	DB	S1		;  S1 - RING IN COUNTER
	DB	S2		;  S2 - ESCAPE CHAR
	DB	S3		;  S3 - CARRIAGE RETURN CHAR
	DB	S4		;  S4 - LINE FEED CHAR
	DB	S5		;  S5 - BACKSPACE CHAR
	DB	S6		;  S6 - DIAL TONE WAIT CHAR
	DB	S7		;  S7 - WAIT FOR CARRIER
	DB	S8		;  S8 - COMMA PAUSE TIME
	DB	S9		;  S9 - CARRIER DETECT RESPONSE
	DB	S10		;  S10 - CARRIER LOSS RESPONSE
	DB	S11		;  S11 - TOUCH TONE TIMING
	DB	S12		;  S12 - ESCAPE CODE GAURD TIME
	DB	S13		;  S13 - BIT MAPPED REGISTER
	DB	S14		;* S14 - BIT MAPPED REGISTER
	DB	S15		;  S15 - BIT MAPPED REGISTER
	DB	S16		;  S16 - TEST REGISTER
	DB	S17		;  S17 - RESERVED
	DB	S18		;* S18 - TEST TIMER
	DB	S19		;  S19 - RESERVED
	DB	S20		;  S20 - RESERVED
	DB	S21		;* S21 - BIT MAPPED
	DB	S22		;* S22 - BIT MAPPED
	DB	S23		;* S23 - BIT MAPPED
	DB	S24		;  S24 - RESERVED
	DB	S25		;* S25 - DTR DELAY
	DB	S26		;* S26 - RTS/CTS DELAY
	DB	S27		;* S27 - BIT MAPPED REGISTER
;==================================================
; MNP OPTION REGISTER DEFAULT TABLE
;==================================================
;
OPT_DEF:
	IFFALSE	MICROCOM
	DB	0		;OPT_0
	DB	5		;OPT_1
	
	IFTRUE	NSP
	DB	080H		;116S 
	ENDIF
	
	IFFALSE	NSP
	DB	081H	
	ENDIF			;116T
	
	ENDIF

	IFTRUE	MICROCOM
	DB	2		;OPT_0
	DB	5		;OPT_1
	DB	081H		;OPT_2
	ENDIF

	DB	3		;OPT_3
	DB	3		;OPT_4
	DB	3		;OPT_5
	DB	1		;OPT_8
	DB	0		;OPT_9
	DB	0		;OPT_A
;
	IFTRUE	JCM
JS_DEF:
	DB	0		;JS0
	DB	1		;JS1
	DB	0		;JS2
	DB	0		;JS3
;	DB	40H		;JS3
	DB	7		;JS4
	DB	0		;JS5
	DB	0		;JS6
	DB	0		;JS7
	DB	0		;JS8
	DB	0		;JS9
	DB	0		;JS10
	DB	0		;JS11
	DB	0		;JS12
	DB	0		;JS13
	DB	0		;JS14
	DB	0		;JS15
	DB	0		;JS16
	DB	0		;JS17
	DB	0		;JS18
	DB	0		;JS19
	DB	0		;JS20
	DB	0		;JS21
	DB	0		;JS22
	DB	0		;JS23
	DB	0		;JS24
	DB	0		;JS25
	DB	0		;JS26
	DB	0		;JS27
	DB	0		;JS28
	DB	0		;JS29
	DB	0		;JS30
	DB	0		;JS31
	ENDIF
;============================================================
; VALID DIAL DIGITS
;============================================================
;
VALID_1D:	
	DB	'S'
VALID_D:	
	DB	'0'
	DB	'1'
	DB	'2'
	DB	'3'
	DB	'4'
	DB	'5'	
	DB	'6'
	DB	'7'
	DB	'8'
	DB	'9'
	DB	'A'
	DB	'B'
	DB	'C'
	DB	'D'
	DB	'*'
	DB	'#'
	DB	'W'
	DB	'P'
	DB	'T'
	DB	'R'
	DB	'@'
	DB	'!'
	DB	';'
	DB	','
	DB	'/'
	DB	0FFH
;
	IFTRUE	FAX
;4-26-90 -- FOR FAX ID DIGITS
VALID_ID:	
	DB	'0'
	DB	'1'
	DB	'2'
	DB	'3'
	DB	'4'
	DB	'5'	
	DB	'6'
	DB	'7'
	DB	'8'
	DB	'9'
	DB	'+'
	DB	' '
	DB	'"'
	DB	0FFH
	ENDIF
;
;==================================================
;TOUCH TONE DIGITS
;==================================================
;
TONE_TAB:
	DB	07H	;'0'
	DB	00H	;'1
	DB	04H	;'2'
	DB	08H	;'3'
	DB	01H	;'4'
	DB	05H	;'5
	DB	09H	;'6'
	DB	02H	;'7'
	DB	06H	;'8'
	DB	0AH	;'9
	DB	0CH	;'A'
	DB	0DH	;'B'
	DB	0EH	;'C'
	DB	0FH	;'D
	DB	03H	;'*'
	DB	0BH	;'#'
	DB	0FFH
;
;==================================================
;AT MESSAGES
;==================================================
;
MSG_OK:		DB	'0 OK',0FFH
MSG_CON:	DB	'1 CONNECT',0FFH
MSG_RING:	DB	'2 RING',0FFH
MSG_NCAR:	DB	'3 NO CARRIER',0FFH
MSG_ERR:	DB	'4 ERROR',0FFH
MSG_12CON:	DB	'5 CONNECT 1200',0FFH
MSG_NODT:	DB	'6 NO DIALTONE',0FFH
MSG_BUSY:	DB	'7 BUSY',0FFH
MSG_NANS:	DB	'8 NO ANSWER',0FFH
MSG_24CON:	DB	'10 CONNECT 2400',0FFH
MSG_21:		DB	'30 CONNECT V.21',0FFH
MSG_23:		DB	'31 CONNECT V.23',0FFH
MSG_ID0:	DB	'240',0FFH
MSG_ID1:	DB	'231',0FFH
MSG_READ:	DB	'MSG_READ',0FFH
MSG_SYS:	
		DB	0DH,0AH,0DH,0AH,'EXAR 2'
	IFTRUE	X2400
		DB	'4'
	ENDIF
	IFFALSE	X2400
		DB	'9'
	ENDIF
	IFTRUE	V42ONLY
		DB	'42',0DH,0AH,0DH,0AH,'     V.42',0DH,0AH
	ENDIF
	IFTRUE	V42BIS
		DB	'43',0DH,0AH,0DH,0AH,'     V.42BIS',0DH,0AH
	ENDIF
	
	IFFALSE	V42ONLY
	IFFALSE	V42BIS
	IFFALSE	NSP
		DB	'0S',0DH,0AH,0DH,0AH
	ENDIF
	IFTRUE	NSP
		DB	'00',0DH,0AH,0DH,0AH
	ENDIF
	ENDIF
	ENDIF
	
	IFTRUE	NSP
		DB	'     NO SPEEDCONVERSION',0DH,0AH
	ENDIF
	IFTRUE	MICROCOM
		DB	'     MNP 5',0DH,0AH
	ENDIF
	IFTRUE	FAX
		DB	'     TR-29 / T.30',0DH,0AH
	ENDIF
	IFTRUE	V.23
		DB	'     V.2321',0DH,0AH
	ENDIF
	IFTRUE	REMOTE
		DB	'     REMOTE ACCESS',0DH,0AH
	ENDIF
	IFTRUE	JCM
		DB	'     JCM  0'
	IFTRUE	JCM_1
		DB	', 1'
	ENDIF
	IFTRUE	JCM_2
		DB	', 2'
	ENDIF
	IFTRUE	JCM_3
		DB	', 3'
	ENDIF
	IFTRUE	JCM_4
		DB	', 4'
	ENDIF
		DB	0DH,0AH
	ENDIF
		DB	0FFH

H_70:		DB	'70 PROTOCOL: NONE',0FFH
H_40:		DB	'40 CARRIER 300',0FFH
H_46:		DB	'46 CARRIER 1200',0FFH
H_47:		DB	'47 CARRIER 2400',0FFH
CN48:		DB	'11 CONNECT 4800',0FFH
CN96:		DB	'12 CONNECT 9600',0FFH
CN192:		DB	'14 CONNECT 19200',0FFH
;
;==========================================
;	COUNTRY CODE SPECIAL COMMAND
;==========================================
;
ATU_I:
	LCALL	FETCH
	CJNE	A,#'B',ATU_OUT
	LCALL	FETCH
	CJNE	A,#'M',ATU_OUT
	LCALL	FETCH
	CJNE	A,#'C',ATU_OUT		;AT_IBMCC
	LCALL	FETCH
	CJNE	A,#'C',ATU_OUT
	LCALL	GET_PARAM
	CJNE	A,#22D,CHK_USA		;JAPAN DEFAULT
	LCALL	SET_JAP
	LJMP	AT_000
CHK_USA:
	LCALL	SET_USA			;USA DEFAULT
	LJMP	AT_000
ATU_OUT:
	LJMP	AT_001	
SET_USA:
	MOV	S6,#2		;SET 	USA DEFAULT
	SETB	BELL212
	SETB	PUL_RATIO
	RET
SET_JAP:   			;SET JAPAN DEFAULT
	MOV	S6,#3
	CLR	BELL212
	CLR	PUL_RATIO
	RET

	END
