        list    ON
;
;	014_092791A
;       RSECT
;
; FROM MOD2.ASM
        EXTERNAL        JS1,JS2,REG_0
;
; FROM MOD5.ASM
;
        EXTERNAL        OFF_HOOK,ON_HOOK
        EXTERNAL        GET_PARAM,WAIT_SEC,WAIT_3MS
        EXTERNAL        SND_HEX,V_CRLF
        EXTERNAL        SND_MSG,PUT_CHAR
        EXTERNAL        SND_OK,AT_000
        EXTERNAL        SND_RESULT
;       EXTERNAL        CTS_ON,CTS_OFF
        EXTERNAL        SET_ID,RESET_ID,AT_ERR,FETCH,PASS,BUF_CHARS
        EXTERNAL        POINTER,MSG_OK,MSG_ERR,S_CRLF
        EXTERNAL        AT_OK,IS_VA,VALID_ID,S3,JP_004
; FROM MOD1.ASM
        EXTERNAL        PUT_DATA
        EXTERNAL        LATCH           ;9-3-91
;
; FROM WMOD.ASM
;
        EXTERNAL        RD0_CNTL,WR0_CNTL,RD1_CNTL,WR1_CNTL
        EXTERNAL        SET_B96,SET_B72,SET_B48,SET_B24
        EXTERNAL        SET_DMF,SET_TMOD,SET_V21
        EXTERNAL        SET_PDM,SET_RTS,CLR_RTS
        EXTERNAL        SET_RAMW,CLR_RAMW,R_PDATA,W_PDATA
        EXTERNAL        CHK_MDA0,R_FREQ,CHK_MDAB
;506S
        EXTERNAL        W_MEMORY,RD_INT,W_MEMORYA,SPEAK_1,SPEAK_2
        EXTERNAL        SET_NTXD,CLR_NTXD
        EXTERNAL        R_FED,ANS_DET,RD_DCD
        EXTERNAL        DISCONNECT,CHK_AGC,RD_PNDET,SET_RGAIN
;506S
        EXTERNAL        RD_MODSEL,SPEAK_ON,SPEAK_OFF
;506T
;
;
; FROM SPDT.ASM
;
        EXTERNAL        SPDT,INI_SPDFT, LOST_DTR
;
        GLOBAL          ATF_T,ATF_F,ATF_R
        GLOBAL          ATF_B,ATF_J,ATF_P
        GLOBAL          ATF_I,ATF_E
        GLOBAL          ATF_A
        GLOBAL          FAX_ANS,FAX_CALL
        GLOBAL          ATF_LID0,FD_CSIS,FD_CSIA,FAXD_INIT
        GLOBAL          ATF_AA,ATF_CLASS0,ATF_CLASS1,FD_CSIS,FD_CSIA,FAXD_INIT
        GLOBAL          ATF_CR,ATF_SESS,ATF_SESS1,ATF_BOR,ATF_MINSP0,ATF_MINSP1
        GLOBAL          ATF_BUG0,ATF_BUG1,ATF_HPS0,MSG_MDL,MSG_MFR
        GLOBAL          CTSOFF,CTSON
;
        RSECT
;
        ORG     08H             ;
;
TIM_1:          DS      1       ;TIMER 1 DOWN COUNTER
TIM_1P:         DS      1       ;TIMER 1 PRESCALAR
TIM_2:          DS      1       ;TIMER 2 DOWN COUNTER
TIM_2P:         DS      1       ;TIMER 2 PRESCALAR
TIM_3:          DS      1       ;TIMER 3 DOWN COUNTER
TIM_3P:         DS      1       ;TIMER 3 PRESCALAR
TIM_4:          DS      1       ;TIMER 4 DOWN COUNTER
TIM_5:          DS      1       ;TIMER 5 DOWN COUNTER
TIM_5P:         DS      1       ;TIMER 5 PRESCALAR
TIM_6:          DS      1       ;TIMER 6 DOWN COUNTER
TIM_6P:         DS      1       ;TIMER 6 PRESCALAR
TIM_7:          DS      1       ;TIMER 7 DOWN COUNTER
TIM_7P:         DS      1       ;TIMER 7 PRESCALAR
TIM_8:          DS      1       ;TIMER 8 DOWN COUNTER
TIM_8P:         DS      1       ;TIMER 8 PRESCALAR
;

;       RSECT
;
        ORG     30H
;
; TRANSMITTER MEMORY ALLOCATION
;
OUTPUT_B:       DS      1       ;TRANSMIT DATA
OUTBT:  DS      1       ;TRANSMIT DATA AFTER ZERO INSERTION
BITC:   DS      1       ;BIT COUNT FOR OUTPUT_B
BTCNT:  DS      1       ;BIT COUNT FOR OUTBT
BCOUNT: DS      1       ;BYTE COUNT FOR TRANSMIT DATA
ZERO:   DS      1       ;1'S COUNTER FOR ZERO INSERTION
STATUS: DS      1       ;TRANSMIT DATA STATUS
DCETPL: DS      1       ;TRANSMIT DATA ADDRESS(LOW BYTE)
DCETPH: DS      1       ;TRANSMIT DATA ADDRESS(HIGH BYTE)
FLG_CNT:        DS      1       ;PREAMBLE COUNTER
TRY_CNT:        DS      1       ;COUNTER FOR TRY CONNECTION
;
; RECEIVER MEMORY ALLOCATION
;
RXTEMP: DS      1       ;RXDATA FROM MODEM
BUFF:   DS      1       ;TEMP BUFFER FOR RXDATA
BICNT:  DS      1       ;BIT COUNTER FOR INPUT_B
BIRCNT: DS      1       ;BIT COUNTER FOR INCOMING RXDATA
BYCNT:  DS      1       ;RXDATA BYTE COUNTER
DCERPL: DS      1       ;RXDATA ADDRESS(LOW BYTE)
DCERPH: DS      1       ;RXDATA ADDRESS (HIGH BYTE)
INPUT_B:        DS      1       ;FINAL RXDATA
INPUT_B1:       DS      1
INPUT_B2:       DS      1
ER_ST:  DS      1
MDINH:  DS      1
MDINL:  DS      1
FRAME_CNT       DS      1       ;RECEIVE FRAME COUNTER
TMPDPL  DS      1
TMPDPH  DS      1
DIS_CNT DS      1
INF_DAT DS      1       ;RECEIVE INFORMATION BYTE
FAM_CNT DS      1
FAX_S0  DS      1       ; 1ST BYTE OF RECEIVED FIF OF HDLC
FAX_S1  DS      1       ;STORE REMOTE SIDE CONTROL BYTE
FAX_S2  DS      1       ;STORE REMOTE SIDE CONTROL BYTE
FAX_S3  DS      1       ; 4TH BYTE OF RECEIVED FIF OF HDLC
FAX_S4  DS      1       ; 5TH BYTE OF RECEIVED FIF OF HDLC
FAX_SA  DS      1       ; T.30 TABLE 3 BIT MAP
FAX_SB  DS      1       ; T.30 TABLE 3 BIT MAP
;
CRCH    DS      1
TEMP_C  DS      1
TEMP_B  DS      1
CRCL    DS      1
;504S
T_R5:
DCS_TMP:
FTT_CNT:        DS      1       ;DAVID 3-15-91 FOR FTT
NSF_TMPB:  DS      1       ;7-10-91TEMP RXDATA BYTE COUNTER SPECIAL FOR NSF FRAME
NSF_BYCNT:  DS      1       ;RXDATA BYTE COUNTER SPECIAL FOR NSF FRAME
;504T
;
FSPD    EQU     9400H   ;PUT IN R4 FOR FAX SPEED SELECTION
DEBUG_F EQU     9401H   ;DEBUG MODE FLAG
SET_MPS EQU     9402H   ;MPS NUMBER
FAX_SPD EQU     9403H   ;FAX REQUEST CONNECT SPEED
OPT_FAX EQU     9404H   ;FAX MODE CONTROL REGISTER
                        ; BIT 0 --
                        ;       0: +FCLASS=0    1: +FCLASS=2
                        ; BIT 1 --
                        ;       0: +FAA=0       1: +FAA=1
                        ; BIT 2 --
                        ;       0: +FCR=0       1: +FCR=1
                        ; BIT 3 --
                        ;       0: +FBOR=0      1: +FBOR=1
                        ; BIT 4 --
                        ;       0: +FBUG=0      1: +FBUG=1
                        ; BIT 5 -- +FPL
                        ; BIT 6 -- +SPL
DEBUG_S EQU     9405H   ;DEBUG MODE FOR SEND DATA
;
; BIT0 : FAX/DATA MODE
; BIT1 : FINE/NORMAL RESOLUTION CONTROL
;
AFTER_S REG     22H.0   ;AFTER SYN FLAG DETECTED
DCE_S   REG     22H.1   ;FINISH ALL FRAME FLAG
NEED_D  REG     22H.2
FIN_FR  REG     22H.3   ;LAST FRAME FLAG
B_MPS   REG     22H.4   ;MPS INDICATION
;
AFT_SYN REG     23H.0
AFT_FR  REG     23H.1
NEED_DR REG     23H.2   ;NEED MORE DATA
B_RTNP  REG     23H.3

R_READY REG     23H.4   ;RXDATA READY
RCV_DF  REG     23H.5
DCE_L   REG     23H.6
GOT_FRM REG     23H.7

RAM28H          EQU     28H     ;MISC "AT" STATUS BITS
;
TIM_1PF         REG     28H.0   ;TIMER 1 PRESCALAR
TIM_6PF         REG     28H.1   ;TIMER 6 PRESCALAR
;
;DATA COM BITS AND GENERAL PURPOSE BITS AND FLAGS
;
RAM2AH          EQU     2AH             ;THIS REGISTER HOLDS THE FLAGS
;
TIM_1F          REG     2AH.0   ;TIMER 1 FLAG
TIM_2F          REG     2AH.1   ;TIMER 2 FLAG
TIM_3F          REG     2AH.2   ;TIMER 3 FLAG
TIM_4F          REG     2AH.3   ;TIMER 4 FLAG
TIM_5F          REG     2AH.4   ;TIMER 5 FLAG
TIM_6F          REG     2AH.5   ;TIMER 6 FLAG
TIM_7F          REG     2AH.6   ;TIMER 7 FLAG
TIM_8F          REG     2AH.7   ;TIMER 8 FLAG
;
NULL    EQU     0
ONE     EQU     1
SYN_FLG EQU     7EH
MEOP    EQU     9500H
RV_1ST  EQU     9100H
;
EIA     EQU     2FH
EIACTS  REG     2FH.0
EIACXR  REG     2FH.7


;9-3-91        INCLUDE DCETYPE.ASM
;9-3-91        INCLUDE JCM.ASM
;9-3-91
;9-3-91        .ifntrue        ( SA2400 )
;9-3-91
;9-3-91LATCH1  EQU     0400BH
;9-3-91;LATCH1 EQU     F000H
;9-3-91        .else
;9-3-91LATCH1  EQU     0200BH
;9-3-91;LATCH1 EQU     20FFH
;9-3-91        .endif
;9-3-91

;       INCLUDE DCETYPE.ASM
SA2400  EQU     0
PC      EQU     1

;       INCLUDE JCM.ASM

JCM     EQU     1
JCM_1   EQU     0
JCM_2   EQU     0
JCM_3   EQU     1
JCM_4   EQU     0

        .ifntrue        ( SA2400 )

;LATCH1  EQU     0400BH
;LATCH1 EQU     F000H
        .else
;LATCH1  EQU     0200BH
;LATCH1 EQU     20FFH
        .endif

;9-3-91
;
;BUFFER FOR SEND TO LINE
FD_DCS  EQU     9500H
FD_DIS  EQU     FD_DCS+8H
FD_CSIA EQU     FD_DIS+8H
FD_CSIS EQU     FD_CSIA+24
FD_TMP  EQU     FD_CSIS+24
FD_SESS EQU     FD_TMP+4        ; CURRENT T.30 SESSION PARAMETER RAM
FD_MINSP EQU    FD_SESS+8       ; T.30 PAASE C NEGOIATION MINIMUM SPEED
;
DCS_SPD EQU     FD_DCS+5H
DIS_SPD EQU     FD_DIS+5H
;
SAV_RAM EQU     9200H
;
; FAX COMMUNICATION CONTROL WORD
;
F_CRP   EQU     1AH     ;COMMAND REPEAT
F_NSF   EQU     20H     ;NON-STANDARD FACILITIES
F_NSC   EQU     22H     ;NON-STANDARD FACILITIES SETUP
F_PIN   EQU     2CH     ;PROCEDURE INTERRUPT NEGATIVE
;501S
F_EOP   EQU     2FH     ;END OF PROCEDURE
F_EOP_X EQU     2EH     ;END OF PROCEDURE
;501T
F_CSI   EQU     40H     ;CALLED SUBSCRIBER IDENTIFICATION
;DAVID F_TSI   EQU     42H     ;TRANSMITTING SUBSCRIBER IDENTIFICATION
F_TSI   EQU     43H     ;TRANSMITTING SUBSCRIBER IDENTIFICATION
F_FTT   EQU     44H     ;FAILURE TO TRAIN
F_RTN   EQU     4CH     ;RETRAIN NEGATIVE
;501S
F_MPS   EQU     4FH     ;MULTIPAGE SIGNAL
F_MPS_X EQU     4EH     ;MULTIPAGE SIGNAL
;501T
F_DIS   EQU     80H     ;DIGITAL IDENTIFICATION SIGNAL
F_DTC   EQU     81H     ;DIGITAL TRANSMIT COMMAND
;DAVID F_DCS   EQU     82H     ;DIGIAL COMMAND SIGNAL
F_DCS   EQU     83H     ;DIGIAL COMMAND SIGNAL
F_CFR   EQU     84H     ;CONFIRM TO RECEIVE
F_MCF   EQU     8CH     ;MESSAGE CONFIRMATION
F_EOM   EQU     8EH     ;END OF MESSAGE
F_PIP   EQU     0ACH    ;PROCEDURE INTERRUPT POSITIVE
F_RTP   EQU     0CCH    ;RETRAIN POSITIVE
;501S
F_DCN   EQU     0FBH    ;DISCONNECT
;501T
CTL_F   EQU     013H    ;CONTROL FIELD
FF_CTL_F   EQU     013H    ;FINAL FRAME CONTROL FIELD
NFF_CTL_F   EQU     03H    ;NON-FINAL FRAME CONTROL FIELD
LCCT    EQU     020H    ;LOST CARRIER COUNT
;
        EJECT
        CODE
;
;
;=============================================================
;
; AT+FAA= COMMAND: AUTO ANSWER FOR DATA&FAX
;               ( AUTO SWITCH FROM DATA TO FAX )
;
; PARAMETERS: 0 - NON-AA MODE, OPT_FAX.1 = 0,
;             1 -  AA, OPT_FAX.1 = 1
;=============================================================
ATF_AA:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        CLR     ACC.1
        JB      PASS,ATF_AA0
        SETB    ACC.1
ATF_AA0:
        MOVX    @DPTR,A
        LJMP    AT_000
;
;=============================================================
;
; AT+FBOR= COMMAND: DATA BIT ORDER
;
; PARAMETERS: 0 - SMAE BIT ORDER, OPT_FAX.3 = 0,
;             1 - REVERSE BIT ORDER, OPT_FAX.3 = 1
;=============================================================
ATF_BOR:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        CLR     ACC.3
        JB      PASS,ATF_BR0
        SETB    ACC.3
ATF_BR0:
        MOVX    @DPTR,A
        LJMP    AT_000
;
;=============================================================
;
; AT+FBUG= COMMAND: SESSION MSG REPORTING
;
; PARAMETERS: 0 - OK
;             1 - ERROR
;=============================================================
ATF_BUG0:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
;
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        CLR     ACC.4           ;12-18
        JB      PASS,ATF_BU0A   ;JUMP IF 0
        SETB    ACC.4           ;12-18
ATF_BU0A:
        MOVX    @DPTR,A         ;12-18
        LJMP    AT_000
;
;=============================================================
;
; AT+FBUG? COMMAND: INQUIRE SESSION MSG REPORTING
;
; PARAMETERS: 0 - DISABLE HDLC REPORTING
;             1 - DISABLE HDLC REPORTING
;=============================================================
;
;12-18-90ATF_BUG1:
;       MOV     DPTR,#MSG_VAL0;
;       LCALL   SND_MSG         ; W/O <CR>
;       LJMP    AT_000
ATF_BUG1:
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        MOV     DPTR,#MSG_VAL0; ;12-18
        JNB     ACC.4,ATF_BU1A  ;12-18
        MOV     DPTR,#MSG_VAL1; ;12-18
ATF_BU1A:                       ;12-18
        LCALL   SND_MSG         ;12-18 W/O <CR>
        LJMP    AT_000          ;12-18
;
;
;
;=============================================================
;
;AT+FCLASS= COMMAND: FAX/DATA MODEM SELECTION
;
; PARAMETERS: 0 - DATA MODE, OPT_FAX.0 = 0,
;             1 - ERROR
;             2 - FAX MODE, OPT_FAX.0 = 1
;             ? - INQUIRE CLASS CAPABILITY
;=============================================================
ATF_CLASS0:
        LCALL   FETCH           ;GET NEXT PARAMETER
        CJNE    A,#'?',ATF_C0   ;9-13-90BRANCH IF NOT "AT+FCLASS=?"
        MOV     DPTR,#MSG_CLAS02;
        LCALL   SND_MSG         ; W/O <CR>
        LJMP    AT_000
ATF_C0:
        CJNE    A,#'1',ATF_C1   ;9-13-90BRANCH IF NOT "AT+FCLASS=?"
        LJMP    AT_ERR
ATF_C1:
        DEC     POINTER         ;POINT TO PREVIOUS BUFFER
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        CLR     ACC.0
        JB      PASS,ATF_C3
        SETB    ACC.0
ATF_C3:
        MOVX    @DPTR,A
        LJMP    AT_000
;
MSG_CLAS02      DB      0DH,0AH,'(0,2)',0FFH            ;
;
ATF_CLASS:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        CLR     ACC.0
        JB      PASS,ATF_C00
        SETB    ACC.0
ATF_C00:
        MOVX    @DPTR,A
        LJMP    AT_000
;
;=============================================================
;
;AT+FCLASS? COMMAND: CLASS INDICATION
;
;=============================================================
ATF_CLASS1:
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        MOV     DPTR,#MSG_VAL0;
        JNB     ACC.0,ATF_CL0
        MOV     DPTR,#MSG_VAL2;
ATF_CL0:
        LCALL   SND_MSG         ; W/O <CR>
        LJMP    AT_000
;
MSG_VAL0        DB    0DH,0AH,'0',0FFH          ;
MSG_VAL1        DB    0DH,0AH,'1',0FFH          ;
MSG_VAL2        DB    0DH,0AH,'2',0FFH          ;
;
;=============================================================
;
;AT+FCR= COMMAND: CAPABILITY TO RECEIVE OR POLL
;
; PARAMETERS: 0 - W/O RECEIVE CAPABILITY,OPT_FAX.2 = 0,
;             1 - W/H RECEIVE CAPABILITY,OPT_FAX.2 = 1
;=============================================================
ATF_CR:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
        CLR     ACC.2
        JB      PASS,ATF_CR0
        SETB    ACC.2
ATF_CR0:
        MOVX    @DPTR,A
        LJMP    AT_000
;=============================================================
;
;AT+FDCC=/+FDIS= COMMAND: DCE CAPABILITY PARAMETER
;
; PARAMETERS:0,1,2,3,4,5,6,7
;             ? - INQUIRE DEFAULT DCE SESSION CAPABILITY
;
;=============================================================
ATF_SESS:
        MOV     R3,#7
        LCALL   FETCH           ;GET NEXT PARAMETER
        CJNE    A,#'?',ATF_SES1 ;9-13-90BRANCH IF NOT "AT+FDCC=?"
;12-12-90       LCALL   SESS_DISP
        MOV     DPTR,#MSG_SESS;
        LCALL   SND_MSG         ; W/O <CR>
        LJMP    AT_000
;
MSG_SESS        DB    0DH,0AH,'(0-1),(0-3),(0-3),(0-2),(0-2),(0),(0),(0-7)',0FFH                ;
;
ATF_SES1:
        LCALL   SESS_SAVE
        LCALL   SESS_SET
        LJMP    AT_000
;
;
SESS_SAVE:
        DEC     POINTER
;10-29-90       LCALL   GET_PARAM       ;GET NEXT PARAMETER
        LCALL   FETCH           ;GET NEXT PARAMETER
        MOV     DPTR,#FD_SESS
        MOVX    @DPTR,A
S_SET0:
        INC     DPTR
S_SET1:
        LCALL   FETCH           ;GET NEXT PARAMETER TO SKIP ","
;10-29-90       LCALL   GET_PARAM       ;GET NEXT PARAMETER
        CJNE    A,S3,S_SET2     ;10-29-90
        SJMP    S_SET4          ;10-29
S_SET2:                         ;10-29
        CJNE    A,#';',S_SET3   ;10-29
        SJMP    S_SET4          ;10-29
S_SET3:                         ;10-29
        MOVX    @DPTR,A
        CJNE    A,#',',S_SET0   ;10-29
        SJMP    S_SET1          ;10-29
;10-29-90       DJNZ    R3,S_SET0
S_SET4:                         ;10-29
        DEC     POINTER         ;10-29
        RET
;
SESS_SET:
        MOV     DPTR,#FD_SESS   ;10-29-90 VERTICAL RESOLUTION
        MOVX    A,@DPTR         ;10-29
        LCALL   DIS1_SET        ;10-29
;FOR FURTHER STUDY      MOV     DPTR,#FD_SESS+1
;       MOVX    A,@DPTR
;       MOV     DPTR,#FD_DIS+5
;       LCALL   DISDCS2_SET
        RET
;
DIS1_SET:
        CJNE    A,#'0',DIS1_S0
        MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        CLR     ACC.6
        SJMP    DIS1_S1
DIS1_S0:
        CJNE    A,#'1',DIS1_S2
        MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        SETB    ACC.6
DIS1_S1:
        MOVX    @DPTR,A
DIS1_S2:
        RET
;
DISDCS2_SET:
        CJNE    A,#'3',DIS2_S0
;       MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        SETB    ACC.2
        CLR     ACC.3
        SJMP    DIS2_S3
DIS2_S0:
        CJNE    A,#'2',DIS2_S1
;       MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        SETB    ACC.2
        SETB    ACC.3
        SJMP    DIS2_S3
DIS2_S1:
        CJNE    A,#'1',DIS2_S2
;       MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        CLR     ACC.2
        SETB    ACC.3
        SJMP    DIS2_S3
DIS2_S2:
        CJNE    A,#'0',DIS2_S4
;       MOV     DPTR,#FD_DIS+5
        MOVX    A,@DPTR
        CLR     ACC.2
        CLR     ACC.3
DIS2_S3:
        MOVX    @DPTR,A
DIS2_S4:
        RET

;3-15-91
DISDCS1_SET:
        CJNE    A,#'1',DS1_S0
        MOVX    A,@DPTR
        SETB    ACC.6
        SJMP    DS1_S1
DS1_S0:
        CJNE    A,#'0',DS1_S2
        MOVX    A,@DPTR
        CLR     ACC.6
DS1_S1:
        MOVX    @DPTR,A
DS1_S2:
        RET


;
;=============================================================
;12-12-90
;AT+FDCC=/+FDIS? COMMAND: INQUIRE CURRENT DCE CAPABILITY PARAMETER
;
;=============================================================
ATF_SESS1:
        MOV     R3,#7
        LCALL   SESS_DISP
        LJMP    AT_000
;
;
SESS_DISP:
        LCALL   S_CRLF
        MOV     DPTR,#FD_SESS
ATF_SES0:
        MOVX    A,@DPTR
;10-29-90       ADD     A,#'0'
        PUSH    DPL
        PUSH    DPH
        LCALL   PUT_CHAR        ;
        MOV     A,#','
        LCALL   PUT_CHAR        ;
        POP     DPH
        POP     DPL
        INC     DPTR
        DJNZ    R3,ATF_SES0
        MOVX    A,@DPTR
;10-29  ADD     A,#'0'
;       LCALL   PUT_CHAR        ;
        LJMP    PUT_CHAR        ;
        RET
;
;=============================================================
;
; AT+FLID= COMMAND: FOR LOCAL ID SETTING
; PARAMETERS: 0 - 9, + , SPACE
;
;=============================================================
ATF_LID0:
        LCALL   FETCH           ;GET NEXT PARAMETER
        CJNE    A,#'"',ATF_LD0A ;BRANCH IF NOT QUOTATION
        MOV     DPTR,#FD_CSIA+4 ;10-29-90
        LCALL   RESET_ID        ;10-29-90CLR ID TO CSI
        MOV     DPTR,#FD_CSIA+23;10-29-90
        LCALL   SET_ID          ;10-29-90GET ID TO CSI
        MOV     DPTR,#FD_CSIS+4 ;10-29-90
        LCALL   RESET_ID        ;10-29-90CLR ID TO TSI
        MOV     DPTR,#FD_CSIS+23;10-29-90
;       MOV     A,POINTER       ;RECOVERY CMD BUF POINTER
;       SUBB    A,#21D          ;20 ID DIGITD
;       MOV     POINTER,A
        MOV     POINTER,#07     ;RECOVERY CMD BUF POINTER
        LCALL   SET_ID          ;GET ID TO TSI
;10-29-90       JB      PASS,ATF_LD1    ;JUMP IF ID VALID
        SJMP    ATF_LD1         ;10-29-90
ATF_LD0:
        LJMP    AT_ERR
ATF_LD0A:
        CJNE    A,#'?',ATF_LD0  ;BRANCH IF NOT QUOTATION
        MOV     DPTR,#MSG_FLID;
        LCALL   SND_MSG         ; W/O <CR>
ATF_LD1:
        LJMP    AT_000
;
MSG_FLID        DB    0DH,0AH,'"(20)(32-127)"',0FFH             ;
;
;=============================================================
;
;AT+FMINSP= COMMAND: MIN PHASE C NEGOIATION SPEED
;
; PARAMETERS:0,1,2,3
;=============================================================
ATF_MINSP0:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        MOV     DPTR,#FD_MINSP
        MOVX    @DPTR,A
        LJMP    AT_000
;
;=============================================================
;
; AT+FHPS= COMMAND: HANDSHAKING PROCOTOL SELECT
;
; PARAMETERS: 0 - OK
;             ELSE - ERROR
;=============================================================
ATF_HPS0:
ATF_MINSP1:
        LCALL   GET_PARAM       ;GET NEXT PARAMETER
        JB      PASS,ATF_HP0A   ;JUMP IF 0
        LJMP    AT_ERR
ATF_HP0A:
        LJMP    AT_000
;=============================================================
;
;AT+FMINSP? COMMAND: INQUIRE MIN PHASE C NEGOIATION SPEED
;
;=============================================================
;ATF_MINSP1:
        LCALL   S_CRLF
        MOV     DPTR,#FD_MINSP
        MOVX    A,@DPTR
        ADD     A,#'0'
        LCALL   PUT_CHAR        ;
        LJMP    AT_000
;
;=============================================================
;
; TO EXCLUSIVE-OR FAX COMMAND CHARACTERS ISSUED BY DTE
; OUTPUT :ACC=XOR CHECKSUM
;
;=============================================================
FXCMD_XOR:
        MOV     B,A                     ;
;2-27-91        MOV     TIM_2,#30D              ;8-23-90 3.0 SECONDS TIMER
        MOV     TIM_2,#60D              ;2-27-91 6.0 SECONDS TIMER
        MOV     TIM_2P,#30              ;8-23-90
        SETB    TIM_2F                  ;8-23-90
F_XR0:  JNB     TIM_2F,F_XR3            ;8-23-90 JUMP IF TIME OUT
        JNB     RI,F_XR0                ;8-23-90
        LCALL   BUF_CHARS               ;BUFFER CHARACHTERS
        JB      PASS,F_XR1              ;BRANCH IF NOT OVERFLOW
        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
        LCALL   SND_RESULT              ;SEND RESULT
        SJMP    FXCMD_XOR
F_XR1:
        MOV     POINTER,#00H            ;POINT TO BEGIN OF BUFFER
F_XR2:
        LCALL   FETCH                   ;
        XRL     B,A                     ; TEMP STORE CMD XOR RESULT IN B REG
        CJNE    A,#0DH,F_XR2            ;BRANCH IF NOT <CR>
        MOV     A,B
F_XR3:                                  ;8-23-90
        RET
;;##################################################
;
; START ANSWER SIDE FAX PROCEDURE.                #
;
;##################################################
;
FAX_ANS:
        SETB    EIA.2           ;3-15-91 MMM OFF THE HS LIGHT
;       LCALL   SET_RGAIN
;
;506S
        JNB     SPEAK_1,SPA1    ;004S
        LCALL   SPEAK_ON        ;X1
        SJMP    SPA3
SPA1:   JNB     SPEAK_2,SPA2
        LCALL   SPEAK_ON        ;10
        SJMP    SPA3
SPA2:   LCALL   SPEAK_OFF       ;00
SPA3:                           ;004T
;506T
        IFTRUE  JCM
        LCALL   RX_FEQ          ;2-27-91
        ENDIF
;
;2-27-91        MOV     B,#0DH          ;12-18-90
;2-27-91        MOV     A,#0B9H         ;12-18-90
;2-27-91        LCALL   WR0_CNTL        ;12-18-90
;
        MOV     B,#0DH          ;12-18-90
        MOV     A,#0B9H         ;12-18-90
        LCALL   WR0_CNTL        ;12-18-90
;
        LCALL   B_RAM           ;10-29-90PUT ALL AT REG INTO RAM
        CLR     RI
        CLR     JP_004          ;2-27-91
        MOV     DIS_CNT,#16
        LCALL   OFF_HOOK
        MOV     A,#2            ;SETUP 2 SECONDS DELAY
        LCALL   WAIT_SEC
        MOV     A,#50
        LCALL   WAIT_3MS
;
;SET T1 TIMEOUT TIMER IN T.30
        MOV     TIM_1,#30       ;SET UP 30 SECONDS FOR TIME OUT
        MOV     TIM_1P,#150
        SETB    TIM_1PF
        SETB    TIM_1F
;
; SEND 2100HZ ANSWER TONE FOR 2.2 SECONDS
;
        LCALL   SET_TMOD        ;SET TONE TRANSMIT MODE
        LCALL   CXR_OFF
;       LCALL   SET_24B
;       MOV     DPTR,#MSG_FCON  ; GET V.21 PREAMBLE
;       LCALL   SND_RESULT
;       LCALL   SET_192B

        MOV     B,#03           ;WRITE ADDRS 3 = 38H
        MOV     A,#38H
        LCALL   WR0_CNTL
        MOV     B,#02           ;WRITE ADDRS 2 = 00
        MOV     A,#00
        LCALL   WR0_CNTL
;
;
        LCALL   SET_RTS         ;TURN ON TRANSMITTER
        LCALL   SET_PDM

        MOV     TIM_2,#22       ;2.2 SECONDS TIMER
        MOV     TIM_2P,#30
        SETB    TIM_2F
V21A00: JB      TIM_2F,V21A00
        MOV     TRY_CNT,#05     ;setup for 3 try.
;
;SQUELCH TRANSMITTER FOR 75MS
;
;11-9-90V21A02: LCALL   CLR_RTS
        LCALL   CLR_RTS
V21A02:
        MOV     A,#23
        LCALL   WAIT_3MS
;
SND_DIS00:
        LCALL   SND_DIS         ;SEND DIS SIGNAL( INCL. CSI )
;
WT_DIS00:
        MOV     A,#23
        LCALL   WAIT_3MS
        LCALL   CHK_FED         ;CHECK ENERGY FROM FAR END( V.21 SIGNALING )
        JB      PASS,GET_DCS
        DJNZ    TRY_CNT,SND_DIS00
GET_D1:                         ;
        MOV     DPTR,#MSG_FHNG01;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT
GET_D2:                         ;
        MOV     DPTR,#MSG_FHNG70;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT
;
; RECEIVING DCS FRAMES
;
GET_DCS:
        LCALL   CHK_AGC         ;8-22-90

	MOV	DPTR,#OPT_FAX
	MOVX	A,@DPTR
	JNB	ACC.0,SET_HCON
	LCALL	SET_192B
SET_HCON:
	MOV	DPTR,#MSG_FCON
	LCALL	SND_RESULT
	LCALL	SET_192B
	
	LCALL   SET_PDM         ;8-22-90
;11-9-90        MOV     TIM_2,#30D      ;SET UP 3.0 SECONS FOR WAITING DCS
        MOV     TIM_2,#50D      ;SET UP 5.0 SECONS FOR WAITING DCS
        LCALL   RCV_FRAMES
;7-10-91        JNB     TIM_1F,GET_D1   ; JUMP IF T1 ELAPSED ALREADY
        JNB     TIM_1F,GET_D2   ; JUMP IF T1 ELAPSED ALREADY
        JNB     TIM_2F,V21A02   ; JUMP IF NO ANY FRAME RCV'D
        CLR     A
        MOV     FAM_CNT,A
NDCS_00:
        LCALL   GET_KWD
        JB      FIN_FR,NDCS_05
        CJNE    A,#43H,NDCS_00
        MOV     R3,FAM_CNT
        SJMP    NDCS_00
;
NDCS_05:
;
        LCALL   CONV_FDCS       ; CONVERT RCV'D DCS INTO BIT MAP
;
        LCALL   RX_SPD          ; PREPARE TO SATRT RECEIVE TCF( 0s FOR 1.5 S )
;
        MOV     DPTR,#MSG_FTSI  ; SEND TSI TO DTE
        LCALL   SND_MSG         ; W/O <CR>
        MOV     FAM_CNT,R3      ;MOVE BACK CSI FAM_CNT.
        LCALL   SND_MCSI        ;SEND TSI/CSI TO HOST
;
        MOV     FAM_CNT,R3      ;MOVE BACK CSI FAM_CNT.
        MOV     DPTR,#MSG_DCS   ;
        LCALL   SND_MSG         ;
        LCALL   SND_MDCS        ;SEND DCS TO HOST
;
GET_TCF:
        MOV     R2,#0
        LCALL   CHK_FED
        JB      PASS,WT_CD5     ;WAIT FOR CARRIER
        DJNZ    TRY_CNT,SND_DIS00A
P0100:                          ;
        MOV     DPTR,#MSG_FHNG70;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT
SND_DIS00A:
	LJMP	SND_DIS00
WT_CD5: CLR     PASS
        LCALL   CHK_PNDET       ;
        JNB     PASS,P0100      ;
        CLR     PASS            ;
        CLR     JP_004          ;2-27-91
	MOV	TIM_2,#10
	MOV	TIM_2P,#30
	SETB	TIM_2F
WT000:
        LCALL   CHK_MDAB
        JNC     WT001
        LCALL   R_PDATA
        JNZ     WT002
        JB      PASS,WT002
	JNB	TIM_2F,TCF_1
	SJMP	WT001

	INC     R2              ;R2 AS -00- COUNTER
        CJNE    R2,#255,WT002
        JB      JP_004,TCF_1    ;2-27-91
        SETB    JP_004          ;2-27-91
        MOV     R2,#00          ;2-27-91
        SJMP    WT000           ;2-27-91
TCF_1:                          ;2-27-91
        SETB    PASS
WT002:
WT001:  LCALL   R_FED           ;
        JC      WT000           ;
;-------------------------------------------- TCF CK OVER
        CLR     JP_004          ;2-27-91
        JB      PASS,TCF_OK
        LCALL   SND_FTT
        DJNZ    TRY_CNT,F_S00
WT003:                          ;
        MOV     DPTR,#MSG_FHNG70;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT
F_S00:  LCALL   F_SPEED         ;FALL BACK TRAINING SPEED
        LJMP    WT_DIS00        ;BACK TO START
;
        MOV     A,#23
        LCALL   WAIT_3MS
;
TCF_OK:
        LCALL   CLR_RTS                 ;SQUELCH TRANSMITER
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
;
;WAIT FOR AT+FDR ISSUED BY DTE
; AT+FDR COMMAND: BEGIN PAHASE C RECEIVE DATA
TCF_OK0:
        MOV     A,#63H                  ; 63H:CHKSUM OF AT+FDR
        LCALL   FXCMD_XOR               ;COMPARE WITH FAX CMD
        JZ      TCF_OK1                 ;BRANCH IF 'AT+FDR"
;7-10-91        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
;7-10        LCALL   SND_RESULT              ;SEND RESULT
        SJMP    WT003                   ;
TCF_OK1:                                ;
        LCALL   SET_RTS                 ;TURN ON TRANSMITTER
;
S_CFR:
;
        LCALL   SND_CFR
        MOV     DPTR,#MSG_CFR   ;SENDING CFR
        LCALL   SND_RESULT      ;
        MOV     DPTR,#MSG_FTSI  ;SEND TSI TO DTE
        LCALL   SND_MSG         ; W/O <CR>
        LCALL   SND_MCSI        ;SEND TSI/CSI TO HOST
        MOV     DPTR,#MSG_DCS   ;
        LCALL   SND_MSG         ;
        LCALL   SND_MDCS        ;SEND DCS TO HOST
        LCALL   RX_SPD          ;SET FAX RCV SPEED
        JNB     SPEAK_1,SPC1    ;004S
        LCALL   SPEAK_OFF
        SJMP    RCV_MSG
SPC1:   JNB     SPEAK_2,SPC2
        LCALL   SPEAK_ON
        SJMP    RCV_MSG
SPC2:   LCALL   SPEAK_OFF       ;004T
;506T
;       LCALL   RX_CONMSG       ; CONNECT MSG
;
; START TO RECEIVE FAX DATA
;
RCV_MSG00:
;3-15-91----begin
;7-10-91        SJMP    RCV_MSG                 ;BRANCH IF '<DC2>"
;7-10-91 D_RDYB:
;7-10   MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
;7-10        LCALL   SND_RESULT              ;SEND RESULT
;7-10        LJMP    R_DCN0                  ;
DTE_RDY1:                               ;
;
RCV_MSG:
        LCALL   CHK_FED
        JB      PASS,RM_00      ;CHECK ENERGY
        JNB     B_MPS,RCV_MSG0  ;JUMP IF NOT MULTI-PAGE
        DJNZ    TRY_CNT,RCV_MSG ;
;7-10-91        LJMP    BK_AT           ;
        LJMP    R0100           ;7-10-91
RCV_MSG0:                       ;
        DJNZ    TRY_CNT,S_CFR
R0100:                          ;
        MOV     DPTR,#MSG_FHNG90        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT
RM_00:
WT_DC1: MOV     A,#0FFH         ;DURING TRAINING SEND 0FFH TO TERMINAL
        LCALL   SND_OUTRF
        LCALL   CHK_PNDET       ;
        JNB     PASS,R0100      ;
;
        MOV     DPTR,#MSG_CON   ;SENDING CONNECT MSG
        LCALL   SND_RESULT      ;
;3-15-91----end
;WAIT FOR <DC2> ISSUED BY DTE
; <DC2> COMMAND: DTE IS READY TO RECEIVE DATA
;10-29-90 -- FOR UPDATED TR29 SPEC
DTE_RDY0:
;10-29-90       MOV     A,#1CH                  ; 1CH:CHKSUM OF <XON>
        CLR     RI                      ; RESET BUF
;10-29  LCALL   FXCMD_XOR               ; COMPARE WITH FAX CMD
;
        MOV     TIM_2,#30D              ;3.0 SECONDS TIMER
        MOV     TIM_2P,#30              ;
        SETB    TIM_2F                  ;
;7-10-91D_RDYA: JNB     TIM_2F,D_RDYB           ;JUMP IF TIME OUT
D_RDYA: JNB     TIM_2F,R0100            ;7-10-91JUMP IF TIME OUT
        JNB     RI,D_RDYA               ;
        CLR     RI
        MOV     A,SBUF
        ANL     A,#7FH                  ;NO PARITY
;7-10-91        CJNE    A,#12H,D_RDYB
        CJNE    A,#12H,R0100            ;7-10-91
;3-15-91        SJMP    DTE_RDY1                ;BRANCH IF '<DC2>"
;
        MOV     R2,#LCCT        ;2-27-91
        LCALL   CXR_ON
RCVM00: LCALL   CHK_MDAB
        JNC     RCVM02          ;JUMP IF FAX DATA IS NOT READY
        LCALL   R_PDATA
        LCALL   DAT_BOR         ; FOR FITTING BITFAX DATA FORMAT
        LCALL   SND_OUTRF
RCVM02:
        LCALL   R_FED           ;CHECK ENERGY
        JC      RCVM00          ;
        DJNZ    R2,RCVM00       ;2-27-91
        LCALL   CXR_OFF
;
; RECEIVE END OF PROCEDURE.
;
        MOV     DPTR,#MSG_ETX   ;
        LCALL   SND_RESULT      ;
        MOV     DPTR,#MSG_FPTS  ;
        LCALL   SND_RESULT      ;
        SETB    JP_004          ;2-27-91
        LCALL   SET_V21
        CLR     JP_004          ;2-27-91
        MOV     A,#23
        LCALL   WAIT_3MS
RCV_EOP:
        LCALL   CHK_FED
        JB      PASS,RE_10
RE_09:  MOV     DPTR,#MSG_FHNG100       ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT
RE_10:
        MOV     TIM_2,#200D     ;SET UP 20.0 SECONS FOR WAITING
        LCALL   RCV_FRAMES
        JB      TIM_2F,RE_11            ; JUMP IF ANY FRAME RCV'D
;7-10-91        LJMP    BK_AT                   ;
        SJMP    RE_09                   ;7-10-91
RE_11:                                  ;
;
        CLR     A
        MOV     FAM_CNT,A
        LCALL   GET_KWD
        CLR     ACC.0
;DAVID  CJNE    A,#F_MPS,RE_00  ;CHECK "MPS"
        CJNE    A,#F_MPS_X,RE_00  ;CHECK "MPS"
        MOV     DPTR,#MSG_FET0          ;
        LCALL   SND_RESULT
        SETB    B_MPS
        SJMP    RE_06                   ;5-18
;7-10-91RE_02:  LJMP    BK_AT                   ;

RE_00:  CLR     ACC.0           ;MASK BIT0
;DAVID  CJNE    A,#F_EOP,RE_10          ;8-22-90
        CJNE    A,#F_EOP_X,RE_10          ;8-22-90
        MOV     DPTR,#MSG_FET2          ;
        LCALL   SND_RESULT
RE_05:  CLR     B_MPS
;
RE_06:  LCALL   CLR_RTS                 ;
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
;
;WAIT FOR AT+FDR ISSUED BY DTE
; AT+FDR COMMAND: CONTINUE PAHASE C RECEIVE DATA
EOP_OK0:
        MOV     A,#63H                  ;
        LCALL   FXCMD_XOR               ; COMPARE WITH FAX CMD
        JZ      EOP_OK1                 ;
;7-10-91        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
;7-10-91        LCALL   SND_RESULT              ;SEND RESULT
;7-10-91        SJMP    R_DCN0                  ;
        SJMP    RE_09                   ;7-10-91
EOP_OK1:                                ;
        LCALL   SET_RTS                 ;TURN ON TRANSMITTER
;
;
; SEND MESSAGE CONFIRMATION
;
S_MCF:
;7-20-90        MOV     A,#23           ;
;7-20-90        LCALL   WAIT_3MS        ;
        LCALL   SND_MCF
;
        JNB     B_MPS,RCV_DCN   ;JUMP IF NOT MULTI-PAGE
;10-29-90       MOV     A,#23           ;
        SETB    JP_004          ;2-27-91
        LCALL   RX_SPD          ;2-27-91MULTI-PAGE, RECEIVE FAX DATA AGAIN
        CLR     JP_004          ;2-27-91
;2-27   LCALL   RX_SPD          ;MULTI-PAGE, RECEIVE FAX DATA AGAIN
        MOV     A,#15           ;10-29 FOR TEFAX
        LCALL   WAIT_3MS        ;
;3-15-91        MOV     DPTR,#MSG_CON   ;
;3-15-91        LCALL   SND_RESULT      ;
;3-15-91        LJMP    RCV_MSG00
        LJMP    RCV_MSG
;
; RECEIVE DISCONNECT MESSAGE
;
RCV_DCN:
        JNB     SPEAK_1,SPD1    ;004S
        LCALL   SPEAK_ON        ;X1
        SJMP    SPD3
SPD1:   JNB     SPEAK_2,SPD2
        LCALL   SPEAK_ON        ;10
        SJMP    SPD3
SPD2:   LCALL   SPEAK_OFF       ;00
SPD3:                           ;004T
;506T
        LCALL   CHK_FED
        JNB     PASS,R_DCN0
        MOV     TIM_2,#200D             ;SET UP 20.0 SECONS FOR WAITING
        LCALL   RCV_FRAMES
        JB      TIM_2F,RCV_D1           ; JUMP IF ANY FRAME RCV'D
;7-10-91        LJMP    BK_AT                   ;
R_DCN0: LJMP    RE_09                   ;7-10-91 SHOULD PHASE E ERROR
RCV_D1:                                 ;
;
        MOV     DPTR,#MSG_FHNG00        ;7-10-91
        LCALL   SND_RESULT
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
        LJMP    BK_AT
;
;##################################################
;
; START CALLING SIDE FAX PROCEDURE.               #
;
;##################################################
;
; DETECT ANSWER TONE FROM ANSWERING MODEM
;
FAX_CALL:
        SETB    EIA.2           ;3-15-91 MMM OFF THE HS LIGHT
        LCALL   B_RAM           ;10-29-90PUT ALL AT REG INTO RAM
;
        IFTRUE  JCM
        LCALL   TX_FEQ          ;2-27-91
        ENDIF
;       LCALL   SET_DCSW                ; SET DCS BR VALUE BE 9600 BPS
        LCALL   PRESET_DCS              ; 3-15-91 PRESET DCS VR BR & LN VALUE BE 9600 BPS
;
        LCALL   OFF_HOOK
        JNB     SPEAK_1,SPB1    ;004S
        LCALL   SPEAK_ON        ;X1
        SJMP    SPB3
SPB1:   JNB     SPEAK_2,SPB2
        LCALL   SPEAK_ON        ;10
        SJMP    SPB3
SPB2:   LCALL   SPEAK_OFF       ;00
SPB3:                           ;004T
;506T
        MOV     TRY_CNT,#5      ;
        MOV     A,#30           ;DELAY 100MS
        LCALL   WAIT_3MS

        MOV     TIM_1,#30       ;SET UP 30 SECONDS FOR TIME OUT
        MOV     TIM_1P,#150
        SETB    TIM_1PF
        SETB    TIM_1F

        CLR     RI
;502S
                SETB     JP_004          ;2-27-91
;502T
        LCALL   CTSOFF
        LCALL   SET_V21         ;SET V21 MODE ( FOR ACTIVE FR1--ANS TONE)
        LCALL   CLR_RTS

        LCALL   SET_PDM         ;SET PARALLEL DATA MODE

F_ENG0: MOV     TIM_4,#33       ;DETECT CONTINUOUS ENERGY FOR 100MS
        SETB    TIM_4F
F_ENG:  LCALL   R_FED           ;DETECT ENERGY
        JNB     TIM_1F,F_ENG1
;       JNB     TIM_2F,ENA_CNG  ;3.0 SEC CNG OFF TIME OUT, RESTART CNG
;7-10-91        JB      RI,F_ENG1       ;IF KEY IN, USER ABORT.
        JB      RI,F_ENG2       ;7-10-91IF KEY IN, USER ABORT.
        JNC     F_ENG0          ;NO ENERGY, RESTART 100MS TIMER
        JB      TIM_4F,F_ENG

        LCALL   CHK_AGC         ;CHECK FOR HIGH ENERGY
        LCALL   SET_PDM
        SJMP    D_ANST
F_ENG1:
        MOV     DPTR,#MSG_FHNG11        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT
F_ENG2:                                 ;7-10-91
        MOV     DPTR,#MSG_FHNG02        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT                   ;7-10
; START TO DETECT 2100HZ ANSWER TONE
;
D_ANST: MOV     TIM_4,#50       ;DETECT ANSWER TONE FOR 1 SECOND
        SETB    TIM_4F
D_ANS00:
        JB      TIM_4F,D_ANS00
        LCALL   V_ANSDET        ;DISPLY 'CED' MSG

W_ANS00:
RCV_DIS:
        MOV     A,#33           ;WAIT 100 MS
        LCALL   WAIT_3MS
RCV_DIS00:
        LCALL   RCV_FRAMES
        JB      TIM_2F,RCV_DIS0A        ; JUMP IF ANY FRAME RCV'D
        MOV     DPTR,#MSG_FHNG20        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT                   ;
RCV_DIS0A:                              ;
        MOV     DPTR,#MSG_FCON  ;
        LCALL   SND_RESULT      ;
;
        LCALL   NDIS00          ;
;
        LCALL   CHK_SPD         ;MATCH ANSWER SIDE RESPONSE FOR SPEED

        LCALL   CLR_RTS                 ;
;
;3-15-91 --SET DCS VR PER RCV'D DIS VR AND AT+FDIS=0/1
        MOV     A,FAX_S1                ;3-15
        MOV     C,ACC.6                 ;3-15
        MOV     DPTR,#FD_DCS+5          ;3-15-91
        MOVX    A,@DPTR                 ;3-15
        ANL     C,ACC.6                 ;3-15
        MOV     ACC.6,C                 ;3-15
        MOVX    @DPTR,A                 ;3-15
;3-15-91 --SET DCS WD PER RCV'D DIS WD AND AT+FDIS(WD)=0/1/2 (3/4 NOT SUPPORTED)
        MOV     DPTR,#FD_DCS+6          ;3-15-91
        MOV     A,FAX_S2                ;3-15
        LCALL   SET_WDLN                ;3-15
;3-15-91 --SET DCS LN PER RCV'D DIS LN AND AT+FDIS(LN)=0/1/2
        RR      A                       ;3-15SHIFT FOR WIDTH CHECKING
        RR      A                       ;3-15
        MOVX    @DPTR,A                 ;3-15
        MOV     A,FAX_S2                ;3-15
        RR      A                       ;3-15SHIFT FOR WIDTH CHECKING
        RR      A                       ;3-15
        LCALL   SET_WDLN                ;3-15
        RL      A                       ;3-15RESTORE FOR DCS+6
        RL      A                       ;3-15
        MOVX    @DPTR,A                 ;3-15

DIS_OK00:
;
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
        LCALL   CTSON           ;

;
;
;WAIT FOR AT+FDT ISSUED BY DTE
; AT+FDR COMMAND: BEGIN PAHASE C RECEIVE DATA
DIS_OK0:
        MOV     A,#65H                  ;
        LCALL   FXCMD_XOR               ; COMPARE WITH FAX CMD
        JZ      DIS_OK1                 ;
;7-10-91        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
        MOV     DPTR,#MSG_FHNG40        ;7-10-91
        LCALL   SND_RESULT              ;SEND RESULT
        LJMP    BK_AT                   ;
DIS_OK1:                                ;
        LCALL   CTSOFF          ;
        LCALL   SET_RTS                 ;TURN ON TRANSMITTER

;
        LCALL   NDIS00          ;
;
        LCALL   DIS_OK2         ;3-15-91
;
RCV_CFR02:
        MOV     DPTR,#FD_DCS+3  ;POINTER TO DCS DATA AREA
        CALL    CONV_FDCS       ;CONVERT TX DCS TO BITMAP
        MOV     DPTR,#MSG_DCS   ;
        LCALL   SND_MSG         ;
        LCALL   SND_MDCS        ;
;2-27-91        MOV     DPTR,#MSG_CON   ;
;2-27-91        LCALL   SND_RESULT      ;
        MOV     A,#23           ;WAIT 75MS
        LCALL   WAIT_3MS
;
; START TO SEND FAX DATA
;
S_FAXD:
        JNB     SPEAK_1,SPE1    ;004S
        LCALL   SPEAK_OFF       ;X1 ***
        SJMP    SPE3
SPE1:   JNB     SPEAK_2,SPE2
        LCALL   SPEAK_ON        ;10
        SJMP    SPE3
SPE2:   LCALL   SPEAK_OFF       ;00
SPE3:                           ;004T
;506T
        MOV     DPTR,#DEBUG_S
        MOVX    A,@DPTR
        JNZ     S_FAX00
;
        LCALL   INI_SPDFT       ;INITIALIZATION FOR TRANSMIT FAX DATA
        LCALL   SND_FDAT        ;WAIT FOR TRAINING SEQUENCE
                                ;WRITE 0FFH TO LOCATION 0 (V.29)
;
        MOV     DPTR,#MSG_CON   ;2-27-91
        LCALL   SND_RESULT      ;2-27-91
;
        MOV     A,#11H          ;
        LCALL   PUT_CHAR        ;
;
        LCALL   CTSON           ;SHOULD SEND <XON>
;2-27-91        MOV     TIM_4,#10
        MOV     TIM_4,#255      ;2-27-91 1.3 SEC FOR QULINK 1.1.2
        SETB    TIM_4F
        CLR     LOST_DTR        ;8-22-90
;INIT FOR RECVING COMANDS IN PHASE C
;       MOV     R7,#00H         ;CLEAR CMD CHKSUM
;
        LCALL   SPDT            ;CALL FOR SEND FAX DATA
;HERE ALL FAX DATA SEND TO LINE ALREADY
        JNB     LOST_DTR,MPS_SEL        ;8-22-90 JUMP IF NO DTR DROP AT ALL
        CLR     LOST_DTR        ;8-22-90
;7-10-91        LJMP    BK_AT           ;8-22-90
        LJMP    F_ENG2           ;7-10-91
S_FAX00:
        LCALL   SND_FDAT
;
; SEND END OF PROCEDURE MESSAGE
;
MPS_SEL:
;
;12-12-90       MOV     A,#20           ;
        MOV     A,#2            ;
        LCALL   WAIT_3MS
;
        LCALL   CLR_RTS                 ;
;509S
                MOV     A,#30           ;12-12-90
;509T
        LCALL   WAIT_3MS        ;12-12-90
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
;509S
        LCALL   SET_V21         ;3-15-91
        MOV     A,#7EH          ;3-15-91
        MOV     B,#00           ;3-15
        LCALL   WR0_CNTL        ;3-15
;3-15-91 WANG        LCALL   SET_RTS         ;3-15TURN ON TRANSMITTER
;509T

;WAIT FOR AT+FET=2/=0 ISSUED BY DTE
; AT+FET=2/+FET=0 COMMAND: BEGIN PAHASE C TRANSMIT DATA
MPS_SEL0:
        MOV     A,#6BH                  ;
        LCALL   FXCMD_XOR               ; COMPARE WITH FAX CMD
        JZ      EOP_SEL1                ;
        XRL     A,#6BH                  ; RECOVERY CHKSUM OF AT+FET=2
        XRL     A,#69H                  ; 69H:CHKSUM OF AT+FET=0
        JZ      MPS_SEL1                ;BRANCH IF 'AT+FET=0'
;7-10-91        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
        MOV     DPTR,#MSG_FHNG50        ;7-10-91
        LCALL   SND_RESULT              ;SEND RESULT
        LJMP    BK_AT                   ;
;
MPS_SEL1:                               ;8-24-90
;12-12-90       LCALL   SET_RTS                 ;8-24-90TURN ON TRANSMITTER
;509S
                MOV     TRY_CNT,#4      ;
;509T
S_MPS:  LCALL   SND_MPS                 ;SEND MPS
        SETB    B_MPS
        SJMP    RCV_MCF00
;
EOP_SEL1:                               ;
;12-12-90       LCALL   SET_RTS                 ;TURN ON TRANSMITTER
;509S
                MOV     TRY_CNT,#4      ;
;509T
S_EOP:  CLR     B_MPS                   ;SEND EOP
        LCALL   SND_EOP
        JNB     SPEAK_1,SPF1    ;004S
        LCALL   SPEAK_ON        ;X1 ***
        SJMP    SPF3
SPF1:   JNB     SPEAK_2,SPF2
        LCALL   SPEAK_ON        ;10
        SJMP    SPF3
SPF2:   LCALL   SPEAK_OFF       ;00
SPF3:                           ;004T
;506T
RCV_MCF00:
        MOV     A,#23
        LCALL   WAIT_3MS
;
;TO RECEIVE MESSAGE CONFIRMATION MESSAGE
;
RCV_MCF:
        LCALL   CHK_FED
        JNB     PASS,S_ME
        MOV     TIM_2,#30D              ;SET UP 3.0 SECONS FOR WAITING
        LCALL   RCV_FRAMES
        JNB     TIM_2F,S_ME             ; JUMP IF NO ANY FRAME RCV'D
R_M1:                                   ;
        CLR     A
        MOV     FAM_CNT,A
        LCALL   GET_KWD
        CLR     B_RTNP                  ;3-15-91
        CLR     ACC.0                    ;3-15-91
        CJNE    A,#F_MCF,R_M2            ;3-15-91CHECK "MCF"
        SJMP    R_M4                    ;3-15
R_M2:   CJNE    A,#F_RTN,R_M3           ;3-15CHECK "RTN"
        MOV     DPTR,#MSG_FPTS_RTN      ;3-15
        SJMP    R_M3A                   ;3-15
R_M3:   CJNE    A,#F_RTP,S_DCN          ;3-15CHECK "RTP"
        MOV     DPTR,#MSG_FPTS_RTP      ;3-15
R_M3A:  SETB    B_RTNP                  ;3-15-91
        LCALL   SND_RESULT              ;3-15
        SJMP    R_M4A                   ;3-15
R_M4:                                   ;3-15
        MOV     DPTR,#MSG_FPTS          ;
        LCALL   SND_RESULT
R_M4A:                                  ;3-15-91
        JNB     B_MPS,S_DCN
;
        LCALL   CLR_RTS                 ;SQUELCH TRANSMITER
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
;WAIT FOR AT+FDT ISSUED BY DTE
; AT+FDR COMMAND: BEGIN PAHASE C RECEIVE DATA
RCV_M0:
        MOV     A,#65H                  ; 65H:CHKSUM OF AT+FDT
        CLR     RI                      ; RESET SBUF
        LCALL   FXCMD_XOR               ; COMPARE WITH FAX CMD
        JZ      RCV_M1                  ;BRANCH IF 'AT+FDT"
;7-10-91        MOV     DPTR,#MSG_ERR           ;SEND OUT ERROR MESSAGE
        MOV     DPTR,#MSG_FHNG50        ;7-10-91
        LCALL   SND_RESULT              ;SEND RESULT
        LJMP    BK_AT                   ;
RCV_M1:                         ;
        JNB     B_RTNP,RC_1             ;3-15-91
        LCALL   DIS_OK2                 ;3-15
RC_1:                                   ;3-15-91
;MING 4-11-91        LCALL   SET_RTS                 ;TURN ON TRANSMITTER
;
        LCALL   CTSOFF                  ; FOR PREVENT DTE FROM SEND DATA TOO EARLY
;2-27-91        MOV     DPTR,#MSG_CON   ; SENDING CONNECT MSG
;2-27-91        LCALL   SND_RESULT      ;
        LJMP    S_FAXD
;
; SEND DISCONNECT MESSAGE
;
S_DCN:
        LCALL   SND_DCN
        MOV     DPTR,#MSG_FHNG00        ;7-10-91
        LCALL   SND_RESULT              ;
        MOV     DPTR,#MSG_OK            ;
        LCALL   SND_RESULT              ;
        LJMP    BK_AT
;
S_ME:   DJNZ    TRY_CNT,S_ME00
        MOV     DPTR,#MSG_FHNG54        ;7-10-91
        JNB     B_MPS,S_ME0             ;7-10-91
S_ME0:  MOV     DPTR,#MSG_FHNG52        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT                   ;BACK TO "AT"
S_ME00: JNB     B_MPS,S_EOP_XX
        LJMP    S_MPS
S_EOP_XX:                       ;3-15-91
        LJMP    S_EOP           ;3-15-91
;
;#############################################################
; CANNED SEND MESSAGE                                        #
;                                                            #
;#############################################################
;
;*******3-15-91
DIS_OK2:
        MOV     TRY_CNT,#04

;2-27-91        MOV     R5,#03                  ;setup for 3 try FOR FTT.
;DAVID 3-15-91        MOV     R5,#04                  ;setup for 4 try FOR SANYO.
        MOV     FTT_CNT,#04                  ;setup for 4 try FOR SANYO.
;
        MOV     A,#23           ;10-29-90WAIT 75MS
        LCALL   WAIT_3MS        ;10-29
        LCALL   SND_TSIDCS      ;10-29 INCLUDING TSI
;       LJMP    SND_TCF
        SJMP    S_TCF           ;10-29
S_DCS:
        MOV     A,#23           ;WAIT 75MS
        LCALL   WAIT_3MS
;
        LCALL   SND_DCS         ; EXCLUDING TSI -FOR TEFAX
;
S_TCF:                          ;10-29-90
        LCALL   SND_TCF         ;WRITE 00H TO LOCATION 0.
;
RCV_CFR:
        LCALL   SET_V21
        MOV     A,#33           ;WAIT 100 MS
        LCALL   WAIT_3MS
RCV_CFR00:
        LCALL   CHK_FED
        JB      PASS,RV_100
        DJNZ    TRY_CNT,S_DCS
RCV_99: MOV     DPTR,#MSG_FHNG25        ;7-10-91
        LCALL   SND_RESULT              ;7-10-91
        LJMP    BK_AT
RV_100:
        MOV     TIM_2,#200D             ;SET UP 20.0 SECONS FOR WAITING
        LCALL   RCV_FRAMES
        JB      TIM_2F,RV_101           ; JUMP IF ANY FRAME RCV'D
;7-10-91        LJMP    BK_AT                   ;
        SJMP    RCV_99                  ;7-10-91
RV_101:                                 ;
        CLR     A
        MOV     FAM_CNT,A
        LCALL   GET_KWD
;505S
                CLR     ACC.0
;505T
        CJNE    A,#F_CFR,RCV_CFR06
        RET
RCV_CFR06:
        MOV     DPTR,#MSG_FTT   ;FAIL TO TRAIN
        LCALL   SND_RESULT
;
;CHECK MIN PHASE C SPEED
        MOV     DPTR,#FD_MINSP
        MOVX    A,@DPTR
        CLR     C
;DAVID 3-15-91        SUBB    A,R5
        SUBB    A,FTT_CNT
        JZ      GON             ;JUMP IF MINSP IS = CURRENT NEGOIATION SPEED
        JC      GON             ;JUMP IF MINSP IS < CURRENT NEGOIATION SPEED
        MOV     DPTR,#MSG_FHNG27;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT
GON:
;
        LCALL   F_SPEED
;DAVID 3-15-91        DJNZ    R5,S_DCS        ; RETRANSMIT
        DJNZ    FTT_CNT,S_DCS        ; RETRANSMIT
        MOV     DPTR,#MSG_FHNG25;7-10-91
        LCALL   SND_RESULT      ;7-10-91
        LJMP    BK_AT           ;
;
;
;==============================================
;
; SUBROUTINE FOR DISPLAY [NSF],CSI,DIS TO DTE
;
;==============================================
NDIS00:
        CLR     A
        MOV     FAM_CNT,A       ;
NDIS_00:
        LCALL   GET_KWD
        JB      FIN_FR,NDIS_05
        CJNE    A,#F_NSF,NDIS_01        ;
        MOV     DPTR,#MSG_FNSF          ;
        LCALL   SND_MSG                 ;
        LCALL   SND_MNSF                ;
        INC     FAM_CNT                 ;3-15-91 SKIP 32- BYTE FOR NSF
        LCALL   GET_KWD                 ;
        JB      FIN_FR,NDIS_05          ;
NDIS_01:                                ;
        CJNE    A,#F_CSI,NDIS_00
        MOV     R3,FAM_CNT      ; STORE CSI FAM_CNT.
        MOV     DPTR,#MSG_FCSI  ;
        LCALL   SND_MSG         ; W/O <CR>
        LCALL   SND_MCSI        ;SEND CSI TO HOST
        SJMP    NDIS_00
;
NDIS_05:
        CALL    CONV_FDCS       ;
        MOV     DPTR,#MSG_DIS
        LCALL   SND_MSG         ; W/O <CR>
;CHECK BR
        MOV     A,FAX_SA                ;
        ANL     A,#00000110B            ;
        CJNE    A,#00000100B,NDIS_06    ; ID DIS BR=02 REGARDED AS 9600
;11-9-90        SETB    ACC.1                   ;
;11-9-90        MOV     FAX_SA,A                ;
        ORL     FAX_SA,#00000010B       ;11-9-90
NDIS_06:                                ;
;       LCALL   SND_MDCS        ;
        LJMP    SND_MDCS        ;
        RET
;
;==============================================
; SUBROUTINE FOR SENDING "DIS"  - CSI + DIS
;
;==============================================
;
SND_DIS:
        LCALL   SET_V21
        LCALL   SET_RTS
        LCALL   IN_HDLC
        MOV     DCETPL,#<FD_CSIA
        MOV     DCETPH,#>FD_CSIA        ;1ST ADDRESS IS 9000H
        LCALL   HDLCTX
        MOV     DCETPL,#<FD_DIS
        MOV     DCETPH,#>FD_DIS
S_DCOM:
;12-12-90       LCALL   IN_HD1
        LCALL   IN_HD4
        LCALL   HDLCTX
        MOV     A,#24
        LCALL   WAIT_3MS        ;WAIT 50MS
;       LCALL   CLR_RTS
        LJMP    CLR_RTS
        RET
;
;==============================================
; SUBROUTINE FOR SENDING "DCS"
;
;==============================================
;
SND_DCS:
        LCALL   SET_V21
        LCALL   SET_RTS
        LCALL   IN_HDLC
;10-29-90       MOV     DCETPL,#<FD_CSIS
;10-29  MOV     DCETPH,#>FD_CSIS        ;1ST ADDRESS IS 9000H
;10-29  LCALL   HDLCTX
        MOV     DCETPL,#<FD_DCS
        MOV     DCETPH,#>FD_DCS
        SJMP    S_DCOM
;
;==============================================
;10-29-90 SUBROUTINE FOR SENDING "DCS"  - TSI + DCS
;
;==============================================
;
SND_TSIDCS:
        LCALL   SET_V21
        LCALL   SET_RTS
        LCALL   IN_HDLC
        MOV     DCETPL,#<FD_CSIS
        MOV     DCETPH,#>FD_CSIS        ;1ST ADDRESS IS 9000H
        LCALL   HDLCTX
        MOV     DCETPL,#<FD_DCS
        MOV     DCETPH,#>FD_DCS
        SJMP    S_DCOM
;
;==============================================
; SEND - "CFR"  -- CONFIRMATION TO RECEIVE
;==============================================
SND_CFR:
        MOV     R2,#F_CFR
;       LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;==============================================
; COMMON ROUTINE FOR SENDING DATA
;==============================================
;
SND_DAT:
;8-22-90        MOV     A,#23           ;WAIT 75MS
;8-22-90        LCALL   WAIT_3MS
        MOV     DPTR,#FD_TMP+3
        MOV     A,R2
SND_COMM:
        MOVX    @DPTR,A
        LCALL   TX_MSG
        MOV     A,#24
        LCALL   WAIT_3MS
;       LCALL   CLR_RTS
        LJMP    CLR_RTS
        RET
;
;===============================================
; SET UART SPEED FOR 19200bps/2400bps
;===============================================
;
SET_192B:
        ORL     PCON,#10000000B
        MOV     TH1,#0FDH
        MOV     TL1,#0FDH
        RET
SET_24B:
        ANL     PCON,#01111111B
        MOV     TH1,#0F4H
        MOV     TL1,#0F4H
        RET
;
;==============================================
; SEND - "FTT"  -- FAIL TO TRAIN
;==============================================
SND_FTT:
        MOV     R2,#F_FTT
 ;      LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;==============================================
; SEND - "MCF"  --MESSAAGE CONFIRMATION
;==============================================
SND_MCF:
        MOV     R2,#F_MCF
;       LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;==============================================
; SEND - "EOP"  --END OF PROCEDURE
;==============================================
SND_EOP:
        MOV     R2,#F_EOP
 ;      LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;==============================================
; SEND - "MPS"  --MULTIPAGE SIGNAL
;==============================================
SND_MPS:
        MOV     R2,#F_MPS
;       LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;==============================================
; SEND - "DCN"  --DISCONNECT
;==============================================
SND_DCN:
        MOV     R2,#F_DCN
;       LCALL   SND_DAT
        LJMP    SND_DAT
        RET
;
;====================================================
; CHK_FRAME: CHECK FRAME/PREPARE KEYWORD TO SEND OUT
; INPUT: "DPTR" FOR KEYWORD
;====================================================
;
GET_KWD:
        MOV     DPTR,#RV_1ST+1
        MOV     A,FAM_CNT
        RL      A
        RL      A
        RL      A
        RL      A
        RL      A
        ADD     A,DPL
        MOV     DPL,A
        MOVX    A,@DPTR         ; HDLC CONTROL FIELD CHARACTER
        CJNE    A,#FF_CTL_F,NOT_END
        SETB    FIN_FR
NOT_E00:
        INC     FAM_CNT
        INC     DPL
        MOVX    A,@DPTR         ; HDLC FCF CHARACTER
        RET
NOT_END:
        CLR     FIN_FR
        SJMP    NOT_E00
;
;======================================================
;
; SEND NSF INFORMATION TO HOST
;======================================================
;
SND_MNSF:
;3-15-91        MOV     R2,#4
        MOV     R2,NSF_BYCNT            ;3-15-91
        DEC     R2                      ;7-10-91 REMOVE CRCL
        DEC     R2                      ;7-10-91 REMOVE CRCH
        MOV     DPTR,#RV_1ST+3
        MOV     A,FAM_CNT
        DEC     A
        RL      A
        RL      A
        RL      A
        RL      A
        RL      A
        ADD     A,DPL
        MOV     DPL,A
SND_NS0:
        MOVX    A,@DPTR
        LCALL   SND_HEX
        MOV     A,#' '
        LCALL   PUT_CHAR
        INC     DPL
        DJNZ    R2,SND_NS0
;       LCALL   S_CRLF
        LJMP    S_CRLF
        RET
;
;======================================================
; SEND CSI INFORMATION TO HOST
;======================================================
;
SND_MCSI:
        MOV     R2,#20
        MOV     DPTR,#RV_1ST+22D                ;
        MOV     A,FAM_CNT
        DEC     A
        LCALL   FR_ROT1
        ADD     A,DPL
        MOV     DPL,A
SND_I00:
        MOVX    A,@DPTR
        JB      ACC.7,SND_I00B  ;12-18-90 JUMP IF NOT VALID ID
        CLR     C               ;12-18-90
        CJNE    A,#20H,SND_I00A ;12-18-90
SND_I00A:                       ;12-18
        JNC     SND_I01         ;12-18-90 JUMP IF VALID ID
SND_I00B:                       ;12-18
        MOV     A,#' '          ;12-18
;
;10-29-90       PUSH    DPL             ;
;10-29  PUSH    DPH             ;
;102-9  MOV     DPTR,#VALID_ID  ;POINT TO VALID DIGIT TABLE
;10-29  LCALL   IS_VA           ;SEE IF DIGIT IN RCV'D FAX ID IS VALID
;10-29  POP     DPH             ;
;10-29  POP     DPL             ;
;10-29  JB      PASS,SND_I01    ;JUMP IF VALID ID
;10-29  MOV     A,#' '          ;
SND_I01:                        ;
        LCALL   PUT_CHAR
        DEC     DPL
        DJNZ    R2,SND_I00
 ;      LCALL   S_CRLF          ;
        LJMP    S_CRLF
        RET
;
;======================================================
;
; CONVERT RECEIVED DCS/DIS TO FAX_SA,FAX_SB TWO BYTE BIT_MAP
;======================================================
CONV_FDCS:
        INC     DPL
        MOVX    A,@DPTR         ;
        MOV     FAX_S0,A        ;
        INC     DPL
        MOVX    A,@DPTR
        MOV     FAX_S1,A        ;STORE RECEIVER FAX SPEED
        INC     DPL
        MOVX    A,@DPTR
        MOV     FAX_S2,A        ;
        JB      ACC.7,CON_06    ;
        MOV     A,#00           ;
        SJMP    CON_07          ;
CON_06:                 ;
        INC     DPL             ;
        MOVX    A,@DPTR         ;
CON_07:                 ;
        MOV     FAX_S3,A        ;
        JB      ACC.7,CON_08    ;
        MOV     A,#00           ;
        SJMP    CON_09          ;
CON_08:                 ;
        INC     DPL             ;
        MOVX    A,@DPTR         ;
CON_09:                 ;
        MOV     FAX_S4,A        ;
;       LCALL   CONV_MDCS       ;
        LJMP    CONV_MDCS       ;
        RET
;
;======================================================
;
; CONVERT RECEIVED DCS IINTO T.30 TABLE 3 BIT MAP
;======================================================
;
CONV_MDCS:
;SET VR
        MOV     A,FAX_S1
        MOV     C,ACC.6         ;BIT 15
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
;SET BR --
;LOWER BIT= (BIT11 .XOR. BIT12), HIGHER BIT= BIT11
        MOV     C,ACC.2         ;BIT 11
        ANL     C,/ACC.3        ;BIT 12
        MOV     ACC.6,C         ;TEMP STORE C,( ACC.6 IS AVAILABLE)
        MOV     C,ACC.3
        ANL     C,/ACC.2
        ORL     C,ACC.6
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
        MOV     C,ACC.2         ;BIT 11
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
;SET WD
        MOV     A,FAX_S4
        JNB     ACC.0,WD4               ;BIT 33
        JNB     ACC.1,WD2               ;BIT 34
        MOV     A,FAX_SA
        SETB    C
        RRC     A
        SETB    C
        RRC     A
        CLR     C
        RRC     A
        MOV     FAX_SA,A
        SJMP    WD5
WD2:    JNB     ACC.2,WD3               ;BIT 35
        MOV     A,FAX_SA
        CLR     C
        RRC     A
        CLR     C
        RRC     A
        SETB    C
        RRC     A
        MOV     FAX_SA,A
        SJMP    WD5
WD3:
        MOV     A,FAX_SA
        SETB    C
        RRC     A
        SETB    C
        RRC     A
        SETB    C
        RRC     A
        MOV     FAX_SA,A
        SJMP    WD5
WD4:
        MOV     A,FAX_S2
        MOV     C,ACC.0         ;BIT 17
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
        MOV     C,ACC.1         ;BIT 18
        XCH     A,FAX_SA
        RRC     A
        CLR     C               ;BIT 33
        RRC     A
        XCH     A,FAX_SA
WD5:
; SET LN
        MOV     A,FAX_S2
        MOV     C,ACC.2         ;BIT 19
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
        MOV     C,ACC.3         ;BIT 20
        XCH     A,FAX_SA
        RRC     A
        XCH     A,FAX_SA
;SET DF
        MOV     A,FAX_S1
        MOV     C,ACC.7         ;BIT 16
        MOV     A,FAX_S3
        MOV     ACC.7,C         ;TEMP STORE BIT 16
        ANL     C,ACC.1         ;BIT 26
        XCH     A,FAX_SB
        RRC     A
        XCH     A,FAX_SB
        MOV     ACC.7,C         ;RESTORE BIT 16
        ANL     C,/ACC.1        ;COMPLEMENTARY BIT 26
        XCH     A,FAX_SB
        RRC     A
        XCH     A,FAX_SB
;SET EC
        MOV     A,FAX_S3
        MOV     C,ACC.2         ;BIT 27
        ANL     C,ACC.3         ;BIT 28
        XCH     A,FAX_SB
        RRC     A
        XCH     A,FAX_SB
        MOV     C,ACC.2         ;BIT 27
        ANL     C,/ACC.3        ;COMPLEMENTARY BIT 28
        XCH     A,FAX_SB
        RRC     A
        XCH     A,FAX_SB
;SET ST
        MOV     A,FAX_S2
        SWAP    A
        ANL     A,#07H          ; MARK OUT BIT 23,22,21
        CJNE    A,#00H,ST_1
        MOV     A,#05H
        SJMP    ST_END
ST_1:
        CJNE    A,#01H,ST_2
        MOV     A,#01H
        SJMP    ST_END
ST_2:
        CJNE    A,#02H,ST_3
        MOV     A,#03H
        SJMP    ST_END
ST_3:
        CJNE    A,#04H,ST_4
        MOV     A,#07H
        SJMP    ST_END
ST_4:
        CJNE    A,#07H,CONV_RET         ;JUMP IF UNDEFINE
        MOV     A,#00H
ST_END:
;SET BF
        CLR     C
        RLC     A                       ; BIT 3,2,1 - ST, BIT 0 - DF
        XCH     A,FAX_SB
        ANL     A,#F0H
        ORL     A,FAX_SB
        SWAP    A
        MOV     FAX_SB,A
CONV_RET:
        RET
;
;
;======================================================
;
; SEND DCS INFORMATION TO HOST
;======================================================
;
SND_MDCS:
;SND_VR
        MOV     A,FAX_SA
        ANL     A,#00000001B
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_BR
        MOV     A,FAX_SA
        ANL     A,#00000110B
        RR      A
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_WD
        MOV     A,FAX_SA
        ANL     A,#00111000B
        RR      A
        RR      A
        RR      A
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_LN
        MOV     A,FAX_SA
        ANL     A,#11000000B
        RL      A
        RL      A
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;
;SND_DF
        MOV     A,FAX_SB
        ANL     A,#00000011B
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_EC
        MOV     A,FAX_SB
        ANL     A,#00001100B
        RR      A
        RR      A
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_BF
        MOV     A,FAX_SB
        SWAP    A
        ANL     A,#00000001B
        ADD     A,#30H
        LCALL   PUT_CHAR
        MOV     A,#','
        LCALL   PUT_CHAR
;SND_ST
        MOV     A,FAX_SB
        SWAP    A
        ANL     A,#00001110B
        RR      A
        ADD     A,#30H
        LCALL   PUT_CHAR
 ;      LCALL    S_CRLF
        LJMP     S_CRLF
        RET
;
;
;=====================================================
; CHECK AVAILABLE CONNECT SPEED FOR FAX MODE
;=====================================================
;
CHK_SPD:
        MOV     A,FAX_S1
        ANL     A,#0CH
        CJNE    A,#0CH,NCHKV97  ;V29/V27 AVAILABLE
        RET
NCHKV97:
        CJNE    A,#08H,NCHK00
        MOV     DPTR,#FD_DCS+5
        MOVX    A,@DPTR
        SETB    ACC.3
        CLR     ACC.2           ;SET 4800BPS FOR FAX
        MOVX    @DPTR,A
NCHK00: RET
;
;=====================================================
; F_SPEED : TRAINING FAIL FALL BACK DATA SPEED
;=====================================================
;
F_SPEED:
        MOV     DPTR,#FD_DCS+5
        MOVX    A,@DPTR
        MOV     B,A             ;2-27-91
        ANL     A,#0CH
        CJNE    A,#4H,FS_96
;
        SETB    ACC.3           ;SET TO 7200BPS
        SJMP    FS_000
FS_96:  CJNE    A,#0CH,FS_72
        CLR     ACC.2           ;SET TO 4800BPS
        SJMP    FS_000
FS_72:  CJNE    A,#08H,FS_000
        CLR     ACC.3           ;SET TO 2400BPS
FS_000:
        XCH     A,B             ;2-27-91
        ANL     A,#F3H          ;2-27-91
        ORL     A,B             ;2-27-91
        MOVX    @DPTR,A
        RET
;
;
;=====================================================
;3-15-91 PRESET_DCSW - PRESET DCS VR BR AND LN
;=====================================================
;
PRESET_DCS:
        MOV     DPTR,#FD_SESS+1 ;12-18-90 RESTORE DCS BR ACCORDING TO +FDCC
        MOVX    A,@DPTR         ;12-18
        MOV     DPTR,#FD_DCS+5  ;12-18
        LCALL   DISDCS2_SET     ;12-18

        MOV     DPTR,#FD_SESS   ; RESTORE DCS VR ACCORDING TO +FDCC
        MOVX    A,@DPTR         ;
        MOV     DPTR,#FD_DCS+5  ;
        LCALL   DISDCS1_SET     ;

        MOV     DPTR,#FD_DCS+6  ;RESTORE DCS WD & LN ACCORDING TO +FDCC
        MOVX    A,@DPTR         ;
        ANL     A,#11110000B
        MOV     DCS_TMP,A
        MOV     DPTR,#FD_SESS+2 ; RESTORE DCS WD ACCORDING TO +FDCC
        MOVX    A,@DPTR         ;
        ORL     A,DCS_TMP
        RR      A
        RR      A
        MOV     DCS_TMP,A
        MOV     DPTR,#FD_SESS+3 ; RESTORE DCS LN ACCORDING TO +FDCC
        MOVX    A,@DPTR         ;
        ORL     A,DCS_TMP
        RL      A
        RL      A
        MOV     DPTR,#FD_DCS+6  ;
        MOVX    @DPTR,A         ;
        RET
;######################
SET_WDLN:
        ANL     A,#00000011B            ;3-15 GET TWO LN(WD) BITS
        CJNE    A,#02H,S_WDLN0          ;3-15
S_WDLN0:JNC     S_WDLN2                 ;3-15 JIF UNLIM (1728-2048-24323)OR INVALID
        CJNE    A,#00H,S_WDLN1          ;3-15 JIF A4 & B4 (1728-2048)
        MOVX    A,@DPTR                 ;3-15
        CLR     ACC.0                   ;3-15 A4(1728) ONLY
        CLR     ACC.1                   ;3-15
        SJMP    S_WDLN2                 ;3-15
S_WDLN1:
        MOVX    A,@DPTR                 ;3-15
        MOV     C,ACC.0                 ;3-15
        ORL     C,ACC.1                 ;3-15
        MOV     ACC.0,C                 ;3-15 BIT0 (DCS)= BIT0 ^ BIT1  (PRE-DCS)
        CLR     ACC.1                   ;3-15
S_WDLN2:RET
;=====================================================
; SET_DCSW - SET DCS FAX SPEED FROM HOST REQUEST
; NOT USED NOW --
;=====================================================
;
; SET_DCSW:
;         MOV     DPTR,#FAX_SPD
;         MOVX    A,@DPTR
;         CJNE    A,#4H,DCS_N24
;         MOV     DPTR,#FD_DCS+5
;         MOVX    A,@DPTR
;         CLR     ACC.2
;         CLR     ACC.3           ;SET UP 2400BPS
;         SJMP    DCS_100
; DCS_N24:
;         MOV     DPTR,#FD_DCS+5
;         CJNE    A,#6H,DCS_N72
;         MOVX    A,@DPTR
;         SETB    ACC.3
;         SETB    ACC.2           ;SET UP 7200BPS
;         SJMP    DCS_100
; DCS_N72:
;         MOVX    A,@DPTR
;         JNC     DCS_96
;         SETB    ACC.3           ;SET UP 4800BPS
;         CLR     ACC.2
;         SJMP    DCS_100
; DCS_96:
;         SETB    ACC.2           ;SET UP 9600BPS
;         CLR     ACC.3
; DCS_100:
;         MOVX    @DPTR,A
;         RET
;
;=====================================================
; SUBROUTINE FOR TEST TRAINING EQUALIZER
;=====================================================
;
SND_TCF:
;2-27-91        MOV     A,#23           ;DELAY 75MS
;2-27-91        LCALL   WAIT_3MS
;2-27-91        LCALL   TX_SPD
   	   LCALL   TX_SPD          ;2-27-91
;508S
                MOV     A,#50           ;DELAY 75MS
;508T
        LCALL   WAIT_3MS        ;2-27-91
        MOV     DPTR,#5         ;2-27SET EPT TONE
        MOVX    A,@DPTR         ;2-27
;508S
                CLR     ACC.3
;508T
        MOVX    @DPTR,A         ;2-27
STCF10: LCALL   SET_RTS
        MOV     DPTR,#4
        MOVX    A,@DPTR
        CJNE    A,#10H,CHK_TCF27
CHK_TCF27:
        JNC     TCF_29B
        MOV     A,#00
        LCALL   W_PDATA
        SJMP    TCF_COM
;508S
;
; WAIT 100MS TO RESET SCRLOT,SCRHIT
;
TCF_29B:
        LCALL   SET_SCREG       ;3-15-91CLEAR SCRLOT,SCRHIT IN XR2901
        LCALL   CHK_CTS         ;3-15
;
;
; SETUP DELAY FOR 1.5 SECONDS TO SEND FAX DATA
;
TCF_COM:
        MOV     A,#00
        LCALL   W_PDATA
;2-27-91        MOV     TIM_2,#16D              ;SET UP 1.6 SECONS FOR TRAINING
;508S
                MOV     TIM_2,#20D              ;SET UP 1.6 SECONS FOR TRAINING
  ;              MOV     TIM_2,#17D              ;SET UP 1.6 SECONS FOR TRAINING
;508T
        MOV     TIM_2P,#30              ;
        SETB    TIM_2F
SND_T01:
        LCALL   CHK_MDA0
        JB      TIM_2F,SND_T01
        MOV     DPTR,#5         ;2-27-91 SET EPT TONE
        MOVX    A,@DPTR         ;2-27
        CLR     ACC.3           ;2-27
        MOVX    @DPTR,A         ;2-27
;       LCALL   CLR_RTS
        LJMP    CLR_RTS
        RET

;
;=====================================================
; SUBROUTINE FOR TEST TRAINING EQUALIZER
;=====================================================
;
SND_TCFA:
        MOV     A,#23           ;DELAY 75MS
        LCALL   WAIT_3MS
        LCALL   SET_FSPD
STCFA10:
        LCALL   SET_RTS
        MOV     A,#0FFH
        LCALL   W_PDATA
;
; SETUP DELAY FOR 1.5 SECONDS TO SEND FAX DATA
;
        MOV     TIM_2,#30       ;SET UP 1.2 SECONS FOR TRAINING
        MOV     TIM_2P,#100
        SETB    TIM_2F
;
SND_TA01:
        JB      TIM_2F,SND_TA01
;       LCALL   CLR_RTS
        LJMP    CLR_RTS
        RET
;
;=========================================================
; SEND FAX DATA
;=========================================================
;
SND_FDAT:
        LCALL   TX_SPD
        LCALL   SET_RTS
        MOV     A,#0FFH         ;WRITE 0FFH TO MODEM
        LCALL   W_PDATA
        MOV     DPTR,#4         ;CHECK V.27 MODE
        MOVX    A,@DPTR
        CJNE    A,#10H,CHK_F27B
CHK_F27B:
        JC      FSPD_COM        ;IF V.27 DON'T RESET SCRAM
        LCALL   SET_SCREG       ;3-15-91 FOR DSP
FSPD_COM:
        LCALL   CHK_CTS         ;3-15-91
;
; SETUP DELAY FOR 1.5 SECONDS TO SEND FAX DATA
;
        MOV     TIM_2,#30       ;SET UP 1.2 SECONS FOR TRAINING
        MOV     TIM_2P,#15      ;SENDING PAGE CARRIER ?
        SETB    TIM_2F
SND_M00:
        JB      TIM_2F,SND_M00
        MOV     DPTR,#DEBUG_S
        MOVX    A,@DPTR
        JNZ     SND_M10
        RET
;
; SETUP DELAY FOR 1.5 SECONDS TO SEND FAX DATA
;
SND_M10:
        MOV     TIM_2,#30       ;SET UP 12 SECONS FOR TRAINING
        MOV     TIM_2P,#100
        SETB    TIM_2F
SND_M01:
        LCALL   CHK_MDA0
        MOV     A,#0AAH
        LCALL   W_PDATA
        JB      TIM_2F,SND_M01
;       LCALL   CLR_RTS
        LJMP    CLR_RTS
        RET
;3-15-91 -- begin
; WAIT 100MS TO RESET SCRLOT,SCRHIT
;
SET_SCREG:
        MOV     DPTR,#4         ;CHECK MODSEL
        MOVX    A,@DPTR
        CJNE    A,#10H,CHK_V29M
CHK_V29M:
        JC      NOT_V29M        ;IF V.27 MODE, NO RESET
        MOV     A,#0FFH
        LCALL   W_PDATA
        MOV     A,#35           ;WAIT 100MS
        LCALL   WAIT_3MS
        MOV     B,#5CH          ;SET TARGET ADDRESS
        MOV     R4,#00
        MOV     R5,#00
        LCALL   W_MEMORYA
        MOV     B,#5DH          ;SET TARGET ADDRESS
        MOV     R4,#00
        MOV     R5,#00
        LCALL   W_MEMORYA
        LCALL   SET_PDM
NOT_V29M:
        RET
;
;
CHK_CTS:
        MOV     DPTR,#08
        MOVX    A,@DPTR
        JB      ACC.6,CHK_CTS
        RET
;3-15-91 -- end
;
CTSON:
        CLR     EIACTS
EIAOUT: MOV     A,EIA
;9-3-91
        MOV     DPTR,#LATCH
;        MOV     DPTR,#LATCH1
;9-3-91
        MOVX    @DPTR,A
        RET
CTSOFF:
        SETB    EIACTS
        SJMP    EIAOUT
;
CXR_ON:
        CLR     EIACXR
        SJMP    EIAOUT
CXR_OFF:
        SETB    EIACXR
        SJMP    EIAOUT
;
;##########################################################
; INITIALIZATION FOR FAX PROGRAM
;
;##########################################################
;
BK_AT:
        LCALL   ON_HOOK
        LCALL   CTSON
        MOV     DPTR,#MSG_NCAR
        LCALL   SND_RESULT
        CLR     A               ;STATUS 0
        MOVX    @DPTR,A
        SJMP    P_RAM           ;BRING BACK ALL RAM
B_RAM:
        MOV     A,R0            ;BACKUP AT BUFFER
        MOV     DPTR,#SAV_RAM   ;FROM 9F00H TO 9F80H
        MOVX    @DPTR,A
        MOV     B,#7FH
        MOV     R0,#NULL
SAV:    INC     DPTR
        INC     R0
        MOV     A,@R0
        MOVX    @DPTR,A
        DJNZ    B,SAV
        RET
P_RAM:  MOV     DPTR,#SAV_RAM   ;RECOVER AT BUFFER
        MOV     B,#7FH
        MOV     R0,#NULL
DUMP:   INC     DPTR
        INC     R0
        MOVX    A,@DPTR
        MOV     @R0,A
        DJNZ    B,DUMP          ;ALL 127 BYTES
        LCALL   SET_24B
        LJMP    DISCONNECT      ;NO CARRIER
;
;===============================================
; SET MODEM TRANSMIT SPEED ACCORDING TO REQUEST
;===============================================
;
TX_SPD:
        MOV     DPTR,#FD_DCS+5  ;GET SPEED INDICATOR
        MOVX    A,@DPTR
TRXS_COM:
        ANL     A,#0CH
        JZ      TXS24
        CJNE    A,#08H,TXS00
        LCALL   SET_B48
        SJMP    TXS100
TXS00:  JC      TXS96
        LCALL   SET_B72
        SJMP    TXS100
TXS96:  LCALL   SET_B96
        SJMP    TXS100
TXS24:  LCALL   SET_B24
TXS100: RET
;
;===============================================
; SET MODEM RECEIVE SPEED ACCORDING TO REQUEST
;===============================================
;
RX_SPD:
        MOV     A,FAX_S1        ;GET SPEED INDICATOR
        SJMP    TRXS_COM
;
;
;=================================================
; SNED MODEM CONNECT SPEED MESAGE AT TRANSMITTER
;=================================================
;
;7-10-91TX_CONMSG:
;        MOV     DPTR,#FD_DCS+5  ;GET SPEED INDICATOR
;        MOVX    A,@DPTR
;TRXCM_COM:
;        ANL     A,#0CH
;        JZ      TXCM24
;        CJNE    A,#08H,TXCM00
;        MOV     DPTR,#MSG_48F
;        SJMP    TXCM100
;TXCM00: JC      TXCM96
;        MOV     DPTR,#MSG_72F
;        SJMP    TXCM100
;TXCM96: MOV     DPTR,#MSG_96F
;        SJMP    TXCM100
;TXCM24: MOV     DPTR,#MSG_24F
;TXCM100:
;       LCALL   SND_RESULT
;        LJMP    SND_RESULT
;        RET
;
;===============================================
; CHK_FED : DETECT ENERGY FROM FAR END
;===============================================
;
CHK_FED:
;3-15-91        MOV     TIM_2,#50       ;SET 5 SECONDS TIME OUT
        MOV     TIM_2,#30       ;SET 3 SECONDS TIME OUT
        MOV     TIM_2P,#30
        SETB    TIM_2F
        CLR     PASS
CHK_F02:
        MOV     TIM_4,#33       ;DETECT ENERGY FOR 100MS
        SETB    TIM_4F
CHK_F02A:
        JNB     TIM_4F,CHK_F00
        LCALL   R_FED
        JC      CHK_F02A
        JNB     TIM_2F,CHK_F04
        SJMP    CHK_F02
CHK_F00:
        SETB    PASS
CHK_F04:
        RET
;
;===============================================
;
; CHK_PNDET : CHECK PN DETECTOR FOR TRAINING
;===============================================
;
CHK_PNDET:
        MOV     TIM_2,#50       ;7-20-90SET 5 SECONDS TIME OUT
        MOV     TIM_2P,#30
        SETB    TIM_2F
        CLR     PASS
CHK_D02:
        MOV     TIM_4,#33       ;DETECT ENERGY FOR 100MS
        SETB    TIM_4F
CHK_D02A:
        JNB     TIM_4F,CHK_D00
        LCALL   RD_PNDET
        JC      CHK_D02A
        JNB     TIM_2F,CHK_D04
        SJMP    CHK_D02
CHK_D00:
        SETB    PASS
        LCALL   R_PDATA
CHK_D04:
        RET
;
;===============================================
; SNED MODEM CONNECT SPEED MESAGE AT RECEIVER
;===============================================
;
;7-10-91RX_CONMSG:
;        MOV     A,FAX_S1        ;GET SPEED INDICATOR
;        SJMP    TRXCM_COM

;==========================================
; SET MODEM SPEED ACCORDING TO 'FSPD'
;==========================================
;
SET_FSPD:
        MOV     DPTR,#FSPD
        MOVX    A,@DPTR         ;CHECK THE DESIRED SPEED
        ANL     A,#03
        CJNE    A,#0,SF_000
        LCALL   SET_B96
        SJMP    SF_100
SF_000: CJNE    A,#1,SF_010
        LCALL   SET_B72
        SJMP    SF_100
SF_010: CJNE    A,#2,SF_020
        LCALL   SET_B48
        SJMP    SF_100
SF_020: CJNE    A,#3,SF_100
        LCALL   SET_B24
SF_100: RET
;
;==========================================
; SEND OUT DATA TO TERMINAL
;==========================================
;
SND_OUT:
        LCALL   CHK_MDA0
        MOV     A,OUTBT
        LCALL   W_PDATA
SND000: RET
;
;=============================================
; SWAP RECEIVING DATA FOR BITFAX
;=============================================
;
DAT_BOR:
        PUSH    23H
        MOV     23H,A
        MOV     DPTR,#OPT_FAX
        MOVX    A,@DPTR
;3-15-91        JB      ACC.3,N00    ;3-15-91 MING JUMP IF +FBOR=1
        JNB     ACC.3,REV_BIT   ;3-15-91 MING JUMP IF +FBOR=1
        MOV     A,23H           ;3-15-91 MING
        SJMP    NSB00           ;3-15-91 MING
REV_BIT:                        ;3-15-91 MING
        CLR     A
        JNB     23H.0,NSB6
        SETB    ACC.7
NSB6:   JNB     23H.1,NSB5
        SETB    ACC.6
NSB5:   JNB     23H.2,NSB4
        SETB    ACC.5
NSB4:   JNB     23H.3,NSB3
        SETB    ACC.4
NSB3:   JNB     23H.4,NSB2
        SETB    ACC.3
NSB2:   JNB     23H.5,NSB1
        SETB    ACC.2
NSB1:   JNB     23H.6,NSB0
        SETB    ACC.1
NSB0:   JNB     23H.7,NSB00
        SETB    ACC.0
        SJMP    NSB00           ;DAVID 3-15-91
N00:    MOV     A,23H           ;DAVID 3-15-91
NSB00:  POP     23H
        RET
;
;==========================================
; SEND OUT DATA TO TERMINAL
;==========================================
;
SND_OUTB:
;12-18-90       MOV     DPTR,#DEBUG_F
;12-18  MOVX    A,@DPTR
;12-18  JZ      SNDB000
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        JNB     ACC.4,SNDB000   ;12-18 JUMP IF +FBUG=0
        MOV     A,OUTPUT_B
        LCALL   SND_HEX
        MOV     A,#' '
        LCALL   PUT_CHAR
SNDB000:
        RET
;
;==========================================
; SEND OUT DATA TO TERMINAL
; DEBUG_F = 0, - QUIET
;           1, - SEND HEX DATA TO TERMINAL
;==========================================
;
SND_OUTR:
        MOV     R3,A
;12-18-90       MOV     DPTR,#DEBUG_F
;12-18  MOVX    A,@DPTR
;12-18  JZ      SNDR000         ;IF DEBUG_F = 0, RETURN
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        JNB     ACC.4,SNDB000   ;12-18 JUMP IF +FBUG=0
SNDR05: MOV     A,R3
        LCALL   SND_HEX
        MOV     A,#' '
        LCALL   PUT_CHAR
        DJNZ    DIS_CNT,SND000
        MOV     DIS_CNT,#16
        LCALL   V_CRLF
SNDR000:
        RET
;
;==========================================
; SEND OUT DATA TO TERMINAL
; DEBUG_F = 0, - SEND REAL DATA
;           1, - SEND HEX DATA TO TERMINAL
;           2, - QUIT
;==========================================
;
SND_OUTRF:
        MOV     R3,A
;<DLE> INSERATION
       CJNE    A,#10H,SND_O1
       MOV     A,#10H
       LCALL   PUT_DATA        ;PUT WHOLE DATA TO SERIAL PORT
SND_O1:
        MOV     DPTR,#DEBUG_F
        MOVX    A,@DPTR
        JZ      SNDRF10         ;IF DEBUG_F = 0, SEND REAL DATA
        CJNE    A,#1,SNDRF00    ;IF DEBUG_F NOT = 1, RETURN
        MOV     A,R3            ;DEBUG_F = 1, SEND HEX
        LCALL   SND_HEX
        MOV     A,#' '
        LCALL   PUT_CHAR
        DJNZ    DIS_CNT,SNDRF00
        MOV     DIS_CNT,#16
        LCALL   V_CRLF
SNDRF00:
        RET
SNDRF10:
        MOV     A,R3
;       LCALL   PUT_DATA        ;PUT WHOLE DATA TO SERIAL PORT
        LJMP    PUT_DATA        ;PUT WHOLE DATA TO SERIAL PORT
        RET
;
V_ANSDET:
        MOV     DPTR,#MSG_CED
;       LCALL   SND_RESULT
        LJMP    SND_RESULT
        RET
;
;==================================================
;
; STORE FAX T.30 SESSION PARAMETER IN RAM
;==================================================
LOD_SESS:
        MOV     R0,#4
        MOV     R1,#9           ;INCLUDE MINSP
        MOV     DPTR,#FD_SESS
LD_S0:
        INC     R0
        MOV     A,R0
        MOVC    A,@A+PC
        MOVX    @DPTR,A
        INC     DPTR
        DJNZ    R1,LD_S0
        RET
DCC:
;       DB      '00000000',0H           ;12-12-90
        DB      '03020005',0H           ;12-18-90
;FOR FUTHER USE         DB      '03020005',0H
;==================================================
; STORE FAX PARAMETER IN RAM
;==================================================
;
FAXD_INIT:
        LCALL   LOD_SESS        ;
        LCALL   SET_PDM
;10-29-90       LCALL   B_RAM           ;PUT ALL AT REG INTO RAM
        MOV     DPTR,#MEOP
        MOV     R0,#4
        MOV     R1,#67
FAX_I00:
        INC     R0
        MOV     A,R0
        MOVC    A,@A+PC
        MOVX    @DPTR,A
        INC     DPTR
        DJNZ    R1,FAX_I00
        RET
;
DCS:
        DB      07H,0FFH,13H,83H,00H,06H,88H,00H
DIS:
        DB      07H,0FFH,13H,80H,00H,0EH,88H,00H
CSIA:
        DB      23,0FFH,03H,40H,'333333333  222222222'
CSIS:
        DB      23,0FFH,03H,43H,'333333333  222222222'
TMP:
        DB      03H,0FFH,13H
;
;
;
MSG_ANSDET      DB      'ANSWER TONE DETECTED',0FFH
MSG_CED         DB      'a CED',0FFH
MSG_DIS         DB      '+FDIS:',0FFH
;7-10-91MSG_24F         DB      'c CONNECT 2400/FAX',0FFH
;7-10-91MSG_48F         DB      'd CONNECT 4800/FAX',0FFH
;7-10-91MSG_72F         DB      'e CONNECT 7200/FAX',0FFH
;7-10-91MSG_96F         DB      'f CONNECT 9600/FAX',0FFH
;7-10-91MSG_FAX         DB      'P INCOMING FAX',0FFH
MSG_CON         DB      'f CONNECT',0FFH        ;
MSG_FCSI        DB      '+FCSI:',0FFH          ;
MSG_FTSI        DB      '+FTSI:',0FFH          ;
MSG_FNSF        DB      '+FNSF:',0FFH          ;
MSG_FHR         DB      '+FHR: ',0FFH          ;
MSG_FHT         DB      '+FHT: ',0FFH          ;
MSG_CFR         DB      'h +FCFR',0FFH
MSG_FTT         DB      'i FTT',0FFH
MSG_MCF         DB      'j +FTPS: 1',0FFH
MSG_RTN         DB      'k RTN',0FFH
MSG_DCS         DB      '+FDCS:',0FFH
MSG_FET0                DB      'm +FET: 0',0FFH                ;
MSG_FET2                DB      'm +FET: 2',0FFH                ;
MSG_MPS         DB      'n MPS',0FFH
MSG_FHNG00      DB      'o00 +FHNG: 00',0FFH       ;
MSG_FHNG01      DB      'o01 +FHNG: 01',0FFH       ;
MSG_FHNG02      DB      'o02 +FHNG: 02',0FFH       ;
MSG_FHNG10      DB      'o10 +FHNG: 10',0FFH       ;
MSG_FHNG11      DB      'o11 +FHNG: 11',0FFH       ;
MSG_FHNG20      DB      'o20 +FHNG: 20',0FFH       ;
MSG_FHNG25      DB      'o25 +FHNG: 25',0FFH       ;
MSG_FHNG27      DB      'o27 +FHNG: 27',0FFH       ;
MSG_FHNG40      DB      'o40 +FHNG: 40',0FFH       ;
MSG_FHNG50      DB      'o50 +FHNG: 50',0FFH       ;
MSG_FHNG52      DB      'o52 +FHNG: 52',0FFH       ;
MSG_FHNG54      DB      'o54 +FHNG: 54',0FFH       ;
MSG_FHNG70      DB      'o70 +FHNG: 70',0FFH       ;
MSG_FHNG90      DB      'o90 +FHNG: 90',0FFH       ;
MSG_FHNG100     DB      'o100 +FHNG: 100',0FFH       ;
MSG_NCAR        DB      '3 NO CARRIER',0FFH
MSG_FCON        DB      '4 +FCON',0FFH          ;
MSG_ETX         DB      '5 ',10H,03H,0FFH       ;
MSG_FPTS        DB      '6 +FPTS: 1',0FFH         ;
MSG_FPTS_RTN    DB      '7 +FPTS: 1,2,0,0',0FFH         ;
MSG_FPTS_RTP    DB      '8 +FPTS: 1,2,0,0',0FFH         ;
MSG_MFR:        DB      'EXAR',0FFH     ;11-9-90
MSG_MDL:        DB      '9648,2,E,290X',0FFH    ;11-9-90

;
;======================================================
; TRANSMIT ONE FRAME OF HDLC FOR MESSAGE
; INPUT DATA PUT IN #FD_TMP + 3
;======================================================
TX_MSG:
        LCALL   SET_V21
        LCALL   SET_RTS
        MOV     DCETPL,#<FD_TMP
        MOV     DCETPH,#>FD_TMP ;1ST ADDRESS IS 8000H
        LCALL   IN_HDLC
;       LCALL   HDLCTX
        LJMP    HDLCTX
        RET
;
;
;=======================================================;
;        HDLC TX FOR DCE SIDE                           ;
;=======================================================;
;
HDLCTX:
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        JNB     ACC.4,HTX0      ;12-18 JUMP IF +FBUG=0
        MOV     DPTR,#MSG_FHT   ;12-18-90
        LCALL   SND_MSG         ;12-18
HTX0:                           ;12-18
        JB      AFTER_S,STX00   ;IS AFTER SYN CHAR.
        LJMP    SYN_AFT
STX00:  MOV     A,OUTPUT_B              ;ROTATE SYN CHAR OUT
        RRC     A               ;
        MOV     OUTPUT_B,A              ;
        MOV     A,OUTBT
        RRC     A
        MOV     OUTBT,A
        DJNZ    BITC,STX01      ;COMPLETE ONE BYTE
        SETB    NEED_D          ;BUFFER EMPTY
STX01:  DJNZ    BTCNT,STX02
        MOV     BTCNT,#08H
        LCALL   SND_OUT
STX02:  JNB     NEED_D,STX00
        MOV     A,FLG_CNT       ;CHECK 1 SECOND PREAMBLE FINISHED?
        JZ      STX03
        DEC     FLG_CNT
        LCALL   IN_HD2
        SJMP    STX00
STX03:
        JNB     DCE_S,NO_FRM    ;NEED SEND ONE FRAME ?
        MOV     ZERO,#NULL      ;YES PRESET OR RESET ALL FLAGS
        MOV     BITC,#08H       ;
        MOV     STATUS,#NULL
        CLR     AFTER_S         ;
        MOV     CRCH,#0FFH      ; PRESET CRC HIGH OR CRC LOW
        MOV     CRCL,#0FFH
        MOV     DPL,DCETPL      ; GET FIRST BYTE OUT
        MOV     DPH,DCETPH
        MOVX    A,@DPTR         ;
        MOV     BCOUNT,A        ;1ST LOCATION IS BYTE COUNT
        INC     DPTR            ;
        MOVX    A,@DPTR
        INC     DPTR
        MOV     DCETPL,DPL
        MOV     DCETPH,DPH      ;
        MOV     OUTPUT_B,A              ;PUT IT INTO TEMP BUFFER
        CLR     NEED_D
        LCALL   PROC_CRC
        LCALL   SND_OUTB
        SJMP    SYN_AFT
NO_FRM:
        MOV     A,STATUS        ;SEND OUT ANOTHER 7EH
        CJNE    A,#05H,STP_FRM
        LCALL   IN_HD2
        MOV     STATUS,#0
        SJMP    HDLCTX
STP_FRM:
        MOV     BITC,#08H       ;NOTHING HAPPEND
        MOV     DPTR,#DEBUG_F
        MOVX    A,@DPTR
        JNZ     TX_MSG00
        RET
TX_MSG00:
;       LCALL   V_CRLF
        LJMP    V_CRLF
        RET
SP_OUT:
        MOV     A,OUTBT         ;ZERO INSERTION
        CLR     C
        RRC     A
        MOV     OUTBT,A
        MOV     ZERO,#NULL      ;RESET ZERO
        DJNZ    BTCNT,N_INS
        MOV     BTCNT,#08H
        LCALL   SND_OUT
        SJMP    SYN_AFT
B_ENDFRM:
        LJMP    END_FRM
SYN_AFT:
        JB      NEED_D,STX08
        MOV     A,ZERO          ;REACH THRESHOLD ?
        ANL     A,#0F8H
        CJNE    A,#0F8H,N_INS   ;
        SJMP    SP_OUT
N_INS:  MOV     A,OUTPUT_B              ;SEND BUFER BITS OUT
        RRC     A
        MOV     OUTPUT_B,A
        MOV     A,OUTBT
        RRC     A
        MOV     OUTBT,A
        RLC     A               ;UPDATE BIT IN "C"
        MOV     A,ZERO          ;ALSO ,DO NOT FORGET ZERO INSERTION
        RRC     A
        MOV     ZERO,A
        DJNZ    BITC,STX06      ;
        SETB    NEED_D
STX06:  DJNZ    BTCNT,STX07
        MOV     BTCNT,#08H
        MOV     A,OUTBT
        LCALL   SND_OUT
STX07:  JNB     NEED_D,SYN_AFT
STX08:  MOV     A,STATUS        ;NO COUNT DOWN FOR END OF FRAME
        JNZ     END_FRM
        DJNZ    BCOUNT,NOT_F    ;FINISH ALL ?
NO_LNK: MOV     STATUS,#ONE
        LJMP    END_FRM
NOT_F
        LCALL   GET_B
        MOV     OUTPUT_B,A              ;
        CLR     NEED_D
        MOV     BITC,#08H
        LCALL   PROC_CRC                ;DO NOT FORGET CRC
        LCALL   SND_OUTB
        LJMP    SYN_AFT
END_FRM:
        MOV     A,STATUS
        CJNE    A,#ONE,CRC_2
        MOV     A,CRCH          ;MOV CRC_H TO SEND
        CPL     A               ;1'S COMPLEMENT CRC_H
        MOV     OUTPUT_B,A
        MOV     BITC,#08H
        CLR     NEED_D
        MOV     STATUS,#02H     ; NEXT TIME WILL BE CRC LOW
        LCALL   SND_OUTB
        LJMP    SYN_AFT
CRC_2:
        MOV     A,STATUS        ;CRC LOW ?
        CJNE    A,#02H,STOP_SYN
        MOV     A,CRCL          ;YES SEND CRC LOW OUT
        CPL     A               ;1'S COMPLEMENT CRC_L
        MOV     OUTPUT_B,A
        LCALL   IN_HD3
        MOV     STATUS,#04H     ;SNED STOP SYN
        LCALL   SND_OUTB
        LJMP    SYN_AFT
STOP_SYN:
        LCALL   IN_HD4
        CLR     DCE_S
        MOV     STATUS,#05
        MOV     A,ZERO          ;REACH THRESHOLD ?
        ANL     A,#0F8H
        CJNE    A,#0F8H,SYS00   ;
        MOV     A,OUTBT         ;ZERO INSERTION
        CLR     C
        RRC     A
        MOV     OUTBT,A
        MOV     ZERO,#NULL      ;RESET ZERO
        DJNZ    BTCNT,SYS00
        MOV     BTCNT,#08H
        LCALL   SND_OUT
SYS00:  LJMP    HDLCTX
;
;==============================================================
; RECEIVE HDLC FRAMES FROM MODEM
;==============================================================
RCV_FRAMES:
        MOV     DPTR,#OPT_FAX   ;12-18-90
        MOVX    A,@DPTR         ;12-18
        JNB     ACC.4,RCVF0     ;12-18 JUMP IF +FBUG=0
        MOV     DPTR,#MSG_FHR   ;12-18-90
        LCALL   SND_MSG         ;12-18
RCVF0:                          ;12-18
        LCALL   R_INIT
        LCALL   SET_T2

RCVF00:
        LCALL   CHK_MDAB        ;
        JC      CHK_M3          ;
        JB      TIM_2F,RCVF00   ;
        SJMP    RCVF02          ;
CHK_M3:                         ;
        LCALL   R_PDATA

;
        LCALL   HDLCRX
        JNB     GOT_FRM,RCVF00  ;CONTINUE, IF NOT RECEIVED COMPLETE.
        MOV     A,ER_ST ;CHECK CORRECT FRAME
        JNZ     RCVF05
        LCALL   FR_ROT
        MOV     DPTR,#RV_1ST+1  ;CHECK LAST FRAME
        ADD     A,DPL
        MOV     DPL,A           ;ADD OFFSET TO CHECK 13H
        MOVX    A,@DPTR
        CJNE    A,#FF_CTL_F,RCVF01
        INC     DPL
        MOVX    A,@DPTR
        MOV     INF_DAT,A       ;FCF OF HDLC
RCVF02:
        RET
RCVF05:
        LCALL   R_FED
;11-9-90        JC      RCVF01          ;IF ENERGY EXIST, THEN GO ON
        JC      RCVF05A         ;IF ENERGY EXIST, THEN GO ON
        CLR     TIM_2F          ; ACT AS TIME OUT
        SJMP    RCVF02          ;
RCVF05A:                        ;11-9-90
        DEC     FRAME_CNT       ;11-9-90 COMPENSATE FRAME_CNT INCREMENT IN RCVF01
                                ;DURING FRAME ERROR RECEPTION
        SJMP    RF01            ;3-15-91
RCVF01:
        CJNE    A,#NFF_CTL_F,RF01;3-15-91
        INC     DPTR             ;3-15
        MOVX    A,@DPTR          ;3-15 FCF
        CJNE    A,#F_NSF,RF01    ;3-15
;        MOV     NSF_BYCNT,BYCNT  ;3-15
        MOV     NSF_BYCNT,NSF_TMPB      ;7-10-91
        INC     FRAME_CNT        ;3-15 ADD ONE MORE 32-BYTE FOR NSF RCV FRAME
RF01:                            ;3-15
        MOV     DIS_CNT,#16
        MOV     A,FRAME_CNT
        CLR     GOT_FRM
        MOV     A,BYCNT
        INC     FRAME_CNT
        LCALL   FR_ROT
        MOV     DCERPL,#<RV_1ST ;PRESET FOR NEXT BUFFER
        MOV     DCERPH,#>RV_1ST
        ADD     A,DCERPL
        MOV     DCERPL,A
        SJMP    RCVF00
;
;*******************************************************;
;       RECEIVED DATA FROM LINE                         ;
;*******************************************************;
;
SRX01:  JNB     NEED_DR,SRX00   ;
        RET
HDLCRX:
        MOV     RXTEMP,A
        MOV     BIRCNT,#08H
        CLR     NEED_DR
;
;=======================================================;
;       RECEIVER SYNC MODE                                      ;
;=======================================================;
;
        JNB     AFT_SYN,SRX00   ; IS AFTER SYN CHAR.
        JB      R_READY,SYN_ST0 ;STARTING OF NEXT FRAME
        LJMP    AFT_STAR
SRX00:  MOV     A,RXTEMP
        RRC     A
        MOV     RXTEMP,A
        MOV     A,BUFF
        RRC     A
        MOV     BUFF,A
        DJNZ    BIRCNT,SRX02
        SETB    NEED_DR
        MOV     BIRCNT,#08H
SRX02:  CJNE    A,#7EH,SRX01    ;NO, CHECK SYN CHAR.
SYN_ST:
;       LCALL   SND_OUTR
SYN_ST0:
        LCALL   PRE_HDLC
        SJMP    SRX06
AFT_STAR:
        MOV     A,RXTEMP
        RRC     A
        MOV     RXTEMP,A
        MOV     A,BUFF
        RRC     A
        MOV     BUFF,A
        DJNZ    BIRCNT,SRX05
        SETB    NEED_DR         ;NEED MORE INPUT DATA
SRX05:  CJNE    A,#0FFH,CHK_7E  ;IS ABORT FLAG ?
        SJMP    RECOVR
SRX06:  JNB     NEED_DR,AFT_STAR ;STILL HAS DATA AVAILABLE?
        RET
CHK_7E:
        CJNE    A,#07EH,CHK_7C  ;IS STILL SYN CHARACTER ?
        LJMP    STP_SYN         ;
CHK_7C:
        ANL     A,#0FCH         ;CHECK IF NEED ZERO INSERTION ?
        CJNE    A,#7CH,NORM_IN
        MOV     BUFF,#NULL
        LJMP    SRX06
RECOVR:
        CLR     AFT_SYN         ;ABORT HERE !
        MOV     BICNT,#08H      ;
        MOV     BUFF,#NULL      ;
        LJMP    HDLCRX
NORM_IN:
        MOV     A,BUFF          ;ROTATE A BIT INTO INPUT BUFFER
        RLC     A
        MOV     A,INPUT_B
        RRC     A
        MOV     INPUT_B,A
        DJNZ    BICNT,SRX06     ;GOT ONE BYTE ?
        LCALL   PROC_CRC
        MOV     A,INPUT_B
        LCALL   STOR_B
        LCALL   SND_OUTR
        MOV     A,BYCNT         ;
        ADD     A,#ONE          ;
        MOV     BYCNT,A         ;
        CLR     AFT_FR
        MOV     BICNT,#08H
        CLR     R_READY
        LJMP    SRX06
STP_SYN:
        JNB     AFT_FR,STOP_FRM
        LJMP    SYN_ST
STOP_FRM:
        MOV     NSF_TMPB,BYCNT  ;7-10-91 PREVENT BYCNT CLR BY PRE_HDLC
        MOV     BUFF,#NULL
        SETB    GOT_FRM         ;FINALLY GOT ONE FRAME
        CLR     AFT_SYN
        MOV     A,CRCH
        CJNE    A,#0B8H,ERROR   ;CRC HIGH IS 0B8H ?
        MOV     A,CRCL
        CJNE    A,#0F0H,ERROR   ;CRC LOW IS 0F0H ?
        JNB     RCV_DF,OK_FRM
OK_FRM:                         ;NO ERROR AND COMPLETE ONE FRAME
        CLR     RCV_DF
        MOV     ER_ST,#NULL
        LJMP    SRX10
ERROR:
        MOV     ER_ST,#ONE
;       LJMP    SYN_ST
SRX10:
        JB      NEED_DR,SRX11
        LJMP    SYN_ST
SRX11:
        LCALL   SND_OUTR
        SETB    R_READY
        RET
;
IN_HDLC:
        MOV     BTCNT,#08H
IN_HD1:
        MOV     FLG_CNT,#38
IN_HD4:
        SETB    AFTER_S
        SETB    DCE_S
IN_HD2:
        MOV     OUTPUT_B,#7EH   ;MOV 1ST "7E".
IN_HD3:
        MOV     BITC,#08H
        CLR     NEED_D
        RET
R_INIT:
        MOV     DCERPL,#<RV_1ST ;PRESET BUFFER POINTER
        MOV     DCERPH,#>RV_1ST
        CLR     AFT_SYN
        CLR     R_READY
        CLR     GOT_FRM
        MOV     FRAME_CNT,#00
        RET
FR_ROT:
        MOV     A,FRAME_CNT
FR_ROT1:
        RL      A
        RL      A
        RL      A
        RL      A
        RL      A
        RET
SET_T2:
        MOV     TIM_2P,#30      ;
        SETB    TIM_2F          ;
        RET
STOR_B:
        MOV     DPL,DCERPL      ;STORE INTO DATA BUFFER
        MOV     DPH,DCERPH      ;
        MOVX    @DPTR,A         ;
        INC     DPTR            ;
        PUSH    ACC             ;
        MOV     A,DPH           ;
        CJNE    A,#92H,NOT_S1   ; NOT TO OVERLAP 9200 (AT CMD STORE BUFFER)
        MOV     DCERPL,#<RV_1ST ;PRESET BUFFER POINTER
        MOV     DCERPH,#>RV_1ST ;
        LJMP    NOT_S2          ;
NOT_S1:                         ;
        MOV     DCERPH,DPH      ;
        MOV     DCERPL,DPL      ;
NOT_S2:                         ;
        POP     ACC             ;
        RET
GET_B:
        MOV     DPL,DCETPL      ;GET NEXT BYTE OUT
        MOV     DPH,DCETPH
        MOVX    A,@DPTR
        INC     DPTR
        MOV     DCETPL,DPL
        MOV     DCETPH,DPH
        RET
PRE_HDLC:
        MOV     BUFF,#NULL      ;
        SETB    AFT_FR
        SETB    AFT_SYN         ; SYNC ALREADY GOT
        MOV     CRCH,#0FFH      ; PRESET CRC WORD
        MOV     CRCL,#0FFH
        MOV     INPUT_B,#NULL
        MOV     BICNT,#08H      ;PRESET BIT COUNT
        MOV     BYCNT,#NULL     ;NO BYTE IN YET
        CLR     R_READY         ;CLEAR RXDATA AVAILABLE
        CLR     RCV_DF          ;FIRST TIME NO DATA BUFFER
        RET
;
;2-27-91
        IFTRUE  JCM
TX_FEQ:
        PUSH    REG_0
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#JS2
        SJMP    S_EQ

RX_FEQ:
        PUSH    REG_0
        PUSH    DPL
        PUSH    DPH
        MOV     DPTR,#JS1
S_EQ:   MOVX    A,@DPTR
        SWAP    A
        ANL     A,#70H
        MOV     R0,A
        MOV     B,#0DH
        LCALL   RD0_CNTL
        ANL     A,#8FH
        ORL     A,R0
        MOV     B,#0DH
        LCALL   WR0_CNTL
        POP     DPH
        POP     DPL
        POP     REG_0
        RET
        ENDIF
;
;********************************************************************
;
;       TABLE LOOKUP FOR CRC-CCITT (X^16 + X^12 + X^5 +1)
;
;********************************************************************
;
PROC_CRC:
        XRL     A,CRCH
        MOV     TEMP_C,A
        MOV     DPTR,#CRCTBH
        MOVC    A,@A+DPTR
        MOV     TEMP_B,CRCL
        MOV     CRCL,A
        MOV     DPTR,#CRCTBL
        MOV     A,TEMP_C
        MOVC    A,@A+DPTR
        XRL     A,TEMP_B
        MOV     CRCH,A
        RET
;
;====================================================================
;       CRC-16 HIGH BYTE
;====================================================================
;
CRCTBH: DB      000H,011H,023H,032H,046H,057H,065H,074H
        DB      08CH,09DH,0AFH,0BEH,0CAH,0DBH,0E9H,0F8H
        DB      010H,001H,033H,022H,056H,047H,075H,064H
        DB      09CH,08DH,0BFH,0AEH,0DAH,0CBH,0F9H,0E8H
        DB      021H,030H,002H,013H,067H,076H,044H,055H
        DB      0ADH,0BCH,08EH,09FH,0EBH,0FAH,0C8H,0D9H
        DB      031H,020H,012H,003H,077H,066H,054H,045H
        DB      0BDH,0ACH,09EH,08FH,0FBH,0EAH,0D8H,0C9H
        DB      042H,053H,061H,070H,004H,015H,027H,036H
        DB      0CEH,0DFH,0EDH,0FCH,088H,099H,0ABH,0BAH
        DB      052H,043H,071H,060H,014H,005H,037H,026H
        DB      0DEH,0CFH,0FDH,0ECH,098H,089H,0BBH,0AAH
        DB      063H,072H,040H,051H,025H,034H,006H,017H
        DB      0EFH,0FEH,0CCH,0DDH,0A9H,0B8H,08AH,09BH
        DB      073H,062H,050H,041H,035H,024H,016H,007H
        DB      0FFH,0EEH,0DCH,0CDH,0B9H,0A8H,09AH,08BH
        DB      084H,095H,0A7H,0B6H,0C2H,0D3H,0E1H,0F0H
        DB      008H,019H,02BH,03AH,04EH,05FH,06DH,07CH
        DB      094H,085H,0B7H,0A6H,0D2H,0C3H,0F1H,0E0H
        DB      018H,009H,03BH,02AH,05EH,04FH,07DH,06CH
        DB      0A5H,0B4H,086H,097H,0E3H,0F2H,0C0H,0D1H
        DB      029H,038H,00AH,01BH,06FH,07EH,04CH,05DH
        DB      0B5H,0A4H,096H,087H,0F3H,0E2H,0D0H,0C1H
        DB      039H,028H,01AH,00BH,07FH,06EH,05CH,04DH
        DB      0C6H,0D7H,0E5H,0F4H,080H,091H,0A3H,0B2H
        DB      04AH,05BH,069H,078H,00CH,01DH,02FH,03EH
        DB      0D6H,0C7H,0F5H,0E4H,090H,081H,0B3H,0A2H
        DB      05AH,04BH,079H,068H,01CH,00DH,03FH,02EH
        DB      0E7H,0F6H,0C4H,0D5H,0A1H,0B0H,082H,093H
        DB      06BH,07AH,048H,059H,02DH,03CH,00EH,01FH
        DB      0F7H,0E6H,0D4H,0C5H,0B1H,0A0H,092H,083H
        DB      07BH,06AH,058H,049H,03DH,02CH,01EH,00FH
;
;================================================================
;      CRC-16 LOW BYTE
;================================================================
;
CRCTBL: DB      000H,089H,012H,09BH,024H,0ADH,036H,0BFH
        DB      048H,0C1H,05AH,0D3H,06CH,0E5H,07EH,0F7H
        DB      081H,008H,093H,01AH,0A5H,02CH,0B7H,03EH
        DB      0C9H,040H,0DBH,052H,0EDH,064H,0FFH,076H
        DB      002H,08BH,010H,099H,026H,0AFH,034H,0BDH
        DB      04AH,0C3H,058H,0D1H,06EH,0E7H,07CH,0F5H
        DB      083H,00AH,091H,018H,0A7H,02EH,0B5H,03CH
        DB      0CBH,042H,0D9H,050H,0EFH,066H,0FDH,074H
        DB      004H,08DH,016H,09FH,020H,0A9H,032H,0BBH
        DB      04CH,0C5H,05EH,0D7H,068H,0E1H,07AH,0F3H
        DB      085H,00CH,097H,01EH,0A1H,028H,0B3H,03AH
        DB      0CDH,044H,0DFH,056H,0E9H,060H,0FBH,072H
        DB      006H,08FH,014H,09DH,022H,0ABH,030H,0B9H
        DB      04EH,0C7H,05CH,0D5H,06AH,0E3H,078H,0F1H
        DB      087H,00EH,095H,01CH,0A3H,02AH,0B1H,038H
        DB      0CFH,046H,0DDH,054H,0EBH,062H,0F9H,070H
        DB      008H,081H,01AH,093H,02CH,0A5H,03EH,0B7H
        DB      040H,0C9H,052H,0DBH,064H,0EDH,076H,0FFH
        DB      089H,000H,09BH,012H,0ADH,024H,0BFH,036H
        DB      0C1H,048H,0D3H,05AH,0E5H,06CH,0F7H,07EH
        DB      00AH,083H,018H,091H,02EH,0A7H,03CH,0B5H
        DB      042H,0CBH,050H,0D9H,066H,0EFH,074H,0FDH
        DB      08BH,002H,099H,010H,0AFH,026H,0BDH,034H
        DB      0C3H,04AH,0D1H,058H,0E7H,06EH,0F5H,07CH
        DB      00CH,085H,01EH,097H,028H,0A1H,03AH,0B3H
        DB      044H,0CDH,056H,0DFH,060H,0E9H,072H,0FBH
        DB      08DH,004H,09FH,016H,0A9H,020H,0BBH,032H
        DB      0C5H,04CH,0D7H,05EH,0E1H,068H,0F3H,07AH
        DB      00EH,087H,01CH,095H,02AH,0A3H,038H,0B1H
        DB      046H,0CFH,054H,0DDH,062H,0EBH,070H,0F9H
        DB      08FH,006H,09DH,014H,0ABH,022H,0B9H,030H
        DB      0C7H,04EH,0D5H,05CH,0E3H,06AH,0F1H,078H
ATF_A:
ATF_B:
ATF_F:
ATF_E:
ATF_T:
ATF_P:
ATF_R:
ATF_J:
ATF_I:
        LJMP    AT_000
        END
