	INCLUDE PAGE.INC
	SUBTTL	VGA BIOS Module D
;****************************************************************
;
;	$Workfile:   vgad.asm  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
;	Contents:
;	This module contains the code for the scroll routines of
;	the VGA BIOS. This includes the scroll for the compatibil-
;	ity modes as well as the extended VGA modes.
;
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgad.asv  $
;      
;         Rev 1.0   21 Dec 1990 11:00:22   Darryl
;      Initial checkin to VCS.
;
;	07/08/89  Speed optimizations made to both Scroll Video
;		  Up and Scroll Video Down.
;
;****************************************************************

	.XLIST
	INCLUDE VGADATA.INC
	.LIST

	%OUT	Assembling VGA BIOS Module D

VGA_Segment SEGMENT PUBLIC WORD

	PUBLIC	Default_VGA_Scroll_Down
	PUBLIC	Default_VGA_Scroll_Up
	PUBLIC	VGA_Scroll_Down			;gdl:12/03/91
	PUBLIC	VGA_Scroll_Up
	PUBLIC	Video_Scroll_Down
	PUBLIC	Video_Scroll_Up

	EXTRN	BIOS_Address:WORD
	EXTRN	Extended_Scroll_Down:NEAR
	EXTRN	Extended_Scroll_Up:NEAR
	EXTRN	Get_Extended_Mode_Info:NEAR
	EXTRN	Get_Current_Mode_Info:NEAR	;gdl:01/14/92

	ASSUME	CS:VGA_Segment
	ASSUME	DS:VGA_Data_Area
	ASSUME	ES:NOTHING

; Temporary stack save variables

AX_Stack_T	EQU	WORD PTR [BP + 00]
AL_Stack_T	EQU	BYTE PTR [BP + 00]
AH_Stack_T	EQU	BYTE PTR [BP + 01]
BX_Stack_T	EQU	WORD PTR [BP + 02]
BL_Stack_T	EQU	BYTE PTR [BP + 02]
BH_Stack_T	EQU	BYTE PTR [BP + 03]

;****************************************************************
;   AH = 06	Scroll active page up
;		CL - Column of scroll upper left
;		CH - Row of scroll upper left
;		DL - Column of scroll lower right
;		DH - Row of scroll lower right
;		BH - Attribute for blanked space
;		AL - Number of lines to scroll
;****************************************************************

;gdl	ALIGN	4

Video_Scroll_Up PROC NEAR
	SUB	SP,4				;Subtract stack space
	MOV	BP,SP				;Set stack mark
	MOV	AX_Stack_T,AX			;Save AX upon entry
	MOV	BX_Stack_T,BX			;Save BX upon entry

	MOV	AX,CX				;Get entry CX
	CMP	Video_Mode,07H			;Test for compatiblity mode
	JBE	Scroll_Active_Up		;Scroll in compatible mode
	CMP	Video_Mode,13H			;Test for mode 13 scroll
	JE	VGA_Scroll_Up			;Yes-Handle mode 13 seperate
	JA	Non_VGA_Scroll_Up		;Are we extended mode

Default_VGA_Scroll_Up:
	JMP	Video_VGA_Scroll_Up		;Perform scroll up

;gdl	ALIGN	4

VGA_Scroll_Up:
	PUSH	DX
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	SHL	DI,1				;Multiply by eight
	SHL	DI,1				;since each character
	SHL	DI,1				;is eight bytes wide
	POP	DX
	MOV	AX,CX
	JMP	VGA_Mode13_Scroll		;Go perform scroll up

Non_VGA_Scroll_Up:
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	MOV	AL,Video_Mode			;Get current video mode
;	CALL	Get_Extended_Mode_Info		;Get info on extended mode
;	JNE	Default_VGA_Scroll_Up		;Go if not supported
	TEST	AL,EVM_Text			;Are we text mode
	MOV	BL,AL				;Save extended mode info
	MOV	AX,CX				;Get entry CX
	JNE	Scroll_Active_Up		;Go handle text mode
	JMP	Extended_Scroll_Up		;Go handled extended scroll up
Video_Scroll_Up ENDP

;****************************************************************
;   AH = 07	Scroll active page down
;		CL - Column of scroll upper left
;		CH - Row of scroll upper left
;		DL - Column of scroll lower right
;		DH - Row of scroll lower right
;		BH - Attribute for blanked space
;		AL - Number of lines to scroll
;****************************************************************

;gdl	ALIGN	4

Video_Scroll_Down PROC NEAR
	SUB	SP,4				;Subtract stack space
	MOV	BP,SP				;Set stack mark
	MOV	AX_Stack_T,AX			;Save AX upon entry
	MOV	BX_Stack_T,BX			;Save BX upon entry

	MOV	AX,CX				;Get CX upon entry
	CMP	Video_Mode,07			;Get video mode byte
	JBE	Scroll_Active_Down		;Scroll in compatible mode
	CMP	Video_Mode,13H			;Are we mode 13
	JE	Mode13_Scroll_Down		;Yes-Go handle mode 13 scroll
	JA	Non_VGA_Scroll_Down		;Go check extended modes

Default_VGA_Scroll_Down:
	JMP	VGA_Scroll_Down 		;Go scroll graphic planar

;gdl	ALIGN	4

Mode13_Scroll_Down:
	JMP	VGA_Mode13_Scroll_Down		;Go scroll mode 13 down

Non_VGA_Scroll_Down:
;gdl:01/14/92
	call	Get_Current_Mode_Info		;Get info on current mode
;	MOV	AL,Video_Mode			;Get current video mode
;	CALL	Get_Extended_Mode_Info		;Get info on extended mode
;	JNE	Default_VGA_Scroll_Down 	;Go if not supported
	TEST	AL,EVM_Text			;Are we text mode
	MOV	BL,AL				;Save extended mode info
	MOV	AX,CX				;Get entry CX
	JNE	Scroll_Active_Down		;Go handle text mode
	JMP	Extended_Scroll_Down		;Go handled extended scroll up
Video_Scroll_Down ENDP

;****************************************************************
;   These routines will scroll up or down in the compatibility modes.
;****************************************************************

Scroll_Active_Down:
	MOV	CX,DX				;Use CX as top on down scroll
	STD					;Move data backwards

Scroll_Active_Up:
	MOV	SI,AX				;Save callers register
	MOV	AL,BYTE PTR Equipment_Installed ;Get equipment installed
	AND	AL,030H 			;Isolate video switches
	CMP	AL,030H 			;Test if monochrome
	MOV	AX,0B000H			;Get monochrome seg address
	JE	Set_TS_Regen_Ptr		;Yes-Go set monochrome seg
	MOV	AH,0B8H 			;Advance to color graphics

Set_TS_Regen_Ptr:
	MOV	ES,AX				;Set video segment address
	MOV	AX,SI				;Restore callers AX
	SUB	DL,AL				;Compute column difference
	SUB	DH,AH				;Compute row difference
	MOV	AL,AL_Stack_T			;Get value from stack
	INC	DL				;Columns are inclusive
	INC	DH				;Rows are inclusive
	MOV	AH,DH				;Get rows to scroll
	OR	AL,AL				;Is row value zero?
	JE	Fill_Only			;Yes-Do fill only
	SUB	AH,AL				;Is rows diff > rows to scroll
	JA	Scroll_and_Fill 		;Go if window > rows to scroll

Fill_Only:
	MOV	AL,DH				;Otherwise clear entire window
	XOR	AH,AH				;Dont scroll any text

Scroll_and_Fill:
	PUSH	AX				;Save scroll and fill rows
	MOV	AH,Video_Mode
	CMP	AH,03H				;Are we in text modes 0 - 3
	JBE	Text_Scroll			;Yes-Go handle text scrolls
	CMP	AH,07H				;Test if in mode 7
	JE	Text_Scroll			;Yes-Go handle text scroll
	CMP	AH,13H				;Test if in extended text mode
	JA	Text_Scroll			;Yes-Go handle text scroll
	JMP	Graphics_Scroll 		;No -Go do graphics scroll

;****************************************************************
;   Text mode scroll
;****************************************************************

;gdl	ALIGN	4

Text_Scroll:
	MOV	BL,AL				;Save rows to fill
	MOV	AL,CH				;Get row number
	MUL	BYTE PTR Video_Columns		;Multiply by column size
	ADD	AL,CL				;Add columns to value
	ADC	AH,00				;Add in any carry
	MOV	DI,Video_Start			;Get the start of the video
	SHR	DI,1				;Remove attribute count
	ADD	DI,AX				;Add rel position to base
	MOV	AL,BL				;AL=Rows to fill
	SHL	DI,1				;Account for attributes
	MOV	SI,DI				;SI will be source for move
						;DI will be source + diff
	MOV	BX,Video_Columns		;Get length of scroll row
	MUL	BL				;Multiply by column size
	PUSH	AX				;Save row fill block size
	SHL	AX,1				;Account for attributes
	SHL	BX,1				;Adjust width for attributes
	CMP	AH_Stack_T,06H			;Test if scroll Up
	JE	Shift_Text_Up			;Yes-AX contains size
	NEG	AX				;Move backwards on
	NEG	BX				;down scroll

Shift_Text_Up:
	MOV	CL,DL				;Get scroll width
	XOR	CH,CH				;Extend to CX
	ADD	SI,AX				;Compute destination address
	MOV	AL,Video_Mode			;Get video mode
	CMP	AL,02				;Are we in 80x25 modes
	JB	Leave_Retrace_On		;No -Dont shut off display
	CMP	AL,03				;Test for 2nd 80x25 mode
	JA	Leave_Retrace_On		;No -Dont shut off display
	TEST	EGA_StatusA,Retrace_Active	;Test for retrace active
	JE	Leave_Retrace_On		;Don't shut off retrace
	MOV	DX,03DAH			;Get video status register

Vertical_Wait:
	IN	AL,DX				;Read status register
	TEST	AL,08H				;Test vertical retrace
	JZ	Vertical_Wait			;Wait - Until there
	SUB	DX,02				;Back up to mode register
	MOV	AL,Video_Mode_Set		;Get current mode set
	AND	AL,0F7H 			;Disable enable video
	OUT	DX,AL				;Turn the screen off

Leave_Retrace_On:
	MOV	AX,ES				;Setup DS to the screen area
	MOV	DS,AX				;Both DS & ES at screen seg
	POP	AX				;Restore fill block size
	POP	DX				;Get scroll & fill values
	CMP	CX,Video_Columns		;Are we scrolling entire window
	JNE	Slow_Text_Scroll		;No -Go scroll line by line
	MOV	BX,AX				;Save fill length
	MOV	AL,CL				;Get window length
	MUL	DH				;Multiply by # of rows
	MOV	CX,AX				;Yes-Get scroll length
	REP	MOVSW				;Move it quickly
	MOV	CX,BX				;Get fill length
	MOV	AL,' '                          ;Fill with blank space
	MOV	AH,BH_Stack_T			;Get screen attribute
	REP	STOSW				;Fill it quickly
	JMP	SHORT Turn_Retrace_On

Slow_Text_Scroll:
	OR	DH,DH				;Any rows to scroll
	JE	Text_Fill_Only			;No -Go do text fill

Scroll_Text_Loop:
	PUSH	CX				;Save scroll length
	PUSH	SI				;Save current row source
	MOV	AX,DI				;Save current row destination
	REP	MOVSW				;Move one line
	MOV	DI,AX				;Restore row destination
	POP	SI				;And row source
	POP	CX				;Restore scroll width
	ADD	SI,BX				;Advance source one row
	ADD	DI,BX				;Advance dest one row
	DEC	DH				;Any rows left to scroll
	JNE	Scroll_Text_Loop		;Yes-Do them

Text_Fill_Only:
	MOV	AL,' '                          ;Fill with blank space
	MOV	AH,BH_Stack_T			;Get screen attribute

Fill_Text_Loop:
	PUSH	CX				;Save scroll width
	PUSH	DI				;Save current fill row
	REP	STOSW				;Clear the row
	POP	DI				;Restore row just filled
	POP	CX				;Restore scroll width
	ADD	DI,BX				;Advance to next row to fill
	DEC	DL				;Any rows left to fill
	JNE	Fill_Text_Loop			;Yes-fill them

Turn_Retrace_On:
	MOV	DS,BIOS_Address 		;Set DS to the BIOS data area
	MOV	AL,Video_Mode			;Get the video mode
	CMP	AL,02				;Were we in modes 2 or 3
	JB	Video_Is_On			;No -Video is still on
	CMP	AL,03				;In modes 2 or 3
	JA	Video_Is_On			;No -Video is still on
	TEST	EGA_StatusA,Retrace_Active	;Test for retrace active
	JE	Video_Is_On			;Already turned on
	MOV	DX,03D8H			;Yes-Get mode register
	MOV	AL,Video_Mode_Set		;Get current mode setting
	OUT	DX,AL				;Enable video display

Video_Is_On:
	ADD	SP,04				;Remove stack frame
	RET

;****************************************************************
;   Graphics mode scroll
;****************************************************************

;gdl	ALIGN	4

Graphics_Scroll:
	CMP	AH,06				;Are we in high res
	JE	One_Bit_Pel			;Yes-pel is only one pixel
	SHL	CL,1				;Mult by 2 since 2 bits/pel
	SHL	DL,1				;Same for scroll width

One_Bit_Pel:
	MOV	SI,DX				;Save window size
	MOV	BL,AL				;Save rows to fill
	MOV	AL,CH				;Get row number
	XOR	AH,AH				;Extend to AX
	MOV	DI,320				;Get length of char line
	MUL	DI				;Compute rows*lines
	ADD	AL,CL				;Add columns to value
	ADC	AH,00				;Add in any carry
	MOV	DI,Video_Start			;Get the start of the video
	ADD	DI,AX				;Add rel position to base
	MOV	AL,BL				;AL=Rows to fill
	XOR	AH,AH				;Extend rows to fill into AX
	MOV	DX,320				;Compute fill size
	MUL	DX				;Multiply row size
	MOV	DX,SI				;Restore register
	PUSH	AX				;Save fill size
	MOV	BX,80				;Line length is always 80
	SUB	BL,DL				;Determine the length of
	SBB	BH,00				;line not in scroll window
	MOV	CH,BH_Stack_T			;Get fill attribute
	CMP	AH_Stack_T,07			;Test for scroll down

; No more accesses from stack, BP is being used !!

	MOV	BP,2000H
	JE	CGA_Scroll_Down 		;Go if CGA scroll down

CGA_Scroll_Up:
	MOV	CL,DL				;Get scroll width
	MOV	SI,DI				;Get offset returned
	ADD	SI,AX				;Set new source for scroll
	POP	AX				;Restore fill block size
	POP	DX				;Get scroll & fill values
	PUSH	CX				;Save fill attribute
	XOR	CH,CH				;Reset high byte
	MOV	AX,ES
	MOV	DS,AX				;Setup segments to video area
	OR	DH,DH				;Any rows to scroll?
	JE	Do_CGA_Up_Fill			;No -Skip the scroll
	SHL	DH,1				;Yes-Multiply by 4
	SHL	DH,1				;4 lines in eack 8K page
	MOV	AX,CX				;Save line length

CGA_Scroll_Up_Loop:
	MOV	CX,AX				;Get line length
	SHR	CX,1				;Save odd byte if any
	REP	MOVSW				;Move words for speed
	RCL	CX,1				;Move odd byte back in
	REP	MOVSB				;Move odd byte if any
	SUB	DI,AX				;Move back to start of line
	SUB	SI,AX				;Move source back to line start
	ADD	SI,BP				;Move to next page
	ADD	DI,BP				;Both source and Dest
	MOV	CX,AX				;Get length of line
	SHR	CX,1				;Save odd byte if any
	REP	MOVSW				;Move words for speed
	RCL	CX,1				;Move odd byte back in
	REP	MOVSB				;Move odd byte if any
	SUB	SI,BP				;Move back to even line
	SUB	DI,BP
	ADD	SI,BX				;Next position
	ADD	DI,BX				;Next dest position
	DEC	DH				;Decrement line counter
	JNE	CGA_Scroll_Up_Loop		;Repeat if lines left
	MOV	CX,AX				;Restore CX with line width

Do_CGA_Up_Fill:
	POP	AX				;Get fill attribute
	MOV	AL,AH				;Put it in AL
	SHL	DL,1				;Yes-Multiply by 4
	SHL	DL,1				;4 lines in eack 8K page
	MOV	SI,CX				;Save line width

CGA_Fill_Up_Loop:
	MOV	CX,SI
	SHR	CX,1				;Save odd byte
	REP	STOSW				;Move words for speed
	RCL	CX,1				;Move odd byte back if any
	REP	STOSB				;Move last byte if any
	SUB	DI,SI				;Restore line start
	ADD	DI,BP				;Move to next 8K page
	MOV	CX,SI
	SHR	CX,1				;Save odd byte
	REP	STOSW				;Move words for speed
	RCL	CX,1				;Move odd byte back if any
	REP	STOSB				;Move last byte if any
	SUB	DI,BP				;Move back to even line
	ADD	DI,BX				;Move to next line
	DEC	DL				;Decrement line count
	JNE	CGA_Fill_Up_Loop		;Repeat if lines left
	ADD	SP,04				;Remove stack frame
	RET

;gdl	ALIGN	4

CGA_Scroll_Down:
	NEG	AX				;Negate difference
	NEG	BX
	NEG	BP
	ADD	DI,20F0H			;Move to odd scan line
	CMP	Video_Mode,06			;Test for low res
	JE	CGA_M4_Scroll_Down		;Yes-Need to advance
	INC	DI				;to last bit in 2 bit pel

CGA_M4_Scroll_Down:
	MOV	CL,DL				;Get scroll width
	MOV	SI,DI				;Get offset returned
	ADD	SI,AX				;Set new source for scroll
	POP	AX				;Restore fill block size
	POP	DX				;Get scroll & fill values
	PUSH	CX				;Save fill attribute
	XOR	CH,CH				;Reset high byte
	MOV	AX,ES
	MOV	DS,AX				;Setup segments to video area
	OR	DH,DH				;Any rows to scroll?
	JE	Do_CGA_Fill_Down		;No -Skip the scroll
	SHL	DH,1				;Yes-Multiply by 4
	SHL	DH,1				;4 lines in eack 8K page
	MOV	AX,CX				;Save line length

CGA_Scroll_Down_Loop:
	MOV	CX,AX				;Get line length
	SHR	CX,1				;Move words for speed
	JNC	Down_Count1_Even		;Go if CX was even
	MOVSB					;Otherwise move last byte

Down_Count1_Even:
	JCXZ	Down_Count1			;Go if only 1 byte moved
	DEC	SI				;Otherwise back up one
	DEC	DI				;for word moves
	REP	MOVSW				;Do the move
	INC	SI
	INC	DI

Down_Count1:
	ADD	SI,AX				;Move back to line start
	ADD	DI,AX				;Move back to line start
	ADD	SI,BP				;Move to next page
	ADD	DI,BP				;Both source and Dest
	MOV	CX,AX				;Get length of line
	SHR	CX,1				;Move words for speed
	JNC	Down_Count2_Even		;Screen width was even
	MOVSB					;Do one more, screen width odd

Down_Count2_Even:
	JCXZ	Down_Count2			;Go if only 1 byte moved
	DEC	SI				;Back up one more for
	DEC	DI				;word moves
	REP	MOVSW				;Move the row
	INC	SI
	INC	DI

Down_Count2:
	SUB	SI,BP				;Move back to even line
	SUB	DI,BP
	ADD	SI,BX				;Next position
	ADD	DI,BX				;Next dest position
	DEC	DH				;Decrement line counter
	JNE	CGA_Scroll_Down_Loop		;Repeat if lines left
	MOV	CX,AX				;Restore CX with line width

Do_CGA_Fill_Down:
	POP	AX				;Get fill attribute
	MOV	AL,AH				;Put it in AL
	SHL	DL,1				;Yes-Multiply by 4
	SHL	DL,1				;4 lines in eack 8K page
	MOV	SI,CX				;Save line width

CGA_Fill_Down_Loop:
	MOV	CX,SI
	SHR	CX,1				;Divide by 2 for word write
	JNC	Down_Count3_Even		;Go if width is even
	STOSB					;Fill last byte of row

Down_Count3_Even:
	JCXZ	Down_Count3			;Go if only 1 byte filled
	DEC	DI				;Back up one for word moves
	REP	STOSW				;Fill the row
	INC	DI

Down_Count3:
	ADD	DI,SI				;Restore line start
	ADD	DI,BP				;Move to next 8K page
	MOV	CX,SI
	SHR	CX,1				;Divide by 2 for word write
	JNC	Down_Count4_Even		;Go if width is even
	STOSB					;Fill last byte of row

Down_Count4_Even:
	JCXZ	Down_Count4			;Go if only 1 byte filled
	DEC	DI				;Back up one for word moves
	REP	STOSW				;Fill the odd row
	INC	DI

Down_Count4:
	SUB	DI,BP				;Move back to even line
	ADD	DI,BX				;Move to next line
	DEC	DL				;Decrement line count
	JNE	CGA_Fill_Down_Loop		;Repeat if lines left
	ADD	SP,04				;Remove stack frame
	RET

;****************************************************************
;   Scroll screen down in modes 0DH - 12H
;****************************************************************

;gdl	ALIGN	4

VGA_Scroll_Down:
	STD
	MOV	AX,DX				;Point to lower right
	MOV	SI,DX				;Save register
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	XOR	AH,AH				;Reset high byte
	MOV	AL,Active_Page			;Get page number
	MUL	Video_Length			;Multiply by page size
	ADD	DI,AX				;Add to base
	MOV	BX,Char_Length			;Get length of character
	DEC	BX				;Decrement one
	MOV	AX,Video_Columns		;Length of line
	MUL	BX				;Multiply by scans - 1
	ADD	DI,AX				;Add offset
	MOV	DX,SI
	JMP	SHORT Start_VGA_Scroll

;****************************************************************
;   Scroll screen up in modes 0DH - 12H
;****************************************************************

;gdl	ALIGN	4

Video_VGA_Scroll_Up:
	MOV	SI,DX				;Save register
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	XOR	AH,AH				;Reset high byte
	MOV	AL,Active_Page			;Get page number
	MUL	Video_Length			;Multiply by page size
	ADD	DI,AX				;Add to base
	MOV	DX,SI

;****************************************************************
;   VGA Mode D, E, F, 10, 11, 12 Scroll Start
;****************************************************************

Start_VGA_Scroll:
	SUB	DX,CX				;Subtract start from end
	INC	DH				;Add one row
	INC	DL				;Add one column
	MOV	AL,AL_Stack_T			;Get value from stack
	MOV	AH,DH				;Get rows to scroll
	OR	AL,AL				;Is row value zero?
	JE	Planar_Fill_Only		;Yes-Do fill only
	SUB	AH,AL				;Is rows diff > rows to scroll
	JA	Planar_Scroll_and_Fill		;Go if window > rows to scroll

Planar_Fill_Only:
	MOV	AL,DH				;Otherwise clear entire window
	XOR	AH,AH				;Dont scroll any text

Planar_Scroll_and_Fill:
	MOV	CX,AX				;Save rows to fill and scroll
	MOV	SI,DX				;Save window row & col length
	MOV	AX,0105H			;Setup write mode 1
	MOV	DX,Graphics_Controller
	OUT	DX,AX				;Write to graphics controller
	MOV	AX,0F02H			;Setup sequencer
	MOV	DX,Sequencer
	OUT	DX,AX				;Output to sequencer
	MOV	AX,CX				;Get rows to scroll and fill
	PUSH	AX				;Save for scroll and fill code
	MOV	BX,Video_Columns		;Get number of columns
	MUL	BL				;Multiply by columns
	MUL	Char_Length			;Multiply by character length
	MOV	CX,AX				;Save fill size
	MOV	DX,SI				;Restore register
	SUB	BL,DL				;Determine the length of
	SBB	BH,00				;line not in scroll window
	CMP	AH_Stack_T,07			;Test for scroll down
	JNE	Not_Scroll_Down 		;Not scroll down
	NEG	AX				;Negate difference
	NEG	BX

Not_Scroll_Down:
	MOV	SI,DI				;Get offset returned
	ADD	SI,AX				;Set new source for scroll
	MOV	AX,CX				;Restore fill block size
	MOV	CL,DL				;Get scroll width
	XOR	CH,CH				;Reset high byte
	POP	DX				;Get scroll & fill values
	CMP	CX,Video_Columns		;Are we scrolling entire window
	JNE	Slow_Planar_Scroll		;No -Go scroll line by line
	MOV	BX,AX				;Yes-Save fill window size (/8)
	MOV	AL,CL				;Get screen width
	MUL	DH				;Multiply by # of rows
	MUL	Char_Length			;And again by char length
	MOV	CX,AX				;Save scroll size
	MOV	AX,0A000H			;Setup segment registers
	MOV	ES,AX				;to video regen
	MOV	DS,AX
	REP	MOVSB				;Scroll screen quickly
	MOV	CX,BX				;Get fill length
	MOV	DX,Graphics_Controller		;Setup the graphics controller
	MOV	AX,0005H			;Set write mode zero
	OUT	DX,AX				;Write graphics mode register
	MOV	AH,BH_Stack_T			;Get attribute color
	XOR	AL,AL				;Set bits to clear
	OUT	DX,AX				;Write to set/reset reg
	INC	AL				;Move to enable set/reset reg
	OUT	DX,AX				;Set enable for clear bits only
	XOR	AX,AX				;Clear enabled bits
	REP	STOSB				;Fill memory quickly
	OUT	DX,AX				;Clear Set/Reset registers
	INC	AL				;Move to Enable set/reset
	OUT	DX,AX				;Clear enable register
	ADD	SP,04				;Remove stack frame
	RET

Slow_Planar_Scroll:
	MOV	AL,BYTE PTR Char_Length 	;Get character length
	MUL	DH				;Compute lines to scroll
	PUSH	DX				;Save rows to clear (DL)
	MOV	DX,AX				;Keep lines in DX
	MOV	AX,0A000H			;Setup segment registers
	MOV	DS,AX				;to the video regen
	MOV	ES,AX
	OR	DX,DX				;Any lines to scroll
	JE	Do_Planar_Fill			;No -Go to fill

Planar_Scroll_Loop:
	MOV	AX,CX				;Save line length
	REP	MOVSB				;Move the line
	MOV	CX,AX				;Restore line length
	ADD	SI,BX				;Next position
	ADD	DI,BX				;Next dest position
	DEC	DX				;Decrement line counter
	JNE	Planar_Scroll_Loop		;Repeat if lines left

Do_Planar_Fill:
	MOV	DS,BIOS_Address 		;Set data segment
	POP	SI				;Get number or lines to fill
	MOV	DX,Graphics_Controller		;Setup the graphics controller
	MOV	AX,0005H			;Set write mode to zero
	OUT	DX,AX				;Write graphics mode register
	MOV	AH,BH_Stack_T			;Get attribute color
	XOR	AL,AL				;Set bits to clear
	OUT	DX,AX				;Write to set/reset reg
	INC	AL				;Move to enable set/reset reg
	OUT	DX,AX				;Set enable for clear bits only
	MOV	DX,SI
	MOV	AL,BYTE PTR Char_Length 	;Get size of character
	MUL	DL				;Compute lines to fill
	MOV	DX,AX				;Save line counter in DX
	XOR	AX,AX				;Fill enabled bits with zero

Planar_Fill_Loop:
	MOV	SI,CX				;Save line length
	REP	STOSB				;Fill with color
	ADD	DI,BX				;Next position
	MOV	CX,SI				;Restore line length
	DEC	DX				;Decrement line count
	JNE	Planar_Fill_Loop		;Repeat if lines left
	MOV	DX,Graphics_Controller		;Clear graphics controller regs
	OUT	DX,AX				;Clear Set/Reset registers
	INC	AL				;Move to Enable set/reset
	OUT	DX,AX				;Clear enable register
	ADD	SP,04				;Remove stack frame
	RET

;****************************************************************
;   VGA Mode 13 Scroll Down
;****************************************************************

;gdl	ALIGN	4

VGA_Mode13_Scroll_Down:
	STD					;Set decrement
	MOV	AX,DX				;Get start position
	PUSH	DX
	MOV	DI,AX				;Get column
	AND	DI,0FFH 			;Reset high byte
	MOV	AL,AH				;AL is row position
	MUL	BYTE PTR Video_Columns		;Multiply by columns
	MUL	Char_Length			;Multiply by length
	ADD	DI,AX				;Set starting scan line
	MOV	BX,Char_Length			;last scan line for the
	DEC	BX				;character position
	MOV	AX,Video_Columns		;Length of line
	MUL	BX				;Multiply by scans - 1
	ADD	DI,AX				;Add offset
	SHL	DI,1				;Multiply by eight
	SHL	DI,1				;since each character
	SHL	DI,1				;is eight bytes wide
	ADD	DI,06				;Move to last pixel
	POP	DX				;Restore register

;****************************************************************
;   VGA Mode 13 Scroll start
;****************************************************************

VGA_Mode13_Scroll:
	SUB	DX,CX				;Subtract start from end
	INC	DH				;Add one row
	INC	DL				;Add one column
	MOV	AL,AL_Stack_T			;Get value from stack
	MOV	AH,DH				;Get rows to scroll
	OR	AL,AL				;Is row value zero?
	JE	Mode13_Fill_Only		;Yes-Do fill only
	SUB	AH,AL				;Is rows diff > rows to scroll
	JA	Mode13_Scroll_and_Fill		;Go if window > rows to scroll

Mode13_Fill_Only:
	MOV	AL,DH				;Otherwise clear entire window
	XOR	AH,AH				;Dont scroll any text

Mode13_Scroll_and_Fill:
	PUSH	AX				;Save scroll and fill rows
	MOV	SI,DX				;Save window row & column length
	MOV	BX,Video_Columns		;Get screen width
	MUL	BL				;Multiply by rows to fill
	MUL	Char_Length			;And by character length
	MOV	DX,SI				;Restore register
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
	PUSH	AX				;Save fill size
	SUB	BL,DL				;Determine the length of
	SBB	BH,00				;line not in scroll window
	CMP	AH_Stack_T,07			;Test for scroll down
	JNE	Not_VGA_Scroll_Down		;Not scroll down
	NEG	AX				;Negate difference
	NEG	BX

Not_VGA_Scroll_Down:
	MOV	CL,DL				;Get scroll width
	MOV	CH,00				;Reset high byte
	MOV	SI,DI				;Get offset returned
	ADD	SI,AX				;Set new source for scroll
	POP	AX				;Restore fill block size
	POP	DX				;Get scroll & fill values
;gdl:04/10/92 Don't use this fast clear screen, because the DOS 5 ANSI.SYS
;	clear 26 lines bug causes us to look bad.  Use the slow clear code.
;	CMP	CX,Video_Columns		;Are we scrolling entire window
;	JNE	Slow_Mode13_Scroll		;No -Go scroll line by line
;	MOV	BX,AX				;Yes-Save fill window size (/8)
;	MOV	AL,CL				;Get screen width
;	MUL	DH				;Multiply by # of rows
;	MUL	Char_Length			;And again by char length
;	MOV	CX,AX				;Save scroll size
;	SHL	CX,1				;Multiply by 4 for
;	SHL	CX,1				;word moves (8 for byte moves)
;	MOV	AX,0A000H			;Setup segment registers
;	MOV	ES,AX				;to video regen
;	MOV	DS,AX
;	REP	MOVSW				;Scroll screen quickly
;	MOV	CX,BX				;Get fill length
;	SHR	CX,1				;Account for word move
;	MOV	AL,BH_Stack_T			;Get color from stack
;	MOV	AH,AL				;Dup for word writes
;	REP	STOSW				;Fill it quickly
;	ADD	SP,04				;Remove stack frame
;	RET

Slow_Mode13_Scroll:
	SHL	BX,1
	SHL	BX,1				;Multiply offset to next line
	SHL	BX,1				;by 8 since 8 byte char width
	SHL	CX,1				;Multiply by 4 for
	SHL	CX,1				;word moves (8 for byte moves)
	MOV	AL,BYTE PTR Char_Length 	;Get character length
	MUL	DH				;Compute lines to scroll
	PUSH	DX				;Save rows to clear (DL)
	MOV	DX,AX				;Keep lines in DX
	MOV	AX,0A000H			;Setup segment registers
	MOV	DS,AX				;to the video regen
	MOV	ES,AX
	OR	DX,DX				;Any lines to scroll
	JE	Do_Mode13_Fill			;No -Go to fill

Mode13_Scroll_Loop:
	MOV	AX,CX				;Save line length
	REP	MOVSW				;Move the line
	MOV	CX,AX				;Restore line length
	ADD	SI,BX				;Next position
	ADD	DI,BX				;Next dest position
	DEC	DX				;Decrement line counter
	JNE	Mode13_Scroll_Loop		;Repeat if lines left

Do_Mode13_Fill:
	POP	DX				;Get rows to fill
	MOV	DS,BIOS_Address 		;Set data segment
	MOV	AL,BYTE PTR Char_Length 	;Get size of character
	MUL	DL				;Compute lines to fill
	MOV	DX,AX				;Save line counter in DX
	MOV	AL,BH_Stack_T			;Get color from stack
	MOV	AH,AL				;Dup in AH for word writes

Mode13_Fill_Loop:
	MOV	SI,CX				;Save line length
	REP	STOSW				;Fill with color
	ADD	DI,BX				;Next position
	MOV	CX,SI				;Restore line length
	DEC	DX				;Decrement line count
	JNE	Mode13_Fill_Loop		;Repeat if lines left
	ADD	SP,04				;Remove stack frame
	RET

;**********************************************************************

VGA_Segment ENDS

	END

