/*--------------------------------------------------------------*/
/*								*/
/*   CLVIEW.HPP - contains the control and class definition     */
/*   Copyright (c) 1992 by Cirrus Logic Inc.	 		*/
/*								*/
/*--------------------------------------------------------------*/

#define FALSE	  0
#define TRUE	  1
#define TEXT	  0
#define GRFX	  1

typedef unsigned char	byte;
typedef unsigned int	word;
typedef unsigned int   	boolean;

#ifndef DESKTOP
const int GD6410	= 5;
const int GD5410	= 6;
const int GD6420	= 7;
#endif

const int MAXSTD 	= 15;		// total number of standard modes

#ifndef DESKTOP
const int MAXOPTIONS	= 18;		// vgaconf options
const int MAXKEYWORD 	= 66;		// #command line vgaconf keywords
#else
const int MAXOPTIONS	= 5;
#endif

const int MAXLINE	= 200;		// #character per line
const int S_SAVE 	= 10001;
const int S_VERIFY	= 10002;
const int S_ADVANCED	= 10003;
const int S_OK		= 10004;


const int KEY_A		= 0x1E61;
const int KEY_B		= 0x3062;
const int KEY_C		= 0x2E63;
const int KEY_H		= 0x2368;
const int KEY_K		= 0x256B;
const int KEY_F		= 0x2166;
const int KEY_L		= 0x266C;
const int KEY_M		= 0x326D;
const int KEY_N		= 0x316E;
const int KEY_O		= 0x186F;
const int KEY_P		= 0x1970;
const int KEY_S		= 0x1F73;
const int KEY_T		= 0x1474;
const int KEY_U		= 0x1675;
const int KEY_V		= 0x2F76;
const int KEY_X		= 0x2D78;
const int KEY_Y		= 0x1579;

// Setup options.
const RAW_CODE SETUP_MENU	   	= 10000;	// Special number.
const RAW_CODE MONITOR_WINDOW   	= 10001;
const RAW_CODE DISPLAY_WINDOW   	= 10003;
#ifndef DESKTOP
const RAW_CODE VGACONF_WINDOW   	= 10004;
#endif
const RAW_CODE EXIT_WINDOW   		= 10005;
const RAW_CODE ABOUT_WINDOW   		= 10006;

// Help options.
const RAW_CODE CLHELP_MENU	   	= 10300;	// Special number.
const RAW_CODE CLHELP_DISPLAY   	= 10301;
const RAW_CODE CLHELP_KEYBOARD		= 10302;
const RAW_CODE CLHELP_MONITOR   	= 10303;
const RAW_CODE CLHELP_MOUSE		= 10304;
#ifndef DESKTOP
const RAW_CODE CLHELP_VGACONF      	= 10305;
#endif

struct VesaInfoStruc {
    char	cVesaSignature[4];
    word	wVesaVersion;
    char	far *zOEMStringPtr;
    byte	bCapabilities[4];
    word	far *wVideoModePtr[1];
    word	wTotalMemory;
    byte	bReserved[236];
};

struct modeRec {
	int modenum;
	int vesamode;
	byte scanline;		// 200/350/400
	byte colors;		// bits/pixel
	int horzres;
	int vertres;
	byte cellwidth;
	byte cellheight;
	byte type;		// text=0, graphics=1
	char info[64]; 		// all the above information in a string
	modeRec *next;
};

struct OPTION_INFO {
	byte bootupValue;	// option value in autoexec.bat
	byte oldValue;		// initial option value
	byte value;		// option value to set
	void (*func)(byte);	// option function()
};

#ifndef DESKTOP
struct KEYWORD_INFO {		// for command line option
	char *string;		// keyword string (ex: "ATTR")
	byte value;		// option value to set (ex: ATTREMUL)
	int option;		// option# (ex: REVERSE)
};
#endif

enum HELP_MSG {
	NO_HELP,
	HELP_SCREEN,
	HELP_MODE,		// display list of modes supported
	NONDOS_MODE,		// true color mode
	HELP_MONTYPE,		// display list of montypes supported
	HELP_CONFIG,		// display config keywords
	HELP_PM,		// can't set power management in crt mode
	HELP_NOMONITOR,		// non-montype product
	HELP_ENVIRONMENT	// can't set display mode
};

enum OPTIONS {
	FREQ_640,
	FREQ_800,
	FREQ_1024,
	FREQ_1280,
	HMONITOR,
	TEXT_REVERSE,
	GRFX_REVERSE,
	BOLD,
	CONTRAST,
	EXPAND,
	POSITION,
	DISPLAY,
	BUS,
	INHIBIT,
	CURSOR,
	RGB,
	POWER,
	TIMER
};

enum MONTYPE
{
	MONTYPE_0,     		// VGA
	MONTYPE_1,     		// 8514
	MONTYPE_2,     		// Super VGA
	MONTYPE_3,     		// Extended Super VGA
	MONTYPE_4, 	  	// Multi-freq
	MONTYPE_5, 	  	// Extended multi-freq
	MONTYPE_6, 	  	// Super multi-freq
	MONTYPE_7,  	  	// Extended Super multi-freq
	MONTYPE_8		// Advanced option set
};

enum F640
{
	F640_60,
	F640_72
};

enum F800
{
	F800_56,
	F800_60,
	F800_72
};

enum F1024
{
	F1024_87i,
	F1024_60,
	F1024_70,
	F1024_72,
	F1024_76
};

enum F1280
{
	F1280_87i,
	F1280_60,
	F1280_70
//	NOT_AVAILABLE 	// for non-alpine chips, not_available = 1
};

enum INPUTS
{
	ENABLED,			// 0
	DISABLED			// 1
};

enum REFRESH_RATE
{
	LOW,
	HIGH
};

#ifndef DESKTOP
enum CONTRAST_ENHANCEMENT
{
	CONTRAST_0,			// attribute emulation
	CONTRAST_1,			// automap
	CONTRAST_2,			// background enhancement
	CONTRAST_3,			// foreground enhancement
	CONTRAST_4			// foreground/background enhancement
};

enum POSITION_CONTROL
{
	CENTER,
	TOP,
	BOTTOM
};

enum DISPLAY_TYPE
{
	LCD,
	CRT,
	SIMULSCAN
};

enum RGB_WEIGHTING
{					// Red Green Blue
	RGB_0,				// 11%  30%  59%
	RGB_1,				// 30%	11%  59%
	RGB_2,				// 11%  59%  30%
	RGB_3,				// 30%  59%  11%
	RGB_4,				// 59%  11%  30%
	RGB_5				// 59%  30%  11%
};

enum POWER_MANAGEMENT
{
	PM_0,			// disable stand-by
	PM_1,			// enable stand-by immediately
	PM_2,			// enable suspend
	PM_3,			// enable stand-by timer (memory)
	PM_4			// enable stand-by timer (keyboard)
};

class CHECK_BOX : public UIW_BUTTON
{
private:
 	int option;		// option #
	
public:
	CHECK_BOX(int left, int top, int width, char *text, int option);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

#endif

class CL_BUTTON : public UIW_BUTTON
{
private:
	int option;
public:
	CL_BUTTON(int left, int top, int width, char *text,
		USER_FUNCTION userFunc, int value);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

class RADIO_BUTTON : public UIW_BUTTON
{
private:
 	int value;		// option value
	int option;		// vgaconf option (including montype)
	
public:
	RADIO_BUTTON(int left, int top, int width, char *text,
		int value, int option, USER_FUNCTION userFunction);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

class COMBO_BOX : public UIW_COMBO_BOX
{
private:
 	int option;		// option #
 	byte maxValue;
public:
	COMBO_BOX(int left, int top, int width, int height, int option, byte max);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

class COMBO_BOX_ITEM : public UIW_STRING
{
private:
 	int value;		// option value
 	int option;		// option #

public:
	COMBO_BOX_ITEM(int width, char *text, int value, int option);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

class VT_LIST_ITEM : public UIW_STRING
{
private:
	USHORT mode;
	USHORT scanlines;

public:
	VT_LIST_ITEM(int width, char *text, USHORT mode, USHORT scanlines);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
};

class CL_WINDOW_MANAGER : public UI_WINDOW_MANAGER
{
public:
	CL_WINDOW_MANAGER(UI_DISPLAY *display, UI_EVENT_MANAGER *eventManager) :
		UI_WINDOW_MANAGER(display, eventManager, CL_WINDOW_MANAGER::ExitFunction) { }
	virtual EVENT_TYPE Event(const UI_EVENT &event);

private:
	static EVENT_TYPE ExitFunction(UI_DISPLAY *display,
		UI_EVENT_MANAGER *eventManager, UI_WINDOW_MANAGER *windowManager);
};

class CONTROL_WINDOW : public UIW_WINDOW
{
public:
	CONTROL_WINDOW(void);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
	static EVENT_TYPE Message(UI_WINDOW_OBJECT *object, UI_EVENT &event, 
		EVENT_TYPE ccode);

protected:
	void Option_Setup(EVENT_TYPE item);
	void Option_Help(EVENT_TYPE item);

	UI_DEVICE *Event_Monitor(void);
	UI_WINDOW_OBJECT *Window_Monitor(void);
	UI_WINDOW_OBJECT *Window_Modes(void);
	UI_WINDOW_OBJECT *Window_Vgaconf(void);
	UI_WINDOW_OBJECT *Window_About(void);
};

