/*---------------------------------------------------------*/
/*                                                                                                                                                        */
/*        CLVIEW.CPP - contains the main control functions.*/
/*        Copyright (c) 1992-1993 by Cirrus Logic Inc.                                    */
/*                                                                                                                                                        */
/*   Mai Vu:12/26/91 - file created                        */
/*                                                         */
/*   Modifications:                                        */
/*                                                         */
/*   MOD1:  ALPINE II MODES, ID,.... STEVE C. 8-12-93      */
/*   MOD2:  CENTERING                STEVE C. 9-07-93      */
/*   MOD3:  ADDED 5429 & NS ID       STEVE C. 10-21-93     */
/*                                                         */
/*---------------------------------------------------------*/

#define USE_RAW_KEYS                            // For accelarator key definitions.
#define USE_HELP_CONTEXTS

#include <bios.h>   // TAKE THESE TWO OUT LATER MOD2
#include <conio.h>

#include <string.h> // MOD2
#include <graphics.h>                   // Include file for palette colors.
#include <ui_win.hpp>
#include <dos.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "clview.hpp"
#include "clmode.hpp"

#ifndef DESKTOP
void setPowerManagement(byte);
void printConfHelp();
void printDisplayStatus(boolean);

extern int lookup[];
extern boolean closeError;
extern boolean escFlag;

char keyword[4];                                        // command-line configuration keyword
int minTimer=2;                                         // minimum stand-by timer (minutes)
int maxTimer=63;                                        // maximum stand-by timer (minutes)
#endif

unsigned int MouseDriverStatus;   /* 2.30 beta 2 */
int RadioButtonToggle;            /* SGC, 2-25-93 */
#ifdef DESKTOP
  int GD5420;                       /* SGC, 2-25-93 */
  extern int is5420();              /* SGC, 2-25-93 */
  unsigned int chiptype;            /* SGC, 3-22-93 */
  extern int is54XX();              /* SGC, 3-22-93 */
  extern void ClearAllTables();     // MOD2

extern unsigned int CenteringTable []; // MOD2
extern char ptableA [];  // 64 * 16 SLOTS, Extended Standard, MOD2
extern char ptableB [];  // 27 * 16 SLOTS, Extended Supplemental, MOD2
extern char CtableTotal;

static char *ControllerType [] = {   /* Controller type strings */
    "Unknown",
    "CL-GD5401",
    "CL-GD5402",
    "CL-GD5420",
    "CL-GD5422/24",
    "CL-GD5426",
    "CL-GD5428",
    "CL-GD5432",  // MOD1
    "CL-GD5434",  // MOD1
    "CL-GD5429",  // MOD3
    "CL-GD5452/53",  // MOD3
	NULL };

#endif
byte NOT_AVAILABLE;                             // value for 1280x1024 frequency option
char* getBIOSVersion();
byte getDisplayStatus(int);
void getExtdMode(int);
void getmode16List();
byte getScanlines();
void getStdmode(int);
int getVideoMemory();
void haltScreen();
int isCLActive();
int isEEPROMPresent();
int isHiFreqSupported();
int isModified();
int isModeSupported(int);
int isMonitorTypeSupported();
int isVesaSupported();
int is6410();
void preview(byte, boolean);
void printHeader();
void printHelp();
void printModeHelp();
void printMonitorHelp();
void setMode(int, byte, boolean);
void setHorzMontype(byte);
void setVertMontype(byte, byte, byte, byte);
void updateAutoexec();
void Window_Advanced();
void Window_Update();

#ifdef DESKTOP  // MOD2
void MonitorAdjustUpdate();  // For centering
#endif

#ifndef DESKTOP

int isPeaven();
void setTextReverse(byte);
void setGrfxReverse(byte);
void setBold(byte);
void setContrast(byte);
void setExpand(byte);
void setPosition(byte);
void setDisplay(byte);
void setBus(byte);
void setInhibitFont(byte);
void setCursor(byte);
void setRGBWeight(byte);
void setPowerManagement(byte);

OPTION_INFO tbl[MAXOPTIONS] =
{ { 0xff, 0, 0, NULL },                                 // 640x480 frequency
{ 0xff, 0, 0, NULL },                                   // 800x600 frequency
{ 0xff, 0, 0, NULL },                                   // 1024x768 frequency
{ 0xff, 0, 0, NULL },                                   // 1280x1024 frequency
{ 0xff, 0, 0, setHorzMontype },
{ 0xff, 0, 0, setTextReverse},
{ 0xff, 0, 0, setGrfxReverse},
{ 0xff, 0, 0, setBold },
{ 0xff, 0, 0, setContrast },
{ 0xff, 0, 0, setExpand },
{ 0xff, 0, 0, setPosition },
{ 0xff, 0, 0, setDisplay },
{ 0xff, 0, 0, setBus },
{ 0xff, 0, 0, setInhibitFont },
{ 0xff, 0, 0, setCursor },
{ 0xff, 0, 0, setRGBWeight },
{ 0xff, 0, 0, setPowerManagement },
{ 0xff, 0, 0, NULL } };                                 // stand-by timer

#else

OPTION_INFO tbl[MAXOPTIONS] =
{{ 0xff, 0, 0, NULL },                                  // 640x480 frequency
{ 0xff, 0, 0, NULL },                                   // 800x600 frequency
{ 0xff, 0, 0, NULL },                                   // 1024x768 frequency
{ 0xff, 0, 0, NULL },                                   // 1280x1024 frequency
{ 0xff, 0, 0, setHorzMontype }};

#endif

extern int updatedMessage;
extern char *CirrusID;
extern char* f640tbl[];
extern char* f800tbl[];
extern char* f1024tbl[];
extern char* f1280tbl[];

modeRec *modeList;                              // list of modes available
byte dosMode;                                           // current mode# in DOS
byte BANKIDX, BANKSIZE;                 // bank index register, size of bank
boolean is_setmode=FALSE;       // flag to execute setmode()
boolean validMode=FALSE;        // modenum is valid
boolean status = FALSE;                 // flag to display current vgaconf status
char *dosModeStr;                               // current mode before executing CLMODE
char filename[10];                              // "filename".EXE string for CLMODE
char filepath[80];                              // the path where "filename".EXE is at
int help = NO_HELP;                // index into the ErrorMessage[]
int keyO;
int clmode;                                                     // mode to be set
int clexit=FALSE;                                       // the exit window has popped up
int clupdate=FALSE;                             // the update window has popped up

#ifdef DESKTOP
int centerupdate=FALSE;                         // MOD2, the centering update window has popped up
int centercom=TRUE;
#endif

USHORT clines;                                  // scanlines to be set
boolean isHiFreqProduct;                // supports hi-frequency modes
boolean isMontypeProduct;               // montype-product
boolean isVesaProduct;                  // Vesa-product

static char* monType[8] = {"VGA ", "8514 compatible", "Super VGA", "Extended Super VGA",
					   "Multifrequency", "Extended Multifrequency",
					   "Super Multifrequency", "Extended Super Multifrequency"};


#ifndef DESKTOP
KEYWORD_INFO confKey[MAXKEYWORD] =
{{ "TEX",       ENABLED,                                TEXT_REVERSE },
{       "NOT",  DISABLED,                       TEXT_REVERSE },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "GRF",  ENABLED,                                GRFX_REVERSE },
{       "NOG",  DISABLED,                       GRFX_REVERSE },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "BOL",  ENABLED,                                BOLD },                         // bold font
{       "NOB",  DISABLED,                       BOLD },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "BLA",  CONTRAST_0,                     CONTRAST },                     // contrast enhancement
{       "GRA",  CONTRAST_1,                     CONTRAST },
{       "BAC",  CONTRAST_2,                     CONTRAST },
{       "TXT",  CONTRAST_3,                     CONTRAST },
{       "BKF",  CONTRAST_4,                     CONTRAST },
{       "$$$",  0,                      0 },
{       "EXP",  ENABLED,                                EXPAND },                       // expand
{       "NOE",  DISABLED,                       EXPAND },  
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "CEN",  CENTER,                         POSITION },                     // vertical position
{       "TOP",  TOP,                                    POSITION },
{       "BOT",  BOTTOM,                         POSITION },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "PAN",  LCD,                                    DISPLAY },                      // display mode
{       "CRT",  CRT,                                    DISPLAY },
{       "SIM",  SIMULSCAN,                      DISPLAY },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "16B",  ENABLED,                                BUS },                          // bus width
{       "NO1",  DISABLED,                       BUS },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "INH",  ENABLED,                                INHIBIT },                      // inhibit font load
{       "NOI",  DISABLED,                       INHIBIT },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "FUL",  ENABLED,                                CURSOR },                       // full height cursor
{       "NOF",  DISABLED,                       CURSOR },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "$$$",  0,                      0 }, {  "$$$",  0,                      0 },
{       "W25",  RGB_0,                          RGB },                          // rgb weighting
{       "W52",  RGB_1,                          RGB },
{       "W29",  RGB_2,                          RGB },
{       "W59",  RGB_3,                          RGB },
{       "W92",  RGB_4,                          RGB },
{       "W95",  RGB_5,                          RGB }};
#endif

static char* ErrorMessage[9] =
{ 
"",
"",
"Non-supported mode.\n",
"Cannot run DOS in mode ",
"Invalid monitor type.\n",
"Unknown keyword.\n",
"Option only available when the panel is active.\n",
"Option not available for this product.\n",
"Unable to set display type selected in this environment.\n"
};

#ifndef DESKTOP
void setConfig()
{
	for(int i = TEXT_REVERSE; i < POWER; i++) {
		if ((i == DISPLAY) || (tbl[i].value != tbl[i].oldValue))
			tbl[i].func(tbl[i].value);
	}
	if (getDisplayStatus(DISPLAY) != CRT)
		tbl[POWER].func(tbl[POWER].value);
}
#endif

CL_BUTTON::CL_BUTTON(int left, int top, int width, char *text,
	USER_FUNCTION userFunction, int aValue ) :
	UIW_BUTTON(left, top, width, text, BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, userFunction, aValue, NULL )
{
}

EVENT_TYPE CL_BUTTON::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;

	if (((value == L_HELP) && (event.rawCode == TAB)) ||   /* SGC, 2-24-93 */
	((value == L_HELP) && (event.rawCode == BACKTAB))) {
		eventManager->Put(event);
		eventManager->Put(event);
	}

	/* SGC, 2-25-93, added to SGC END */

	if (RadioButtonToggle == 0) {
	  switch (ccode)
	  {
	  case E_KEY:
		UI_EVENT tEvent;
		switch (event.rawCode)
		{
		case KEY_A:
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		case KEY_H:
			eventManager->Put(UI_EVENT(L_HELP));
			break;
		case KEY_V:
			setHorzMontype(tbl[HMONITOR].value);
			getmode16List();
			eventManager->DevicePosition(E_MOUSE, 0, 0); /* 2.30 beta 2 */
			preview(0x12, TRUE);
			eventManager->DevicePosition(E_MOUSE, 0, 0);
			eventManager->Put(UI_EVENT(S_REDISPLAY));
			break;
		case KEY_K:
			setHorzMontype(tbl[HMONITOR].value);
#ifndef DESKTOP
			setConfig();
#endif
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		};
		break;
	  }
	}
	RadioButtonToggle = 0;

	/* SGC END */

	ccode = UIW_BUTTON::Event(event);
	// Return the control code.
	return (ccode);

}

RADIO_BUTTON::RADIO_BUTTON(int left, int top, int width, char *text,
	int aValue, int anOption, USER_FUNCTION userFunction) :
	UIW_BUTTON(left, top, width, text, BTF_RADIO_BUTTON, WOF_NO_FLAGS,
	userFunction, 0, NULL )
{
	value = aValue;
	option = anOption;
	if (getDisplayStatus(option) == value)
	   woStatus = WOS_SELECTED;
	if (FlagSet(woStatus, WOS_SELECTED))
		woStatus |= WOS_CURRENT;
}

EVENT_TYPE RADIO_BUTTON::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case E_KEY:
		UI_EVENT tEvent;
		RadioButtonToggle = 1;  /* SGC, 2-25-93 */
		switch (event.rawCode)
		{
		case KEY_A:
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		case KEY_H:
			eventManager->Put(UI_EVENT(L_HELP));
			break;
		case KEY_V:
			setHorzMontype(tbl[HMONITOR].value);
			getmode16List();
			eventManager->DevicePosition(E_MOUSE, 0, 0); /* 2.30 beta 2 */
			preview(0x12, TRUE);
			eventManager->DevicePosition(E_MOUSE, 0, 0);
			eventManager->Put(UI_EVENT(S_REDISPLAY));
			break;
		case KEY_K:
			setHorzMontype(tbl[HMONITOR].value);
#ifndef DESKTOP
			setConfig();
#endif
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		};
		break;

   case L_SELECT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
	case S_CURRENT:
	if (FlagSet(woStatus, WOS_SELECTED))
		tbl[option].value = (USHORT) value;
	break;

	}
	ccode = UIW_BUTTON::Event(event);
	// Return the control code.
	return (ccode);

}

#ifndef DESKTOP
CHECK_BOX::CHECK_BOX(int left, int top, int width, char *text, int anOption) :
	UIW_BUTTON(left, top, width, text, BTF_CHECK_BOX, WOF_NO_FLAGS,
	NULL, 0, NULL )
{
	option = anOption;
	if (getDisplayStatus(option) == ENABLED)                        // option is enabled
		woStatus |= WOS_SELECTED;
}

EVENT_TYPE CHECK_BOX::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case E_KEY:
		keyO = FALSE;
		switch (event.rawCode) {
			case KEY_A:
				eventManager->Put(UI_EVENT(S_CLOSE));
				break;
			case KEY_H:
				eventManager->Put(UI_EVENT(L_HELP));
				break;
			case KEY_K:
				keyO = TRUE;                    
				eventManager->Put(UI_EVENT(S_CLOSE));
				break;
		}
			break;

   case L_SELECT:
	case S_CURRENT:
	case S_NON_CURRENT:
		if (woStatus & WOS_SELECTED)
			tbl[option].value = ENABLED;
		else tbl[option].value = DISABLED;
		if (keyO)
			setConfig();
	break;

	}

	ccode = UIW_BUTTON::Event(event);
	// Return the control code.
	return (ccode);

}
#endif

COMBO_BOX::COMBO_BOX(int left, int top, int width, int height, int num, byte max) :
	UIW_COMBO_BOX(left, top, width, height, NULL, WNF_NO_WRAP,
		WOF_NO_FLAGS, WOAF_NO_FLAGS)
{
	option = num;
	maxValue = max;
}

EVENT_TYPE COMBO_BOX::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;

	if (ccode == E_KEY)
	{
		switch (event.rawCode)
		{
		case WHITE_UP_ARROW:
		case GRAY_UP_ARROW:
			if (tbl[option].value != 0)
				(tbl[option].value)--;
		   ccode = UIW_COMBO_BOX::Event(event);
			break;
		case WHITE_DOWN_ARROW:
		case GRAY_DOWN_ARROW:
			if (tbl[option].value < (maxValue-1))
				(tbl[option].value)++;
		   ccode = UIW_COMBO_BOX::Event(event);
			break;
		case TAB:
		case BACKTAB:
		case ESCAPE:
		case ENTER:
		case ALT_O:
		case ALT_C:
		case ALT_H:
		case ALT_T:
		case ALT_F4:
		   ccode = UIW_COMBO_BOX::Event(event);
			break;
		default:
			break;
		}                               
	}
	else ccode = UIW_COMBO_BOX::Event(event);
	// Return the control code.
	return (ccode);
}

COMBO_BOX_ITEM::COMBO_BOX_ITEM(int width, char *text,   int num, int anOption) :
	UIW_STRING(0, 0, width, text, -1, STF_NO_FLAGS, WOF_BORDER, NULL)
{
	value = num;
	option = anOption;
	if (getDisplayStatus(option) == value)
	   woStatus = WOS_SELECTED;
	if (FlagSet(woStatus, WOS_SELECTED))
		woStatus |= WOS_CURRENT;
}

EVENT_TYPE COMBO_BOX_ITEM::Event(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case E_KEY:
		if (event.rawCode == KEY_H)
			eventManager->Put(UI_EVENT(L_HELP));
		break;
	case L_PGUP:
	case L_PGDN:
	case S_CURRENT:
	case S_NON_CURRENT:
		if (ccode == S_CURRENT)
			woStatus |= WOS_SELECTED;
		else
			woStatus &= ~WOS_SELECTED;
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		if (FlagSet(woStatus, WOS_SELECTED))
			tbl[option].value = value;
		break;
	}
	ccode = UIW_STRING::Event(event);
	// Return the control code.
	return (ccode);
}

UI_WINDOW_OBJECT *CONTROL_WINDOW::Window_About(void)
{
	char *name = new char[strlen(filename)+17];
	strcpy(name, filename);
	strcat(name, " Utility Program");

	int column = 6;
	if (strlen(filename) < 6) column+=2;

	UIW_WINDOW *about = new UIW_WINDOW(28, 6, 35, 9, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE );

	*about
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("About...");
	*about
		+ new UIW_PROMPT(column, 1, name)
#ifndef DESKTOP
		+ new UIW_PROMPT(6, 2, "  Version 2.30p Beta2") // laptop
#else
		//+ new UIW_PROMPT(6, 2, "  Version 2.33d Beta8") // desktop beta
		+ new UIW_PROMPT(8, 2, "  Version 2.33d") // desktop release
#endif
		+ new UIW_PROMPT(3, 3, "  Copyright (C) 1992-1993. ")
		+ new UIW_PROMPT(7, 4, "  Cirrus Logic Inc.")
		+ new UIW_BUTTON(11, 6, 10, "OK",
			BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
			WOF_JUSTIFY_CENTER, NULL, S_CLOSE);

//   Return the window pointer.
	return (about);
}

EVENT_TYPE CL_WINDOW_MANAGER::Event(const UI_EVENT &event)
{
	// Allow the base window manager to process the event.
	EVENT_TYPE ccode = UI_WINDOW_MANAGER::Event(event);

	// Send the event to any event monitor windows.
	for (UI_WINDOW_OBJECT *object = First(); object; object = object->Next());

	// Return the control code.
	return (ccode);
}

CONTROL_WINDOW::CONTROL_WINDOW() :
	UIW_WINDOW(10, 3, 74, 15, WOF_NO_FLAGS, WOAF_LOCKED | WOAF_NO_SIZE | WOAF_NO_MOVE)
{
	char *exitStr = new char[strlen(filename)+8];
	strcpy(exitStr, "E&xit ");
	strcat(exitStr, filename);

	char *title = new char[strlen(filename)+16];
	strcpy(title, filename);
	strcat(title, " Utility Program");
	// Attach the sub-window objects to the control window.
	*this
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE(title);

int top = 1;
#ifndef DESKTOP
	*this
	+ new UIW_BUTTON(2, top, 16, "&Configuration", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, VGACONF_WINDOW);
	top+=2;
#endif

if (isMontypeProduct)
{
	*this
	+ new UIW_BUTTON(2, top, 16, "Monitor &Type", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, MONITOR_WINDOW);
	top+=2;
}

	*this
	+ new UIW_BUTTON(2, top, 16, "Video &Modes", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, DISPLAY_WINDOW)
	+ new UIW_BUTTON(2, top+2, 16, "A&bout...", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, ABOUT_WINDOW)
	+ new UIW_BUTTON(2, top+4, 16, "E&xit", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, L_EXIT_FUNCTION);

		top = 1;

#ifndef DESKTOP
	*this
	+ new UIW_BUTTON(21, top, 25, "Help on Con&figuration", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, CLHELP_VGACONF);
	top+=2;
#endif

if (isMontypeProduct)
{
	*this
	+ new UIW_BUTTON(21, top, 25, "Help on M&onitor Type", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, CLHELP_MONITOR);
	top+=2;
}

	char *Memory = new char[20];
	strcpy(Memory,itoa(getVideoMemory(), Memory, 10));
	strcat(Memory,"K");
	strcat(Memory," Video Memory");

	*this
	+ new UIW_BUTTON(21, top, 25, "Help on &Video Modes", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, CLHELP_DISPLAY)
	+ new UIW_BUTTON(21, top+2, 25, "&Help on Keyboard ", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, CLHELP_KEYBOARD)
	+ new UIW_BUTTON(21, top+4, 25, "Help on Mo&use ", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
		WOF_BORDER | WOF_JUSTIFY_CENTER, Message, CLHELP_MOUSE)
#ifndef DESKTOP
	+ new UIW_TEXT(49, 3, 22, 1,
		CirrusID,
		22, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)
#else
	+ new UIW_TEXT(49, 3, 22, 1,
		ControllerType[chiptype],
		22, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)
#endif
	+ new UIW_TEXT(49, 4, 22, 1,
		getBIOSVersion(),
		22, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)
	+ new UIW_TEXT(49, 5, 22, 1,
	   Memory,
		22, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER)
	+ new UIW_TEXT(2, 12, 50, 1,
		"To make a selection, press the underlined letter.",
		50, WNF_NO_FLAGS, WOF_VIEW_ONLY | WOF_NON_SELECTABLE | WOF_BORDER);
}

void CONTROL_WINDOW::Option_Setup(int item)
{
	// Get the specified window.
	UI_WINDOW_OBJECT *object = NULL;

	if (item == MONITOR_WINDOW)
		object = Window_Monitor();
#ifndef DESKTOP
	else if (item == VGACONF_WINDOW)
		object = Window_Vgaconf();
#endif
	else if (item == DISPLAY_WINDOW)
		object = Window_Modes();
	else if (item == ABOUT_WINDOW)
		object = Window_About();

	// Add the window object to the window manager.
	if (object)
		*windowManager + object;
}

EVENT_TYPE CONTROL_WINDOW::Event(const UI_EVENT &event)
{
	// Check for an accelerator key.
	EVENT_TYPE ccode = event.type;
	if ((ccode == L_EXIT_FUNCTION) || (event.rawCode == KEY_X))
		eventManager->Put(UI_EVENT(L_EXIT_FUNCTION));

	if (ccode == E_KEY)
	{
		switch (event.rawCode)
		{
#ifndef DESKTOP
			case KEY_C:
					Option_Setup(VGACONF_WINDOW);
				break;
#endif
			case KEY_T:
				if (isMontypeProduct)
					Option_Setup(MONITOR_WINDOW);
				break;
			case KEY_B:
				Option_Setup(ABOUT_WINDOW);
				break;
			case KEY_H:
				Option_Help(CLHELP_KEYBOARD);
				break;
			case KEY_M:
				Option_Setup(DISPLAY_WINDOW);
				break;
#ifndef DESKTOP
			case KEY_F:
					Option_Help(CLHELP_VGACONF);
				break;
#endif
			case KEY_O:
				if (isMontypeProduct)
					Option_Help(CLHELP_MONITOR);
				break;
			case KEY_U:
				Option_Help(CLHELP_MOUSE);
				break;
			case KEY_V:
				Option_Help(CLHELP_DISPLAY);
				break;
		};

		// Define the set of accelerator keys.
		static struct ACCELERATOR_PAIR
		{
			RAW_CODE rawCode;
			LOGICAL_EVENT logicalType;
		} acceleratorTable[] =
		{
			{ SHIFT_F5,             S_DEINITIALIZE },
			{ SHIFT_F6,             S_REDISPLAY },
			{ ALT_F4,               L_EXIT_FUNCTION },
			{ 0, 0 }        // End of array.
		};

		for (int i = 0; acceleratorTable[i].rawCode; i++)
			if (event.rawCode == acceleratorTable[i].rawCode)
			{
				UI_EVENT tEvent(acceleratorTable[i].logicalType);
				eventManager->Put(tEvent);      // Put the accelarator key
				return (ccode);                         // into the system.
			}
	}

	// Process the event according to its type.
	if (ccode >= CLHELP_MENU)
		Option_Help(event.type);                                // Help option.
	else if (ccode >= SETUP_MENU)
		Option_Setup(event.type);                       // Monitor option.
	else
		ccode = UIW_WINDOW::Event(event);       // Unknown event.

	// Return the control code.
	return (ccode);
}

EVENT_TYPE CONTROL_WINDOW::Message(UI_WINDOW_OBJECT *object, UI_EVENT &event,
	EVENT_TYPE ccode)
{
	// Put the message in the event queue so the control window
	// can handle it at a higher level.
	if (ccode == L_SELECT)
	{
		for (UI_WINDOW_OBJECT *tObject = object->windowManager->First();
			tObject && FlagSet(tObject->woAdvancedFlags, WOAF_TEMPORARY);
			tObject = tObject->Next())
			object->eventManager->Put(UI_EVENT(S_CLOSE_TEMPORARY));
		event.type = ((UIW_POP_UP_ITEM *)object)->value;
		object->eventManager->Put(event);
	}
	return (ccode);
}

#ifdef DESKTOP // MOD2, Centering Update Exit (MOD2, ALL WITHIN IFDEF DESKTOP)

void Centering_TSR_Update()  // UPDATE CTABLE in CENTER.COM, IF FOUND
{
	FILE *stream;
	char inFile[11] =  "CENTER.COM"; // CENTERING TSR
	char ch;
	fpos_t filepos;
	unsigned int index;

	if ((stream = fopen(inFile, "rb+")) == NULL){  // center.exe file doesn't exist, give error
	  centercom = FALSE;
	}
	else {  // FIND CTABLE & MODIFY IT WITH CLMODE CTABLE
	  centercom = TRUE;
	  do {  // FIND ID FIRST
	    ch = fgetc (stream);
	    if (ch == 0x43){
	      ch = fgetc (stream);
	      if (ch == 0x54){
		ch = fgetc (stream);
		if (ch == 0x41){
		  ch = fgetc (stream);
		  if (ch == 0x42){
		    ch = fgetc (stream);
		    if (ch == 0x4C){
		      ch = fgetc (stream);
		      if (ch == 0x45){
			fgetpos (stream,&filepos); // CTABLE found!
			fsetpos (stream,&filepos); // reset for writing
			goto TableFound;
		      }
		    }
		  }
		}
	      }
	    }
	  } while (!feof(stream));
	  TableFound:
	  if (!feof(stream)) {  // Transfer ptables into CENTER.COM CTABLE
	    for (index = 0; index < 0x3FF; index++)
	      fputc (ptableA [index],stream);
	    fputc (0,stream);
	    for (index = 0; index < 0x1AF; index++)
	      fputc (ptableB [index],stream);
	    fseek(stream,0x13L,SEEK_SET);
	    fputc (CtableTotal,stream);  // Write number of extended modes
	  }
	  fclose(stream);
	}
}

EVENT_TYPE Centering_Update(UI_WINDOW_OBJECT *data, UI_EVENT &,      EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *button = (UIW_BUTTON *)data;

	switch(button->value) {
		case S_SAVE:
			Centering_TSR_Update();
		case S_CLOSE:
			data->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
	};

	return(ccode);
}

void MonitorAdjustUpdate()
{
	centerupdate = TRUE;
	UIW_WINDOW *window = new UIW_WINDOW(25, 6, 42, 7, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE);

	UI_WINDOW_OBJECT *object = NULL;
	char *title = new char[20];
	strcpy(title, "Centering Adjust ");

	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE(title)
		+ new UIW_PROMPT(4, 1, "Do you want to save your new")
		+ new UIW_PROMPT(4, 2, "centering adjustments to TSR ?")
		+ new UIW_BUTTON(8, 4, 9, "&No", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Centering_Update, S_CLOSE)
		+ new UIW_BUTTON(23, 4, 9, "&Yes",      BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Centering_Update, S_SAVE);

	object->windowManager->Add(window);
}
#endif

EVENT_TYPE Exit_Update(UI_WINDOW_OBJECT *data, UI_EVENT &,      EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return 0;

	// Exit the application by sending a message.
	UIW_BUTTON *button = (UIW_BUTTON *)data;

	switch(button->value) {
		case S_SAVE:
			updateAutoexec();
		case S_CLOSE:
			data->eventManager->Put(UI_EVENT(L_EXIT));
			break;
		case L_CANCEL:
			data->eventManager->Put(UI_EVENT(S_CLOSE));
			break;
	};

	return(ccode);
}

void Window_Update()
{
	clupdate = TRUE;
	UIW_WINDOW *window = new UIW_WINDOW(25, 6, 42, 7, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE );

	UI_WINDOW_OBJECT *object = NULL;
	char *title = new char[20];
	strcpy(title, "Exit ");
	strcat(title, filename);

	*window
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE(title)
		+ new UIW_PROMPT(4, 1, "Do you want to update the new")
		+ new UIW_PROMPT(4, 2, "settings in AUTOEXEC.BAT ?")
		+ new UIW_BUTTON(4, 4, 9, "&No", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Update, S_CLOSE)
		+ new UIW_BUTTON(16, 4, 9, "&Yes",      BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Update, S_SAVE)
		+ new UIW_BUTTON(28, 4, 9, "C&ancel", BTF_NO_TOGGLE | BTF_AUTO_SIZE,
			WOF_BORDER | WOF_JUSTIFY_CENTER, Exit_Update, L_CANCEL);

	object->windowManager->Add(window);
}

EVENT_TYPE CL_WINDOW_MANAGER::ExitFunction(UI_DISPLAY *,
	UI_EVENT_MANAGER *eventManager, UI_WINDOW_MANAGER *windowManager)
{                        // MOD2, eventManager added on previous line
	char *title = new char[20];
	strcpy(title, "Exit ");
	strcat(title, filename);


	// if int 15h call is success, bypass the updating of autoexec.bat
   union REGS   regs;
#ifdef DESKTOP
	centercom = TRUE;  // Assume to start, MOD2
	if (CenteringTable[0] != 0xFF){ // MOD2, CENTERING
	  MonitorAdjustUpdate();
	  EVENT_TYPE ccode;
	  do {               // Wait for user response
	    UI_EVENT event;
	    eventManager->Get(event);
	    if (centerupdate)  // MonitorAdjustUpdate() has been executed
	    {
			switch (event.rawCode) {
				case KEY_Y:
					Centering_TSR_Update();
				case KEY_N:
					eventManager->Put(UI_EVENT(S_CLOSE));
					break;
			}
	    }
	    ccode = windowManager->Event(event);
	  } while (ccode != S_CLOSE);
	  centerupdate = FALSE;
	  if (centercom == FALSE){  // MOD2, COM file not found
	    UIW_WINDOW *ferror = new UIW_WINDOW(28, 6, 35, 9, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE );

	    *ferror
		+ new UIW_BORDER
		+ new UIW_SYSTEM_BUTTON
		+ new UIW_TITLE("File Error...");
	    *ferror
		+ new UIW_PROMPT(3, 1, "CLMODE can not find the TSR")
		+ new UIW_PROMPT(3, 2, "file CENTER.COM!  Please")
		+ new UIW_PROMPT(3, 3, "check to see if CENTER.COM")
		+ new UIW_PROMPT(3, 4, "is available, and retry.")
		+ new UIW_BUTTON(11, 6, 10, "OK",
			BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
			WOF_JUSTIFY_CENTER, NULL, S_CLOSE);
		*windowManager + ferror;
	    putch (7);
	    do {               // Wait for user response
	      UI_EVENT event;
	      eventManager->Get(event);
	      ccode = windowManager->Event(event);
	    } while (ccode != S_CLOSE);
	  }
	}                               // MOD2

	outportb(0x3c4, 0x9);        // EEPROM only work on desktop product currently -sean
	regs.h.dh = inportb(0x3c5);
	outportb(0x3c4, 0xa);
	regs.h.dl = inportb(0x3c5);
	regs.x.ax = 0x448f;
	int86(0x15,&regs,&regs);

	// int 15h call failed
	if ((!isEEPROMPresent()) && (regs.x.cflag != 0) && isModified())
		Window_Update();
#else           // desktop --sean
	if (isModified())
		Window_Update();                // for laptop product --sean
#endif          // desktop --sean
	else
	{
		clexit = TRUE;

		// Create the exit window.
		char *message = new char[40];
		strcpy(message, "This will exit ");
		strcat(message, filename);
		strcat(message, " Utility. ");

		UIW_WINDOW *window = new UIW_WINDOW(25, 6, 40, 6, WOF_NO_FLAGS,
			WOAF_MODAL | WOAF_NO_SIZE);

		*window
			+ new UIW_BORDER
			+ new UIW_SYSTEM_BUTTON
			+ new UIW_TITLE(title)
			+ new UIW_STRING(3, 1, 32, message, 100, STF_NO_FLAGS, WOF_NON_SELECTABLE | WOF_JUSTIFY_CENTER);
		*window
			+ new UIW_BUTTON(6, 3, 10, "O&K",
			BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
				WOF_JUSTIFY_CENTER, NULL, L_EXIT)
			+ new UIW_BUTTON(21, 3, 10, "C&ancel",
				BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
				WOF_JUSTIFY_CENTER, NULL, S_CLOSE);
		*windowManager + window;
	}
	return (S_CONTINUE);
}

void commandLine(int argc, char *argv[])
{
#ifdef DESKTOP
      GD5420 = is5420 (); /* SGC, 2-25-93, check for 5420, 1 = is there */
#endif
      for(int i=1; i < argc; i++) {
		int j = 0;
	   switch(*(argv[i])) {
			case '-' :
			case '?' :
			case '/' :
			case 'h' :
			case 'H' :
				help = HELP_SCREEN;
				break;
			case 't' :                              // vertical timings
			case 'T' :
				byte freq = argv[i][3] - 0x30;
				switch(argv[i][1]) {
					case('6'):              // 640x480
						if (freq > F640_72)
							help = HELP_SCREEN;
						else tbl[FREQ_640].value = freq;
						break;
					case('8'):              // 800x600
						if (freq > F800_72)
							help = HELP_SCREEN;
						else tbl[FREQ_800].value = freq;
						break;
					case('1'):              // 1024x768
						if (((isHiFreqProduct) && (freq > F1024_76))
						|| ((isHiFreqProduct == FALSE) && (freq > F1024_72)))
							help = HELP_SCREEN;
						else tbl[FREQ_1024].value = freq;
						break;
					case('2'):              // 1280x1024
						if (((isHiFreqProduct) && (freq > 3))
						|| ((isHiFreqProduct == FALSE) && (freq > 1)))
							help = HELP_SCREEN;
						else {
							if ((isHiFreqProduct == FALSE) && (freq == 1))
								freq = NOT_AVAILABLE;
							tbl[FREQ_1280].value = freq;
						}
						break;
					default:
						help = HELP_SCREEN;
						break;
				};
				if (help != HELP_SCREEN) {
					tbl[HMONITOR].value = MONTYPE_8;
				   setVertMontype(tbl[FREQ_640].value, tbl[FREQ_800].value,     tbl[FREQ_1024].value, tbl[FREQ_1280].value);
				}
				break;
			case 'm' :      // monitor type option
			case 'M' :      // monitor type option
				if (isMontypeProduct)
				{
					for (j=1; j < (strlen(argv[i])); j++) {
						if (isdigit(argv[i][j]))
							tbl[HMONITOR].value = argv[i][j] - 0x30;
						else tbl[HMONITOR].value = 0x80;        // unknown monitor type
					}                                                       
					if ((tbl[HMONITOR].value > 7) || (!(isModeSupported(clmode))))
						help = HELP_MONTYPE;
					else 
					{
						system("cls");
						setHorzMontype(tbl[HMONITOR].value);
					}
				}
				else
					help = HELP_NOMONITOR;
			// Need to update the list of modes supported
				delete modeList;                                // free the pointer to be safe
				modeList = NULL;                                // initialize it
			   for(int mode=0x7f; mode >= 0x14; mode--)
			getExtdMode(mode);
			   for(mode=(MAXSTD-1); mode >= 0; mode--)
				getStdmode(mode);
		break;
			case 'n' :      // disable power save mode
			case 'N' :      // disable power save mode
#ifdef DESKTOP
				help = HELP_SCREEN;
#else
				tbl[POWER].value = PM_0;
				setPowerManagement(PM_0);
		break;
#endif
			case 'k' :      // enable keyboard stand-by mode timer
			case 'K' :      // enable keyboard stand-by mode timer
#ifdef DESKTOP
				help = HELP_SCREEN;
#else
				if (getDisplayStatus(DISPLAY) != CRT)
				{
					if (argv[i][1] == '=')
					{
						j=2;
						tbl[POWER].value = PM_4;
						sscanf(&(argv[i])[j],"%d",&(tbl[TIMER].value));
						do {j++;} while (argv[i][j]!=0x00);
						if (tbl[TIMER].value < minTimer)
							tbl[TIMER].value = minTimer;
						else if (tbl[TIMER].value > maxTimer) 
							tbl[TIMER].value = maxTimer;
						setPowerManagement(PM_4);
					}
					else help = HELP_CONFIG;
				}
				else help = HELP_PM;
#endif
		break;
			case 'c' :      // enable no CPU video access stand-by mode timer
			case 'C' :      // enable no CPU video access stand-by mode timer
#ifdef DESKTOP
				help = HELP_SCREEN;
#else
				if (getDisplayStatus(DISPLAY) != CRT)
				{
					if (argv[i][1] == '=')
					{
						j=2;
						tbl[POWER].value = PM_3;
						sscanf(&(argv[i])[j],"%d",&tbl[TIMER].value);
						do {j++;} while (argv[i][j]!=0x00);
						if (tbl[TIMER].value < minTimer)
							tbl[TIMER].value = minTimer;
						else if (tbl[TIMER].value > maxTimer)
							tbl[TIMER].value = maxTimer;
						setPowerManagement(PM_3);
					}
					else help = HELP_CONFIG;
				}
				else help = HELP_PM;
#endif
		break;
			case 's' :      // vgaconf status display
			case 'S' :      // vgaconf status display
				status = TRUE;
		break;
			case 'v' :      // vgaconf option
			case 'V' :      // vgaconf option
#ifndef DESKTOP
				keyword[0] = argv[i][1];                // just get the
				keyword[1] = argv[i][2];                // first 3 characters
				keyword[2] = argv[i][3];                // of the keyword
				boolean found = FALSE;
				int k=0;
				do
				{
					if (stricmp(keyword, confKey[k].string) == 0) found=TRUE;
					else k++;
				} while ((!found) && (k < MAXKEYWORD));
				// RGB option not supported for Peaven
				if ( (isPeaven()) && ((keyword[0] == 'w') || (keyword[0] == 'W')))
					found = FALSE;
				if (!found) help = HELP_CONFIG;
				else
				{
					tbl[confKey[k].option].value = confKey[k].value;
					tbl[confKey[k].option].func(tbl[confKey[k].option].value);
				}
#else
				help = HELP_SCREEN;
#endif
		break;
			default:
				int value;
				value = sscanf(&(argv[i])[j],"%x",&clmode);
				if ((value == 0) && (argv[i][j] != '0'))
					 help = HELP_MODE;
				else            // check whether mode is supported
				{
					do {j++;} while (argv[i][j]!=0x00);
					if (argv[i][j-1] == '-')
						clines = 0;
					else if (argv[i][j-1] == '*')
						clines = 1;
					else clines = 2;
					if (isModeSupported(clmode) == 2)               // > 256-color mode
						help = NONDOS_MODE;
					else if (isModeSupported(clmode) == 1)
						is_setmode = TRUE;
					else help = HELP_MODE;
				 }      // switch statement
			}       // else 
			if (help != NO_HELP)
				i=argc;                 // exit for loop
		} // for loop
}

int main(int argc, char *argv[])
{
byte hmonitor;

#ifdef DESKTOP                          // 2.30 beta 3, CHECK FOR CIRRUS Desktop PRODUCTS
unsigned int ExtRegState;

	outp (0x3c4,6);
	outp (0x3c5,0x12);
	ExtRegState = inp (0x3c5);
	if (ExtRegState != 0x12){   //We didn't find a 542X/0X product
	  outp(0x3ce, 0xA);
	  outp(0x3cf, 0xEC);        //unlock extensions on 5410
	  ExtRegState = inp (0x3cf) & 1;
	  if (ExtRegState != 1) { //no 5410, give error message
	    printf("\nPROGRAM ABORTED!!\n");
	    printf("\nYou do not have a CIRRUS LOGIC VGA installed.\n");
	    return (0);
	  }
	}
	ClearAllTables ();  // Clear Centering tables MOD2
#endif

	// Get the "filename".EXE string
	int i = strlen(argv[0]) - 5;
	for (int j=0; argv[0][i] != 0x5c; j++,i--)
		filename[j] = argv[0][i];

	for(j=0; i >= 0; j++, i--)
		filepath[j] = argv[0][i];

	strrev(filename);
	strrev(filepath);
#ifndef DESKTOP
	if (!isCLActive()) {
		printHeader();
		printf("%s\n", filename, " only runs on the monitor connected to the Cirrus Logic video adapter !!!");
		return (0);
	}
#endif
	// initialize all the flags for functions that are supported

/* SGC, 2-25-93, to SGC END */

#ifdef DESKTOP                          // EEPROM only work on desktop product currently -sean
	isMontypeProduct = TRUE;  // Must be true for advanced options on desktop
	chiptype = is54XX ();     // check on chiptype
#else
	isMontypeProduct = isMonitorTypeSupported();
#endif

/* SGC END */

	isVesaProduct = isVesaSupported();

	// Get the list of modes available
    for(int mode=0x7f; mode >= 0x14; mode--)
       getExtdMode(mode);
    for(mode=(MAXSTD-1); mode >= 0; mode--)
	    getStdmode(mode);

	// Initialize the bankidx register
	// For Cirrus design, the bankidx is E otherwise it's 9 for Acumos chips
   union REGS   regs;
	outp(0x3ce, 0xA);
	outp(0x3cf, 0xEC);                                      // unlock extensions
	if (inp(0x3cf) & 1) {                           // Cirrus
		BANKIDX = 0xE;
		outport(0x3ce, 0x030D);                 // select 64K page
	}
	else BANKIDX = 9;

	regs.x.ax = 0;            /* 2.30 beta 2, get mouse driver status */
	int86(0x33,&regs,&regs);
	MouseDriverStatus = regs.x.ax;

	// initialize the current monitor type and advanced frequency option
	if (isMontypeProduct) {
		// initialize the horizontal and vertical timings values
		isHiFreqProduct = isHiFreqSupported();
		NOT_AVAILABLE = (isHiFreqProduct ? 3 : 1 );
		for(int i=FREQ_640; i <= HMONITOR; i++)
			tbl[i].oldValue = tbl[i].value = getDisplayStatus(i);
	}
	
	// initialize the current display status if supported
#ifndef DESKTOP
	if (is6410())
		minTimer = 3;
	for(int option = TEXT_REVERSE; option <= TIMER; option++)
		tbl[option].oldValue = tbl[option].value = getDisplayStatus(option);
	if ( (is6410()) && ( (((tbl[TIMER].value-1) % 4) != 3) ||
	(((tbl[TIMER].value-1) % 4) != 2)) && (tbl[TIMER].value > 3))
	{
		tbl[TIMER].value--;
		tbl[TIMER].oldValue--;
	}
#endif

	dosModeStr = new char[4];
	clmode = dosMode = *((byte far*) MK_FP(0, 0x449));
	if ((dosMode == 7) | (dosMode == 0xf))
	    setMode(0x12, 2, FALSE);

	itoa(dosMode, dosModeStr, 16);
	clines = getScanlines();

if (argc == 1)                                  // desktop execution
{
	// Use the EGAVGA.BGI driver
	registerbgidriver(EGAVGA_driver);

	// Initialize the display (compiler dependent).
	UI_DISPLAY *display = new UI_BGI_DISPLAY;

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_CURSOR
		+ new UID_MOUSE;

	// Initialize the application window manager and add the control window.
	CL_WINDOW_MANAGER *windowManager = new CL_WINDOW_MANAGER(display, eventManager);
	CONTROL_WINDOW *window = new CONTROL_WINDOW;
	*windowManager + window;

	// This line assigns the exit function to be called before the control
	// window is closed.  It MUST be after the window is added to windowManager.
	windowManager->screenID = window->screenID;

	char *helpfile = new char[80];
	strcpy(helpfile, filepath);
	strcat(helpfile, filename);
	strcat(helpfile, ".DAT");

	// Initialize the help system.
	UI_WINDOW_OBJECT::helpSystem = new UI_HELP_SYSTEM( helpfile,
		windowManager, HELP_VGACONF);

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

#ifndef DESKTOP
		closeError=TRUE;
		if ((event.rawCode == ESCAPE) || (event.rawCode == ALT_A))
			escFlag=TRUE;           // don't open the standby error window
#endif

		if (clupdate)                           // Window_Update() has been executed
		{
			switch (event.rawCode) {
				case KEY_A:
					eventManager->Put(UI_EVENT(S_CLOSE));
					clupdate=FALSE;         // no, the user didn't want to exit
					break;
				case KEY_Y:
					updateAutoexec();
				case KEY_N:
					eventManager->Put(UI_EVENT(L_EXIT));
					break;
			}
		}

#ifdef DESKTOP  // MOD2, Centering
		if (centerupdate)  // MonitorAdjustUpdate() has been executed
		{
			switch (event.rawCode) {
				case KEY_Y:
					Centering_TSR_Update();
				case KEY_N:
					eventManager->Put(UI_EVENT(S_CLOSE));
					break;
			}
		}
#endif

		if (clexit)                                     // exitfunction() has been executed
		{
			if (event.rawCode == KEY_A)
			{
				eventManager->Put(UI_EVENT(S_CLOSE));
				clexit=FALSE;           // no, the user didn't want to exit
			}
			else if (event.rawCode == KEY_K)
				eventManager->Put(UI_EVENT(L_EXIT));
		}
		
		if (event.rawCode == ESCAPE)
			eventManager->Put(UI_EVENT(S_CLOSE));

		// Check for a screen reset message.
		if (event.type == S_RESET_DISPLAY)
		{
			event.data = NULL;

			// Tell the managers we changed the display.
			windowManager->Event(event);
			eventManager->Event(event);

			delete display;
			if (event.rawCode == TDM_NONE)
				display = new UI_BGI_DISPLAY;

			// Tell the managers we changed the display.
			event.data = display;
			eventManager->Event(event);
			ccode = windowManager->Event(event);
		}
		else
			ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete UI_WINDOW_OBJECT::helpSystem;
	delete windowManager;
	delete eventManager;
	delete display;

	if ((dosMode == 7) | (dosMode == 0xf))
	  setMode(dosMode, clines, FALSE);          // call the BIOS to set the mode
}       // if statement
else                    // command-line code
	commandLine(argc, argv);

	if ((is_setmode) && (isModeSupported(clmode)))
		setMode(clmode, clines, TRUE);          // call the BIOS to set the mode
	else
	{                       // better check to see if the dosMode is still valid
		if (!(isModeSupported(dosMode)))
			 setMode(3, 2, TRUE);                                    // default to mode 3+
		else    // we're ok, its still a valid mode
		{
			if ((dosMode == 7) | (dosMode == 0xf))
			  setMode(dosMode, clines, TRUE);          // call the BIOS to set the mode
			printHeader();
			printf("Video Mode is %s\n", dosModeStr);
		}
	}

	if (isMontypeProduct) {
#ifndef DESKTOP
		hmonitor = getDisplayStatus(HMONITOR);     //get real current montype 231p-b5
#else
		hmonitor = tbl[HMONITOR].value;
#endif
		if (hmonitor <= 8){  // beta 3 2.30
		 if (hmonitor != MONTYPE_8)
			printf("Monitor Type (%d) %s\n", hmonitor, monType[hmonitor]);
		 else {
			printf("Vertical frequency settings:\n");
#ifdef DESKTOP          /* SGC, 2-26-93 */
			if (GD5420 == 0)
#endif
			  printf("%s;  %s;  %s", f640tbl[tbl[FREQ_640].value],
			  f800tbl[tbl[FREQ_800].value], f1024tbl[tbl[FREQ_1024].value]);
#ifdef DESKTOP
			else {
			  if (tbl[FREQ_1024].value >= 3)
			    printf("%s;  %s;  %s", f640tbl[tbl[FREQ_640].value],
			    f800tbl[tbl[FREQ_800].value], f1024tbl[3]);
			  else
			    printf("%s;  %s;  %s", f640tbl[tbl[FREQ_640].value],
			    f800tbl[tbl[FREQ_800].value], f1024tbl[tbl[FREQ_1024].value]);
			}
#endif
			if (tbl[FREQ_1280].value == NOT_AVAILABLE)
				printf("\n");
			else {
#ifdef DESKTOP                          /* SGC, 2-25-93 */
			  if (GD5420 == 1)
			    printf("\n");
			  else
#endif
			    printf(";  %s\n", f1280tbl[tbl[FREQ_1280].value]);
			}
		 }
		}
	}

#ifdef DESKTOP    // added 3-22-93, SGC
	if (status == TRUE){
		printf("Controller Type: %s\n", ControllerType[chiptype]);
	}
#endif

#ifndef DESKTOP
	if ((getDisplayStatus(DISPLAY) != tbl[DISPLAY].value))
		printf("\nERROR ! %s\n", ErrorMessage[HELP_ENVIRONMENT]);
	if (status)
		printDisplayStatus(1);
#endif

	if (help > HELP_SCREEN)
		printf("\nERROR ! %s", ErrorMessage[help]);
	switch (help)
	{
#ifndef DESKTOP
		case NO_HELP:
			printDisplayStatus(0);
			break;
#endif
		case HELP_SCREEN:
			if ((dosMode == 7) | (dosMode == 0xf))
			  setMode(dosMode, clines, TRUE);          // call the BIOS to set the mode
			printHelp();
			break;
		case HELP_MODE:
			printModeHelp();
			break;
		case NONDOS_MODE:
			printf("%x\n", clmode);
			break;
		case HELP_MONTYPE:
			printMonitorHelp();
			break;
#ifndef DESKTOP
		case HELP_CONFIG:
			haltScreen();
			printConfHelp();
			break;
#endif
		default:
			break;
	}

	if (updatedMessage)
		printf("\nAUTOEXEC.BAT has been updated.\n");

	return (0);
}
