/*==========================================================================
  STYLE1.C

  Example code to demonstrate draw operations style 1. A GREEN filled
  rectangle is drawn.

  1. Setup draw engine context manually
  2. Setup draw trajectory of draw operation
  3. Initiate draw operation by writing to the appropriate register
  4. Repeat steps 1 to 3 for each operation

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    unsigned long save_dst_cntl;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // Step 1: Setup draw engine context manually -- and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Step 2: Setup draw trajectory of draw operation - i.e. rectangle fill

    // If a 24 bpp mode has been set, get the rotation and enable 24 bpp
    // rotation in the destination trajectory.
    if (modeinfo.bpp == 24)
    {
        wait_for_idle ();
        save_dst_cntl = regr (DST_CNTL);
        regw (DST_CNTL, save_dst_cntl | DST_24_ROTATION_ENABLE |
                        (GET24BPPROTATION(0) << 8));
    }

    // draw a filled rectangle
    wait_for_fifo (5);
    regw (DP_FRGD_CLR, get_color_code (LIGHTGREEN));
    regw (DST_X, 0);
    regw (DST_Y, 0);
    regw (DST_HEIGHT, modeinfo.yres / 4);

    // Step 3: Initiate the draw operation - DST_WIDTH is a draw initiator
    if (modeinfo.bpp == 24)
    {
        regw (DST_WIDTH, (modeinfo.xres / 4) * 3);
    }
    else
    {
        regw (DST_WIDTH, modeinfo.xres / 4);
    }

    // wait for a carriage return
    getch ();

    // Restore DST_CNTL if modified.
    if (modeinfo.bpp == 24)
    {
        wait_for_fifo (1);
        regw (DST_CNTL, save_dst_cntl);
    }

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

