; ===========================================================================
; XFERF.ASM
;
; Interface routine for XFER.C for faster VGA aperture data transfer.
;
; Compiling:
;   masm /Ml /D<memory model> getio.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1994 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA


.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; ---------------------------------------------------------------------------
; PGL_XFERF
;
; Routine to transfer data quickly (compared to C code) for the VGA aperture.
; It's assumed that the VGA aperture is already setup. The input parameters
; are fetched from the stack.
;
; Inputs : DWORD PTR - pointer to CPU data
;          WORD      - VGA aperture offset
;          WORD      - number of bytes
;          WORD      - direction (0 = read, 1 = write)
;
; Outputs: none
; ---------------------------------------------------------------------------
            public  pgl_xferf

IFDEF mem_S
pgl_xferf   proc    near
ELSE
pgl_xferf   proc    far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    ax
            push    bx
            push    cx
            push    si
            push    di
            push    ds
            push    es

            ; get direction flag (0 = READ, 1 = WRITE)
            mov     bx, WORD PTR [bp+PARM+8]
            and     bx, 1

            ; determine move direction (read if bx = 0, write if bx = 1)
            cmp     bx, 0
            jne     @F

            ; read (SRC = VGA aperture, DST = CPU data buffer)
            ;
            ; SRC = DS:SI
            ; DST = ES:DI
            ;

            ; get pointer to CPU data and place it in ES:DI
            mov     di, WORD PTR [bp+PARM]      ; get offset of CPU data
            mov     ax, WORD PTR [bp+PARM+2]    ; get segment of CPU data
            mov     es, ax

            ; get VGA aperture pointer and place it in DS:SI
            mov     si, WORD PTR [bp+PARM+4]
            mov     ax, 0a000h
            mov     ds, ax

            jmp     pxf1

@@:
            ; write (SRC = CPU data buffer, DST = VGA aperture)
            ;
            ; SRC = DS:SI
            ; DST = ES:DI
            ;

            ; get pointer to CPU data and place it in DS:SI
            mov     si, WORD PTR [bp+PARM]      ; get offset of CPU data
            mov     ax, WORD PTR [bp+PARM+2]    ; get segment of CPU data
            mov     ds, ax

            ; get VGA aperture pointer and place it in ES:DI
            mov     di, WORD PTR [bp+PARM+4]
            mov     ax, 0a000h
            mov     es, ax

pxf1:
            ; get number of bytes to transfer
            mov     cx, WORD PTR [bp+PARM+6]

            ; transfer bytes from DS:SI to ES:DI for 'CX' bytes
            rep     movsb

            ; restore saved registers
            pop     es
            pop     ds
            pop     di
            pop     si
            pop     cx
            pop     bx
            pop     ax

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

pgl_xferf  endp

            end

