/*==========================================================================
* VBLANK.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved  *
*                                                                          *
* Functions for vblank syncronization                                      *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_waitforvblank - wait for a given number of vertical blank syncs

  This function returns after the last frame on the TRAILING edge of the
  VBLANK sync pulse.
-------------------------------------------------------------------------- */
void PGL_waitforvblank(int frames)
{
    int i;

    for (i = 0; i < frames; i++)
    {
        while ((regr(CRTC_INT_CNTL) & VBLANK_ON) == VBLANK_ON) ;
        while ((regr(CRTC_INT_CNTL) & VBLANK_ON) == VBLANK_OFF) ;
    }
}

/* --------------------------------------------------------------------------
  PGL_waitforvblankst - wait for a given number of vertical blank syncs

  This function returns after the last frame on the STARTING edge of the
  VBLANK sync pulse.
-------------------------------------------------------------------------- */
void PGL_waitforvblankst(int frames)
{
    int i;

    for (i = 0; i < frames; i++)
    {
        while ((regr(CRTC_INT_CNTL) & VBLANK_ON) == VBLANK_OFF) ;
        while ((regr(CRTC_INT_CNTL) & VBLANK_ON) == VBLANK_ON) ;
    }
}

