/*==========================================================================
* SETSRC.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved  *
*                                                                          *
* PGL functions to control where source data is drawn for patterned line,  *
* patterned rectangles, and polygons.                                      *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_setsrcline - set source line coordinate for patterned lines

  Set the internal source line coordinate to draw patterned lines. This
  affects patterned lines when calling PGL_drawline(). The given line should
  be within the range of PGL_modecfg.yres and PGL_modecfg.maxy.
-------------------------------------------------------------------------- */
void PGL_setsrcline(int y)
{
    PGL_attr.srcline_y = y;
}

/* --------------------------------------------------------------------------
  PGL_getsrcline - get source line coordinate for patterned lines
-------------------------------------------------------------------------- */
int PGL_getsrcline(void)
{
    return (PGL_attr.srcline_y);
}

/* --------------------------------------------------------------------------
  PGL_setsrcrect - set source line coordinate for patterned rectangles

  Set the internal source line coordinate to draw patterned rectangles. This
  affects patterned rectangles when calling PGL_drawrect(). The given line
  should be within the range of PGL_modecfg.yres and PGL_modecfg.maxy.
-------------------------------------------------------------------------- */
void PGL_setsrcrect(int y)
{
    PGL_attr.srcrect_y = y;
}

/* --------------------------------------------------------------------------
  PGL_getsrcrect - get source line coordinate for patterned rectangles
-------------------------------------------------------------------------- */
int PGL_getsrcrect(void)
{
    return (PGL_attr.srcrect_y);
}

/* --------------------------------------------------------------------------
  PGL_setsrcpoly - set source line coordinate for polygon outlines

  Set the internal source line coordinate to draw polygon outlines. This
  affects polygons when calling PGL_drawpolygon(). The given line should be
  within the range of PGL_modecfg.yres and PGL_modecfg.maxy.
-------------------------------------------------------------------------- */
void PGL_setsrcpoly(int y)
{
    PGL_attr.srcpoly_y = y;
}

/* --------------------------------------------------------------------------
  PGL_getsrcpoly - get source line coordinate for polygon outlines
-------------------------------------------------------------------------- */
int PGL_getsrcpoly(void)
{
    return (PGL_attr.srcpoly_y);
}

