/*==========================================================================
* CALCFREQ.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL functions to calculate V and H sync frequencies.                     *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  CALC_H_FREQ - calculate the horizontal frequency

  The horizontal frequency of a given installed mode may be found by
  passing 'crtc_h_total' and 'dot_clock' from the structure returned by
  PGL_loadmodelist(). The result is accurate to one decimal place.

  h_freq = calc_h_freq(mode->crtc_h_total, mode->dot_clock);

-------------------------------------------------------------------------- */
double calc_h_freq(unsigned int crtc_h_total, unsigned int dot_clock)
{
    return (double)((dot_clock * 100UL) / ((unsigned long)(crtc_h_total + 1UL) * 8UL));
}

/* --------------------------------------------------------------------------
  CALC_V_FREQ - calculate the vertical frequency

  The vertical frequency of a given installed mode may be found by
  passing 'crtc_h_total', 'crtc_v_total', 'dot_clock', and 'crt_parms1' from
  the structure returned by PGL_loadmodelist(). 'crt_parms1' is used to find
  out if the mode is doublescanned. The returned value is an integer. The
  returned value will be zero if either 'crtc_h_total' or 'crtc_v_total' are
  zero.

  v_freq = calc_v_freq(mode->crtc_h_total,
                       mode->crtc_v_total,
                       mode->dot_clock,
                       mode->crt_parms1);

-------------------------------------------------------------------------- */
int calc_v_freq(unsigned int crtc_h_total,
                unsigned int crtc_v_total,
                unsigned int dot_clock,
                unsigned int crt_parms1)
{
    unsigned long vfreq;

    // protect code from zero values passed from ROM
    if ((crtc_h_total == 0) || (crtc_v_total == 0))
    {
        vfreq = 0;
    }
    else
    {
        vfreq = (dot_clock * 1250UL) / ((unsigned long)crtc_h_total * (unsigned long)crtc_v_total);
        if ((crt_parms1 & 0x100) == 0x100)
        {
            // double scanned
            vfreq = vfreq * 2;
        }
    }

    return ((int)vfreq);
}

