/*==========================================================================
* BIT.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved  *
*                                                                          *
* Private PGL unity functions to manipulate bit patterns.                  *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"


/* --------------------------------------------------------------------------
  pgl_swapnibble - swaps the nibbles for each byte in the given double word

  This is useful only for 4 bpp modes.
-------------------------------------------------------------------------- */
unsigned long pgl_swapnibble(unsigned long data)
{
    unsigned long nib1, nib2, nib3, nib4;
    unsigned long nib5, nib6, nib7, nib8;

    nib1 = (data & 0x0f) << 4;
    nib2 = (data & 0xf0) >> 4;
    nib3 = (data & 0xf00) << 4;
    nib4 = (data & 0xf000) >> 4;
    nib5 = (data & 0xf0000) << 4;
    nib6 = (data & 0xf00000) >> 4;
    nib7 = (data & 0xf000000) << 4;
    nib8 = (data & 0xf0000000) >> 4;

    return (nib8 | nib7 | nib6 | nib5 | nib4 | nib3 | nib2 | nib1);
}

/* --------------------------------------------------------------------------
  pgl_get24bpprotation - calculates the rotation for 24 bpp mode

  This is useful only for 24 bpp modes. The given X coordinate must be
  in 24 bpp. The returned value is specificly designed to be ORed with
  other values when writing to the DST_CNTL register.
-------------------------------------------------------------------------- */
unsigned long pgl_get24bpprotation(int x)
{
    unsigned long rotation;

    rotation = (unsigned long)(((x * 3) / 4) % 6);

    return (rotation << 8);
}

/* --------------------------------------------------------------------------
  pgl_expand8to24bpp - given an 8 bit piece of font data, expand each bit 3
                       times

  This is useful only for 24 bpp modes where the source requires this type
  of expansion.
-------------------------------------------------------------------------- */
unsigned long pgl_expand8to24bpp(unsigned char data8)
{
    unsigned long data24, bit, mask, shifter;
    int i;

    data24 = 0;
    shifter = 0;
    mask = 1;
    for (i = 0; i < 8; i++)
    {
        bit = (data8 & mask) >> shifter;
        bit = (bit << 2) | (bit << 1) | bit;
        data24 = (data24 << 3) | bit;

        shifter++;
        mask = mask << 1;
    }

    return (data24);
}

/* --------------------------------------------------------------------------
  pgl_reversedata - reverse the bits of the given data

  This is a general utility.
-------------------------------------------------------------------------- */
unsigned long pgl_reversedata(unsigned long data, int nbits)
{
    unsigned long newdata, bit, mask, shifter;
    int i;

    if (nbits > 32) nbits = 32;

    newdata = 0;
    shifter = 0;
    mask = 1;
    for (i = 0; i < nbits; i++)
    {
        bit = (data & mask) >> shifter;
        newdata = (newdata << 1) | bit;

        shifter++;
        mask = mask << 1;
    }

    return (newdata);
}

/* --------------------------------------------------------------------------
  pgl_convertpattern - rearrange fill pattern for 4 bpp modes

  Since the default CRTC pixel order is MSB to LSB in each nibble for 4 bpp
  modes, fill patterns need converting. The fonts require MSB to LSB for
  performance reasons.
-------------------------------------------------------------------------- */
unsigned long pgl_convertpattern(unsigned long pattern)
{
    unsigned long byte1, byte2, byte3, byte4;

    byte1 = pgl_reversedata(pattern & 0xff, 8);
    byte2 = pgl_reversedata((pattern & 0xff00) >> 8, 8) << 8;
    byte3 = pgl_reversedata((pattern & 0xff0000) >> 16, 8) << 16;
    byte4 = pgl_reversedata((pattern & 0xff000000) >> 24, 8) << 24;

    return (byte4 | byte3 | byte2 | byte1);
}

/* --------------------------------------------------------------------------
  pgl_getxyoffset - calculate the physical byte offset from a given point
                    (x, y)
-------------------------------------------------------------------------- */
unsigned long pgl_getxyoffset(int x, int y)
{
    unsigned long offset;

    offset = (unsigned long)y;
    offset = (unsigned long)(offset * PGL_modecfg.pitch);
    if (PGL_modecfg.bpp == 4)
    {
        offset = (unsigned long)(offset / 2);
        offset = (unsigned long)(offset + (x / 2));
    }
    else
    {
        offset = (unsigned long)(offset * (PGL_modecfg.bpp / 8));
        offset = (unsigned long)(offset + ((PGL_modecfg.bpp / 8) * x));
    }

    // add 'memory offset' (in qwords) to final value
    offset = offset + (PGL_modecfg.memory_offset * 8);

    return (offset);
}

