/*==========================================================================
* APPADDR.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved *
*                                                                          *
* PGL functions to get and set the Linear aperture address. This will the  *
* memory mapped register routines REGR() and REGW().                       *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>
#include <malloc.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_setapertureaddress - set the linear aperture address
  
  This function sets the current linear aperture address. The PGL internal
  structure is also updated. Be sure not to set a zero aperture address.
-------------------------------------------------------------------------- */
void PGL_setapertureaddress(unsigned long address)
{
    unsigned long addr;

    // write to hardware
    if ((PGL_modecfg.chip_type == CHIP_CT_ID) ||
        (PGL_modecfg.chip_type == CHIP_DT_ID))
    {
        // 16Meg increments
        addr = (address >> 18) & 0x3fc0;
    }
    else
    {
        // 4Meg increments
        addr = (address >> 18) & 0x3ff0;
    }
    iow32(ioCONFIG_CNTL, (ior32(ioCONFIG_CNTL) & 0xffff000f) | addr);

    // update PGL structure
    PGL_updateaperturestatus();
}

/* --------------------------------------------------------------------------
  PGL_getapertureaddress - get the linear aperture address
  
  This function gets the current linear aperture address from the hardware.
-------------------------------------------------------------------------- */
unsigned long PGL_getapertureaddress(void)
{
    unsigned long addr;

    if ((PGL_modecfg.chip_type == CHIP_CT_ID) ||
        (PGL_modecfg.chip_type == CHIP_DT_ID))
    {
        // 16Meg increments
        addr = (ior32(ioCONFIG_CNTL) & 0x00003fc0) << 18;
    }
    else
    {
        // 4Meg increments
        addr = (ior32(ioCONFIG_CNTL) & 0x00003ff0) << 18;
    }
    return (addr);
}

