/*===========================================================================
 PGLGLOB.H - Copyright (c) 1994 ATI Technologies Inc.  All rights reserved

 PGL global include file for PGL source files. This file is private to the
 PGL source files. Insure that PGL.H is included BEFORE this header in the
 source file.
 ===========================================================================*/

#include "pgl.h"

// Include PGL.H BEFORE this header


// --- PGL external variable declarations ---

extern PGL_queryheader   PGL_querydata;
extern PGL_modeconfig    PGL_modecfg;
extern PGL_attribute     PGL_attr;
extern PGL_palette       save_palette[];

extern int               PGL_palSave;
extern int               PGL_modeSet;
extern int               PGL_savecurflag;
extern unsigned long     PGL_memBndry;
extern unsigned int      PGL_modeType;

extern PGL_palette       DefaultPalette[];

extern PGL_genericcolors PGL_generic;


// --- PGL private functions that are global to the PGL ---

void               pgl_autolinearaperture(void);
PGL_scissor        pgl_boxsize(int n, PGL_point *vertices);
void               pgl_bressline24(int x1, int y1, int x2, int y2);
unsigned long      pgl_convertpattern(unsigned long pattern);
void               pgl_drawln(int x1, int y1, int x2, int y2);
unsigned long      pgl_expand8to24bpp(unsigned char data8);
int                pgl_fifotimeout(int function, int entries);
unsigned long      pgl_get24bpprotation(int x);
void               pgl_getcursorposition(unsigned int *position,
                                         unsigned int *cursortype);
unsigned char far *pgl_getfontaddress(int romcode);
void               pgl_hline24(int x1, int x2, int y);
int                pgl_isatimach64rom(unsigned int rom_segment);
int                pgl_isatisigrom(unsigned int rom_segment);
void               pgl_outline(int x1, int y1, int x2, int y2);
void               pgl_preparevgaswitch(void);
void               pgl_restorecursorcolors(void);
void               pgl_restoretextmode(void);
void               pgl_restoretextscreen(unsigned int mode,
                                         unsigned int *buffer);
unsigned long      pgl_reversedata(unsigned long data, int nbits);
void               pgl_savecursorcolors(void);
void               pgl_savetextmode(void);
void               pgl_savetextscreen(unsigned int mode,
                                      unsigned int *buffer);
void               pgl_setcursorposition(unsigned int position,
                                         unsigned int cursortype);
void               pgl_setpackedpixel(void);
void               pgl_setupaperture(void);
void               pgl_solidrect(int x, int y, int width, int height);
unsigned long      pgl_swapnibble(unsigned long data);
void               pgl_terminate(void);
void               pgl_text24(int x, int y, char *string, PGL_font *font);
void               pgl_vline24(int y1, int y2, int x);

