/*===========================================================================
 PGLDEMO.H - Copyright (c) 1994 ATI Technologies Inc.  All rights reserved

 Include file for PGLDEMO source
 ===========================================================================*/

// Macro to get a random integer within a specified range
#define getrandom( min, max ) ((rand() % (max - min + 1)) + min)

// constants for BITM demo
#define MAX_BITM_LEN 160

// constants for DrawGrid
#define MAXLINES 400

//
// DEFINES FOR POLYGON DEMOS
//

#define PG_MIN 3        // minimum number of sides
#define PG_MAX 6        // maximum number of sides


// defines for Scrolling Directions
#define SCROLL_UP    0
#define SCROLL_DOWN  1
#define SCROLL_LEFT  2
#define SCROLL_RIGHT 3

// defines for demo types
#define RANDOM_DEMO  0
#define STATIC_DEMO -1

//
// CONSTANTS FOR BLIT DEMOS
//
#define  MIN_BLIT_WIDTH    50
#define  MAX_BLIT_WIDTH    150
#define  MIN_BLIT_HEIGHT   50
#define  MAX_BLIT_HEIGHT   150

//
// FUNCTION PROTOTYPES
//

typedef int (*PFUNC)(void);
typedef int (*PFUNCA)(int);

// prototypes for demo.c
int DoDemo(int (*DemoFunc)(void), int (*InitFunc)(void), 
           int (*DeInitFunc)(void), int (*ClearFunc)(int),
           long DemoCount, int BackColour);
int StaticLine(void);
int StaticOpenRect(void);
int StaticSolidRect(void);
int StaticPatternRect(void);
int StaticOpenPoly(void);
int StaticSolidPoly(void);
int StaticPatternPoly(void);
int StaticScreenBlit(void);
int StaticBufferBlit(void);
int RandLine(void);
int RandSolidRect(void);
int RandOpenRect(void);
int RandPatternRect(void);
int RandOpenPoly(void);
int RandSolidPoly(void);
int RandPatternPoly(void);
int RandScreenBlit(void);
int RandBufferBlit(void);
int SetSolidFill(void);
int SetPatternFill(void);
int InitBlit(void);
int DemoFont(void);
int View_Targa(void);
int ColourDemo(void);
int FullScreen(int BackColour);
int HalfScreen(int BackColour);

// prototypes for cursor.c
void pattern4(int xres, int yres);
void pattern8(int xres, int yres);
void pattern15(int xres, int yres);
void pattern16(int xres, int yres);
void pattern24(int xres, int yres, int depth);
void pattern32(int xres, int yres, int depth);
int  InitMouse(void);
int  CursorDemo(int type, int mouse);

// prototypes for pgldemo.c
void RandMessage(void);
void get_key_code(int *ascii_code, int *scan_code);

