#!/usr/bin/sh

filesdone=0

if [ $# -gt 0 ]
then

	for file in $*
	do
		prefix=`echo $file | sed 's/\.gz\$//g'`
		if [ "$file" != "$prefix" ]
		then
			filesdone=1
			prefix=`basename $prefix`
			gzip -dc $file > $PWD/$prefix.igs
			echo "$prefix.igs created."
		fi
	done
else
	echo "Error - No files specified!\n"
	echo "Usage:"
	echo "\tcopydir.sh file_name_1 [file_name_2 ...]"
	echo "\nFiles will be copied to the current directory as specified by \$PWD\n\n"

fi

if [ $filesdone -ne 1 ]
then
	echo "Error - No gZip files specified!\n"
	echo "Please specify files ending in \".gz\".\n"
fi
