;			Applied MicroCircuits Corporation
;			         615 Lusk Blvd.
;			      San Diego, CA 92121
;
;This file contains functions to read and and write to configuration
;registers written in Assembly language.


;--------------------------------------------------------------------
;                       FIND_PCI_BIOS
;
; Test for the existence of PCI supporting BIOS
;--------------------------------------------------------------------
find_pci_bios proc near
	mov     ah, PCI_FUNC_ID         ;load pci function id into AH
	mov     al, FIND_PCI_BIOS       ;load pci bios function into AL
	int     1ah                     ;call bios interrupt
	jc      nobios                  ;if carry flag is set no pci bios was found 
	mov     HDWR_MECH, al           ;save hardware mechanism value
	mov     INTLVL_MAJ, bh          ;save interface level major version
	mov     INTLVL_MIN, bl          ;save interface level minor version
	mov     BUSES, cl               ;save number of last PCI bus in the system
nobios:
	ret
find_pci_bios endp

;--------------------------------------------------------------------
;                       TEST_PCI_DEVICE
;
;       This function will search for a PCI device using the device's
;	vendor id and device id.
;       The return code to signal succes/failure/bad vendor id
;	will be returned in AL.
;--------------------------------------------------------------------
test_pci_dev proc near
	mov	cx, DEV_ID		;device id must be in CX
	mov	dx, VEN_ID		;vendor id must be in DX
	mov     ah, PCI_FUNC_ID 	;load pci function id into AH
	mov     al, FIND_PCI_DEV	;load search for device function into AL
	mov	si, INDEX		;device index number (0 - N)
	int     1ah             	;call bios
	cmp     ah, SUCCESS     	;check if call was successful
	jz      pci_dev_fnd         	;if yes then pci device was found
	jmp     gb_tpd          	;else go back and check al for return code
pci_dev_fnd:
	mov	DEV_FUNC, bl		;pci device found, save device & function number
	mov	BUS_NUM, bh		;save bus number
no_dev_fnd:
	ret
test_pci_dev endp

;--------------------------------------------------------------------
;                       FIND_DEV_CC
;
;       Find a PCI device with specific class code
;--------------------------------------------------------------------
find_dev_cc proc    near
	mov     ah, PCI_FUNC_ID         ;setup PCI BIOS call
	mov     al, FIND_PCI_CLASS_CODE ;BIOS call for class code
	mov     ecx, CLASS_CODE         ;load class code to look for
	mov     si, INDEX               ;put bus index in SI
	int     1ah                     ;PCI bios call
	cmp     ah, SUCCESS             ;test if there is a device with this class code
	jnz     nosuccess               ;if not return
	mov     BUS_NUM, bh             ;if yes save us number
	mov     DEV_FUNC, bl            ;also save device and function number
	inc     INDEX                   ;increment to check next buss index number
	jmp	found_cc
nosuccess:
	mov     INDEX, 0                ;
found_cc:
	ret
find_dev_cc endp

;--------------------------------------------------------------------
;			GEN_SPECIAL_CYCLE
;
;	Generates a PCI special cycle.
;---------------------------------------------------------------------
gen_special_cycle	proc	near
	mov     ah, PCI_FUNC_ID         ;setup PCI BIOS call
	mov	al, GENERATE_SPEC_CYCLE	;put special cycle code in al
	mov	bh, BUS_NUM		;put bus number in bh
	mov	edx, SPECIAL_CYCLE_DATA	;put special cycle data in edx
	int	1ah			;PCI BIOS call
	ret	
gen_special_cycle	endp

;--------------------------------------------------------------------
;                       READ_C_BYTE
;
;       Read an 8-bit configuration register.
;	The value read is returned in CL.
;--------------------------------------------------------------------
read_c_byte proc   near           
	push    bx 			;save register value
	push	ax			;
	mov	bh, BUS_NUM		;load bus number
	mov     bl, DEV_FUNC		;load device number and function number
	mov     ah, PCI_FUNC_ID		;load PCI finction id
	mov     al, READ_CONFIG_BYTE	;load read byte function
	int     1ah             	;bios interrupt call
	pop	ax			;
	pop	bx			;restore register value
	jnc	good			;if successful return to calling function
good:   ret                     	;return to calling function
read_c_byte endp

;--------------------------------------------------------------------
;                       READ_C_WORD
;
;       Read a 16-bit configuration register.
;	The value read is returned in CX.
;--------------------------------------------------------------------
read_c_word proc near    
	push    bx              	;save registers
	push	ax			;
	mov	bh, BUS_NUM		;
	mov     bl, DEV_FUNC    	;load device number and function number
	mov     ah, PCI_FUNC_ID 	;load PCI function id
	mov     al, READ_CONFIG_WORD	;load read word function
	int	1ah			;bios interrupt call
	pop	ax			;restore register values
	pop     bx              	;
	ret
read_c_word endp

;--------------------------------------------------------------------
;                       READ_C_DWORD
;
;       Read a 32-bit configuration register.
;	The value read is returned in ECX.
;--------------------------------------------------------------------
read_c_dword proc near        
	push    bx              	;save registers
	push	ax			;
	mov	bh, BUS_NUM		;
	mov     bl, DEV_FUNC    	;load device number and function number
	mov     ah, PCI_FUNC_ID 	;load PCI function id
	mov     al, READ_CONFIG_DWORD   ;load read double word function
	int     1ah             	;bios interrupt call
	pop	ax			;restore register values
	pop     bx              	;
	ret
read_c_dword endp

;--------------------------------------------------------------------
;                       WRITE_C_BYTE
;
;       Write to an 8-bit configuration register
;	The value in CL will be written to the register.
;--------------------------------------------------------------------
write_c_byte proc near
	push    ax                  	;save register values
	push    bx                  	;
	push	cx			;
	mov	cl, BYTE_VALUE		;put value to write in cl
	mov     ah, PCI_FUNC_ID     	;load function id
	mov     al, WRITE_CONFIG_BYTE	;load write function value
	mov	bh, BUS_NUM	    	;load bus number
	mov     bl, DEV_FUNC        	;load device and function number
	int     1ah                 	;call bios
	pop	cx
	pop     bx                  	;restore register values
	pop     ax                  	;
	ret
write_c_byte endp

;--------------------------------------------------------------------
;                       WRITE_C_WORD
;
;       Write to 16-bit configuration register
;	The value in CX will be written to the register.
;--------------------------------------------------------------------
write_c_word proc near
	push    bx                      ;save registers
	push	ax			;
	push	cx			;
	mov	cx, WORD_VALUE		;mov 16-bit value to write into cx
	mov     ah, PCI_FUNC_ID         ;load function id
	mov     al, WRITE_CONFIG_WORD   ;load write function value
	mov	bh, BUS_NUM		;load bus number
	mov     bl, DEV_FUNC            ;load device and function number
	int     1ah			;call bios
	pop	cx			;
	pop	ax			;
	pop     bx                      ;restore register values
	ret                             ;
write_c_word endp

;--------------------------------------------------------------------
;                       WRITE_C_DWORD
;
;       Write to a 32-bit configuration register
;	The value in ECX will be written to the register.
;--------------------------------------------------------------------
write_c_dword proc near
	push    ax			;save register values
	push    bx			;
	push	ecx			;
	mov	ecx, DWORD_VALUE	;mov 32-bit value to write into ecx
	mov     ah, PCI_FUNC_ID         ;tell BIOS this is a PCI function
	mov     al, WRITE_CONFIG_DWORD  ;tell BIOS what type of PCI function
	mov	bh, BUS_NUM		;tell BIOS which PCI bus to write to
	mov     bl, DEV_FUNC            ;load device and function number
	int     1ah                     ;call BIOS
	pop	ecx			;
	pop     bx                      ;restore register values
	pop     ax			;
	ret
write_c_dword endp

;--------------------------------------------------------------------
;			WRITE_OP_REG_BYTE
;
;	Write a byte of data to an operation register.
;--------------------------------------------------------------------
write_op_reg_byte   proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	mov	al, BYTE_VALUE		;put value to write in al
	out	dx, al			;write to the operation register
	ret
write_op_reg_byte   endp

;--------------------------------------------------------------------
;			WRITE_OP_REG_WORD
;
;	Write a 16-bit value to an operation register.
;--------------------------------------------------------------------
write_op_reg_word     proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	mov	ax, WORD_VALUE		;put value to write in ax
	out	dx, ax			;write to the operation register
	ret
write_op_reg_word     endp

;--------------------------------------------------------------------
;			WRITE_OP_REG_DWORD
;
;	Write a 32-bit value to an operation register.
;--------------------------------------------------------------------
write_op_reg_dword     proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	mov	eax, DWORD_VALUE	;put value to write in eax
	out	dx, eax			;write to the operation register
	ret
write_op_reg_dword     endp

;--------------------------------------------------------------------
;			READ_OP_REG_BYTE
;
;	Read a byte of data from an operation register.
;--------------------------------------------------------------------
read_op_reg_byte     proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	in	al, dx			;read the register
	ret
read_op_reg_byte     endp

;--------------------------------------------------------------------
;			READ_OP_REG_WORD
;
;	Read a 16-bit value of data from an operation register.
;--------------------------------------------------------------------
read_op_reg_word     proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	in	ax, dx			;read the register
	ret
read_op_reg_word     endp

;--------------------------------------------------------------------
;			READ_OP_REG_DWORD
;
;	Read a byte of data from an operation register.
;--------------------------------------------------------------------
read_op_reg_dword     proc	near
	mov	edx, OPREG_ADDR		;move operation register address to edx
	in	eax, dx			;read the register
	ret
read_op_reg_dword     endp

;--------------------------------------------------------------------

