PAGE (55, 132)
TITLE PCILIB2.ASM 

COMMENT *
	Applied MicroCircuits Corporation
	PCILIB2.ASM
	This file contains the functions that read the configuration
	registers on the AMCC MatchMaker.
*

	include	pciincl.inc
.386

	extrn	CLRSCR:BYTE, CLRSPACE:BYTE, read_flag:BYTE
	extrn	BUS_NUM:BYTE, DEV_FUNC:BYTE, flag:BYTE
	extrn	VAL_SIZE:BYTE, BYTE_VAL:BYTE, WORD_VAL:WORD, DWORD_VAL:DWORD
	extrn	WRITE_DWORD:DWORD

DSEG	SEGMENT	PARA	PUBLIC	'DATA'


DSEG	ENDS
;--------------------------------------------------------------------

	extrn	setcur:near, readcur:near, string:near, read_c_byte:near
	extrn	read_c_word:near, read_c_dword:near, write_c_byte:near
	extrn	write_c_word:near, write_c_dword:near
	extrn	place_cur:near, print_byte:near, getin_val:near
	extrn	print_word:near, print_3bytes:near, print_dword:near
	extrn	string:near, clear_screen:near

	public	do_c_read_write, read_all_config_regs
;	public	read_c_byte

CSEG    SEGMENT use16    PUBLIC  'CODE'
	ASSUME  CS:CSEG,DS:DSEG,ES:DSEG,SS:DSEG

;--------------------------------------------------------------------
;			DO_C_READ_WRITE
;
;	Read configuration registers
;--------------------------------------------------------------------
do_c_read_write  proc  near
	call	readcur			;read cursor position
	push	dx			;save it
	push	dx			;save it again
	cmp	dl, 1			;check if cursor is on column 1
	jnz	nxt_col			;if not jmp to next set of registers
	push	dx			;if it is on column 1, save cursor position again
	mov	dl, 10d			;change cursor row to 10
	call	setcur			;go move the cursor
	lea	dx, CLRSPACE		;clear the spaces where the register value will be printed
	call	string			;
	pop	dx			;restore cursor position
	mov	dl, 10d			;move it again to column 10
	call	setcur			;go move it 
	pop	ax			;restore cursor position again
	cmp	ah, 3			;check if it is on row 3
	jz	rvid			;if yes go read VID register
	cmp	ah, 4			;check if it is on row 4
	jz	rdid			;if yes go read DID register
	cmp	ah, 5			;check if it is on row 5
	jz	rcmd			;if yes go read CMD register
	cmp	ah, 6			;check if it is on row 6
	jz	rsts			;if yes go read STS register
	cmp	ah, 7			;check if it is on row 7
	jz	rrid			;if yes go read RID register
	cmp	ah, 8			;check if it is on row 8
	jz	rclcd			;if yes go read CLCD register
	cmp	ah, 9			;check if it is on row 9
	jz	rcaln			;if yes go read CALN register
	cmp	ah, 10			;check if it is on row 10
	jz	rlat			;if yes go read LAT register
	cmp	ah, 11d			;check if it is on row 11
	jz	rhdr			;if yes go read HDR register
	cmp	ah, 12d			;check if it is on row 12
	jz	rbist			;if yes go read BIST register
	cmp	ah, 13d			;check if it is on row 13
	jz	rbadr0			;if yes go read BADR0 register
	jmp	gb_cread		;go back 
nxt_col:
	push	dx			;save cursor position
	mov	dl, 41d			;move cursor to column 41
	call	setcur			;go move it
	lea	dx, CLRSPACE		;clear the spaces where value will be printed
	call	string			;
	pop	dx			;restore cursor position
	mov	dl, 41d			;move cursor to column 41
	call	setcur			;go move it
	pop	ax			;restore cursor position
	cmp	ah, 3d			;check if it is on row 3
	jz	rbadr1			;if yes go read BADR1
	cmp	ah, 4d			;check if it is on row 4
	jz	rbadr2			;if yes go read BADR2
	cmp	ah, 5d			;check if it is on row 5
	jz	rbadr3			;if yes go read BADR3
	cmp	ah, 6d			;check if it is on row 6
	jz	rbadr4			;if yes go read BADR4
	cmp	ah, 7d			;check if it is on row 7
	jz	rbadr5			;if yes go read BADR5
	cmp	ah, 8d			;check if it is on row 8
	jz	rexrom			;if yes go read EXROM register
	cmp	ah, 9d			;check if it is on row 9
	jz	rintln			;if yes go read INTLN register
	cmp	ah, 10d			;check if it is on row 10
	jz	rintpin			;if yes go read INTPIN register
	cmp	ah, 11d			;check if it is on row 11
	jz	rming			;if yes go read MINGNT register
	cmp	ah, 12d			;check if it is on row 12
	jz	rmaxl			;if yes go read MAXLAT register
	jmp	gb_cread		;
rvid:	mov	di, VID_ADDR		;move address to VID register to di
	jmp	word_reg		;go read it
rdid:	mov	di, DID_ADDR		;move address to DID register to di
	jmp	word_reg		;go read it
rcmd:	mov	di, CMD_ADDR		;move address to COMMAND register to di
	jmp	word_reg		;go read it
rsts:	mov	di, STS_ADDR		;move address to STATUS register to di
	jmp	word_reg		;go read it
rrid:	mov	di, RID_ADDR		;move address to REVISION ID register to di
	jmp	byte_reg		;go read it
rclcd:	mov	di, 0008h 		;use one location before CLCD register to read 32-bits
	jmp	b3_reg			;go read it
rcaln:	mov	di, CALN_ADDR		;move address to CALN register to di
	jmp	byte_reg		;go read it
rlat:	mov	di, LAT_ADDR		;move address to LATENCY register to di
	jmp	byte_reg		;go read it
rhdr:	mov	di, HDR_ADDR		;move address to HEADER register to di
	jmp	byte_reg		;go read it
rbist:	mov	di, BIST_ADDR		;move address to BIST register to di
	jmp	byte_reg		;go read it
rbadr0:	mov	di, BADR0_ADDR		;move address to BADR0 register to di
	jmp	dword_reg		;go read it
rbadr1:	mov	di, BADR1_ADDR		;move address to BADR1 register to di
	jmp	dword_reg		;go read it
rbadr2:	mov	di, BADR2_ADDR		;move address to BADR2 register to di
	jmp	dword_reg		;go read it
rbadr3:	mov	di, BADR3_ADDR		;move address to BADR3 register to di
	jmp	dword_reg		;go read it
rbadr4:	mov	di, BADR4_ADDR		;move address to BADR4 register to di
	jmp	dword_reg		;go read it
rbadr5:	mov	di, BADR5_ADDR		;move address to BADR5 register to di
	jmp	dword_reg		;go read it
rexrom:	mov	di, EXROM_ADDR		;move address to EXROM register to di
	jmp	dword_reg		;go read it
rintln:	mov	di, INTLN_ADDR		;move address to INTLN register to di
	jmp	byte_reg		;go read it
rintpin:mov	di, INTPIN_ADDR		;move address to INTPIN register to di
	jmp	byte_reg		;go read it
rming:	mov	di, MINGNT_ADDR		;move address to MINGNT register to di
	jmp	byte_reg		;go read it
rmaxl:	mov	di, MAXLAT_ADDR		;move address to MAXLAT register to di
	jmp	byte_reg		;go read it
byte_reg:				;read a byte wide register
	cmp	read_flag, 0		;check if it is a read operation
	jz	wbyte_reg		;if not then go write to the register
	call	read_c_byte		;read the register
	mov	BYTE_VAL, cl		;get the value ready to print
	call	print_byte		;show it
	jmp	gb_cread		;go back
wbyte_reg:				;write to a byte wide register
	mov	VAL_SIZE, 2		;initialize nibble counter
	call	getin_val		;go get the user's input
	call	write_c_byte		;write the value to the register
	jmp	gb_cread		;go back
word_reg:				;read a 16 bit register
	cmp	read_flag, 0		;check if it is a read operation
	jz	wword_reg		;if not then go write to the register
	call	read_c_word		;read the register
	mov	WORD_VAL, cx		;get the value ready to print
	call	print_word		;show it
	jmp	gb_cread		;go back
wword_reg:				;write to a 16 bit register
	mov	VAL_SIZE, 4
	call	getin_val		;get the value to write
	call	write_c_word		;go write it
	jmp	gb_cread		;go back
b3_reg:					; 24 bit register (CLCD) operation
	cmp	read_flag, 0		;checkk if it is a read operation
	jz	wdword_reg		;if not then go do a write operation
	call	read_c_dword		;read the 24-bit register as a 32 register
	mov	DWORD_VAL, ecx		;get it ready to print
	call	print_3bytes		;print it to the screen
	jmp	gb_cread		;go back
dword_reg:				;32 bit register operation
	cmp	read_flag, 0		;check if it is a read operation
	jz	wdword_reg		;if not go do a write operation
	call	read_c_dword		;read a 32 bit register
	mov	DWORD_VAL, ecx		;get it ready to print
	call	print_dword		;print the value to the screen
	jmp	gb_cread		;go back
wdword_reg:				;write to a 32 bit register
	mov	VAL_SIZE, 8
	call	getin_val		;get the value to be written
	call	write_c_dword		;write a double word to the register
	jmp	gb_cread		;go back
gb_cread:
	sub	ecx, ecx		;clear ecx
	mov	WRITE_DWORD, ecx	;clear WRITE_DWORD
	pop	dx			;pop original cursor position
	call	setcur			;move cursor to original position
	ret
do_c_read_write  endp
;--------------------------------------------------------------------
;			READ_ALL_CONFIG_REGS
;
;	Shows status of all configuration registers
;	
;--------------------------------------------------------------------
read_all_config_regs proc near
	call	readcur			;read the current cursor position
	push	dx			;save it
	mov	dx, 0301h		;move cursor to top of first column
	call	setcur			;go move it
	mov	flag, 1			;initialize flag to indicate set of registers being read
	mov	cl, 0bh			;set counter to 11
	push	cx			;save it
cregs:	mov	read_flag, 1		;set read flag to indicate read
	call	do_c_read_write		;go read the next register
	inc	dh			;set cursor position to the next column
	call	setcur			;move the cursor
	pop	cx			;restore the counter
	dec	cl			;decrement the counter
	push	cx			;save it again
	cmp	cl, 0			;check if the counter is zero
	jz	no_cregs		;
	jmp	cregs			;
no_cregs:
	cmp	flag, 1			;
	jnz	no_cregs2		;
	pop	cx			;
	mov	dx, 031eh		;
	call	setcur			;
	mov	cx, 0ah			;
	push	cx			;
	mov	flag, 2			;
	jmp	cregs			;
no_cregs2:
	pop	cx			;get data off the stack
	pop	dx			;get data off the stack
	call	setcur			;move the cursor
	ret
read_all_config_regs endp
;--------------------------------------------------------------------
CSEG	ends
	end
