PAGE (55,132)
TITLE PCI DIAGNOSTICS

COMMENT *
	PROGRAM NAME    : PCIDIAG.ASM
	COPYRIGHT       : APPLIED MICRO CIRCUITS CORPORATION
	Library file for PCI diagnostic program AMCCDIAG version 2.0
	This file contains the functions that identify all the PCI
	devices in the system and run all the diagnostics on the
	AMCC MatchMaker.
*

	include pciincl.inc
.386

	extrn   CLRSCR:BYTE, CRLF:BYTE, ANY_KEY:BYTE, SPACE:BYTE

	extrn   BYTE_VAL:BYTE, CCODE:DWORD, CLSCODE:DWORD, INDEX:WORD
	extrn   count:BYTE, flag:BYTE, MEMIO:BYTE, MEM_ALLOC:DWORD
	extrn   BYTE_VAL:BYTE, WORD_VAL:WORD, DWORD_VAL:DWORD
	extrn   BUS_NUM:BYTE, DEV_FUNC:BYTE, VEN_ID:WORD, DEV_ID:WORD
	extrn   BADR0_REG:DWORD, OPER_REG:DWORD

	extrn   TEST_OMB1:DWORD, TEST_OMB2:DWORD, TEST_OMB3:DWORD
	extrn   TEST_OMB4:DWORD, TEST_IMB1:DWORD, TEST_IMB2:DWORD
	extrn   TEST_IMB3:DWORD, TEST_IMB4:DWORD, TEST_FIFO:DWORD
	extrn   TEST_MWAR:DWORD, TEST_MWTCR:DWORD, TEST_MRAR:DWORD
	extrn   TEST_MRTCR:DWORD, TEST_MBEF:DWORD, TEST_INTCSR:DWORD
	extrn   TEST_BMCSR:DWORD, TEST_BYTE0:DWORD, TEST_BYTE1:DWORD
	extrn   TEST_BYTE2:DWORD, TEST_BYTE3:DWORD, TEST_OMBREG1:DWORD
	extrn   TEST_OMBREG2:DWORD, TEST_OMBREG3:DWORD, TEST_OMBREG4:DWORD
	extrn   FILE_HANDLE:WORD

	public  MBEF_CLR_ERR

DSEG    SEGMENT use16    PUBLIC  'DATA'

hdr2 db 'Searching for PCI BIOS...',0ah,0dh,'$'
hdr3 db 'PCI BIOS found.',0ah, 0dh, '$'
err2 db 'PCI BIOS not found.',0ah,0dh,'$'
BASE_ADDRESS db 'Base Address : ', '$'
badr0space db ', ', '$'
badr0read  db 1 dup(0)
CMD_REG    dw 1 dup(0)

HDWR_MECH  db 1 dup(0)
INTLVL_MAJ db 1 dup(0)
INTLVL_MIN db 1 dup(0)
BUSES      db 1 dup(0)
LINE_POS3   equ 40

; DEVICE TYPE INFORMATION MESSAGES

DEV_FND    db 1 dup(0)
PCI_INFO   db 0ah, 0dh, 'PCI BIOS Information:', 0ah, 0dh, '$'
IOSPACE    db 'I/O Space', '$'
MEMSPACE   db 'Memory Space', '$'
LOCATE32   db 'Locate anywhere (32)', '$'
UNDER1M    db 'Below 1 MB', '$'
LOCATE64   db 'Locate anywhere (64)', '$'
RESVD      db 'RESERVED', '$'
BUSNUMBER  db 'BusNum      : ', '$'
DEVFUNCNUM db 'DevFunc Num : ', '$'
INTERFACE  db 'Interface Level : ', '$'
MECHANISM  db 1 dup(0)
NO_MECH    db 'No Configuration Mechanism Supported', '$'
CONFIG_MECH   db 'Configuration Mechanism : #', '$'
SPECIAL_CYCLE db 1 dup(0)
NO_CYCLE   db 'No Special Cycle Support Found', '$'
YES_CYCLE  db 'Special Cycle Supported', '$'
LAST_BUS   db 'Last PCI bus number : ', '$'
NO_DEVS    db 'No PCI Devices were found', '$'
VNDRID     db 'Vendor ID   : ','$'
DVICEID    db 'Device ID : ', '$'
CLASS_CODE db 'Class Code  : ', '$'
DEV_TYPE   db 'Device Type : ', '$'
DESCRIPT   db 'Description : ', '$'
EARLY      db 'Pre 2.0 spec. device', '$'
MASS_STOR  db 'Mass Storage Controller', '$'
NTWK_CONT  db 'Network Controller', '$'
DISP_CONT  db 'Display Controller', '$'
MULTI_MED  db 'Multimedia Device', '$'
MEMRY_CONT db 'Memory Controller', '$'
BRIDGE_DEV db 'Bridge Device', '$'
GENL_DEV   db 'Does not fit class codes', '$'
ALL_DEVS   db 'All devices other than VGA', '$'
VGAS       db 'VGA-compatible device', '$'
SCSI       db 'SCSI Controller', '$'
IDEC       db 'IDE Controller', '$'
FLOPPY     db 'Floppy disk Controller', '$'
IPIC       db 'IPI Controller', '$'
OTHERS     db 'Other mass storage Controller', '$'
NET_ETHER  db 'Ethernet Controller', '$'
NET_TOKEN  db 'Token ring Controller', '$'
NET_FDDI   db 'FDDI Controller', '$'
NET_OTHER  db 'Other network Controller', '$'
DISP_VGA   db 'VGA-compatible Controller', '$'
DISP_XGA   db 'XGA Controller', '$'
DISP_OTHER db 'Other display Controller', '$'
MM_VIDEO   db 'Video device', '$'
MM_AUDIO   db 'Audio device', '$'
MM_OTHER   db 'Other multimedia device', '$'
MEM_RAM    db 'RAM memory controller', '$'
MEM_FLASH  db 'Flash memory controller', '$'
MEM_OTHER  db 'Other memory controller', '$'
BRIDGE_HOST   db 'Host/PCI bridge', '$'
BRIDGE_IS     db 'PCI/IS bridge', '$'
BRIDGE_EIS    db 'PCI/EIS bridge', '$'
BRIDGE_MICRO  db 'PCI/Micro Channel bridge', '$'
BRIDGE_PCI    db 'PCI/PCI bridge', '$'
BRIDGE_PCMCIA db 'PCI/PCMCIA bridge', '$'
BRIDGE_OTHER  db 'Other bridge type', '$'

;Diagnostic test messages
MBEF_CLR_ERR  db 'MBEF register did not clear. ',0ah,0dh, '$'
MBEF_B0_ERR db 'Error on byte 0 ','$'
MBEF_B1_ERR db 'Error on byte 1 ','$'
MBEF_B2_ERR db 'Error on byte 2 ','$'
MBEF_B3_ERR db 'Error on byte 3 ','$'
OF_OMBX     db 'of register OMB', '$'
CONTINUE_PROMPT db '                      Continue tests? (Y/N) ', '$'
ERR_FILE    db 'diagnos.err', '$'

opfile_err  db 'error opening file', '$'
MBEF_TEST1_FAIL db 'OMB Test 1 : Testing OMB bytes and MBEF... Failed', '$'
MBEF_TEST2_FAIL db 'OMB Test 2 : Failed', '$'
MBEF_TEST1_PASS db 'OMB Test 1 : Testing OMB bytes and MBEF... Passed', '$'
MBEF_TEST2_PASS db 'OMB Test 2 : Passed', '$'
MBEF_TEST1_ERRS db 1 dup(0)
MBEF_TEST2_ERRS db 1 dup(0)
OMB1_BYTE0_ERRS db 1 dup(0)
OMB1_BYTE1_ERRS db 1 dup(0)
OMB1_BYTE2_ERRS db 1 dup(0)
OMB1_BYTE3_ERRS db 1 dup(0)
OMB2_BYTE0_ERRS db 1 dup(0)
OMB2_BYTE1_ERRS db 1 dup(0)
OMB2_BYTE2_ERRS db 1 dup(0)
OMB2_BYTE3_ERRS db 1 dup(0)
OMB3_BYTE0_ERRS db 1 dup(0)
OMB3_BYTE1_ERRS db 1 dup(0)
OMB3_BYTE2_ERRS db 1 dup(0)
OMB3_BYTE3_ERRS db 1 dup(0)
OMB4_BYTE0_ERRS db 1 dup(0)
OMB4_BYTE1_ERRS db 1 dup(0)
OMB4_BYTE2_ERRS db 1 dup(0)
OMB4_BYTE3_ERRS db 1 dup(0)
FIFO_TEST1_PASS db 'FIFO Test 1 : Reading FIFO on loop-back mode... Passed', '$'
FIFO_TEST1_FAIL db 'FIFO Test 1 : Reading FIFO on loop-back mode... Failed', '$'

FIFO_TEST1_ERRS db 1 dup(0)
ERROR_COUNT db 'Total Diagnostic Errors : ', '$'
WRITE_STRING db 2 dup(0) , '$' ;this goes with writing errors to a file
STRING_MBEF  dd 1 dup (0)      ;write errors to a file
STRING_WAS   db 'MBEF was : ', '$'  ;write errors to a file
STRING_SHOULD_BE db 'It should have been - ', '$'  ;write errors to a file

; Variables for diagnostics
WHICH_OMBTEST     db 1 dup(0)
OMB_COUNT   db 1 dup(0)
NEXT_OMB    dd 1 dup(0)
current_omb  db 1 dup(0)
current_byte db 1 dup(0)
ERRS_FOUND  db 1 dup(0)
TMP_REG  dd 1 dup(0)
TEST_TMP_REG  dd 1 dup(0)

BAD_DMA  db 'Data mismatch!', '$'
FIFO_STRING  db 'FIFO byte ', '$'
MEM_LOC  db 'Memory location ', '$'
SMALL_SPACE db '  : ', '$'
CNTR   db 1 dup(0)
DIFF   db 1 dup(0)
colon db ':', '$'

SOURCE_BUFF dd 100 dup(?)
DEST_BUFF   dd 100 dup(?)

DSEG    ends
;--------------------------------------------------------------------

	extrn   string:near, input:near, go_dos:near, place_cur:near

	extrn   print_byte:near, print_word:near, print_dword:near
	extrn   showbyte:near, read_c_byte:near, read_c_word:near
	extrn   read_c_dword:near
	extrn   getin_val:near, write_c_byte:near, clear_mbef:near
	extrn   write_c_word:near, write_c_dword:near, clear_fifo:near

	public  test_pci_bios, fod, get_vid, run_diagnostic

CSEG    SEGMENT use16   PUBLIC  'CODE'
	ASSUME  CS:CSEG,DS:DSEG,ES:DSEG,SS:DSEG


;--------------------------------------------------------------------
;                       TEST_PCI_BIOS
;
; Test for the existence of PCI supporting BIOS
;--------------------------------------------------------------------
test_pci_bios proc near
	lea     dx, CLRSCR              ;clear screen
	call    string                  ;
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
	lea     dx, hdr2                ;print test for bios message
	call    string                  ;call string output
	mov     ah, PCI_FUNC_ID         ;load pci function id into AH
	mov     al, FIND_PCI_BIOS       ;load pci bios function into AL
	int     1ah                     ;call bios interrupt
	jc      nobios                  ;if carry flag is set no pci bios was found 
	mov     HDWR_MECH, al           ;save hardware mechanism value
	mov     INTLVL_MAJ, bh          ;save interface level major version
	mov     INTLVL_MIN, bl          ;save interface level minor version
	mov     BUSES, cl               ;save number of last PCI bus in the system
	call    pci_bus_data            ;get and print the pci bus information
	jmp     cont                    ;continue
nobios: lea     dx, err2                ;print no pci bios message
	call    string                  ;call string output
	lea     dx, ANY_KEY             ;press any key to continue
	call    string                  ;
	call    input                   ;look for the key
	call    go_dos                  ; exit program
cont:   ret
test_pci_bios endp
;--------------------------------------------------------------------
;                       PCI_BUS_DATA
;
;       Get and show PCI bus info
;--------------------------------------------------------------------
pci_bus_data  proc  near
	call    check_mechanism         ;check what type of mechanism is supported
	call    check_special_cycle     ;check if special cycle is supported
	lea     dx, hdr3                ;show pci bios was found message
	call    string                  ;call string output
	lea     dx, PCI_INFO            ;show pci info message
	call    string                  ;
	lea     dx, INTERFACE           ;show interface level message
	call    string                  ;
	mov     cl, INTLVL_MAJ          ;load first half of interface level
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;go print it
	mov     dl, '.'                 ;print the decimal point
	call    showbyte                ;
	mov     cl, INTLVL_MIN          ;load second half of interface level
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;go print it
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
	lea     dx, LAST_BUS            ;load last bus number message
	call    string                  ;
	mov     cl, BUSES               ;load last bus number
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;go print it
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
	cmp     MECHANISM, 0            ;compare mechanism to zero
	jnz     showmech                ;if it is not zero get the mechanism message
	lea     dx, NO_MECH             ;if it is zero there is no mechanism
	call    string                  ;go print the message
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
	lea     dx, NO_CYCLE            ;if no mechanism there is no cycle
	call    string                  ;
	jmp     gbpcibus                ;go back
showmech:lea    dx, CONFIG_MECH         ;load configuration message
	call    string                  ;
	mov     cl, MECHANISM           ;load mechanism number
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;go print it
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
	cmp     SPECIAL_CYCLE, 0        ;check if special cycle is zero
	jz      no_cyc                  ;if yes there is no special cycle
	lea     dx, YES_CYCLE           ;if not zero, special cycle is supported
	jmp     pcycle                  ;go print the message
no_cyc  :lea    dx, NO_CYCLE            ;load the no cycle message
pcycle: call    string                  ;
	lea     dx, CRLF                ;go to the next line
	call    string                  ;
gbpcibus:
	ret
pci_bus_data  endp
;--------------------------------------------------------------------
;                       CHECK_MECHANISM
;
;       Check which hardware mechanism is supported
;--------------------------------------------------------------------
check_mechanism  proc  near
	mov     al, HDWR_MECH           ;load mechanism number returned
	and     al, 03h                 ;mask bits and only keep bits 0 and 1
	cmp     al, 1                   ;check if mechanism number is 1
	jz      mech1                   ;mechanism number is 1, go save it
	cmp     al, 2                   ;check if mechanism number is 2
	jz      mech2                   ;mechanism number is 2, go save it
	mov     MECHANISM, 0            ;otherwise mechanism is zero
	jmp     gbcheckm                ;go back
mech1:  mov     MECHANISM, 1            ;save mechanism number
	jmp     gbcheckm                ;go back
mech2:  mov     MECHANISM, 2            ;save mechanism number
gbcheckm:
	ret
check_mechanism  endp
;--------------------------------------------------------------------
;                       CHECK_SPECIAL_CYCLE
;
;       Check if special cycle is supported
;--------------------------------------------------------------------
check_special_cycle  proc near
	mov     al, MECHANISM           ;load mechanism number
	cmp     MECHANISM, 0            ;check if it is zero
	jz      nocycle                 ;if it is no special cycle is supported
	cmp     MECHANISM, 1            ;check if it is 1
	jz      checkm1                 ;go check for special cycle support
	and     al, 20h                 ;mechanism number is 2, mask uneeded bits
	cmp     al, 0                   ;check if result is zero
	jz      nocycle                 ;if it is no special cycle is supported
	jmp     spec_cyc                ;if not zero then special cycle is supported
checkm1:and     al, 10h                 ;mechanism number is 1, mask off bits
	cmp     al, 0                   ;check if result is zero
	jz      nocycle                 ;if yes no special cycle is supported
spec_cyc:mov    SPECIAL_CYCLE, 1        ;if not zero, set special cycle flag
	jmp     gbcheckc                ;go back
nocycle:mov     SPECIAL_CYCLE, 0        ;no special cycle supported, clear flag
gbcheckc:
	ret
check_special_cycle  endp
;--------------------------------------------------------------------
;                       FIND_CC
;
;       Find a device with specific class code
;--------------------------------------------------------------------
find_cc proc    near
	mov     ah, PCI_FUNC_ID         ;setup PCI BIOS call
	mov     al, FIND_PCI_CLASS_CODE ;BIOS call for class code
	mov     ecx, CLSCODE            ;load test class code
	mov     si, INDEX               ;bus index goes in SI
	int     1ah                     ;PCI bios call
	cmp     ah, SUCCESS             ;test if there is a device with this class code
	jnz     nosxs                   ;if not return
	mov     BUS_NUM, bh             ;if yes save us number
	mov     DEV_FUNC, bl            ;also save device and function number
	inc     INDEX                   ;increment to check next buss index number
	jmp     gbo                     ;now return
nosxs:  mov     INDEX, 0                ;
gbo:    ret
find_cc endp
;--------------------------------------------------------------------
;                       FOD
;
;       This functions attempts to identify all the PCI devices
;       in the system.
;--------------------------------------------------------------------
fod     proc    near
	mov     count, 0                ;initialize count to zero
	mov     flag, 0                 ;clear flag that indicates searchc is over
	mov     DEV_FND, 0              ;clear device found flag
	mov     CLSCODE, 00000000h      ;start with class code 0
	mov     CCODE, 00000000h        ;save class code
tagn:   call    find_cc                 ;call function to search for pci device 
	cmp     ah, SUCCESS             ;check if a device was found with this class code
	jnz     gncc                    ;if not go to get the next class code
	call    get_dev_info            ;else device was found, go get device info
	jmp     gncc                    ;when done go get the next class code
gncc:   call    get_nxt_cc              ;go get the next class code
	cmp     flag, 0                 ;check if search is over
	jnz     gbfod                   ;if flag is not zero the search is over
	jmp     tagn                    ;if search is not over go search for another device
gbfod:  cmp     DEV_FND, 0              ;check if any devices were found
	jnz     fx                      ;if yes then exit
	lea     dx, NO_DEVS             ;else show message that no devices were found
	call    string                  ;
	lea     dx, crlf                ;go down to next line (carriage rturn & line feed)
	call    string                  ;
	lea     dx, ANY_KEY             ;display 'press any key' prompt
	call    string                  ;
	call    input                   ;get user input
	call    go_dos                  ;
fx:     ret
fod     endp
;--------------------------------------------------------------------   
;                       GET_DEV_INFO
;
;       Get device information if a pci device is found by function fod
;--------------------------------------------------------------------
get_dev_info proc  near
	call    get_vid                 ;go read the vendor id register of the device
	call    get_did                 ;read the device id register
	call    get_clascode            ;read the class code register
	call    print_dev_info          ;go print the device information
	ret
get_dev_info  endp
;--------------------------------------------------------------------
;                       GET_VID
;
;       Get VID register from the PCI device
;--------------------------------------------------------------------
get_vid proc    near
	mov     ax, 00                  ;load the VID register offset
	mov     di, ax                  ;load it into DI
	call    read_c_word             ;go read the register
	mov     VEN_ID, cx              ;save the returned value
	ret
get_vid endp
;--------------------------------------------------------------------
;                       GET_DID
;
;       Get the DID register of the PCI device
;--------------------------------------------------------------------
get_did proc    near
	mov     ax, 0002h               ;load the DID register offset
	mov     di, ax                  ;load it into DI
	call    read_c_word             ;go read the register
	mov     DEV_ID, cx              ;save the returned value
gbgd:   ret
get_did endp
;--------------------------------------------------------------------
;                       GET_CLASCODE
;
;       Get the CLCD register of the PCI device
;--------------------------------------------------------------------
get_clascode proc  near
	mov     ax, 0008h               ;load the register offset
	mov     di, ax                  ;load it into DI
	call    read_c_dword            ;go read the register
	mov     CCODE, ecx              ;save the returned value
	ret
get_clascode  endp
;--------------------------------------------------------------------
;                       PRINT_DEV_INFO
;
;       Print the information on the PCI device
;--------------------------------------------------------------------
print_dev_info  proc  near
	add     DEV_FND, 1              ;set flag to indicate a device was found
	lea     dx, DEV_TYPE            ;print device type message
	call    string                  ;
	mov     cl, count               ;check base class of device
	cmp     cl, 0                   ;if zero it is an early pre 2.0 device
	jz      erly                    ;
	cmp     cl, 1                   ;check if base class is 1
	jz      msc                     ;if yes it is a  mass storage controller
	cmp     cl, 2                   ;check if base class is 2
	jz      nc                      ;if yes it is a network controller
	cmp     cl, 3                   ;check if base class is 3
	jz      dc                      ;if yes it is a display controller
	cmp     cl, 4                   ;check if base class is 4
	jz      mmd                     ;if yes it is a multimedia device
	cmp     cl, 5                   ;check if base class is 5
	jz      mmryc                   ;if yes it is a memory controller
	cmp     cl, 6                   ;check if base class is 6
	jz      bd                      ;if yes device is a bridge device
	cmp     cl, 7                   ;check if base class is 7
	jz      genl                    ;if yes it is a general device
	jmp     gbpdi                   ;if none of the above then go back
erly:   lea     dx, EARLY               ;print message that device is pre 2.0
	jmp     pregs                   ;go print register contents
msc:    lea     dx, MASS_STOR           ;print message that it is a mass storage device
	jmp     pregs                   ;go print register contents
nc:     lea     dx, NTWK_CONT           ;print message that device is a network controller
	jmp     pregs                   ;go print register contents
dc:     lea     dx, DISP_CONT           ;print message, device is a display controller
	jmp     pregs                   ;go print register contents
mmd:    lea     dx, MULTI_MED           ;print message, device is a multimedia device
	jmp     pregs                   ;go print register contents
mmryc:  lea     dx, MEMRY_CONT          ;print message, device is a memory controller
	jmp     pregs                   ;go print register contents
bd:     lea     dx, BRIDGE_DEV          ;print message, device is a bridge device
	jmp     pregs                   ;go print register contents
genl:   lea     dx, GENL_DEV            ;print message, device is a general device
	jmp     pregs                   ;go print register contents
pregs:  call    string                  ;
	mov     bl, LINE_POS3           ;get the new cursor position 
	call    place_cur               ;set the cursor
	call    dev_desc                ;call function to print the device description
	lea     dx, crlf                ;go to the next line
	call    string                  ;
	lea     dx, VNDRID              ;print vendor id message
	call    string                  ;
	mov     cx, VEN_ID              ;get the vendor id
	mov     WORD_VAL, cx            ;get it ready to print
	call    print_word              ;print it
	lea     dx, space               ;move the cursor over
	call    string                  ;
	lea     dx, DVICEID             ;print device id message
	call    string                  ;
	mov     cx, DEV_ID              ;get the device id
	mov     WORD_VAL, cx            ;get it ready to print
	call    print_word              ;print it
	mov     bl, LINE_POS3           ;get new cursor position
	call    place_cur               ;mov the cursor to the new position
	lea     dx, CLASS_CODE          ;print class code message
	call    string                  ;
	mov     ecx, CLSCODE            ;put the class code in ecx
	mov     DWORD_VAL, ecx          ;get it ready to print
	call    print_dword             ;print it
	lea     dx, crlf                ;go to the next line
	call    string                  ;
	lea     dx, BUSNUMBER           ;print the bus number message
	call    string                  ;
	mov     cl, BUS_NUM             ;get the PCI bes number
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;print it
	lea     dx, space               ;move the cursor over
	call    string                  ;
	lea     dx, DEVFUNCNUM          ;print device and function number message
	call    string                  ;
	mov     cl, DEV_FUNC            ;get device and function number
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;print it
	lea     dx, crlf                ;go to the next line
	call    string                  ;
	lea     dx, BASE_ADDRESS        ;print base address message
	call    string                  ;
	call    read_badr0              ;go get and print the base address information
	lea     dx, crlf                ;go to the next line
	call    string                  ;
	call    string                  ;
gbpdi:  ret
print_dev_info  endp
;--------------------------------------------------------------------
;                       DEV_DESC
;
;       Determine and print the PCI device's description
;--------------------------------------------------------------------
dev_desc  proc near
	lea     dx, DESCRIPT            ;print the description message
	call    string                  ;
	mov     ecx, CLSCODE            ;get the device's class code
	push    ecx                     ;save it
	pop     cx                      ;pop the low word
	pop     dx                      ;pop the high word
	cmp     dl, 00                  ;compare the class code to 0
	jz      erlycc                  ;check if it is a pre 2.0 spec device
	cmp     dl, 1                   ;check if class code is 1
	jz      mstor                   ;if yes then it is a mass storage controller
	cmp     dl, 02                  ;check if class code is 2
	jz      netwrk                  ;if yes then it is a network controller
	cmp     dl, 03                  ;check if class code is 3
	jz      dsplay                  ;if yes then it is a display cintroller
	cmp     dl, 04                  ;check if class code is 4
	jz      media                   ;if yes then it is a multi media controller
	cmp     al, 05                  ;check if class code is 5
	jz      memdev                  ;if yes it is a memory controller
	cmp     al, 06                  ;check if class code is 6
	jz      bdev                    ;if yes it is a bridge device
	cmp     al, 0ffh                ;check if class code is ffh
	jz      nofit                   ;if yes then it does not fit defined class codes
	jmp     gbprc                   ;if none of the above get out
erlycc: call    pre20                   ;go determine what kind of early device it is
	jmp     gbprc                   ;get out
mstor:  call    mstorage                ;go determine what kind of mass storage controller it is
	jmp     gbprc                   ;get out
netwrk: call    netwrk_cont             ;go determine what kind of network controller it is
	jmp     gbprc                   ;get out
dsplay: call    display_cont            ;go determine what kind of display controller it is
	jmp     gbprc                   ;get out
media:  call    multi_media             ;go determine what kind of multimedia controller it is
	jmp     gbprc                   ;get out
memdev: call    memory_device           ;go determine what kind of memory controller it is
	jmp     gbprc                   ;get out
bdev:   call    bridge_device           ;go determine what kind of bridge device it is
	jmp     gbprc                   ;get out
nofit:
gbprc:  ret
dev_desc  endp
;--------------------------------------------------------------------
;                       MSTORAGE
;
;       Determine what type of mass storage device it is.
;--------------------------------------------------------------------
mstorage  proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      scsil                   ;if yes then it is a SCSI controller
	cmp     ch, 01                  ;check if sub-class is 1
	jz      ide                     ;if yes it is an IDE controller
	cmp     ch, 02                  ;check if sub-class is 2
	jz      fdc                     ;if yes it is a floppy disk controller
	cmp     ch, 03                  ;check if sub-class is 3
	jz      ipi                     ;if yes it is an IPI controller
	cmp     ch, 80                  ;check if sub-class is 80
	jz      otr                     ;if yes it is some other type of mass storage controller
scsil:  lea     dx, SCSI                ;print SCSI controller message
	jmp     gbmstr                  ;go back
ide:    lea     dx, IDEC                ;print IDE controller message
	jmp     gbmstr                  ;go back
fdc:    lea     dx, FLOPPY              ;print floppy controller message
	jmp     gbmstr                  ;go back
ipi:    lea     dx, IPIC                ;print IPI controller message
	jmp     gbmstr                  ;go back
otr:    lea     dx, OTHERS              ;print other type of controller message
gbmstr: call    string                  ;print it
	ret
mstorage  endp
;--------------------------------------------------------------------
;                       NETWRK_CONT
;
;       Determine what type of networl controller it is.
;--------------------------------------------------------------------
netwrk_cont  proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      ether                   ;if yes it is an Ethernet controller
	cmp     ch, 01                  ;check if sub-class is 1
	jz      token                   ;if yes it is a Token Ring controller
	cmp     ch, 02                  ;check if sub-class is 2
	jz      fddi                    ;if yess it is an FDDI controller
	cmp     ch, 80                  ;check if sub-class is 80
	jz      othernc                 ;if yes it is some other type of network controller
	jmp     gbnet                   ;if none of these then go back
ether:  lea     dx, NET_ETHER           ;print Ethernet controller message
	jmp     gbnet                   ;go back
token:  lea     dx, NET_TOKEN           ;print Token Ring controller message
	jmp     gbnet                   ;go back
fddi:   lea     dx, NET_FDDI            ;print floppy disk controller message
	jmp     gbnet                   ;go back
othernc:lea     dx, NET_OTHER           ;print other type of controller message
gbnet:  call    string                  ;print it
	ret
netwrk_cont  endp
;--------------------------------------------------------------------
;                       DISPLAY_CONT
;
;       Determine what type of display controller it is.
;--------------------------------------------------------------------
display_cont  proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      vg                      ;if yes it is a VGA-compatible controller
	cmp     ch, 01                  ;check if sub-class is 1
	jz      og                      ;if yes it is an XGA controller 
	cmp     ch, 80                  ;check if sub-class is 80
	jz      otherg                  ;if yes it is some other type of display controller
	jmp     gbdisp                  ;if none of these go back
vg:     lea     dx, DISP_VGA            ;print VGA controller message
	jmp     gbdisp                  ;go back
og:     lea     dx, DISP_XGA            ;print XGA controller message
	jmp     gbdisp                  ;go back
otherg: lea     dx, DISP_OTHER          ;print other type of controller message
gbdisp: call    string                  ;print it
	ret
display_cont  endp
;--------------------------------------------------------------------
;                       MULTI_MEDIA
;
;       Determine what type of multimedia device it is.
;
;       INPUTS: base code part of the class code, in register CH
;--------------------------------------------------------------------
multi_media proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      vdo                     ;if yes it is a video device
	cmp     ch, 01                  ;check if sub-class is 1
	jz      ado                     ;if yes it is an audio device
	cmp     ch, 80                  ;check if sub-class is 80
	jz      othermm                 ;if yes it is some other type of multi media device
	jmp     gbdisp                  ;if none of these go back
vdo:    lea     dx, MM_VIDEO            ;print video device message
	jmp     gbmm                    ;go back
ado:    lea     dx, MM_AUDIO            ;print audio device message
	jmp     gbmm                    ;go back
othermm: lea    dx, MM_OTHER            ;print other type of device message
gbmm:   call    string                  ;print it
	ret
multi_media  endp
;--------------------------------------------------------------------
;                       PRE20
;
;       Determine what type of pre 2.0 spec device it is
;
;       INPUT: base code part of the class code, in register CH
;--------------------------------------------------------------------
pre20   proc    near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      alldevs                 ;if yes it is for all devices other than VGA
	lea     dx, VGAS                ;if no then it is a VGA compatible device
	jmp     vgad                    ;go print the message
alldevs: lea    dx, ALL_DEVS            ;load all devices message
vgad:   call    string                  ;print the message
	ret
pre20   endp
;--------------------------------------------------------------------
;                       MEMORY_DEVICE
;
;       Determine what type of menory controller it is.
;--------------------------------------------------------------------
memory_device  proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      ramcont                 ;if yes it is a RAM controller
	cmp     ch, 01                  ;check if sub-class is 1
	jz      flashcont               ;if yes it is a Flash memory controller
	cmp     ch, 02                  ;check if sub-class is 2
	jz      othrmem                 ;if yes it is some other type of memory controller
	jmp     gbmd                    ;if none of these go back
ramcont:lea     dx, MEM_RAM             ;print RAM controller message
	jmp     gbps                    ;go back
flashcont:lea   dx, MEM_FLASH           ;print Flash memory controller message
	jmp     gbps                    ;go back
othrmem:lea     dx, MEM_OTHER           ;print other type of controller message
gbps:   call    string                  ;print it
gbmd:   ret
memory_device  endp
;--------------------------------------------------------------------
;                       BRIDGE_DEVICE
;
;       Determine what type of bridge device it is.
;--------------------------------------------------------------------
bridge_device  proc  near
	cmp     ch, 00                  ;check if sub-class is 0
	jz      pci_host                ;if yes it is a host/pci bridge
	cmp     ch, 01                  ;check if sub-class is 1
	jz      pci_is                  ;if yes it is a pci/is bridge
	cmp     ch, 02                  ;check if sub-class is 2
	jz      pci_eis                 ;if yes it is a pci/eis bridge
	cmp     ch, 03                  ;check if sub-class is 3
	jz      pci_micro               ;if yes it is a pci/micro channel bridge
	cmp     ch, 04                  ;check if sub-class is 4
	jz      pci_pci                 ;if yes it is a pci/pci bridge
	cmp     ch, 05                  ;check if sub-class is 5
	jz      pci_pcmcia              ;if yes it is a pci/pcmcia bridge
	cmp     ch, 80h                 ;check if sub-class is 80
	jz      pci_othr                ;if yes it is some other bridge type
	jmp     gb_bdev                 ;if none of these go back
pci_host:
	lea     dx, BRIDGE_HOST         ;display bridge host description
	jmp     gb_bdev                 ;
pci_is: lea     dx, BRIDGE_IS           ;
	jmp     gb_bdev                 ;
pci_eis:lea     dx, BRIDGE_EIS          ;
	jmp     gb_bdev
pci_micro:
	lea     dx, BRIDGE_MICRO
	jmp     gb_bdev                 ;
pci_pci:lea     dx, BRIDGE_PCI          ;
	jmp     gb_bdev                 ;
pci_pcmcia:
	lea     dx, BRIDGE_PCMCIA       ;
	jmp     gb_bdev                 ;
pci_othr:
	lea     dx, BRIDGE_OTHER        ;
gb_bdev:call    string
	ret
bridge_device  endp
;--------------------------------------------------------------------
;                       GENERAL_DEVICE
;
;       The PCI device si a general purpose device
;       and does not belong to any class code
;--------------------------------------------------------------------
general_device  proc  near
	lea     dx, GENL_DEV            ;display general device description
	call    string                  ;
	ret
general_device  endp
;--------------------------------------------------------------------
;                       GET_NEXT_CC
;
;       Try the next class code and look for a device
;
;       INPUTS: CLSCODE
;               INDEX
;--------------------------------------------------------------------
get_nxt_cc  proc  near
	cmp     INDEX, 0                ;check if index is zero
	jz      nxtcc                   ;if yes no device was found, go increment class code
	mov     INDEX, 0                ;reset index to zero
	mov     ecx, CLSCODE            ;else device was found, save current CC
	mov     CCODE, ecx              ;save class code
	add     CLSCODE, 00000100h      ;increment sub-class
	jmp     gobak_cc                ;go back look for another device
nxtcc:  mov     ecx, CCODE              ;bring back last class code
	mov     CLSCODE, ecx            ;restore class code
	cmp     count, 6                ;has last base class been checked
	je      no_more                 ;if yes, search is done go set flag
	jg      nowdone                 ;
	add     count, 1                ;else increment counter
	add     CLSCODE, 00010000h      ;increment class code
	mov     ecx, CLSCODE            ;move class code to ecx
	mov     CCODE, ecx              ;save it
	jmp     gobak_cc                ;go back
no_more:mov     CLSCODE, 00ff0000h      ;try last class code
	mov     ecx, CLSCODE            ;move to ecx
	mov     CCODE, ecx              ;save it 
	inc     count                   ;increment the counter
	jmp     gobak_cc                ;go look for the device
nowdone:mov     flag, 1                 ;set flag to indicate the search is over
gobak_cc:
	ret
get_nxt_cc  endp
;--------------------------------------------------------------------
;                       READ_BADR0
;
;       Read the base address register and get the base address
;       and I/O or memory allocation information.
;--------------------------------------------------------------------
read_badr0  proc  near
	call    get_base_ops            ;call the function to get the base address
	mov     ecx, BADR0_REG          ;move the base address to ecx
	push    ecx                     ;save it
	mov     DWORD_VAL, ecx          ;get it ready to print 
	call    print_dword             ;print it
	pop     cx                      ;pop lower byte
	pop     dx                      ;pop upper byte
	mov     dx, cx                  ;save lower byte in dx
	and     cl, 01h                 ;mask bit 0
	cmp     cl, 1                   ;check if the bit is set
iosp:   jnz     memsp                   ;if not set then  type is memory sapce
	mov     MEMIO, 1h               ;set the MEMIO flag to show type is IO
	lea     dx, badr0space          ;add space and comma
	call    string                  ;
	lea     dx, IOSPACE             ;write io space description
	call    string                  ;
	lea     dx, badr0space          ;add space and comma
	call    string                  ;
	mov     ecx, MEM_ALLOC          ;retrieve the amount of memory allocated for this device
	mov     DWORD_VAL, ecx          ;get it ready to print
	call    print_dword             ;print it to the screen
	jmp     gbrb0                   ;return
memsp:  mov     MEMIO, 00h              ;set the MEMIO flag to 00 to show it is memory space
	mov     cx, dx                  ;save device base address in cx
	lea     dx, badr0space          ;add space and comma
	call    string                  ;
	lea     dx, MEMSPACE            ;display message that this is memory space
	call    string                  ;
	lea     dx, badr0space          ;add space and comma
	call    string                  ;
	and     cl, 06h                 ;mask bits 1 and 2
	ror     cl, 1                   ;rotate cl right 1 bit
	cmp     cl, 0                   ;check if cl is zero
	jz      la32                    ;print
	cmp     cl, 1                   ;check if cl is one
	jz      u1mg                    ;
	cmp     cl, 2                   ;check if cl is two
	jz      lany64                  ;
	cmp     cl, 3                   ;check if cl is three
	jz      rsvp                    ;
	jmp     gbrb0                   ;
la32:   lea     dx, locate32            ;
	jmp     gb1                     ;
u1mg:   lea     dx, under1m             ;
	jmp     gb1                     ;
lany64: lea     dx, locate64            ;
	jmp     gb1                     ;
rsvp:   lea     dx, resvd               ;
gb1:    call    string                  ;
	lea     dx, badr0space          ;
	call    string                  ;
	mov     ecx, MEM_ALLOC          ;
	call    print_dword             ;
gbrb0:  ret
read_badr0  endp
;--------------------------------------------------------------------
;                       GET_BASE_OPS
;
;       Get the memory allocation information for the PCI device
;--------------------------------------------------------------------
get_base_ops  proc  near
	mov     badr0read, 1            ;set the flag to show badr0 has been read
	call    clear_cmd               ;clear command register
	mov     ax, BADR0_ADDR          ;bring up register offset
	mov     di, ax                  ;load register offset to di
	call    read_c_dword            ;read BADR0
	mov     BADR0_REG, ecx          ;save the value
	mov     ecx, 0ffffffffh         ;write all 1's to the register
	call    write_c_dword           ;write it
	call    read_c_dword            ;read the new value - memory allocated
	mov     MEM_ALLOC, ecx          ;save that value
	mov     ecx, BADR0_REG          ;bring back original value
	call    get_opreg               ;clear the proper bits to get the base address
	call    write_c_dword           ;write the original value back to the register
	call    restore_cmd             ;restore command register
	ret
get_base_ops   endp
;--------------------------------------------------------------------
;                       CLEAR_CMD
;
;       Clear the command register
;--------------------------------------------------------------------
clear_cmd  proc  near
	mov     ax, CMD_ADDR            ;get command register offset
	mov     di, ax                  ;put it in DI
	call    read_c_word             ;go read it
	mov     CMD_REG, cx             ;save the register's contents
	and     cx, 1100h               ;clear the memory and io access enable bits
	call    write_c_word            ;write the new value back to the register
	ret
clear_cmd  endp
;--------------------------------------------------------------------
;                       RESTORE_CMD
;
;       Restore the original value to the command register
;--------------------------------------------------------------------
restore_cmd  proc  near
	mov     ax, CMD_ADDR            ;get command register offset
	mov     di, ax                  ;put it in DI
	mov     cx, CMD_REG             ;get the register's original contents
	call    write_c_word            ;write it back to the register
	ret
restore_cmd   endp
;--------------------------------------------------------------------
;                       GET_OPREG
;
;       Get the base address for the operation registers
;--------------------------------------------------------------------
get_opreg  proc  near
	cmp     MEMIO, 0                ;check if mem or space to know what to mask off
	jnz     iospc                   ;jump if io space
	and     cl, 0f8h                ;if it is memory space, clear fisrt 3 bits
	jmp     gbgop                   ;go save it
iospc:  and     cl, 0fch                ;clear first 2 bits
gbgop:  mov     OPER_REG, ecx           ;save the base address
	ret
get_opreg  endp

;--------------------------------------------------------------------

;********************************************************************
;       Functions to run tests on operation registers
;
;********************************************************************
;                       RUN_DIAGNOSTIC
;
;       Run diagnostic tests on the AMCC PCI device
;--------------------------------------------------------------------
run_diagnostic  proc  near
	call    open_err_file           ;open the error tracking file
	call    run_omb_tests           ;run the mailbox tests
call_FIFO_test1:
	mov     ERRS_FOUND, 0           ;initialize error counter
	call    fifo_test1              ;run fifo test
	mov     cl, FIFO_TEST1_ERRS           ;move error count to cl
	add     ERRS_FOUND, cl          ;save fifo test1 errors
	call    check_test_results      ;print out results of the tests
;       jmp     gb_rund                 ;
;file_err:
;       lea     dx, opfile_err          ;
;       call    string                  ;
;       call    input                   ;
	call    close_err_file          ;
;       call    go_dos                  ;
gb_rund:
	ret
run_diagnostic  endp
;--------------------------------------------------------------------
;                       RUN_OMB_TESTS
;
;       Run tests on the mailbox registers
;--------------------------------------------------------------------
run_omb_tests  proc  near
	mov     OMB_COUNT, 0            ;set OMB count to 0
	call    clear_mbef              ;clear mailbox register flags
call_OMB_test1:
	mov     WHICH_OMBTEST, 1        ;signal that test1 is being run
	call    omb_test1               ;run test1 for OMB's
;       mov     cl, ERRS_FOUND          ;get error count
	mov     cl, OMB1_BYTE0_ERRS     ;
	add     cl, OMB1_BYTE1_ERRS     ;
	add     cl, OMB1_BYTE2_ERRS     ;
	add     cl, OMB1_BYTE3_ERRS     ;
	mov     MBEF_TEST1_ERRS, cl     ;
	mov     ERRS_FOUND, 0           ;
	mov     WHICH_OMBTEST, 2        ;signal that test2 is being run
call_OMB_test2: 
	call    omb_test2               ;run test2 for OMB's
	mov     cl, ERRS_FOUND          ;get error count
	mov     MBEF_TEST2_ERRS, cl     ;

	ret
run_omb_tests  endp
;--------------------------------------------------------------------
;                       CHECK_TEST_RESULTS
;
;       Prints out results of the diagnostic tests: OMB tests 1 and 2,
;       FIFO test
;--------------------------------------------------------------------
check_test_results  proc  near
	mov     cl, MBEF_TEST1_ERRS     ;
	add     cl, MBEF_TEST2_ERRS     ;
	add     cl, FIFO_TEST1_ERRS     ;
	lea     dx, crlf                ;skip 2 lines
	call    string                  ;
	call    string                  ;
	cmp     MBEF_TEST1_ERRS, 0      ;check if any errors during test1
	jz      test1_pass              ;if not then test1 passed
	lea     dx, MBEF_TEST1_FAIL     ;otherwise show message test1 failed
	call    string                  ;
	jmp     check_test2             ;go check test2 results
test1_pass:
	lea     dx, MBEF_TEST1_PASS     ;print message that test1 passed
	call    string                  ;
check_test2:
	lea     dx, crlf                ;skip a line
	call    string                  ;
	cmp     MBEF_TEST2_ERRS, 0      ;check if any errors on during test2
	jz      test2_pass              ;if not then test2 passed
	lea     dx, MBEF_TEST2_FAIL     ;otherwise show message test2 failed
	call    string                  ;
	jmp     check_fifo_test1        ;check fifo test results
test2_pass:
	lea     dx, MBEF_TEST2_PASS     ;print message that test2 passed
	call    string                  ;
check_fifo_test1:
	lea     dx, crlf                ;skip a line
	call    string                  ;
	cmp     FIFO_TEST1_ERRS, 0      ;check if any errors during fifo test1
	jz      fifo_t1_pass            ;if not then fifo test1 passed
	lea     dx, FIFO_TEST1_FAIL     ;otherwise fifo test1 failed
	call    string                  ;
	jmp     total_errs              ;
fifo_t1_pass:
	lea     dx, FIFO_TEST1_PASS     ;print message fifo test1 passed
	call    string                  ;
total_errs:
	lea     dx, crlf                ;skip a line
	call    string                  ;
	lea     dx, ERROR_COUNT         ;print total error count
	call    string                  ;
	mov     cl, ERRS_FOUND          ;get error count
	mov     BYTE_VAL, cl            ;get it ready to print
	call    print_byte              ;print it
	call    input                   ;
	ret
check_test_results  endp
;--------------------------------------------------------------------
;                       OMB_TEST1
;
;       Test OMB registers by writing to them one byte at a time.
;--------------------------------------------------------------------
omb_test1  proc  near
	lea     dx, CLRSCR              ;clear screen
	call    string                  ;
	mov     ax, dx                  ;put some number into ax
	mov     cx, 000fh               ;initialize the counter
	push    cx                      ;save it
nxt_omb:
	call    get_next_omb            ;go get the next OMB reg
	lea     dx, crlf                ;
	call    string                  ;
	call    string                  ;
check_byte0:
	mov     current_byte, 0         ;
	call    clear_mbef              ;
	mov     edx, NEXT_OMB           ;put OMB address in dx
	add     ax, 0012h               ;put data to write in al
	out     dx, al                  ;write to first byte of OMB
	in      al, dx                  ;read it back
	mov     BYTE_VAL, al            ;
	call    print_byte              ; show what is in OMB
	lea     dx, SPACE               ;
	call    string                  ;
	mov     edx, TEST_MBEF          ;get MBEF address
	in      eax, dx                 ;read the MBEF register
	mov     DWORD_VAL, eax          ;
	mov     STRING_MBEF, eax        ;save it
	push    eax                     ;
	call    print_dword             ; show status of MBEF
	lea     dx, SPACE               ;
	call    string                  ;
	mov     eax, TEST_BYTE0         ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	pop     eax                     ;
	cmp     eax, TEST_BYTE0          ;only bit 0 should be set
	jz      check_byte1             ;
	call    ombtest1_errs           ;
	cmp     flag, 'y'               ;
	jz      check_byte1             ;
	call    go_dos                  ;

check_byte1:
	mov     current_byte, 1         ;set current_byte flag to 1
	lea     dx, crlf                ;skip a line
	call    string                  ;
	call    clear_mbef              ;clear mailbox register flags
	mov     edx, NEXT_OMB           ;get the address for the next omb register
	inc     dl                      ;point to byte 1 of omb register
	mov     al, 87h                 ;init ax with some number
	out     dx, al                  ;write to byte 1
	dec     dl                      ;point to beginning of omb (byte0)
	in      eax, dx                 ;read the omb register
	mov     WORD_VAL, ax            ;
	call    print_word              ;print out the register's contents
	lea     dx, SPACE               ;
	call    string                  ;
	mov     edx, TEST_MBEF          ;get mailbox status register address
	in      eax, dx                 ;read it
	mov     DWORD_VAL, eax          ;get ready to print what was read
	push    eax                     ;save it for now
	call    print_dword             ;print it
	pop     eax                     ;get it back
	cmp     eax, TEST_BYTE1         ;**************bit 1 should be set
	jz      check_byte2             ;
	call    ombtest1_errs           ;
	cmp     flag, 'y'               ;
	jz      check_byte2             ;
eatit:  call    go_dos                  ;

check_byte2:
	mov     current_byte, 2         ;
	lea     dx, crlf                ;set current_byte flag to 2
	call    string                  ;
	call    clear_mbef              ;
	mov     edx, NEXT_OMB           ;
	inc     dl                      ;
	inc     dl                      ;
	add     ax, 0031h               ;
	out     dx, al                  ;
	dec     dx                      ;
	dec     dx                      ;
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	lea     dx, SPACE               ;
	call    string                  ;
	mov     edx, TEST_MBEF          ;
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	push    eax                     ;
	call    print_dword             ;
	pop     eax                     ;
	cmp     eax, TEST_BYTE2         ;
	jz      check_byte3             ;
	call    ombtest1_errs           ;
	cmp     flag, 'y'               ;
	jz      check_byte3             ;
	call    go_dos                  ;

check_byte3:
	mov     current_byte, 3         ;
	lea     dx, crlf                ;
	call    string                  ;
	call    clear_mbef              ;
	mov     edx, NEXT_OMB           ;
	inc     dx                      ;
	inc     dx                      ;
	inc     dx                      ;
	add     ax, 0095h               ;
	out     dx, al                  ;
	dec     dx                      ;
	dec     dx                      ;
	dec     dx                      ;
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	lea     dx, SPACE               ;
	call    string                  ;
	mov     edx, TEST_MBEF          ;
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	push    eax                     ;
	call    print_dword             ;
	pop     eax                     ;
	cmp     eax, TEST_BYTE3         ;******* change to eax ********
	jz      check_if_done           ;
	call    ombtest1_errs           ;
	cmp     flag, 'y'               ;
	jz      check_if_done           ;
	call    go_dos                  ;

check_if_done:
	cmp     OMB_COUNT, 4            ;
	jl      nxt_omb                 ;
	mov     OMB_COUNT, 00h          ;
	pop     cx                      ;
	dec     cx                      ;
	cmp     cx, 0                   ;
	jz      gb_test1                ;
	push    cx                      ;
	jmp     nxt_omb                 ;
gb_test1:
	ret
omb_test1  endp
;--------------------------------------------------------------------
;                       OMB_TEST2
;
;       Test OMB registers by writing to one register at a time (32-bit writes)
;--------------------------------------------------------------------
omb_test2  proc  near
	lea     dx, CLRSCR              ;clear screen
	call    string                  ;
	mov     cx, 000fh               ;initialize counter
	push    cx                      ;save it
	add     eax, ecx                ;put some number into eax
	add     eax, edx                ;add whatever is in edx to eax
get_nxtomb:
	call    get_next_omb            ;go get the next OMB reg
	lea     dx, crlf                ;go down 2 lines
	call    string                  ;
	call    string                  ;
	mov     dl, OMB_COUNT           ;move the OMB number to dl
	add     dl, 30h                 ;add ascii bias
	mov     ah, 02h                 ;setup for character output
	int     21h                     ;call DOS
	ror     eax, 3                  ;rotate eax 3 bits to the right
check_ombreg1:
	call    clear_mbef              ;clear the mailbox status registers
	mov     edx, NEXT_OMB           ;put OMB address in dx
	out     dx, eax                 ;write to the OMB register
	in      eax, dx                 ;read it back
	mov     DWORD_VAL, eax          ;get it ready to print 
	call    print_dword             ;show it
	mov     edx, TEST_MBEF          ;get MBEF adress
	in      eax, dx                 ;read the MBEF register
	mov     DWORD_VAL, eax          ;get it ready to print 
	push    eax                     ;save it
	call    print_dword             ;show it
	pop     eax                     ;get it back
	cmp     eax, TEST_OMBREG1       ;check if the correct bits are set
	jnz     err_on_ombreg1          ;if not show error message
check_ombreg2:
	call    get_next_omb            ;get the address to the next OMB register
	lea     dx, crlf                ;go down to the next line
	call    string                  ;
	call    string                  ;go down one more line
	mov     dl, OMB_COUNT           ;put the OMB register count in dl
	add     dl, 30h                 ;add the ascii bias
	mov     ah, 02h                 ;setup for character output
	int     21h                     ;call DOS
	call    clear_mbef              ;clear the mailbox status flag
	mov     edx, NEXT_OMB           ;put OMB address in dx
	add     eax, BADR0_REG          ;put data to write in al
	out     dx, eax                 ;write to first byte of OMB
	in      eax, dx                 ;read it back
	mov     DWORD_VAL, eax          ;get it ready toprint
	call    print_dword             ;show it
	mov     edx, TEST_MBEF          ;get MBEF adress
	in      eax, dx                 ;read the mailbox status register
	mov     DWORD_VAL, eax          ;get it ready to print 
	push    eax                     ;save it
	call    print_dword             ;show it
	pop     eax                     ;get it back
	cmp     eax, TEST_OMBREG2       ;check if the correct bits are set
	jnz     err_on_ombreg2          ;if not show an error message
check_ombreg3:
	call    get_next_omb            ;
	lea     dx, crlf                ;
	call    string                  ;
	call    string                  ;
	mov     dl, OMB_COUNT           ;
	add     dl, 30h                 ;print out which OMB reg it is
	mov     ah, 02h                 ;
	int     21h                     ;
	call    clear_mbef              ;
	mov     edx, NEXT_OMB           ;put OMB address in dx
;       add     eax, 11111155h          ;
	add     eax, BADR0_REG          ;put data to write in al
	out     dx, eax                 ;write to first byte of OMB
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	mov     edx, TEST_MBEF          ;get MBEF adress
	in      eax, dx                 ;read the MBEF register
	mov     DWORD_VAL, eax          ;
	push    eax                     ;
	call    print_dword             ;
	pop     eax                     ;
	cmp     eax, TEST_OMBREG3       ;only bit 0 should be set
	jnz     err_on_ombreg3          ;
check_ombreg4:
	call    get_next_omb            ;
	lea     dx, crlf                ;
	call    string                  ;
	call    string                  ;
	mov     dl, OMB_COUNT           ;
	add     dl, 30h                 ;print out which OMB reg it is
	mov     ah, 02h                 ;
	int     21h                     ;
	call    clear_mbef              ;
	mov     edx, NEXT_OMB           ;put OMB address in dx
	add     eax, 12151358h          ;
	add     eax, BADR0_REG          ;put data to write in al
	out     dx, eax                 ;write to first byte of OMB
	in      eax, dx                 ;
	mov     DWORD_VAL, eax          ;
	call    print_dword             ;
	mov     edx, TEST_MBEF          ;get MBEF adress
	in      eax, dx                 ;read the MBEF register
	mov     DWORD_VAL, eax          ;
	push    eax                     ;
	call    print_dword             ;
	pop     eax                     ;
	cmp     eax, TEST_OMBREG4       ;only bit 0 should be set
	jnz     err_on_ombreg4          ;
check_done:
	mov     OMB_COUNT, 00h          ;check if test is done, have all registers been tested
	pop     cx                      ;restore test iteration counter
	dec     cx                      ;decrement it
	cmp     cx, 0                   ;check if it is zero
	jz      gb_test2                ;if yes then return
	push    cx                      ;if not then save it
	jmp     get_nxtomb              ;go do it again

err_on_ombreg1:
err_on_ombreg2:
err_on_ombreg3:
err_on_ombreg4:
	add     ERRS_FOUND, 1
gb_test2:
	ret
omb_test2  endp
;--------------------------------------------------------------------
;                       GET_NEXT_OMB
;
;       Get the address of the next OMB register.
;       This function is called by the OMB test functions
;--------------------------------------------------------------------
get_next_omb  proc  near
	add     OMB_COUNT, 1            ;increment mailbox counter
	cmp     OMB_COUNT, 1            ;check if it is mailbox 1
	jnz     get_omb2                ;if not go find out which one it is
	mov     ecx, TEST_OMB1          ;if it is mailbox 1 get the address
	mov     NEXT_OMB, ecx           ;save the address
	mov     current_omb, 1
	mov     TEST_BYTE0, 00000001h   ;initialize test value for byte0 write
	mov     TEST_BYTE1, 00000002h   ;initialize test value for byte1 write
	mov     TEST_BYTE2, 00000004h   ;initialize test value for byte2 write
	mov     TEST_BYTE3, 00000008h   ;initialize test value for byte3 write
	cmp     WHICH_OMBTEST, 1        ;check if it was called by the test1 function
	jnz     test2                   ;if not then it was called by the test2 function
	jmp     gb_nxtomb
test2:  mov     TEST_OMBREG1, 0000000fh ;
	mov     TEST_OMBREG2, 000000f0h ;
	mov     TEST_OMBREG3, 00000f00h ;
	mov     TEST_OMBREG4, 0000f000h ;
	jmp     gb_nxtomb               ;
get_omb2:
	cmp     OMB_COUNT, 2            ;
	jnz     get_omb3                ;
	mov     ecx, TEST_OMB2          ;
	mov     NEXT_OMB, ecx           ;
	mov     current_omb, 2          ;
	cmp     WHICH_OMBTEST, 1        ;
	jnz     gb_nxtomb               ;
	jmp     get_test_byte           ;
get_omb3:
	cmp     OMB_COUNT, 3            ;
	jne     get_omb4                ;
	mov     ecx, TEST_OMB3          ;
	mov     NEXT_OMB, ecx           ;
	mov     current_omb, 3          ;
	cmp     WHICH_OMBTEST, 1        ;
	jnz     gb_nxtomb               ;
	jmp     get_test_byte           ;
get_omb4:
	mov     ecx, TEST_OMB4          ;
	mov     NEXT_OMB, ecx           ;
	mov     current_omb, 4          ;
	cmp     WHICH_OMBTEST, 1        ;
	jnz     gb_nxtomb               ;
get_test_byte:
	mov     ecx, TEST_BYTE0         ;
	rol     ecx, 4                  ;
	mov     TEST_BYTE0, ecx         ;
	mov     ecx, TEST_BYTE1         ;
	rol     ecx, 4                  ;
	mov     TEST_BYTE1, ecx         ;
	mov     ecx, TEST_BYTE2         ;
	rol     ecx, 4                  ;
	mov     TEST_BYTE2, ecx         ;
	mov     ecx, TEST_BYTE3         ;
	rol     ecx, 4                  ;
	mov     TEST_BYTE3, ecx         ;
gb_nxtomb:
	ret
get_next_omb  endp
;--------------------------------------------------------------------
;                       OMBTEST1_ERRS
;
;       Process and Keep track of errors that occur during OMB test 1
;--------------------------------------------------------------------
ombtest1_errs  proc  near
;       cmp     OMB_COUNT, 1            ;
;       jnz     count_omb2_errs         ;
count_omb1_errs:
	cmp     current_byte, 0         ;
	jnz     omb_b1_errs             ;
	add     OMB1_BYTE0_ERRS, 1      ;
	lea     dx, SPACE               ;
	call    string                  ;
	lea     dx, MBEF_B0_ERR         ;
	call    string                  ;
	lea     dx, OF_OMBX             ;
	call    string                  ;
	call    show_omb_num            ;
;       mov     dx, offset MBEF_B0_ERR  ;write error message to error file
;       call    write_error             ;
	jmp     get_input1              ;
omb_b1_errs:
	cmp     current_byte, 1         ;
	jnz     omb1_b2_errs            ;
	add     OMB1_BYTE1_ERRS, 1      ;
	lea     dx, SPACE               ;
	call    string                  ;
	lea     dx, MBEF_B1_ERR         ;
	call    string                  ;
	lea     dx, OF_OMBX             ;
	call    string                  ;
	call    show_omb_num            ;
;       mov     dx, offset MBEF_B1_ERR  ;write error message to error file
;       call    write_error             ;
	jmp     get_input1              ;
omb1_b2_errs:
	cmp     current_byte, 2         ;
	jnz     omb1_b3_errs            ;
	add     OMB1_BYTE2_ERRS, 1      ;
	lea     dx, SPACE               ;
	call    string                  ;
	lea     dx, MBEF_B2_ERR         ;
	call    string                  ;
	lea     dx, OF_OMBX             ;
	call    string                  ;
	call    show_omb_num            ;
;       mov     dx, offset MBEF_B2_ERR  ;write error message to error file
;       call    write_error             ;
	jmp     get_input1              ;
omb1_b3_errs:
	add     OMB1_BYTE3_ERRS, 1      ;
	lea     dx, SPACE               ;
	call    string                  ;
	lea     dx, MBEF_B3_ERR         ;
	call    string                  ;
	lea     dx, OF_OMBX             ;
	call    string                  ;
	call    show_omb_num            ;
;       mov     dx, offset MBEF_B3_ERR  ;write error message to error file
;       call    write_error             ;
	call    string                  ;
	jmp     get_input1              ;
get_input1:             
	lea     dx, crlf                ;
	call    string                  ;
	mov     dx, offset crlf         ;
	mov     cx, 2h                  ;
	call    write_to_err_file       ;
	lea     dx, CONTINUE_PROMPT     ;
	call    string                  ;
get_input2:
	call    input                   ;
	cmp     al, 'y'                 ;
	jz      go_on                   ;
	cmp     al, 'Y'                 ;
	jz      go_on                   ;
	cmp     al, 'n'                 ;
	jz      go_on                   ;
	cmp     al, 'N'                 ;
	jz      go_on                   ;
	jmp     get_input2              ;
go_on:                  
	mov     flag, al                ;
	jmp     gb_goback               ;

gb_goback:
	ret
ombtest1_errs  endp
;--------------------------------------------------------------------
;                       WRITE_ERROR
;
;       Write the error message to the error file
;--------------------------------------------------------------------
write_error proc near
	mov     cx, 10h
	call    write_to_err_file
	mov     dx, offset OF_OMBX
	mov     cx, 0fh
	call    write_to_err_file
	mov     cl, OMB_COUNT
	add     cl, 30h
	mov     WRITE_STRING, cl
	mov     dx, offset WRITE_STRING
	mov     cx, 2h
	call    write_to_err_file
	mov     dx, offset crlf
	mov     cx, 2h
	call    write_to_err_file

;       mov     dx, offset STRING_WAS
;       mov     cx, 0bh
;       call    write_to_err_file

;       call    print_reg_to_file

;       mov     dx, offset STRING_SHOULD_BE
;       mov     cx, 017h
;       call    write_to_err_file

	ret
write_error endp
;--------------------------------------------------------------------
;                       PRINT_REG_TO_FILE
;
;       Prints a register value to the error file
;       Called by : WRITE_ERROR
;--------------------------------------------------------------------
print_reg_to_file proc near
	mov     bl, 02
	mov     edx, STRING_MBEF
	mov     WORD_VAL, dx
	and     dl, 0f0h
next31:
	ror     dl, 1
	ror     dl, 1
	ror     dl, 1
	ror     dl, 1
next32:
	cmp     dl, 9h
	jg      process_let
	add     dl, 30h 
	jmp     write_2_file
process_let:
	add     dl, 37h
write_2_file:
	mov     WRITE_STRING, dl
	mov     dx, offset WRITE_STRING
	mov     cx, 2h
	call    write_to_err_file
	mov     dx, WORD_VAL
	and     dl, 0fh
	dec     bl
	cmp     bl, 0
	jnz     next32
gb_wtf:
	ret
print_reg_to_file endp
;--------------------------------------------------------------------
;                       OPEN_ERR_FILE
;
;       Opens the eror file if it already exists, Creates it if it
;       does not yet exist.
;--------------------------------------------------------------------
open_err_file  proc  near
	mov     dx, offset ERR_FILE     ;
	mov     al, 11000010b           ;
	mov     ah, 3dh                 ;try to open the error report file
	int     21h                     ;
	jc      create_file             ;if it does not exist then create it
	mov     FILE_HANDLE, ax         ;if it does exist save the file handle
	jmp     gb_opfile               ;go back
create_file:
	mov     dx, offset ERR_FILE     ;
	mov     cx, 0                   ;
	mov     ah, 3ch                 ;create the error report file
	int     21h                     ;
	mov     FILE_HANDLE, ax         ;save the file handle
gb_opfile:
	ret
open_err_file  endp
;--------------------------------------------------------------------
;                       CLOSE_ERR_FILE
;
;       Closes the error file.
;       Called by : RUN_TESTS
;--------------------------------------------------------------------
close_err_file  proc  near
	mov     bx, FILE_HANDLE
	mov     ah, 3eh
	int     21h
	ret
close_err_file  endp
;--------------------------------------------------------------------
;                       WRITE_TO_ERR_FILE
;
;       Writes a string to the error file.
;       The string offset is in DX, the number of bytes is in CX.
;       DX and CX are initialized in the calling function.
;--------------------------------------------------------------------
write_to_err_file  proc  near
	push    cx
	push    bx
	mov     bx, FILE_HANDLE
	mov     ah, 40h
	int     21h
	pop     bx
	pop     cx
	ret
write_to_err_file  endp
;--------------------------------------------------------------------
;                       FIFO_TEST1
;
;       Test FIFO register by writing directly to the register
;--------------------------------------------------------------------
fifo_test1  proc  near
	call    write_to_buffer         ;fill buffer with some data
	lea     dx, CRLF                ;carriage return line feed
	call    string                  ;
	mov     edx, TEST_INTCSR        ;point to Interrupt control/status register
	mov     eax, 3c000000h          ;no endian conversion/fifo advance on byte 3
	out     dx, eax                 ;send it
	mov     di, 0004                ;point to PCICMD . register 
	mov     cx, 0007h               ;establish bus master status
	call    write_c_word            ;write value to PCICMD register
	mov     edx, TEST_BMCSR         ;write to BMCSR 
	mov     eax, 16000000h          ;clear FIFO register and set for loop back mode
	out     dx, eax                 ;do it
	xor     eax, eax                ;clear eax
	mov     ax, offset SOURCE_BUFF  ;get offset of data buffer
	mov     dx, ds                  ;get segment address
	shl     edx, 4                  ;shift segment address left 4 bits
	add     eax, edx                ;add buffer offset
	mov     DWORD_VAL, eax          ;save buffer seg:offset (20 bit address)
	mov     edx, TEST_MRAR          ;write read buffer seg:offset
	out     dx, eax                 ;to MRAR
	in      eax, dx                 ;read the address back (address minus bits 0 and 1)
	mov     ebx, eax                ;put it in bx
	mov     eax, DWORD_VAL          ;get the real address back
	sub     al, bl                  ;get the difference between the real addr and the addr in MRAR
	mov     DIFF, al                ;save the difference, this is how many bytes you have to
					;step through the FIFO to get to the first byte from the buffer
	mov     al, 4                   ;put maximum count in al
	sub     al, DIFF                ;subtract DIFF, this tells the number of bytes left through in the 32 bit word
	mov     CNTR, al                ;set counter to compare four bytes
	mov     ax, 64h                 ;initialize read counter to 100 bytes
	mov     edx, TEST_MRTCR         ;write it to counter register
	out     dx, ax                  ;write it
	mov     edx, TEST_BMCSR         ;get address to MCSR
	mov     ax, 4000h               ;write to read transfer bit
	out     dx, ax                  ;initiate read transfer
	mov     bx, offset SOURCE_BUFF  ;get address of memory buffer
	mov     si, bx                  ;set SI to point to it
	mov     bx, offset DEST_BUFF    ;get address of destination buffer
	mov     di, bx                  ;set DI to point to it
setup_compare:        
	mov     edx, TEST_FIFO          ;get address to FIFO register
	add     dl, DIFF                ;point to the byte to start from
	push    edx                     ;save it for now
read_mem:
	pop     edx                     ;get address of current byte in FIFO register
	in      al, dx                  ;read the next byte in the FIFO
	inc     dx                      ;point to the next byte
	push    edx                     ;save it
	mov     [di], al                ;save the value read to a memory buffer
	cmp     al, [si]                ;compare FIFO byte to memory byte (SI points to the buffer of data that was read
	jne     dma_error               ;if memory data and fifo byte are not the same then show an error message
	mov     BYTE_VAL, al            ;get it ready to print out
	call    print_byte              ;show it
	lea     dx, SPACE               ;space over
	call    string                  ;
	mov     bl, [si]                ;get the byte of data in memory to bl
	mov     BYTE_VAL, bl            ;get it ready to print
	call    print_byte              ;show it
return_to_compare:
	lea     dx, CRLF                ;go down to the next line
	call    string                  ;
	inc     si                      ;point to the next byte of data
	cmp     CNTR, 0                 ;check if all four bytes have been read 
	jz      omit_counter            ;if yes go check the FIFO status
	dec     CNTR                    ;otherwise decrement the FIFO first
omit_counter:        
	mov     edx, TEST_BMCSR         ;get MCSR address
	in      eax, dx                 ;read it
	and     al, 20h                 ;mask off bits
	cmp     al, 20h                 ;check if FIFO is empty
	jz      gohome                  ;if yes then test is done
	cmp     CNTR, 0                 ;else check the counter
	jnz     read_mem                ;if not zero then read the next byte in the FIFO
	pop     edx                     ;else FIFO has advanced
	mov     edx, TEST_FIFO          ;reset dx to point to first byte in the FIFO
	push    edx                     ;save it
	mov     CNTR, 4                 ;reset byte counter to 4
	jmp     read_mem                ;go do it again
dma_error:
	call    count_fifo_error        ;show error message and count the number os errors
	jmp     return_to_compare       ;continue the test
gohome:
	pop     edx                     ;test is done, get data off the stack
	mov     edx, TEST_BMCSR         ;get MCSR address
	mov     eax, 06000000h          ;clear the FIFO register
	out     dx, eax                 ;do it
	ret
fifo_test1  endp
;--------------------------------------------------------------------
;                       WRITE_TO_BUFFER
;
;       This procedure fills the source buffer with data.
;--------------------------------------------------------------------
write_to_buffer proc    near
	mov     ax, offset SOURCE_BUFF  ;point to source buffer
	mov     di, ax                  ;move source buffer address to di
	mov     cl, 0ffh                ;set counter to 256
	mov     al, 83h                 ;start with some value to write to the buffer
do_fill:
	mov     [si], al                ;write to the current byte pointed to in the buffer
	inc     si                      ;point to next byte in the buffer
	add     al, 3                   ;add some value to the value written to the buffer
	dec     cl                      ;decrement the counter
	cmp     cl, 0                   ;check if the counter is zero
	jnz     do_fill                 ;if not keep writing to buffer
	ret
write_to_buffer endp
;--------------------------------------------------------------------
;                       COUNT_FIFO_ERROR
;
;       This procedure counts the number of errors that occur in the FIFO test
;       and displays error messages when the errors occur.
;--------------------------------------------------------------------
count_fifo_error proc    near
	push    dx                      ;save the registers
	push    ax                      ;
	push    di                      ;
	add     FIFO_TEST1_ERRS, 1      ;increment the error counter
	lea     dx, CRLF                ;skip a line
	call    string                  ;
	lea     dx, CRLF                ;skip a linne
	call    string                  ;
	lea     dx, BAD_DMA             ;display error message
	call    string                  ;
	lea     dx, CRLF                ;skip a line
	call    string                  ;
	lea     dx, FIFO_STRING         ;show the data read from the FIFO
	call    string                  ;
	mov     al, 4                   ;put 4 in al
	sub     al, CNTR                ;subtract byte count from 4, this determines byte number
	mov     BYTE_VAL, al            ;get it ready to print
	call    print_byte              ;show it
	lea     dx, SMALL_SPACE         ;print a colon and move over a space
	call    string                  ;
	mov     al, [si]                ;show the byte of data in the buffer corresponding to the FIFO
	mov     BYTE_VAL, al            ;get it ready to print
	call    print_byte              ;show it
	lea     dx, SPACE               ;move over some spaces
	call    string                  ;
	lea     dx, MEM_LOC             ;show memory location string
	call    string                  ;
	mov     ax, ds                  ;move segment address into ax
	mov     WORD_VAL, ax            ;get it ready to print
	call    print_word              ;show it
	lea     dx, colon               ;print a colon
	call    string                  ;
	mov     WORD_VAL, si            ;get the address of the current byte
	call    print_word              ;get it ready to print
	lea     dx, SMALL_SPACE         ;show it
	call   string                   ;
	mov     al, [si]                ;put the byte of data in al
	mov     BYTE_VAL, al            ;get it ready to print
	call    print_byte              ;show it
	lea     dx, SPACE               ;move over some spaces
	call    string                  ;
	lea     dx, CRLF                ;skip a line
	call    string                  ;
	pop     di                      ;restore registers
	pop     ax                      ;
	pop     dx                      ;
	ret
count_fifo_error endp
;--------------------------------------------------------------------
;                       SHOW_OMB_NUM
;
;
;--------------------------------------------------------------------
show_omb_num  proc  near
	push    ax                      ;save registers
	push    dx                      ;
	mov     dl, OMB_COUNT           ;move OMB number to dl
	add     dl, 30h                 ;add ascii bias
	mov     ah, 02h                 ;set up character ouput
	int     21h                     ;call to DOS
	pop     dx                      ;restore registers
	pop     ax                      ;
	ret
show_omb_num  endp
;--------------------------------------------------------------------
CSEG    ends
	end
