@echo off
rem -------------------------------------------------------------------------
rem winstall - install monitor in the background
rem usage: winstall NN
rem where: NN = network { en, fd, tr }
rem -------------------------------------------------------------------------

if "%1"=="en" set mon0=tr
if "%1"=="en" set mon1=fd

if "%1"=="fd" set mon0=en
if "%1"=="fd" set mon1=tr

if "%1"=="tr" set mon0=en
if "%1"=="tr" set mon1=fd

rem - check that the other monitors are not installed
call wchkmon.bat %mon0%
if errorlevel 1 goto exit

call wchkmon.bat %mon1%
if errorlevel 1 goto exit

rem - work in the Sniffer directory
cd \%1sniff

rem - load the monitor driver, if necessary
if exist \config\%1mon.ins goto loaded
echo Loading the monitor driver...
if "%1"=="fd" fixemm clear > nul
if "%1"=="fd" fixemm %2
%1mondrv
if errorlevel 1 goto load_error
:loaded

rem - update the monitor semaphore file
if exist \config\%1mon.rem del \config\%1mon.rem
echo installed > \config\%1mon.ins
goto exit

rem - unable to determine monitor state, not removed
:state_error
echo Fatal Error: Unable to determine the monitor state!
echo Re-boot the system and configure the monitor again.
echo If the problem persists, contact Technical Support.
pause
goto exit

rem - unable to load the monitor driver
:load_error
if "%1"=="fd" fixemm clear > nul
echo Fatal Error: Unable to load the monitor driver!
echo Re-boot the system and configure the monitor again.
echo If the problem persists, contact Technical Support.
pause
goto exit

rem - back to the menu
:exit
cd \
menu
