@echo off
rem -------------------------------------------------------------------------
rem upload.bat: Sniffer Analyzer installation batch file
rem usage: upload ADDR NW NAME [NOCHECK]
rem -------------------------------------------------------------------------

if "%1"=="" goto err_usage
if "%2"=="" goto err_usage
if "%3"=="" goto err_usage
if "%4"=="" goto err_usage

rem - save 'important' files, only once per version
:skiptest
if exist \%2sniff\startup.45?  goto clean1
if exist \%2sniff\startup.%2? copy \%2sniff\startup.%2? \%2sniff\startup.45? >NUL

:clean1
if exist \tools\menu%2.450 goto clean2
if exist \tools\menu%2.txt copy \tools\menu%2.txt \tools\menu%2.450 >NUL

rem save sn*.bat's that may have been modified
:clean2
if exist \tools\snload.450 goto clean3
if exist \tools\snload.bat copy \tools\snload.bat \tools\snload.450

rem - perform cleanup: old Sniffer execs, startup.enb, ??mon.cfg, etc.
:clean3
if exist \%2sniff\%2mon.* del \%2sniff\%2mon.* >NUL
if exist \%2sniff\%2sn????.exe del \%2sniff\%2sn????.exe >NUL
if exist \%2sniff\startup.%2? del \%2sniff\startup.%2? >NUL

rem - create the monitor directories if necessary
:monitor

rem - account for the monitor directories
if "%4"=="offline" goto no_mon
if "%4"=="update" goto no_mon
if not "%2"=="EN" if not "%2"=="TR" if not "%2"=="FD" goto no_mon
if not exist \%2alarms\NUL md \%2alarms >NUL
if not exist \%2hist\NUL md \%2hist >NUL  
:no_mon

rem - need to create syreport for SIA to handle schedule saves

if not "%2"=="SY" goto notsy
if not exist c:\syreport\nul md \syreport >NUL
:notsy

rem - no config file for LM2000
if "%2"=="LM" goto noconfig
if "%4"=="update" goto noconfig

rem - copy the config file
if not exist \%2sniff\NUL md \%2sniff >NUL
copy \config\%2sniff.cfg \%2sniff > nul

:noconfig
rem - load the Sniffer software off the floppies
:retry
cls
echo.
ngrestor a: c: /T%3
if errorlevel 99 goto err_disk
if errorlevel  2 goto err_quit
if errorlevel  1 goto err_load
rem - retain the address check program

if "%2"=="LM" goto no_addr
if exist \tools\%1addr.exe copy \tools\%1addr.exe \%2sniff >NUL

if "%4"=="update" goto no_addr
if not "%1"=="TRMA" goto no_addr
call c:\trsniff\trcfg.bat c:\tools\cfg.err
:no_addr

if not "%4"=="offline" goto keep_mon
echo.
echo Performing cleanup and configuring Sniffer...
echo.
if exist \%2sniff\%2mon*.* del \%2sniff\%2mon*.* >NUL
if exist \config\%2mon.mnu del \config\%2mon.mnu
if exist \config\%2mon.rem del \config\%2mon.rem
:keep_mon

rem - done with that Sniffer
if exist \config\nwaddr.%2   del \config\nwaddr.%2 >NUL
if exist \config\%2sniff.cfg del \config\%2sniff.cfg >NUL
if exist \tools\%1addr.exe   del \tools\%1addr.exe >NUL 
goto exit

rem - invalid usage of batch file
:err_usage
echo.
echo Fatal Error: invalid or missing command line parameter(s)!
echo The batch file should not be used from the command line.
echo.
echo Invalid or missing parameter(s): %1 %2 %3 > c:\update.err
pause
goto exit

rem - ngrestor failure
:err_load
echo.
echo Fatal Error: NGRESTOR failed to load the Sniffer Network Analyzer 
echo software. Please contact Network General Technical Support for 
echo assistance.
echo.
echo NGRESTOR failed to load the Sniffer analyzer software: %1 %2 %3 > c:\update.err
pause
goto exit

rem - user quit at ngrestore prompt
:err_quit
echo.
echo The NGRESTOR process was terminated.  If you are experiencing
echo difficulties, please contact Network General Technical Support for 
echo assistance.
echo.
goto exit

rem - failed to insert the correct first diskette
:err_disk
echo.
echo The diskette you inserted is not a %3 Software diskette.
echo.
echo To continue the %4, use %3 Software diskette 01.
echo To abort the %4, answer NO at the next prompt.
echo.

input "Do you wish to continue the %4?"
if errorlevel 1 goto retry
echo Aborted trying to load %3 Software diskette 01 > c:\update.err
goto exit

rem - failed to read adapter address
:err_adapter
echo.
echo The %4 program did not find the %3 adapter card because:
echo.
echo  a. the %3 adapter card is not currently installed, or
echo  b. the %3 adapter address does not match the software address, or
echo  c. the %3 adapter card is malfunctioning.
echo.
echo If case a. is true, you may continue loading the software for other
echo adapters and return to load the %3 software later.  To do so, run 
echo the batchfile upmain.bat from the root directory of your c: drive
echo after installing the adapter for the %3 network.
echo.
echo If either case b. or c. is true, please contact Network General 
echo Support Technical for assistance.
echo.

input "Do you wish to continue loading software for other adapters?"
if errorlevel 1 goto exit
echo %1addr.exe failed: %1 %2 %3 > c:\update.err
goto exit

rem - common exit
:exit

