#define	PROGRAM_NAME	"fdcch_ci.c"
#define	VERSION	1.01

// fdcch_ci.c
//
//   FDCCH C/I PERFORMANCE TEST PROCEDURE
//
//   Developed to quantify the C/I performance of the Forward DCCH
//   and the effects of various Access Parameters on that performance.
//
//		Usage:
//			fd n b
//
//		Where:
//			n = file number (see file naming convention below)
//			b = band to measure (see below)
//
//		Output File Naming convention
//			Files are named according to date, number (supplied above),
//			The file is stored in the DATA directory of the current
//			 working directory (DATA\) with name of:
//				mmddnn.log   <test results log file>
//			where:
//				mmdd is the captured month, date
//				nn is the file number specified as command line argument
//
//		NOTE: Will not overwrite an existing file
//
//		File Format (Output)
//			All fields are seperated by tabs and units of measure are
//				km/hr, dBm, and ratio values depending upon type of
//				measurement.
//			The format of each line is:
//			  Channel \t Doppler(km/hr) \t Correlation \t ARQ \t DIC \t 
//			  Max Retries\t Max Repetitions \t Max Busy/Reserved \t
//			  Max Counters \t C/I ratio \t BER \t WER \t RSS(dBm) \t
//         Audit Failures \t SPACH Failures \t RDATA Failures \n.
//		User is prompted for the following information:
//
//	Ver 0.1  Sourced from test.c from hna_cart.c
//

// =================================================================


#include <stdio.h>
#include <stdlib.h>
#include	<math.h>
#include	<string.h>
#include	<time.h>
#include <conio.h>

// Define control parameters
#define	TRUE	1
#define	FALSE	0

#include "gpib_lib.c"		// basic library
#include "ifr_lib.c"

// User entered information and key variables
FILE	*data_fileg, *data_filed, *data_files;		// data file definition
#define OUTPUT_PATH "DATA\\"
#define LOG_EXT ".log"

// Define IFR Parameters
#define IFR_DEV 2
#define INIT_CI_LEVEL 21
#define MAX_MESSAGE_LENGTH 128

// Define file formats
#define	STD_HEAD1	"#  Proprietray Information\n#  Property of SOUTHWESTERN BELL TECHNOLOGY RESOURCES INC\n"
#define	STD_HEAD2	"#  written by program %s Version %.2f\n", PROGRAM_NAME, VERSION



int process_command_line_arguments (int argc, char **argv, int *meas_number)
/* read and do any and all command line arguments from dos */
/*  Returns TRUE if all arguments were valid */
{
	/* Required are three arguments */
	if (argc != 2)
	{
		printf ("Arguments Required: number(1-99) \n");
		return (!TRUE);
	}

	/* Transfer measurement number back */
	*meas_number = atoi (argv[1]);
	

	return (TRUE);
}	/* end process_command_lines */





build_base_file_name (int number, char *output)
/* Builds the base file name of mmddnnbn */
{
	char date_buffer[10];
	char	temp_buffer[10];

	/* Build mmdd */
	_strdate(date_buffer);	/* get current date */
	strncpy (temp_buffer, date_buffer, (size_t) 2);	/* get month (mm) */
	strncpy (&temp_buffer[2], &date_buffer[3], (size_t) 2);	/* get date (dd) */
	temp_buffer[4] = '\0';	/* end of string */

	strcpy (output, OUTPUT_PATH);
	strcat (output, temp_buffer);

	/* Add the measurement number */
	sprintf (temp_buffer, "%2d", number);
	if (temp_buffer[0] == ' ')
		temp_buffer[0] = '0';  /* add leading zero if needed */
	strcat (output, temp_buffer);

}  /* build_data_file_name */

int open_all_files(int number)
/* Open all output files checking to see if it exists first.  Returns
 *   TRUE if all files opened OK.
*/
{
	char	base_file_name[64];
	char	file_name[64];
	int	any_exist = !TRUE;

	build_base_file_name (number, base_file_name);

printf ("Base name %s\n", base_file_name);

/* 1. Open log file */
	strcpy (file_name, base_file_name);
	strcat (file_name, LOG_EXT);  /* summary file extension added */

	/* See if the file exists by opening as a read only */
	data_fileg = fopen (file_name, "r");

	if (data_fileg == NULL)
	{  /* File does not exist */
		/* create it, just leave it blank */
		data_fileg = fopen (file_name, "w");
		printf ("%s Opened.\n", file_name);
	}
	else
	{  /* file exists, need to pick out next Meas_ID */
		fclose (data_fileg);	/* close it */
		any_exist = TRUE;
		printf ("ERROR: File Exists: %s\n", file_name);
	}


	return (!any_exist);
}



close_files(void)
{
	fclose (data_fileg);
}

write_output_files (int mb, double a[], double s[], double d[])
/* Write the output files */
{
}

int registered(int ifr_ud){

int i;
int exit_loop = FALSE, registered = FALSE, continue_test = TRUE;
char response[MAX_MESSAGE_LENGTH];
char result;

/* power up and register phone */
    printf( " Power up the phone, please.\n ");
    printf( " Waiting for Camping then Registration.\n");
    printf( " Hit any key to skip or Q to quit.\n" );
    printf( "\nPARAGRAPH 1.2 " );

/* Initialize RDCCH */
	ifr_init_RDCCH(ifr_ud);

/* Loop through until phone registers or users hits key */
   while (!registered & !exit_loop){

	ifr_ask_RDCCH_msg (ifr_ud, response);

/* Check to see if phone has sent registration message */
		if(result = strstr(response,"REGISTRATION") != NULL){
			registered = TRUE;
			printf( " Phone registered.\n");
			ifr_send_reg_accept(ifr_ud);
		}

/* Check for keyboard input */
		if(kbhit())
		{
			i = getch();
			if (i == 'q'){
				exit_loop = TRUE;
				continue_test = TRUE;
			}
			else
				exit_loop = TRUE;
		} /* keyboard input */
			
	} /* while loop */		

return(continue_test);
}


main(int argc, char **argv)
{
	int ifr_dev = IFR_DEV;		// GPIB logical device number for IFR 1600CSA
	int ifr_ud ;		// GPIB handler for new 488 routines for IFR

	int	meas_number;
	int	in_key, i;

/* Initialize C/I Level */
	int C_I = INIT_CI_LEVEL;

/* Define IFR Data Structures */
	ACCESS_PARAMS acc;
	MACA_PARAMS maca;

/* Initialize Access Parameters (IFR) */
	acc.MaxReps = 1;
	acc.MaxRetries = 1;
	acc.MaxBusy = 1;
	acc.MaxStop = 1;
	acc.DelayInterval =1;
	acc.burst =1;

/* Initialize Test Output Parameters */
	maca.passed = TRUE;
	maca.avg_BER =0.0;
	maca.avg_WER =0.0;
	maca.avg_RSS =0.0;
	maca.audit_conf_fail_rate=0.0;
	maca.SPACH_conf_fail_rate=0.0;
	maca.rdata_acpt_fail_rate=0.0;
	maca.max_audit_conf_fail_rate=.1;

	printf ("%s Version %.2f\n", PROGRAM_NAME, VERSION);
	printf ("\nCopyright Southwestern Bell Technology Resources 1996\n\n\n\n\n");


/* process any command line arguments */
	if (!process_command_line_arguments (argc, argv, &meas_number))
	{
		printf ("Command Line Error, Program aborted\n");
		exit (1);
	}

	/* Open all files */
	if (!open_all_files(meas_number))
	{
		printf ("File(s) for this number already exist\n");
		exit (1);
	}

	ifr_ud = gpib_open(ifr_dev);		// get the ud for the IFR 

	/* Set C/I level by adjusting attenuation
	set_atten(atten_ud, C_I);  // adjust attenuation

	/* setup DCCH w/ appropriate access parameters */
	ifr_init_FDCCH(ifr_ud, &acc);

	/* Power up and register phone */
	if (!registered(ifr_ud)) {
		printf("Phone failed to register.");
		exit(1);
	}

	/* Find Min C/I Required for maximum value of Max Retries	*/
	while(acc.MaxRetries < 8){
	/* send audit order w/ forced registration & maca enabled */
		ifr_send_audit(ifr_ud);	

	/* check for audit confirmation and maca report
		if (!ifr_ask_audit_con(ifr_ud,&maca)){	 
			printf("GPIB I/O Error: Phone not responding.\n");
			exit(1);
		}

		if(maca.audit_conf_fail_rate > maca.max_audit_conf_fail_rate){
			C_I = C_I - 1; 								// decrement C/I by 1 dB
//			set_atten(atten_ud, C_I);  				adjust attenuation
		}
		else{
			acc.MaxRetries = acc.MaxRetries + 1; // increment max retries
		}
	}

  
}		// end main

