#include <stdio.h>
#include <stdlib.h>
#include "gpib_lib.c"		// basic library
#include "mp2500_lib.c"		  // mp2500 routines

#define MP2500_DEV 7

int process_command_line_arguments (int argc, char **argv, int *ch_number, int *seg_number, int *doppler)
/* read and do any and all command line arguments from dos */
/*  Returns TRUE if all arguments were valid */
{
	/* Required are three arguments */
	if (argc != 4)
	{
		printf ("Arguments Required: number(1-99) \n");
		return (!TRUE);
	}

	/* Transfer device number and channel number back */
	*ch_number = atoi (argv[1]);
	*seg_number = atoi (argv[2]);
	*doppler = atoi (argv[3]);	

	return (TRUE);
}	/* end process_command_lines */

main(int argc, char **argv)
{
	int mp_ud ;		// GPIB handler for new 488 routines for MP2500
	int ch_number;
	int seg_number, doppler;
	int mp_dev = MP2500_DEV;		// GPIB logical device number for NOISECOM 2500

	/* process any command line arguments */
	if (!process_command_line_arguments (argc, argv, &ch_number, &seg_number, &doppler))
	{
		printf ("Command Line Error, Program aborted\n");
		exit (1);
	}

	mp_ud = gpib_open(mp2500_dev);		// get the ud for the MP2500 

	mp_set_chan (mp_ud, ch_number);
	mp_set_segment(mp_ud, seg_number);
	mp_set_doppl(mp_ud, doppler);

}


