#include <stdio.h>
#include <stdlib.h>
#include "gpib_lib.c"		// basic library
#include "ifr_lib.c"		  // ifr routines

// Define IFR Parameters
#define IFR_DEV 8
#define MAX_MESSAGE_LENGTH 128  // length of gpib message response

int process_command_line_arguments (int argc, char **argv, int *ch_number)
/* read and do any and all command line arguments from dos */
/*  Returns TRUE if all arguments were valid */
{
	/* Required are three arguments */
	if (argc != 2)
	{
		printf ("Arguments Required: number(1-99) \n");
		return (!TRUE);
	}

	/* Transfer measurement number and channel number back */
	*ch_number = atoi (argv[1]);
	

	return (TRUE);
}	/* end process_command_lines */

main(int argc, char **argv)
{
	int ifr_dev = IFR_DEV;		// GPIB logical device number for IFR 1600CSA
	int ifr_ud ;		// GPIB handler for new 488 routines for IFR
	int ch_number;

	/* Define IFR Data Structures */
	ACCESS_PARAMS acc;

	/* Initialize Access Parameters (IFR) */
	acc.MaxReps = 1;		 /* Max Repetitions */
	acc.MaxRetries = 1;	 /* Max Retries */
	acc.MaxBusy = 1;		 /* Max Busy/Reserved */
	acc.MaxStop = 1;		 /* Max Stop Counter */
	acc.DelayInterval =1; /* DIC */
	acc.burst =1;			 /* ARQ */

	/* process any command line arguments */
	if (!process_command_line_arguments (argc, argv, &ch_number))
	{
		printf ("Command Line Error, Program aborted\n");
		exit (1);
	}

	ifr_ud = gpib_open(ifr_dev);		// get the ud for the IFR 

/* load macro to perform dcch initialization */
	gpib_write(ifr_ud,":mmem:load:macro \"\", \"fdinit\" ");

	/* setup DCCH w/ appropriate access parameters */
	ifr_init_FDCCH(ifr_ud, &acc, ch_number);

}

