// Define control parameters
#define	TRUE	1
#define	FALSE	0

/* TYPEDEFS */

typedef struct {
					  int	burst;
                 int MaxRetries;
                 int	MaxBusy;
                 int	MaxReps;
                 int	MaxStop;
                 int	DelayInterval;
               } ACCESS_PARAMS;

typedef struct {
						int passed;
						double avg_BER;
						double avg_WER;
						double avg_RSS;
						double audit_conf_fail_rate;
						double SPACH_conf_fail_rate;
						double rdata_acpt_fail_rate;
						double max_audit_conf_fail_rate;
					}MACA_PARAMS;

void ifr_init_FDCCH(int ifr_ud, ACCESS_PARAMS *acc, int ch_num)
{
/* build DCCH with appropriate access parameters */

	char message[24];
	int mask = TIMO;

/* load macro to perform dcch initialization */
	gpib_write(ifr_ud,":mmem:load:macro \" \", \"fdinit\" ");

/* load macro to perform registration */
	gpib_write(ifr_ud,":mmem:load:macro \" \", \"fdreg\" ");

/* set timeout period to 10 sec */

	ibtmo(ifr_ud,13);

   printf ( "DCCH CHANNEL = %d\n", ch_num);

/* Initialize command string */
	sprintf(message,"fdinit %d,%d,%d,%d,%d,%d,%d\n", ch_num, acc->MaxRetries, acc->MaxReps, 
	acc->MaxBusy, acc->MaxStop, acc->DelayInterval, acc->burst);

/* Send command to IFR */
	gpib_write(ifr_ud, message);
	printf ("Setting up DCCH, please wait ...\n");
	ibwait(ifr_ud,mask);

}

void ifr_init_RDCCH (int ifr_ud, int burst){

/* Initialize which messages to listen to on RDCCH */
   if(burst == 1)
		gpib_write(ifr_ud,":rdcch:length:abbreviated");
	else
		gpib_write(ifr_ud,":rdcch:length:normal");

}

void ifr_ask_RDCCH_msg(int ifr_ud, char message[], char response[]){
int mask = TIMO | RQS;
int resp_len = MAX_MESSAGE_LENGTH;

	strset(response,' ');
   gpib_write(ifr_ud, message);
	ibwait(ifr_ud,mask);
	gpib_read(ifr_ud,response,resp_len);
   printf("%s\n", response);
	
}



int ifr_ask_audit_con (int ifr_ud, int burst, MACA_PARAMS *maca){

	int confirmed = FALSE;

	/*setup RDCCH to read layer 3 messages */
	ifr_init_RDCCH(ifr_ud, burst);

	if (ifr_ask_mess_rcvd(ifr_ud,"wait_for_audit_con 1","AUDITCON")){
		confirmed = TRUE;
      printf( " Audit Confirmation Received");
   }
   else
      printf( " Audit Confirmation Failed");
	
	return(confirmed);

} 

int ifr_ask_mess_rcvd(int ifr_ud, char message[], char confirmation[]){
	int received = FALSE;
	char response[MAX_MESSAGE_LENGTH];
	char *result;

	/* Check to see if phone has sent message */
	ifr_ask_RDCCH_msg (ifr_ud, message, response);

	if((result = strstr(response,confirmation)) != NULL)
			received = TRUE;
	return(received);
}

int kb_exit_loop(void){

int exit_loop = FALSE;
int i;

	/* Check for keyboard input */
		if(kbhit())
		{
			i = getch();
			if (i == 'q'){
				exit_loop = TRUE;
			}
			else
				exit_loop = TRUE;
		} /* keyboard input */

	return(exit_loop);
}			

int registered(int ifr_ud, int burst){

int i;
int exit_loop = FALSE, registered = FALSE;
char response[MAX_MESSAGE_LENGTH];
char result;

/* power up and register phone */
    printf( " Power up the phone, please.\n ");
    printf( " Waiting for Camping then Registration.\n");
    printf( " Hit any key to abort.\n" );

/* Initialize RDCCH */
	ifr_init_RDCCH(ifr_ud, burst);

/* Loop through until phone registers or users hits key */
   while (!registered & !exit_loop){

		/* Check to see if phone has sent registration message */
		if(ifr_ask_mess_rcvd(ifr_ud, "fdreg2","REGISTRATION")){
			registered = TRUE;
			printf( " Phone registered.\n");
		}

		/* Check for keyboard input */
		exit_loop = kb_exit_loop();
	}
	return(!exit_loop);
}
