//  GPIB_LIB.C
//
//   Library routines for GPIB board.
//		 DOES NOT RUN UNDER ULI(Universal Language Interface).
//
//  04-14-91  Copied from gpib_uli and modified for non-uli environment.
//
//	NOTE: This module should be included BEFORE other gpib handler includes
//
//
//  Routines:
//		ud = int gpib_open (logical_device); Opens a logical device, returns 'ud'
//		bytes_read = gpib_read (int ud, char string[], number_bytes); read from a device
//		bytes_written = gpib_write (int ud, char string[]);  write to a device
//    gpib_local(int ud);		set this device to local
//		gpib_start()  for compatibility with serial version
//		gpib_stop()  for compataibility
//		gpib_wait(int ud, int x, int mask)  wait for x seconds or until mask message rcvd

// Declare the gpib variables and constants file
#include	"c:\at-gpib\decl.h"
#include	<string.h>

//  Declare stuff here

gpib_start()
{
}

gpib_stop()
{
}

int gpib_open(int logical_device)
//  Open a specific instruement on logical device (1-15) specified.
//		returns the "ud", the device handler number for subsequent read/writes
//	If not found, or other error, program aborts
{
	int	ud;
	char	buffer[16];

	sprintf (buffer, "DEV%d", logical_device);
	ud = ibfind (buffer);
	if (ud < 0) {		// error occured
		printf ("gpib_open-FATAL-Error opening device <%s>\n", buffer);
		exit (1);
	}
	ibclr (ud);
	return (ud);
}	// end gpib_open

int gpib_read (int ud, char string[], int number_bytes)
// Read in a string of "number_bytes" characters from the device at ud.
//  The actual number of bytes ready (int value) is returned
{
	ibrd (ud, string, (long) number_bytes);
	return (ibcnt);		// return the actual number of bytes read
}

int gpib_write (int ud, char string[])
// Read in a string of "number_bytes" characters from the device at ud.
//  The actual number of bytes ready (int value) is returned
{
	ibwrt (ud, string, (long) strlen(string));
	return (ibcnt);		// return the actual number of bytes written
}

gpib_local(ud)
int ud;
{
	ibloc (ud);		// switch device to local
}

gpib_wait(int ud, int mask)
{
// wait for timeout seconds before transmitting/receiving any new messages
	int result;

	result = ibwait(ud, mask);   // pause
	return(result);
}

gpib_tmo(int ud, double tmo_sec)
{
	int iwait = 0;

	// encode timeout period 
	if(tmo_sec <= 10e-6)
		iwait = 1;
	else if (tmo_sec <= 30e-6)
		iwait = 2;
	else if (tmo_sec <= 30e-6)
		iwait = 2;
	else if (tmo_sec <= 100e-6)
		iwait = 3;
	else if (tmo_sec <= 300e-6)
		iwait = 4;
	else if (tmo_sec <= 1e-3)
		iwait = 5;
	else if (tmo_sec <= 3e-3)
		iwait = 6;
	else if (tmo_sec <= 10e-3)
		iwait = 7;
	else if (tmo_sec <= 30e-3)
		iwait = 8;
	else if (tmo_sec <= 100e-3)
		iwait = 9;
	else if (tmo_sec <= 300e-3)
		iwait = 10;
	else if (tmo_sec <= 1)
		iwait = 11;
	else if (tmo_sec <= 3)
		iwait = 12;
	else if (tmo_sec <= 10)
		iwait = 13;
	else if (tmo_sec <= 30)
		iwait = 14;
	else if (tmo_sec <= 100)
		iwait = 15;
	else if (tmo_sec <= 300)
		iwait = 16;
	else if (tmo_sec <= 1000)
		iwait = 17;

	ibtmo(ud,iwait);  // set time out period to x seconds

}


