/*******************************************************************/
/*  Program name: sacap.c v1.0                                                   */
/*  Description: This program captures the trace of a spectrum analyzer          */
/*                                                                                      */
/*  Author:  SAH                                                                        */
/*  Date of last change:  07/8/96                                                       */
/*******************************************************************/

/* Insert system includes here */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

/* Insert global defines here */
#define GPIB_BOARD 0    /* id number for the GPIB board */
#define HSA_ADDR   7    /* GPIB address for the spectrum analyzer */

/* Insert gpib includes here */
 #include "c:\at-gpib\decl.h"
 #include "hsa_11.c"   /* HP Spectrum Analyzer routines */


/* Insert local prototype declarations here */
void setup(char *filename, double *nom_frq, int *atten, double *vid_bw,
	   double *swp_time, double *span, double *res_bw, double *ref_lev,
	   double *vid_trig);
void strrepl(char instring[], char target, char replacement);


/*****************************************************************/
void main(int argc, char **argv)
{

  double anlzr_cf,swp_time,span,res_bw, vid_bw; 
  double start_frq, end_frq, ref_lev, vid_trig;
  int atten, i;
  char  trace_buffer[HSA_BUF_LENGTH];
  /* ??? aunits, log_scale;  */



/* Initialize Default Values for the Spectrum Analyzer */
  anlzr_cf=820.0E6;  
  span=0.0;
  res_bw=30.0E3;
  vid_bw=30.0E3;
  atten=10;
  ref_lev=-30.0;
  swp_time=1.0;
  vid_trig=-999.0; /* normal trigger */

  /* read file specified in command line and setup test parameters */
  setup(argv[1], &anlzr_cf, &atten, &vid_bw, &swp_time, &span, &res_bw,
	&ref_lev, &vid_trig);
  
 /**** Initialize GPIB Board ****/
  SendIFC (GPIB_BOARD);
  if (ibsta & ERR) {
      printf("NO RESPONSE FROM GPIB!\n\a");
      exit (1);
    }

  /**** Initialize Sp Analyzer to Setup File Values ****/
  hsa_preset(HSA_ADDR);  /* initialize Sp An at defined addr */
  hsa_sweep_mode(HSA_ADDR, SWEEP_SINGLE);
//  hsa_sweep(HSA_ADDR);
  hsa_cf(HSA_ADDR,anlzr_cf);
  hsa_span(HSA_ADDR,span);
  hsa_sweep_time(HSA_ADDR,swp_time);
  hsa_rb(HSA_ADDR,res_bw);
  hsa_vb(HSA_ADDR,vid_bw);
  hsa_atten(HSA_ADDR,atten); 
  hsa_ref_level(HSA_ADDR,ref_lev); 
  if (vid_trig > -200.0)
     hsa_vid_trig(HSA_ADDR, vid_trig);

  /********* Capture Analyzer Setup Info **********/
  start_frq=hsa_ask_sf(HSA_ADDR);
  end_frq=hsa_ask_ef(HSA_ADDR);
  atten=hsa_ask_atten(HSA_ADDR);
  ref_lev=hsa_ask_ref_level(HSA_ADDR);
  swp_time=hsa_ask_sweep_time(HSA_ADDR);
  res_bw=hsa_ask_rb(HSA_ADDR);
  vid_bw=hsa_ask_vb(HSA_ADDR);

/*  aunits=hsa_ask_units(HSA_ADDR); */
/*  log_scale=hsa_ask_lg(HSA_ADDR); */

/********* Print Setup Info to Standard Output **********/
  printf("\n\n");
  printf("***  SPECTRUM ANALYZER TRACE CAPTURE APPLICATION ***\n");
  printf("  TEST EQUIPMENT CONFIGURATION  \n");
  printf("--------------------------------\n");
  printf("Setup File: \t%s\n", argv[1]);
  printf("Start Freq:   \t%11.6lf Hz\n",start_frq);
  printf("Stop Freq:   \t%11.6lf Hz\n",end_frq);
  printf("Sweep Time: \t%11.6lf sec\n",swp_time);
  printf("Res BW:     \t%11.6lf Hz\n",res_bw);
  printf("Vid BW:     \t%11.6lf Hz\n",vid_bw);
  printf("Atten:      \t%11d dB\n",atten);
  printf("Ref Lev: \t%11.6lf dBm\n",ref_lev);
  
/**************** Capture Trace *****************/
  hsa_trace_format(HSA_ADDR, P_FORMAT);
  hsa_get_traceA(HSA_ADDR, trace_buffer);  


/********* Write Data to Standard Output Device **********/
  /* replace commas with newline chars and print  */
  strrepl(trace_buffer, ',', '\n');
  printf("%s\n",trace_buffer);
  printf("\n\n");
  printf("Process Completed: \n\a");


}  /* end of sacap.c main program */
/*****************************************************************/





/*****************************************************************/
/* Routine to parse file (*filename) and return setup parameters */
/*****************************************************************/
void setup(char *filename, double *nom_frq, int *atten, double *vid_bw,
	   double *swp_time, double *frq_span, double *res_bw, 
	   double *ref_lev, double *vid_trig)
{
  FILE *setup_file;
  char delims[] = "\t =:\r";
  char buffer[81], *parameter;


  if((setup_file=fopen(filename,"r"))==NULL)
  { printf("Setup Filename <%s> Not Found!\n\a", filename);
    exit(0);
  }

  while (fgets(buffer, 80, setup_file) != NULL)
  {
    parameter=strtok(buffer,delims);

    if (strncmp(parameter,"CF",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",nom_frq);
    }

    if (strncmp(parameter,"SP",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",frq_span);
    }

    if (strncmp(parameter,"ST",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",swp_time);
    }
    
    if (strncmp(parameter,"RB",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",res_bw);
    }

    if (strncmp(parameter,"VB",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",vid_bw);
    }

    if (strncmp(parameter,"AT",2) == 0)
    {sscanf(strtok(NULL,delims),"%d",atten);
    }
    
if (strncmp(parameter,"RL",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",ref_lev);
    }
    
if (strncmp(parameter,"VT",2) == 0)
    {sscanf(strtok(NULL,delims),"%lf",vid_trig);
    }
    
  } /* end while */

  fclose(setup_file);

} /* end setup routine */
/*****************************************************************/


/*****************************************************************/
/* Routine to replace all occurences of a character in a string with another char      */
/*****************************************************************/
void strrepl(char instring[], char target, char replacement)
{
  int i;

  i=0;
  while (instring[i] != '\0')
  {
    if (instring[i] == target)
	instring[i] = replacement;

    i++;
  } /* end while */

} /* end strrepl routine */
/*****************************************************************/

