/********************************************************************
	$Workfile:   scldata.h  $

	Copyright Northern Telecom Limited. 1989
	All Rights Reserved under the Copyright Laws.

	This file is designed to help applications declare data
	for timer records and transmission buffers.  The file
	is set up to allocate data statically.  If you wish to
	allocate timer and buffer data statically, do the following

	- Define constants in your source code
	  - NTnumTimers    The number of timers to init
	  - NTnumBuffers   The number of functional msg buffers to init
	  - NTnumB2Buffers  The number of B2 channel buffers to init.
	- Then include this file
	- during initialization, you make the following calls:
	  - initBuffers( NTsclBuffers, NTnumBuffers );
	  - initB2Buffers( NTsclB2Buffers, NTnumB2Buffers );
	  - initTimers( NTsclTimers, NTnumTimers );

	If you don't define one of the above constants, no data
	of that type will get declared.

	This file works with Small, Medium, Compact, Large
	and Huge memory models.

	$Revision:   1.4  $

	$Author:   CHARLES  $

	$Date:   27 Jul 1989 21:33:58  $

**********************************************************************/

/*
**	declare data structure sizes for various memory models
*/

#if (defined(M_I86SM) || defined(M_I86CM))
	#define NTsclBufferSize		67
	#define NTsclB2BufferSize	256
	#define NTsclTimeRecSize	8
#elif (defined(M_I86MM) || defined(M_I86LM) || defined(M_I86HM))
	#define NTsclBufferSize 	67
	#define NTsclB2BufferSize	256
	#define NTsclTimeRecSize	10
#endif

/*
**	Allocate data statically for buffers and timers
*/

#ifdef NTnumTimers
	byte	NTsclTimers[ NTsclTimeRecSize * NTnumTimers ];
#endif

#ifdef NTnumBuffers
	byte	NTsclBuffers[ NTsclBufferSize * NTnumBuffers ];
#endif

#ifdef NTnumB2Buffers
	byte	NTsclB2Buffers[ NTsclB2BufferSize * NTnumB2Buffers ];
#endif

