/********************************************************************
	$Workfile:   norstar.h  $

	Copyright Northern Telecom Limited. 1988
	All Rights Reserved under the Copyright Laws.

	This file contains declarations for interfacing to
	the Norstar System Software.

	$Revision:   1.11  $

	$Author:   CHARLES  $

	$Date:   21 Sep 1989 17:05:44  $

	
**********************************************************************/


/************************************************************************/
/* 	MANIFEST CONSTANT DEFINITIONS							*/
/************************************************************************/


/*======================================================================*/
/*  EVENT TYPES.							*/

#define	RXPACK	1
#define	TIMEOUT	2
#define	ERROR		4
#define	EXCEPT	5
#define	EXEVENT	10

/*  EXCEPT event codes for loop/PCI status changes */

#define	TCM_ON		3
#define	TCM_OFF		4

/************************************************************************/
/* 	STRUCTURE DECLARATIONS						*/
/************************************************************************/

union	eventVal {
	unsigned char	*inPack;
	int	errCode;
	int	exceptCode;
	unsigned int	timerID;
	struct {
		unsigned int	appCode;
		unsigned long	value;
	} exEvent;
};

struct	eventRec {
	unsigned int		eventType;
	union	eventVal 	event;
};


/************************************************************************/
/* 	FUNCTION DECLARATIONS						*/
/************************************************************************/


struct eventRec *nextEvent(int *);
unsigned int getSize( unsigned int );


int useNorstar( unsigned int progSize, char far *appData, int multiFlag );
int  	relNorstar( void );
