/*=========================================================================*/
/*  This program illustrates the use of save and recall panel state        */
/*  functions (SavePanelState and RecallPanelState).                       */
/*=========================================================================*/

/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex8.h"

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= MAIN PROGRAM ==========================================================*/

main()

{
  int id,panel_hdl,handle;
  long filesize;
  char filename[81];

  /*-----------------------------------------------------------------------*/
  /*  Load the panel from the resource file.  Use the constant assigned    */
  /*  in the editor to refer to the panel.  The handle returned by         */
  /*  LoadPanel must be used to reference the panel in all subsequent      */
  /*  function calls. If the panel handle is negative, the load failed,    */
  /*  so print a message and exit the program.  Otherwise, display the     */
  /*  panel.                                                               */
  /*-----------------------------------------------------------------------*/
  panel_hdl = LoadPanel("uil_ex8.uir",SCOPE);
  if (panel_hdl < 0) {
    FmtOut("Unable to load the required panel from the resource file.\n");
    return;
  }
  DisplayPanel(panel_hdl);

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to TRUE.  This will  */
    /*  cause the function to wait for an event.  When an event occurs,    */
    /*  the id variable will match one of the control ID constants         */
    /*  assigned in the editor.  Since we only have one panel loaded, we   */
    /*  do not have to examine the handle value returned by GetUserEvent.  */
    /*---------------------------------------------------------------------*/
    GetUserEvent(TRUE,&handle,&id);
    switch (id) {
      case SCOPE_SETUP_SEND :
        /*-----------------------------------------------------------------*/
        /*  This is where the code that actually controls the scope would  */
        /*  be located.  It would query the panel for the value of each    */
        /*  control, format the command strings, and send them to the      */
        /*  scope.  Since there is no actual instrument attached in this   */
        /*  example, nothing is done.                                      */
        /*-----------------------------------------------------------------*/
        MessagePopup("Setup was successfully sent to the scope");
        break;
      case SCOPE_SETUP_STORE :
        /*-----------------------------------------------------------------*/
        /*  Query the user for the name of the setup file and add the      */
        /*  .SET extension to the name.                                    */
        /*-----------------------------------------------------------------*/
        PromptPopup ("Enter the setup file name without extension:", filename, 80);
        Fmt(filename,"%s<%s[t46].set",filename);
        /*-----------------------------------------------------------------*/
        /*  If the file does not already exist, or the user wants to       */
        /*  overwrite the existing setup file, save the panel state in     */
        /*  the specified file.                                            */
        /*-----------------------------------------------------------------*/
        if ((GetFileInfo (filename, &filesize) == 0) ||
            ConfirmPopup("File already exists. Do you want to overwrite it?")) {
          if (SavePanelState (panel_hdl, filename) == 0)
            MessagePopup("Setup file was successfully saved");
          else
            MessagePopup("Error saving setup file");
        }
        break;
      case SCOPE_SETUP_RECALL :
        /*-----------------------------------------------------------------*/
        /*  If the user selects a setup file, recall the panel state to    */
        /*  reflect the contents of the selected file.                     */
        /*  Start at the current directory by passing an empty string as   */
        /*  the first parameter to FileSelectPopup.  Allow the user to     */
        /*  change directories and drives by passing a zero as the fourth  */
        /*  parameter.                                                     */
        /*-----------------------------------------------------------------*/
        if (FileSelectPopup ("","*.set","Select a Setup File to Recall",0,1,1,filename) == 1)
          if (RecallPanelState(panel_hdl,filename) != 0)
            MessagePopup("Invalid setup file");
        break;
      case SCOPE_RESET :
        /*-----------------------------------------------------------------*/
        /*  Reset the scope setup by defaulting the panel.  It is often    */
        /*  convenient to set the control default values in the editor to  */
        /*  match that of a default configuration.  Then DefaultPanel can  */
        /*  be used to quickly reset the panel.                            */
        /*-----------------------------------------------------------------*/
        DefaultPanel(panel_hdl);
        break;
      case SCOPE_QUIT :
        /*-----------------------------------------------------------------*/
        /*  When the Quit button is pushed exit the program.  Remember,    */
        /*  CloseInterfaceManager will be called automatically to unload   */
        /*  the panel and reset the display to text mode.                  */
        /*-----------------------------------------------------------------*/
        return;
        break;
    }
  }
}
