/*=========================================================================*/
/*  This program illustrates the use of some predefined pop-up panels      */
/*  available in the User Interface Library.                               */
/*=========================================================================*/

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= FUNCTION DECLARATIONS =================================================*/

void GraphDataFile (void);

/*= MAIN PROGRAM ==========================================================*/

main()

{
  int quit;
  char msg[60];
  char username[50];

  /*-----------------------------------------------------------------------*/
  /*  Display a welcoming message and prompt the user for their name.      */
  /*-----------------------------------------------------------------------*/
  MessagePopup ("Welcome to LabWindows 2.0");
  PromptPopup ("Please enter your name:", username, 40);

  quit = FALSE;
  /*-----------------------------------------------------------------------*/
  /*  Loop until the user quits.                                           */
  /*-----------------------------------------------------------------------*/
  while (!quit) {
    GraphDataFile();
    quit = ConfirmPopup ("Do you want to quit?");
  }

  /*-----------------------------------------------------------------------*/
  /*  Format a farewell message and display it to the user.                */
  /*-----------------------------------------------------------------------*/
  Fmt(msg, "Goodbye %s. Have a nice day!", username);
  MessagePopup (msg);
}

/*= GRAPH DATA FILE =======================================================*/

void GraphDataFile (void)

{
  int handle;
  char dirname[68];
  char filename[80];
  double data[100];

  /*-----------------------------------------------------------------------*/
  /*  Invoke the FileSelectPopup in the following manner:                  */
  /*                                                                       */
  /*    1. Start at the directory containing this program file.            */
  /*       This is done by passing in parameter 1 the directory name       */
  /*       obtained by the GetProgramDir function.                         */
  /*    2. Display all files that have the "dat" extension.                */
  /*    3. The title of the pop-up panel is specified in parameter three.  */
  /*    4. Since parameter four is nonzero, the user cannot change         */
  /*       directories or drives.                                          */
  /*    5. Since parameter five is nonzero, the user is limited to         */
  /*       selecting files that have the "dat" extension.                  */
  /*    6. Since parameter six is nonzero, the user can select cancel and  */
  /*       remove the pop-up without selecting a file.                     */
  /*    7. Finally, if a file was selected, its name is stored in the      */
  /*       buffer specified in parameter seven. This buffer must be at     */
  /*       least 80 characters long to allow for the largest possible      */
  /*       path name.                                                      */
  /*                                                                       */
  /*  FileSelectPopup returns a 1 if a file was selected, a 0 if no file   */
  /*  was selected, or a negative number if an error occurred.             */
  /*-----------------------------------------------------------------------*/
  GetProgramDir (dirname);
  if (FileSelectPopup (dirname, "*.dat", "Select a Data File to Graph", 1, 1, 1, filename) != 1)
    return;

  /*-----------------------------------------------------------------------*/
  /*  Open the data file, read its contents, and graph the data.           */
  /*-----------------------------------------------------------------------*/
  handle = OpenFile (filename, 1, 0, 0);
  if (handle != -1) {
    if (ScanFile (handle, "%100f>%100f", data) == 1)
      YGraphPopup (data, 100, 4);
    else
      MessagePopup("Not a valid data file");
    CloseFile (handle);
  }
}
