/*=========================================================================*/
/*  This program illustrates the use of the strip chart routines available */
/*  in the User Interface Library.                                         */
/*=========================================================================*/

/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex5.h"

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= FUNCTION DECLARATIONS =================================================*/

void AquireAndAverageData (double [], double [], int);

/*= MAIN PROGRAM ==========================================================*/

void main (void)

{
  int id,panel_hdl,start,handle;
  double avg[1],data[4];

  /*-----------------------------------------------------------------------*/
  /*  Load the panel from the resource file.  Use the constant assigned    */
  /*  in the editor to refer to the panel.  The handle returned by         */
  /*  LoadPanel must be used to reference the panel in all subsequent      */
  /*  function calls. If the panel handle is negative, the panel failed,   */
  /*  so print a message and exit the program.  Otherwise, display the     */
  /*  panel.                                                               */
  /*-----------------------------------------------------------------------*/
  panel_hdl = LoadPanel("uil_ex5.uir",VM);
  if (panel_hdl < 0) {
    FmtOut("Unable to load the required panel from the resource file.\n");
    return;
  }
  DisplayPanel(panel_hdl);

  start = FALSE;

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to FALSE. This will  */
    /*  cause the function to return immediately without waiting for an    */
    /*  event.  If an event occurred, the id variable will match one of    */
    /*  the control ID constants assigned in the editor.  Since we only    */
    /*  have one panel loaded, we do not have to examine the handle value  */
    /*  returned by GetUserEvent.                                          */
    /*---------------------------------------------------------------------*/
    GetUserEvent(FALSE,&handle,&id);
    switch (id) {
      case VM_START :
        start = TRUE;
        break;
      case VM_STOP :
        start = FALSE;
        break;
      case VM_RESET :
        /*-----------------------------------------------------------------*/
        /*  When the Reset button is pushed, delete the plots from both    */
        /*  strip charts.                                                  */
        /*-----------------------------------------------------------------*/
        DeletePlots(panel_hdl,VM_INPUTS);
        DeletePlots(panel_hdl,VM_AVERAGE);
        break;
      case VM_QUIT :
        /*-----------------------------------------------------------------*/
        /*  When the Quit button is pushed exit the program.  Remember,    */
        /*  CloseInterfaceManager will be called automatically to unload   */
        /*  the panel and reset the display to text mode.                  */
        /*-----------------------------------------------------------------*/
        return;
        break;
    }
    /*---------------------------------------------------------------------*/
    /*  If the start flag is set, we acquire a new set of data along with  */
    /*  its average value.  The data is plotted into the top strip chart   */
    /*  and the average is plotted into the bottom strip chart.            */
    /*---------------------------------------------------------------------*/
    if (start) {
      AquireAndAverageData(data,avg,4);
      PlotStripChart(panel_hdl,VM_INPUTS,data,4,0,0,4);
      PlotStripChart(panel_hdl,VM_AVERAGE,avg,1,0,0,4);
    }
  }
}

/*= ACQUIRE AND AVERAGE DATA ==============================================*/
/*                                                                         */
/*  This function simulates acquiring one set of voltage values from a 4   */
/*  channel data acquisition card.  It also calculates the average of all  */
/*  channel voltage values.                                                */
/*=========================================================================*/

void AquireAndAverageData (data, avg, num_channels)

double data[];
double avg[];
int num_channels;

{
  int i;
  double sum;

  sum = 0.0;
  /*-----------------------------------------------------------------------*/
  /*  Simulate voltage values for each input channel.  The value's range   */
  /*  is between 0 and 10 volts.                                           */
  /*-----------------------------------------------------------------------*/
  for (i=0; (i < num_channels); i++) {
    data[i] = rand() / 3276.7;
    sum += data[i];
  }

  avg[0] = sum / num_channels;
}
