/*=========================================================================*/
/*  This program illustrates the use of the graphing routines available    */
/*  in the User Interface Library.                                         */
/*=========================================================================*/

/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex4.h"

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= STATIC VARIABLES ======================================================*/

static int panel_hdl;

/*= FUNCTION DECLARATIONS =================================================*/

void DoYPlot (void);
void DoXYPlot (void);
void DoWfmPlot (void);
void DoPtPlot (void);
void DoTextPlot (void);
void FillArray (double [], int);

double RandomNumber (void);

/*= MAIN PROGRAM ==========================================================*/

void main (void)

{
  int id,handle;

  /*-----------------------------------------------------------------------*/
  /*  Load the panel from the resource file.  Use the constant assigned    */
  /*  in the editor to refer to the panel.  The handle returned by         */
  /*  LoadPanel must be used to reference the panel in all subsequent      */
  /*  function calls. If the panel handle is negative, the panel failed,   */
  /*  so print a message and exit the program.  Otherwise, display the     */
  /*  panel.                                                               */
  /*-----------------------------------------------------------------------*/
  panel_hdl = LoadPanel("uil_ex4.uir",GE);
  if (panel_hdl < 0) {
    FmtOut("Unable to load the required panel from resource file.\n");
    return;
  }
  DisplayPanel(panel_hdl);

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to TRUE.  This will  */
    /*  cause the function to wait for an event.  When an event occurs,    */
    /*  the id variable will match one of the control ID constants         */
    /*  assigned in the editor.  Since we only have one panel loaded, we   */
    /*  do not have to examine the handle value returned by GetUserEvent.  */
    /*---------------------------------------------------------------------*/
    GetUserEvent(TRUE,&handle,&id);
    switch (id) {
      case GE_GRAPH :
        /*-----------------------------------------------------------------*/
        /*  When the Graph button is pushed, add a new plot to each        */
        /*  graph.  Each plot is also added to the combined graph.         */
        /*                                                                 */
        /*  Note:  All of the graphs are configured for auto scaling.      */
        /*-----------------------------------------------------------------*/
        DoYPlot();
        DoXYPlot();
        DoWfmPlot();
        DoPtPlot();
        DoTextPlot();
        break;
      case GE_RESET :
        /*-----------------------------------------------------------------*/
        /*  When the Reset button is pushed, delete the plots from all     */
        /*  the graphs.  This will cause the plot area for each graph to   */
        /*  be cleared and its grid redrawn.                               */
        /*-----------------------------------------------------------------*/
        DeletePlots(panel_hdl,GE_XY_PLOT);
        DeletePlots(panel_hdl,GE_Y_PLOT);
        DeletePlots(panel_hdl,GE_WFM_PLOT);
        DeletePlots(panel_hdl,GE_PT_PLOT);
        DeletePlots(panel_hdl,GE_TEXT_PLOT);
        DeletePlots(panel_hdl,GE_CMB_PLOT);
        break;
      case GE_QUIT :
        /*-----------------------------------------------------------------*/
        /*  When the Quit button is pushed exit the program.  Remember,    */
        /*  CloseInterfaceManager will be called automatically to unload   */
        /*  the panel and reset the display to text mode.                  */
        /*-----------------------------------------------------------------*/
        return;
        break;
    }
  }
}

/*= DO Y PLOT =============================================================*/
/*                                                                         */
/*  Plots Y into the Y graph and the combined plots graph.                 */
/*=========================================================================*/

void DoYPlot (void)

{
  double y[100];

  FillArray(y,100);
  PlotY(panel_hdl,GE_Y_PLOT,y,100,4,0,0,1,9);
  PlotY(panel_hdl,GE_CMB_PLOT,y,100,4,0,0,1,9);
}

/*= DO X-Y PLOT ===========================================================*/
/*                                                                         */
/*  Plots X-Y into the X-Y graph and the combined plots graph.             */
/*=========================================================================*/

void DoXYPlot (void)

{
  double x[100], y[100];

  FillArray(x,100);
  FillArray(y,100);
  PlotXY(panel_hdl,GE_XY_PLOT,x,y,100,4,4,0,0,1,11);
  PlotXY(panel_hdl,GE_CMB_PLOT,x,y,100,4,4,0,0,1,11);
}

/*= DO WAVEFORM PLOT ======================================================*/
/*                                                                         */
/*  Plots a waveform into the waveform graph and the combined plots graph. */
/*=========================================================================*/

void DoWfmPlot (void)

{
  double wfm[100];

  FillArray(wfm,100);
  PlotWaveform(panel_hdl,GE_WFM_PLOT,wfm,100,4,1.0,0.0,0.0,1.0,0,0,1,13);
  PlotWaveform(panel_hdl,GE_CMB_PLOT,wfm,100,4,1.0,0.0,0.0,1.0,0,0,1,13);
}

/*= DO POINT PLOT =========================================================*/
/*                                                                         */
/*  Plots a point into the point graph and the combined plots graph.       */
/*=========================================================================*/

void DoPtPlot (void)

{
  double x, y;

  x = RandomNumber();
  y = RandomNumber();
  PlotPoint(panel_hdl,GE_PT_PLOT,x,y,0,14);
  PlotPoint(panel_hdl,GE_CMB_PLOT,x,y,0,14);
}

/*= DO TEXT PLOT ==========================================================*/
/*                                                                         */
/*  Plots a text string into the text plot graph and the combined plots    */
/*  graph.                                                                 */
/*=========================================================================*/

void DoTextPlot (void)

{
  double x, y;

  x = RandomNumber();
  y = RandomNumber();
  PlotText(panel_hdl,GE_TEXT_PLOT,x,y,"Text",0,14,-1);
  PlotText(panel_hdl,GE_CMB_PLOT,x,y,"Text",0,14,-1);
}

/*= FILL ARRAY ============================================================*/
/*                                                                         */
/*  Fills an array with random numbers between 0 and 100.                  */
/*=========================================================================*/

void FillArray (array, num_pts)

double array[];
int num_pts;

{
  int i;

  for (i=0; (i < num_pts); i++)
    array[i] = RandomNumber();
}

/*= RANDOM NUMBER =========================================================*/
/*                                                                         */
/*  Generates a random number between 0 and 100.                           */
/*=========================================================================*/

double RandomNumber (void)

{
  return(rand() / 327.67);
}
