/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex3.h"

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= FUNCTION DECLARATIONS =================================================*/

int ProcessPopup2 (void);
int ProcessPopup3 (void);
void ProcessPopup1 (void);

/*= MAIN PROGRAM ==========================================================*/

main()

{
  int id,menu_bar,val,panel1,panel2,handle;
  char msg[60];

  /*-----------------------------------------------------------------------*/
  /*  Load the menu bar from the resource file.  Use the constant assigned */
  /*  in the editor to refer to the menu bar.  The handle returned by      */
  /*  LoadMenuBar must be used to reference the menu bar in all subsequent */
  /*  function calls. If load was successful, the menu bar will be drawn   */
  /*  at the top of the screen.                                            */
  /*-----------------------------------------------------------------------*/
  menu_bar = LoadMenuBar ("uil_ex3.uir", BAR);
  if (menu_bar < 0) {
    FmtOut("Unable to load the required menu bar from the resource file.\n");
    return;
  }

  /*-----------------------------------------------------------------------*/
  /*  Load the panels from the resource file.  Use the constants assigned  */
  /*  in the editor to refer to the panels.  The handles returned by       */
  /*  LoadPanel must be used to reference the panels in all subsequent     */
  /*  function calls. If either panel handle is negative, the load         */
  /*  failed, so print a message and exit the program. Otherwise, display  */
  /*  the panels.                                                          */
  /*-----------------------------------------------------------------------*/
  panel1 = LoadPanel ("uil_ex3.uir", P1);
  panel2 = LoadPanel ("uil_ex3.uir", P2);
  if ((panel1 < 0)  || (panel2 < 0)) {
    FmtOut("Unable to load the required panel from the resource file.\n");
    return;
  }
  DisplayPanel (panel1);
  DisplayPanel (panel2);

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to TRUE.  This will  */
    /*  cause the function to wait for an event.  When an event occurs,    */
    /*  the handle variable will either match the menu bar handle or the   */
    /*  panel handle.  The id variable will match one of the menu bar or   */
    /*  control ID constants assigned in the editor.                       */
    /*---------------------------------------------------------------------*/
    GetUserEvent (TRUE, &handle, &id);
    /*---------------------------------------------------------------------*/
    /*  If the handle matches the menu bar handle, decode the id variable  */
    /*  to figure out which menu item or immediate command was selected.   */
    /*---------------------------------------------------------------------*/
    if (handle == menu_bar) {
      switch (id) {
        case BAR_PANEL_DISPLAY :
          DisplayPanel(panel1);
          DisplayPanel(panel2);
          SetInputMode(menu_bar,BAR_PANEL_HIDE,TRUE);
          SetInputMode(menu_bar,BAR_PANEL_DISPLAY,FALSE);
          break;
        case BAR_PANEL_HIDE :
          HidePanel(panel1);
          HidePanel(panel2);
          SetInputMode(menu_bar,BAR_PANEL_HIDE,FALSE);
          SetInputMode(menu_bar,BAR_PANEL_DISPLAY,TRUE);
          break;
        case BAR_POPUP_DISPLAY :
          ProcessPopup1();
          break;
        case BAR_QUIT :
          /*---------------------------------------------------------------*/
          /*  When the Quit command is selected exit the program.          */
          /*  Remember, CloseInterfaceManager will be called automatically */
          /*  to unload the menu bar and panel, and to reset the display   */
          /*  to text mode.                                                */
          /*---------------------------------------------------------------*/
          return;
          break;
      }
    }
    /*---------------------------------------------------------------------*/
    /*  If the handle matches the panel handle, decode the id variable     */
    /*  to figure out which control was selected.                          */
    /*---------------------------------------------------------------------*/
    else if (handle == panel1) {
      switch (id) {
        case P1_BUTTON :
          MessagePopup("Button on Panel #1 pressed");
          break;
      }
    }
    else if (handle == panel2) {
      switch (id) {
        case P2_BUTTON :
          MessagePopup("Button on Panel #2 pressed");
          break;
       }
    }
  }
}

/*= PROCESS POPUP 1 =======================================================*/

void ProcessPopup1 (void)

{
  int id,popup;

  popup = LoadPanel ("uil_ex3.uir", POPUP1);
  InstallPopup(popup);

  while (TRUE) {
    GetPopupEvent(TRUE,&id);
    switch (id) {
      case POPUP1_NEXT :
        if (ProcessPopup2() == -1) {
          UnloadPanel(popup);
          return;
        }
        break;
      case POPUP1_EXIT :
        RemovePopup(FALSE);
        UnloadPanel(popup);
        return;
        break;
    }
  }
}

/*= PROCESS POPUP 2 =======================================================*/

int ProcessPopup2 (void)

{
  int id,popup;

  popup = LoadPanel ("uil_ex3.uir", POPUP2);
  InstallPopup(popup);

  while (TRUE) {
    GetPopupEvent(TRUE,&id);
    switch (id) {
      case POPUP2_NEXT :
        if (ProcessPopup3() == -1) {
          UnloadPanel(popup);
          return(-1);
        }
        break;
      case POPUP2_BACK :
        RemovePopup(FALSE);
        UnloadPanel(popup);
        return(0);
        break;
      case POPUP2_EXIT :
        RemovePopup(TRUE);
        UnloadPanel(popup);
        return(-1);
        break;
    }
  }
}

/*= PROCESS POPUP 3 =======================================================*/

int ProcessPopup3 (void)

{
  int id,popup;

  popup = LoadPanel ("uil_ex3.uir", POPUP3);
  InstallPopup(popup);

  while (TRUE) {
    GetPopupEvent(TRUE,&id);
    switch (id) {
      case POPUP3_BACK :
        RemovePopup(FALSE);
        UnloadPanel(popup);
        return(0);
        break;
      case POPUP3_EXIT :
        RemovePopup(TRUE);
        UnloadPanel(popup);
        return(-1);
        break;
    }
  }
}

