/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex2.h"

/*= DEFINES ===============================================================*/

#define  TRUE   1
#define  FALSE  0

/*= MAIN PROGRAM ==========================================================*/

main()

{
  int id,menu_bar,val,panel_hdl,handle;
  char msg[60];

  /*-----------------------------------------------------------------------*/
  /*  Load the menu bar from the resource file.  Use the constant assigned */
  /*  in the editor to refer to the menu bar.  The handle returned by      */
  /*  LoadMenuBar must be used to reference the menu bar in all subsequent */
  /*  function calls. If load was successful, the menu bar will be drawn   */
  /*  at the top of the screen.                                            */
  /*-----------------------------------------------------------------------*/
  menu_bar = LoadMenuBar ("uil_ex2.uir", BAR);
  if (menu_bar < 0) {
    FmtOut("Unable to load the required menu bar from the resource file.\n");
    return;
  }

  /*-----------------------------------------------------------------------*/
  /*  Load the panel from the resource file.  Use the constant assigned    */
  /*  in the editor to refer to the panel.  The handle returned by         */
  /*  LoadPanel must be used to reference the panel in all subsequent      */
  /*  function calls. If the panel handle is negative, the load failed,    */
  /*  so print a message and exit the program. Otherwise, display the      */
  /*  the panel.                                                           */
  /*-----------------------------------------------------------------------*/
  panel_hdl = LoadPanel ("uil_ex2.uir", PANEL);
  if (panel_hdl < 0) {
    FmtOut("Unable to load the required panel from the resource file.\n");
    return;
  }
  DisplayPanel (panel_hdl);

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to TRUE.  This will  */
    /*  cause the function to wait for an event.  When an event occurs,    */
    /*  the handle variable will either match the menu bar handle or the   */
    /*  panel handle.  The id variable will match one of the menu bar or   */
    /*  control ID constants assigned in the editor.                       */
    /*---------------------------------------------------------------------*/
    GetUserEvent (TRUE, &handle, &id);
    /*---------------------------------------------------------------------*/
    /*  If the handle matches the menu bar handle, decode the id variable  */
    /*  to figure out which menu item or immediate command was selected.   */
    /*---------------------------------------------------------------------*/
    if (handle == menu_bar) {
      switch (id) {
        case BAR_MENU_ITEM1 :
          MessagePopup("Item 1 selected");
          break;
        case BAR_MENU_ITEM2 :
          MessagePopup("Item 2 selected");
          break;
        case BAR_MENU_ITEM3 :
          MessagePopup("Item 3 selected");
          break;
        case BAR_PANEL_ENABLE :
          /*---------------------------------------------------------------*/
          /*  Here we want to enable user input on the entire panel, so we */
          /*  call SetInputMode with first parameter equal to the panel    */
          /*  handle, the second parameter equal to the -1 (meaning the    */
          /*  entire panel, not an individual control), and the third      */
          /*  parameter equal to TRUE which will enable user input. The    */
          /*  panel title is undimmed when input is enabled.               */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,-1,TRUE);
          /*---------------------------------------------------------------*/
          /*  Checkmark the enable menu item, and uncheckmark the disable  */
          /*  menu item.                                                   */
          /*---------------------------------------------------------------*/
          SetMenuItemCheckmark (BAR_PANEL_ENABLE, TRUE);
          SetMenuItemCheckmark (BAR_PANEL_DISABLE, FALSE);
          break;
        case BAR_PANEL_DISABLE :
          /*---------------------------------------------------------------*/
          /*  Here we want to disable user input on the entire panel, so   */
          /*  we call SetInputMode with first parameter equal to the panel */
          /*  handle, the second parameter equal to the -1 (meaning the    */
          /*  entire panel, not an individual control), and the third      */
          /*  parameter equal to FALSE which will disable user input. The  */
          /*  panel title is dimmed when input is disabled.                */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,-1,FALSE);
          SetMenuItemCheckmark (BAR_PANEL_ENABLE, FALSE);
          SetMenuItemCheckmark (BAR_PANEL_DISABLE, TRUE);
          break;
        case BAR_QUIT :
          /*---------------------------------------------------------------*/
          /*  When the Quit command is selected exit the program.          */
          /*  Remember, CloseInterfaceManager will be called automatically */
          /*  to unload the menu bar and panel, and to reset the display   */
          /*  to text mode.                                                */
          /*---------------------------------------------------------------*/
          return;
          break;
      }
    }
    /*---------------------------------------------------------------------*/
    /*  If the handle matches the panel handle, decode the id variable     */
    /*  to figure out which control was selected.                          */
    /*---------------------------------------------------------------------*/
    else if (handle == panel_hdl) {
      switch (id) {
        case PANEL_BUTTON1 :
          MessagePopup("Button 1 pressed");
          break;
        case PANEL_BUTTON2 :
          MessagePopup("Button 2 pressed");
          break;
        case PANEL_BUTTON3 :
          MessagePopup("Button 3 pressed");
          break;
        case PANEL_HOT_SLIDE :
          /*---------------------------------------------------------------*/
          /*  Since Hot Slide is configured as a hot control, it generates */
          /*  an event when its state is changed. Here, we query the       */
          /*  control for its current value and display it in a message    */
          /*  pop-up.                                                      */
          /*---------------------------------------------------------------*/
          GetCtrlVal(panel_hdl,PANEL_HOT_SLIDE,&val);
          Fmt(msg,"Hot slide control changed to %d",val);
          /*---------------------------------------------------------------*/
          /*  MessagePopup is one of the predefined pop-up panels that are */
          /*  available in the User Interface Library.                     */
          /*---------------------------------------------------------------*/
          MessagePopup(msg);
          break;
        case PANEL_DISABLE_MENU_BAR :
          /*---------------------------------------------------------------*/
          /*  When the disable menu bar button is selected, we disable     */
          /*  user input for the entire menu bar.  The menu bar labels are */
          /*  dimmed and remain unselectable until input is enabled again. */
          /*---------------------------------------------------------------*/
          SetInputMode(menu_bar,-1,FALSE);
          /*---------------------------------------------------------------*/
          /*  Toggle the input mode on the enable and disable menu bar     */
          /*  input push buttons.                                          */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,PANEL_ENABLE_MENU_BAR,TRUE);
          SetInputMode(panel_hdl,PANEL_DISABLE_MENU_BAR,FALSE);
          break;
        case PANEL_ENABLE_MENU_BAR :
          /*---------------------------------------------------------------*/
          /*  When the enable menu bar button is selected, we enable user  */
          /*  input for the entire menu bar.  The menu bar labels are      */
          /*  undimmed and remain selectable until input is disabled       */
          /*  again.                                                       */
          /*---------------------------------------------------------------*/
          SetInputMode(menu_bar,-1,TRUE);
          /*---------------------------------------------------------------*/
          /*  Toggle the input mode on the enable and disable menu bar     */
          /*  input push buttons.                                          */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,PANEL_ENABLE_MENU_BAR,FALSE);
          SetInputMode(panel_hdl,PANEL_DISABLE_MENU_BAR,TRUE);
          break;
        case PANEL_DISABLE_BUTTONS :
          /*---------------------------------------------------------------*/
          /*  Disable the three push buttons (Button 1, Button 2, and      */
          /*  Button 3) as well as the Disable Buttons push button.        */
          /*  Enable the Undo Disable push button.                         */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,PANEL_BUTTON1,FALSE);
          SetInputMode(panel_hdl,PANEL_BUTTON2,FALSE);
          SetInputMode(panel_hdl,PANEL_BUTTON3,FALSE);
          SetInputMode(panel_hdl,PANEL_UNDO_DISABLE,TRUE);
          SetInputMode(panel_hdl,PANEL_DISABLE_BUTTONS,FALSE);
          break;
        case PANEL_UNDO_DISABLE :
          /*---------------------------------------------------------------*/
          /*  Enable the three push buttons (Button 1, Button 2, and       */
          /*  Button 3) as well as the Disable Buttons push button.        */
          /*  Disable the Undo Disable push button.                        */
          /*---------------------------------------------------------------*/
          SetInputMode(panel_hdl,PANEL_BUTTON1,TRUE);
          SetInputMode(panel_hdl,PANEL_BUTTON2,TRUE);
          SetInputMode(panel_hdl,PANEL_BUTTON3,TRUE);
          SetInputMode(panel_hdl,PANEL_UNDO_DISABLE,FALSE);
          SetInputMode(panel_hdl,PANEL_DISABLE_BUTTONS,TRUE);
          break;
      }
    }
  }
}
