/*=========================================================================*/
/*  This program illustrates the use of single panel.  It displays various */
/*  waveforms and performs simple analysis on them.                        */
/*=========================================================================*/

/*= INCLUDES ==============================================================*/
/*                                                                         */
/*  Remember, never modify the contents of include files generated by the  */
/*  User Interface Editor.                                                 */
/*=========================================================================*/

#include "uil_ex1.h"

/*= DEFINES ===============================================================*/

#define  TRUE    1
#define  FALSE   0

#define  OFF     0
#define  SINE    1
#define  COSINE  2
#define  ADD     1
#define  MULT    2

/*= FUNCTION DECLARATIONS =================================================*/

void MakeSine (double[], double);
void MakeCosine (double[], double);
void CalcWaveforms (int, int, int);

/*= STATIC VARIABLES ======================================================*/

static double Ch3Max;
static double Ch3Min;
static double Ch3Avg;

static double Wave1[101];
static double Wave2[101];
static double Wave3[101];

/*= MAIN PROGRAM ==========================================================*/

main()

{
  int id,panel,handle,chan1,chan2,chan3;

  /*-----------------------------------------------------------------------*/
  /*  Load the panel from the resource file.  Use the constant assigned    */
  /*  in the editor to refer to the panel.  The handle returned by         */
  /*  LoadPanel must be used to reference the panel in all subsequent      */
  /*  function calls. If the panel handle is negative, the load failed,    */
  /*  so print a message and exit the program.  Otherwise, display the     */
  /*  panel.                                                               */
  /*-----------------------------------------------------------------------*/
  panel = LoadPanel("uil_ex1.uir",SCOPE);
  if (panel < 0) {
    FmtOut("Unable to load the required panel from the resource file.\n");
    return;
  }
  DisplayPanel(panel);

  while (TRUE) {
    /*---------------------------------------------------------------------*/
    /*  Call GetUserEvent with the wait parameter set to TRUE.  This will  */
    /*  cause the function to wait for an event.  When an event occurs,    */
    /*  the id variable will match one of the control ID constants         */
    /*  assigned in the editor.  Since we only have one panel loaded, we   */
    /*  do not have to examine the handle value returned by GetUserEvent.  */
    /*---------------------------------------------------------------------*/
    GetUserEvent(TRUE,&handle,&id);
    switch (id) {
      case SCOPE_DISP :
        /*-----------------------------------------------------------------*/
        /*  Query the panel for each channel selection and calculate the   */
        /*  waveform for each channel.                                     */
        /*-----------------------------------------------------------------*/
        GetCtrlVal(panel,SCOPE_CH1,&chan1);
        GetCtrlVal(panel,SCOPE_CH2,&chan2);
        GetCtrlVal(panel,SCOPE_CH3,&chan3);
        CalcWaveforms(chan1, chan2, chan3);
        /*-----------------------------------------------------------------*/
        /*  Clear the graph of its current plots. Plot the waveform        */
        /*  selected for each channel.  Light the LED for each active      */
        /*  channel                                                        */
        /*-----------------------------------------------------------------*/
        DeletePlots(panel,SCOPE_GRAPH);
        if (chan3 != OFF)
          PlotY(panel,SCOPE_GRAPH,Wave3,100,4,0,0,1,13);
        if (chan1 != OFF)
          PlotY(panel,SCOPE_GRAPH,Wave1,100,4,0,0,1,9);
        if (chan2 != OFF)
          PlotY(panel,SCOPE_GRAPH,Wave2,100,4,0,0,1,14);
        SetCtrlVal(panel,SCOPE_STATE1,chan1);
        SetCtrlVal(panel,SCOPE_STATE2,chan2);
        SetCtrlVal(panel,SCOPE_STATE3,chan3);
        /*-----------------------------------------------------------------*/
        /*  Update the maximum, minimum and average values for channel 3.  */
        /*-----------------------------------------------------------------*/
        SetCtrlVal(panel,SCOPE_MAX,Ch3Max);
        SetCtrlVal(panel,SCOPE_MIN,Ch3Min);
        SetCtrlVal(panel,SCOPE_AVG,Ch3Avg);
        break;
      case SCOPE_QUIT :
        /*-----------------------------------------------------------------*/
        /*  When the Quit button is pushed exit the program.  Remember,    */
        /*  CloseInterfaceManager will be called automatically to unload   */
        /*  the panel and reset the display to text mode.                  */
        /*-----------------------------------------------------------------*/
        return;
        break;
    }
  }
}

/*= CALCULATE WAVEFORMS ===================================================*/

void CalcWaveforms (chan1, chan2, chan3)

int chan1;
int chan2;
int chan3;

{
  int min_ndx, max_ndx;

  /*-----------------------------------------------------------------------*/
  /*  Determine if channel 1 is to dislplay a sine, cosine or has been     */
  /*  turned off.                                                          */
  /*-----------------------------------------------------------------------*/

  switch (chan1) {
    case SINE :
      MakeSine(Wave1,0.5);
      break;
    case COSINE :
      MakeCosine(Wave1,0.5);
      break;
    case OFF :
      Clear1D(Wave1,100);
      break;
  }

  /*-----------------------------------------------------------------------*/
  /*  Determine if channel 2 is to dislplay a sine, cosine or has been     */
  /*  turned off.                                                          */
  /*-----------------------------------------------------------------------*/
  switch (chan2) {
    case SINE :
      MakeSine(Wave2,-0.5);
      break;
    case COSINE :
      MakeCosine(Wave2,-0.5);
      break;
    case OFF :
      Clear1D(Wave2,100);
      break;
  }

  /*-----------------------------------------------------------------------*/
  /*  Determine if channel 3 is to dislplay the addition or multiplication */
  /*  of channels 1 and 2, or if it has been turned off.                   */
  /*-----------------------------------------------------------------------*/
  switch (chan3) {
    case ADD :
      Add1D(Wave1,Wave2,100,Wave3);
      break;
    case MULT :
      Mul1D(Wave1,Wave2,100,Wave3);
      break;
    case OFF :
      Clear1D(Wave3,100);
      break;
  }

  /*-----------------------------------------------------------------------*/
  /*  Calculate the maximum, minimum, and average value of the waveform    */
  /*  on channel 3.                                                        */
  /*-----------------------------------------------------------------------*/
  MaxMin1D(Wave3,100,&Ch3Max,&max_ndx,&Ch3Min,&min_ndx);
  Mean(Wave3,100,&Ch3Avg);
}

/*= MAKE SINEWAVE =========================================================*/

void MakeSine (waveform, offset)

double waveform[];
double offset;

{
  int i;
  double scale;

  scale = 4.0 * 3.1416;
  for (i=0; (i < 100); i++)
    waveform[i] = offset + sin(i/scale);
}

/*= MAKE COSINEWAVE =======================================================*/

void MakeCosine (waveform, offset)

double waveform[];
double offset;

{
  int i;
  double scale;

  scale = 4.0 * 3.1416;
  for (i=0; (i < 100); i++)
    waveform[i] = offset + cos(i/scale);
}

