/*
    This program is written to run inside the LabWindows interactive program.
    To make a standalone application, use the Create EXE command in the
    LabWindows File menu.
*/
                                    /* STANDARD EGA COLORS... */
#define EC_BLACK        0
#define EC_BLUE         1
#define EC_GREEN        2
#define EC_CYAN         3
#define EC_RED          4
#define EC_MAGENTA      5
#define EC_BROWN        6
#define EC_LTGRAY       7
#define EC_DKGRAY       8
#define EC_LTBLUE       9
#define EC_LTGREEN     10
#define EC_LTCYAN      11
#define EC_LTRED       12
#define EC_LTMAGENTA   13
#define EC_YELLOW      14
#define EC_WHITE       15

                                    /* PLOTTING MODES... */
#define PM_IMMEDIATE  0                  /* Plot all curves when specified */
#define PM_DELAYED    1                  /* Delay plotting until GrfReset */
#define PM_SINGLESTEP 2                  /* Immediate mode with pause    */

                                   /* PORT VALUES */
#define ALL_PORTS     0                  /* apply port operation to all */

                                   /* SETTINGS for SetDisplayMode */
#define TEXT_MODE     0
#define GRAPHICS_MODE 1

                                   /* SCROLLING MODE for CreateStripChart */
#define SCROLL_CONTINUOUS  0             /* scroll point by point */
#define SCROLL_BLOCK       1             /* erase and start over when full */

#define FALSE       0
#define TRUE        1

#define PASS_ONE    0
#define PASS_TWO    1

static int port[10];
static double b[101], c[101] ;


/*  FillArrays generates sinewaves into the arrays b and c */
void FillArrays ()
{
    double scale, pi;
    int i;

    pi = 3.141597;
    for (i = 0; i < 100; ++i)  {           /* Fill arrays with data        */
        scale = 1.0 - (double)i / 100.0;
        b[i] = scale * sin (0.1 * pi * (double)i);
        c[i] = 0.5 * scale * sin (0.07 * pi * (double)i);
    }
}


/* InitializeSettings initializes some graphics attributes */
void InitializeSettings ()
{
    SetPlotMode (PM_IMMEDIATE);
    SetFrmColor (EC_LTMAGENTA);
    SetBckColor (EC_BLUE);
    SetGrdColor (EC_LTGREEN);
    SetLblColor (EC_WHITE);
}


/*  PostMsg posts a message to the screen and waits for the user to
    press a key.   */
void PostMsg (msg)
  char *msg;
{
  while (keyhit())
        getkey();
  GrfMsg (msg, EC_WHITE);
  getkey ();
}


/*  GraphData graphs two plots into the active port in different colors. */
void GraphData (pass)
    int pass;
{
    if (pass == PASS_ONE) {
        SetCrvColor (EC_LTCYAN);
        GrfYCurv2D (b, 101);
    }
    else {                              /* else, pass is PASS_TWO */
        SetCrvColor (EC_YELLOW);
        GrfYCurv2D (c, 101);
    }
}


/*  DrawIncreasingPorts creates five ports, each of which is larger
    than the preceding one.  The first four ports are deleted.   */
void DrawIncreasingPorts ()
{
    int size, i, j;
    int tmp;

    size = 20;
    PostMsg ("Press a key to draw ports of increasing size ... ");
    SetTitle ("Sample Waves");
    for (i = 0; i < 5; ++i) {
        tmp = CreatePort (-1, -1, size, size);   /* center port in screen  */
        GraphData (PASS_ONE);              /* add first plot to the port   */
        GraphData (PASS_TWO);              /* add second plot to the port  */
        size = size + 20;                  /* make each port bigger        */
        for (j = 0; j < 1000; ++j)         /* a little delay               */
            ;
        if (i < 4)                         /* delete all but the last port */
            DeletePort (tmp);
  }
}


/*  MakeNewPort creates a new port of width h and height v, and increments
    the variable portNum    */
void MakeNewPort (h, v, portNum)
int h;
int v;
int portNum;
{
    char title[20];

    Fmt (title, "Port #%d", portNum);
    port[portNum] = CreatePort (h, v, 33, 33);
    SetTitle (title);
    GraphData (PASS_ONE);
}


/*  DrawSmallPorts creates nine small ports and plot data into them. */
void DrawSmallPorts ()
{
    int h, v;

    h = 0;
    v = 66;
    MakeNewPort (h, v, 1);
    h = 33;
    MakeNewPort (h, v, 2);
    h = 66;
    MakeNewPort (h, v, 3);
    v = 33;
    MakeNewPort (h, v, 4);
    v = 0;
    MakeNewPort (h, v, 5);
    h = 33;
    MakeNewPort (h, v, 6);
    h = 0;
    MakeNewPort (h, v, 7);
    v = 33;
    MakeNewPort (h, v, 8);
    h = 33;
    MakeNewPort (h, v, 9);
}


/*  AddCurvesToSmallPorts goes through all the small ports, adding
    a new curve to each one.   */
void AddCurvesToSmallPorts ()
{
    int portNum;

    for (portNum = 1; portNum < 10; ++portNum) {
        SetActivePort (port[portNum]);          /* goto next port          */
        GraphData (PASS_TWO);                   /* add another curve       */
    }
}


/*  RedrawSmallPortPlots redraws the plots into the existing small ports. */
void RedrawSmallPortPlots ()
{
    int i;
    char msg[80];

    PostMsg ("Ready to redraw plots into each port ... press a key");
    for (i = 1; i <= 9; ++i) {
        SetActivePort (port[i]);           /* move to another port         */
        GraphData (PASS_ONE);
        GraphData (PASS_TWO);
  }
}


/*  RemoveAndFlushAllPlots removes the plot data from each of the small ports.
    In addition, the plots are be erased from the screen.                  */
void RemoveAndFlushAllPlots ()
{
    PostMsg ("Ready to remove plots from all ports ... press a key");
    RemovePlots (0);                  /* clear data & erase plot area */
    DisplayPort (0);
}


/*  DeleteSmallPorts delete the small ports one by one.  */
void DeleteSmallPorts ()
{
    int i;
    char msg[80];

    for (i = 1; i <= 9; ++i) {             /* delete the ports one by one  */
        Fmt (msg, "Ready to delete port %d ... press a key", i);
        PostMsg (msg);
        DeletePort (port[i]);
  }
}


/* DrawAutoSizedPlot draws plot of waveforms with increasing magnitude and
   auto-scales the plot as the magnitude increases  */
void DrawAutoSizedPlot ()
{
    int i;

    GrfLReset(0,0,1,1) ;
    InitializeSettings() ;
    SetAxAuto(-1, 2) ;

    SetCrvColor (EC_LTCYAN);
    GrfYCurv2D (c, 51);
    LinEv1D(b, 101, -2.0, 0.0, b) ;
    PostMsg("Plot larger amplitude waveform with more points using autoscaling... press a key");

    SetCrvColor (EC_LTMAGENTA);
    GrfYCurv2D (b, 76);
    LinEv1D(c, 101, -3.0, 0.0, c) ;
    PostMsg("Ready to plot waveform with more points... press a key");

    SetCrvColor (EC_YELLOW);
    GrfYCurv2D (c, 101);
}


/*  DoStripDemo deletes port #9 and creates a strip chart in its place.
    As data is added to the strip chart, the user is given the option of
    escaping by pressing a key. */
void DoStripDemo ()
{
    register int i;

    PostMsg ("Press a key to turn Port #9 into a strip chart...");
    GrfMsg ("Strip chart in progress... Press a key to stop.", 14);
    DeletePort (port[9]);
    port[9] = CreateStripChart (33,33,33,33,-1.0,1.0,0.0,1.0,
                                50,1,SCROLL_CONTINUOUS);
    SetTraceColor (port[9], 1, EC_LTCYAN);
    SetControlTrace (port[9], b, 100, 0, 0, EC_YELLOW);
    while (! keyhit ())
        for (i = 0; i < 100; ++i)
            GrfStrip (port[9], c, i, 1, 0);
}


void main ()
{
  int i, nLoaded, firstHandle, lastHandle, portNum;

  /***
         This example program draws a series of graphs on the screen.
         To run the program you must have a graphics adapter in your
         computer.  This program should be run on a color monitor.  If
         you do not have a color monitor, the graphs may not be
         visible or the program may not run at all.
  ***/

    GrfLReset(0,0,1,1) ;
    FillArrays ();
    InitializeSettings ();                 /* initialize some attributes   */
    DrawIncreasingPorts ();                /* draw the ports getting larger*/

    PostMsg ("Press a key to draw small ports ... ");
    DeletePort (ALL_PORTS);                /* delete everything            */
    DrawSmallPorts ();                     /* now draw the smaller ports   */
    PostMsg ("Press a key to add another curve to each port ... ");
    AddCurvesToSmallPorts();               /* add some more to small ports */

    PostMsg ("Ready to save small ports to disk ... press a key");
    SaveGraphFile ("ports.grf", ALL_PORTS);  /* save everything to disk    */

    RemoveAndFlushAllPlots ();             /* remove the plots from ports  */
    RedrawSmallPortPlots ();               /* redraw plots into ports      */
    DeleteSmallPorts ();                   /* delete the ports             */
    PostMsg ("Now everything should be deleted ... press a key");

    PostMsg ("Ready to reload small ports from  disk ... press a key");
                                           /* load the ports from disk     */
    nLoaded = LoadGraphFile ("ports.grf", &firstHandle);

    PostMsg ("Small ports loaded ... press a key to display them");
    DisplayPort (ALL_PORTS);               /* show the new ports           */

    /* the following recovers the port handles loaded from the file */
    lastHandle = firstHandle + nLoaded - 1;
    portNum = 1;
    for (i = firstHandle; i <= lastHandle; ++i) {
        port[portNum] = i;
        ++portNum;
    }
    DoStripDemo ();                  /* replace port #9 with a strip chart */
    PostMsg("Draw plots with automatic re-scaling...press a key") ;
    DrawAutoSizedPlot()  ;           /* demonstrate automatic re-scaling   */

    PostMsg ("Ready to delete all the ports & return to text mode... press a key");
    DeletePort (ALL_PORTS);                /* delete all the ports         */
    SetDisplayMode (TEXT_MODE);            /* finally, return to text mode */
}



