/****************************************************************************/
/* This is an example of a LabWindows application that calls a high-level   */
/* DOS LabDriver function to stream data to disk.  The data is captured by  */
/* a DAQ_to_Disk call and plotted on a graph.                               */
/* Note: If you are using Programmed I/O (interrupt driven) for data        */
/*       acquisition, the acquisition rate of the DAQ_to_Disk call may have */
/*       to be lowered depending on the speed of your machine.  Trying to   */
/*       run an interrupt driven acquisition too fast will lock up the      */
/*       computer.                                                          */
/****************************************************************************/

/* Maximum number of points to acquire and plot */
#define MAXPOINTS 2000

/* Rate at which to acquire data */
#define RATE 20000.0

/* buffer to hold unscaled voltage values for plotting */
static int buffer[100] ;


main()
{
  int slot,
      channel,
      err,
      handle,           /* use for file I/O */
      plotIndex ;

   long
      numTimeOutTicks;  /* timeout limit for Timeout_Config call */

  FmtOut("\n\nExecution begins...") ;

  /* Get user input */
  FmtOut ("\n\nEnter the slot of the MIO-16, MIO16F-5, Lab-PC or LPM-16 (1-8):") ;
  ScanIn ("%d", &slot) ;
  if (slot < 1 || slot > 8) {
     FmtOut("\nGoodbye!\n") ;
     exit(0) ;
  }
  FmtOut ("\n\nWhich channel do you want to read? (0 - 7) : ") ;
  ScanIn ("%d", &channel) ;

  /* Establish a timeout limit - use a minimum of approx 1 sec */
  numTimeOutTicks = (MAXPOINTS / RATE) * 20;
  if (numTimeOutTicks < 20L) numTimeOutTicks = 20L;

  err = Timeout_Config (slot, numTimeOutTicks);

  /* Perform data acquisition with high-level DAQ call.           */
  /* Use a sampling rate of 20,000 pts/sec and a gain stage of 1. */
  /* Save the acquired data to the new file "test.dat".           */
  err = DAQ_to_Disk (slot, channel, 1, "test.dat", (long)MAXPOINTS, RATE, 0) ;
  if (err) {
     FmtOut("\nError %i occurred while calling DAQ_to_Disk.", err) ;
     FmtOut("\nGoodbye!\n") ;
     exit(0) ;
  }

  FmtOut ("\n%d samples acquired.", MAXPOINTS) ;
  plotIndex = 0 ;
  while (1) {
     FmtOut ("\nEach plot contains 100 points.") ;
     FmtOut ("\nEnter starting index of plot (0 - %d), -1 ends :",MAXPOINTS-100) ;
     ScanIn ("%d", &plotIndex) ;
     if (plotIndex < 0 || plotIndex + 100 > MAXPOINTS) {
        /* index is out of range, so end program. */
        FmtOut("\nGoodbye!\n") ;
        exit(0) ;
     }

     /* Read the sample data from the disk file and into a memory buffer */
     handle = OpenFile ("test.dat", 1, 2, 0) ;
     SetFilePtr (handle, (long) plotIndex * 2, 0) ;
     ScanFile(handle, "%*i>%*i", (int) 100, (int) 100, buffer) ;
     CloseFile(handle) ;

     /* plot the 100 points of data read */
     YGraphPopup (buffer, 100, 1) ;
     /* puts lw back to text mode */
     CloseInterfaceManager() ;
  }
}
