#include "aiaoxmpl.h"

/****************************************************************************/
/* This is an example of a LabWindows application that calls high-level DOS */
/* LabDriver functions to read and write voltages to data acquisition       */
/* boards.  Reading from the analog input channels is supported with the    */
/* following boards: AT-MIO-16, MC-MIO-16, Lab-PC, AT-MIO-16F-5, PC-LPM-16. */
/* Writing to the analog output channels is supported with the following    */
/* boards: AT-MIO-16, MC-MIO-16, Lab-PC, AT-MIO-16F-5.                      */
/****************************************************************************/

#define TRUE   1
#define FALSE  0

void main()
{
   int er, ph ;
   int pan, ctrl ;

   int daqErr, board, AI_Chan, AO_Chan ;
   double AI_Volts, AO_Volts ;
   int quit_app ;

   /* open and display user panel */
   er = OpenInterfaceManager() ;
   ph = LoadPanel("aiaoxmpl.uir", P1) ;
   er = DisplayPanel(ph) ;

   quit_app = FALSE ;      /* this is TRUE when quit key is pressed */

   while (!quit_app)  {
      er = GetUserEvent(0, &pan, &ctrl) ;
      switch (ctrl)  {
         case P1_QUIT:
            /* user pressed the QUIT button */
            quit_app = TRUE ;
            break ;
         case P1_AIGO:
            /* user pressed the READ button */
            /* get board and channel number */
            GetCtrlVal(ph, P1_BOARD, &board) ;
            GetCtrlVal(ph, P1_AICHAN, &AI_Chan) ;
            /* call DOS LabDriver function */
            daqErr = AI_VRead(board, AI_Chan, 1, &AI_Volts) ;
            /* display result in user panel */
            SetCtrlVal(ph, P1_AIVOLTS, AI_Volts) ;
            SetCtrlVal(ph, P1_AIERROR, daqErr) ;
            break ;
         case P1_AOGO:
            /* user pressed the WRITE button */
            /* get board, channel number and voltage */
            GetCtrlVal(ph, P1_BOARD, &board) ;
            GetCtrlVal(ph, P1_AOCHAN, &AO_Chan) ;
            GetCtrlVal(ph, P1_AOVOLTS, &AO_Volts) ;
            /* call DOS LabDriver function */
            daqErr = AO_VWrite(board, AO_Chan, AO_Volts) ;
            /* display result in user panel */
            SetCtrlVal(ph, P1_AOERROR, daqErr) ;
            break ;
         default: break;
      }
   }
   /* close user panel */
   er = CloseInterfaceManager() ;
}
