/*
 * rs232.h
 *
 * "Include" file for Microsoft C programs using
 * the LabWindows RS232 Library.
 *
 * Copyright (C) National Instruments 1988-1989.
 *
 */

extern int rs232err;

void OpenComConfig (int port_no, int baud_rate, int parity, int data_bits,
		    int stop_bits, int iq_size, int oq_size, int port_addr,
		    int int_level);
void OpenCom (int port_no);
void CloseCom (int port_no);

void SetXMode (int port_no, int Xmode);
void SetCTSMode (int port_no, int CTSmode);
void SetComTime (int port_no, double seconds);

void ComBreak (int port_no, int milliseconds);

int  GetInQLen (int port_no);
int  GetOutQLen (int port_no);
int  GetComStat (int port_no);

void FlushInQ (int port_no);
void FlushOutQ (int port_no);

int  ComWrtByte (int port_no, int byte);
int  ComWrt (int port_no, char buf[], int max_cnt);
int  ComRdByte (int port_no);
int  ComRd (int port_no, char buf[], int max_cnt);
int  ComRdTerm (int port_no, char buf[], int max_cnt, int term_byte);

int  ComToFile (int port_no, int handle, int max_cnt, int term_byte);
int  ComFromFile (int port_no, int handle, int max_cnt, int term_byte);

int  XModemConfig (int port_no, double start_delay, int max_tries,
		   double wait_period, int packet_size);
int  XModemReceive (int port_no, char path_name[]);
int  XModemSend (int port_no, char path_name[]);

